

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanGetDetailsWrapper.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanGetDetailsWrapper.sp,v $ $Id: AppPlanGetDetailsWrapper.sp,v 1.1.6.2 2018/04/06 20:37:11 anagrale Exp $";
--	+===================================================================+
--	|  			AppPlanGetDetailsWrapper  								|
--	|		 Procedure to get plan information							|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppPlanGetDetailsWrapper <<<'

IF EXISTS (select * from sysobjects where name='AppPlanGetDetailsWrapper')
	drop procedure AppPlanGetDetailsWrapper
IF EXISTS (select * from GxQscripts where name='AppPlanGetDetailsWrapper')
	delete from GxQscripts where name = 'AppPlanGetDetailsWrapper'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanGetDetailsWrapper')
	delete from GXDBVersions where aliasname = 'AppPlanGetDetailsWrapper'
GO
print '... Creating Procedure: AppPlanGetDetailsWrapper'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPlanGetDetailsWrapper
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
	DECLARE	@o_xmlString			XML
	-- Plan ID
	DECLARE @planId    INT = ISNULL (( SELECT ref.value('@planId', 'INT')
						           FROM @i_xmlString.nodes ('Api_GetPlanDetailsReq/plan') R(ref)), 0)
	-- Plan class
	-- Assume regular plan
	DECLARE @planClass INT
	SET @planClass = 3
	-- Plan type
	-- if not passed, assume any
	DECLARE @planType  INT = ISNULL (( SELECT ref.value('@planType', 'INT')
						           FROM @i_xmlString.nodes ('Api_GetPlanDetailsReq/plan') R(ref)), 0)
	-- Plan subtype
	-- if not passed, assume any
	DECLARE @planSubtype INT = ISNULL (( SELECT ref.value('@planSubtype', 'INT')
						           FROM @i_xmlString.nodes ('Api_GetPlanDetailsReq/plan') R(ref)), 0)
	DECLARE @userId INT = ISNULL((SELECT ref.value('@userId', 'INT')
              FROM @i_xmlString.nodes('Api_GetPlanDetailsReq/processinginstructioninfo/user') r (ref)), 0)
	IF @userId = 0
		SET @userId = 1
	IF @planId > 0
	BEGIN
		EXEC AppPlanGetDetailsV2 @planId, @userId, @planClass, @planType, @planSubtype, @o_xmlString OUTPUT
	END
	IF @o_xmlString IS NULL
		SET @o_xmlString = '<Api_GetPlanDetailsResp/>'
	SELECT @o_xmlString  as o_xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanGetDetailsWrapper')
	delete from GxQscripts where name = 'AppPlanGetDetailsWrapper'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanGetDetailsWrapper')
	delete from GXDBVersions where aliasname = 'AppPlanGetDetailsWrapper'
GO

insert into GXDBVersions values(2, 'AppPlanGetDetailsWrapper',  '00010001000600020000', 'AppPlanGetDetailsWrapper', '00010001000600020000')
GO

