

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanGetDetailsV2.sp] ---------- 

-- MODIFIED FOR (CCP)
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanGetDetailsV2.sp,v $ $Id: AppPlanGetDetailsV2.sp,v 1.1.2.93.4.1 2021/01/08 23:57:06 njain Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   AppPlanGetDetailsV2   -
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppPlanGetDetailsV2')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanGetDetailsV2 <<<'
	drop procedure AppPlanGetDetailsV2
END
IF EXISTS (select * from GxQscripts where name='AppPlanGetDetailsV2')
	delete from GxQscripts where name = 'AppPlanGetDetailsV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanGetDetailsV2')
	delete from GXDBVersions where aliasname = 'AppPlanGetDetailsV2'
GO
print '... Creating Procedure: AppPlanGetDetailsV2'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppPlanGetDetailsV2
  @i_planId INT,
  @i_userId INT,
  @i_planClass INT,
  @i_planType INT,
  @i_planSubtype INT,
  @x_xmlData XML OUTPUT,
  @i_localeId INT = 0,
  @i_skipSecurityCheck INT = 0
AS
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
-- creating and deleting temporary table requires sp recompilation lets do it just once at the very beginning
IF OBJECT_ID('tempdb.dbo.#planList')                    IS NOT NULL DROP TABLE #planList
IF OBJECT_ID('tempdb.dbo.#PlanDetails_PlanProps')       IS NOT NULL DROP TABLE #PlanDetails_PlanProps
IF OBJECT_ID('tempdb.dbo.#planConfig' )                 IS NOT NULL DROP TABLE #planConfig
IF OBJECT_ID('tempdb.dbo.#planContent')                 IS NOT NULL DROP TABLE #planContent
IF OBJECT_ID('tempdb.dbo.#planPermissions')             IS NOT NULL DROP TABLE #planPermissions
IF OBJECT_ID('tempdb.dbo.#usersSec_getUsersNewTbl')     IS NOT NULL DROP TABLE #usersSec_getUsersNewTbl
IF OBJECT_ID('tempdb.dbo.#usergroupsSec_getUsersNewTbl')IS NOT NULL DROP TABLE #usergroupsSec_getUsersNewTbl
IF OBJECT_ID('tempdb.dbo.#userClients')					IS NOT NULL DROP TABLE #userClients
CREATE TABLE #PlanDetails_PlanProps         (depth INT, componentNameId INT, attrName VARCHAR(512), attrType INT, attrVal VARCHAR(MAX), [entityTypeId] INT, [Status] INT, PRIMARY KEY(attrName))
CREATE TABLE #usergroupsSec_getUsersNewTbl  (userGroupId INT PRIMARY KEY)
CREATE TABLE #usersSec_getUsersNewTbl       (userId INT PRIMARY KEY)
CREATE TABLE #planList                      (planId INT NOT NULL)
CREATE TABLE #planPermissions               (permissionId INT)
CREATE TABLE #planConfig                    (entityType INT, entityId INT NOT NULL)
CREATE TABLE #userClients					(t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT)
CREATE CLUSTERED INDEX PlanDetails_Config_EntityType_idx ON #planConfig(entityType)
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
-- if plan id is not specified then it could be the case that master, template or default is requested.
DECLARE @errorCode INT = CASE WHEN ISNULL(@i_planId, 0) = 0 THEN 2 ELSE 0 END
IF @i_planId = 0 BEGIN
    IF @i_planClass IN (0, 1)  BEGIN -- for master and template plans query database for the plan definiton
        -- figure out plan name
        DECLARE @name NVARCHAR(64) = 'Plan ' + CAST(@i_planSubtype AS NVARCHAR(32)) +
                                     (CASE @i_planClass WHEN 0 THEN ' master record' WHEN 1 THEN ' template record' ELSE CAST(@i_planClass AS NVARCHAR(32)) + ' record' END)
        -- query plan defintion and return it
        SELECT @x_xmlData = ISNULL(value, '<Api_GetPlanDetailsResp />') FROM GXGlobalParam WHERE name = @name; RETURN;
    END ELSE IF @i_planClass = 2 BEGIN -- -- default plan for the plan subtype is requested
        -- figure out plan id
        SET @i_planId = (SELECT id FROM APP_Plan WHERE pclass = 2 AND [type] = @i_planType AND subType = @i_planSubtype)
        SET @errorCode = CASE WHEN @i_planId IS NULL THEN 2 ELSE 0 END
    END
END
IF ISNULL(@i_planSubtype, 0) = 0
        SELECT @i_planSubtype = subType FROM App_Plan WHERE id = @i_planId
-- Do security check only if allowed
IF (@errorCode = 0) AND (@i_skipSecurityCheck = 0)
BEGIN -- user permissions
    -- to check if user has rights to retrieve information about plan get the list of plan ids which are visible to user
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 158, 31, '#planList'
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 158, 159, '#planList'
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 158, 158, '#planList'
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 158, 157, '#planList'
    IF ( (NOT EXISTS (SELECT 1 FROM #planList planList WHERE planid = @i_planId)) AND
         (NOT EXISTS (SELECT 1 FROM App_plan WHERE id = @i_planId and ownerId = @i_userId)) )
	BEGIN
		DECLARE @o_hasPermission INT = 0
		-- sec_getNonIdaObjectsForThisUser just checks for rights on the plan. For replication plans, you need some extra checks like checking rights on the Hypervisor
        -- associated with the replication task of the plan.
IF(@i_planId <> 0 AND @i_planSubtype = 83918853)
		BEGIN
EXEC [dbo].[sec_CheckRepPlanEntitiesSecurity] @i_planId, 158, @i_planSubtype, @i_userId,0, @o_hasPermission OUTPUT
			IF(@o_hasPermission = 1)
			BEGIN
				INSERT INTO #planList
					SELECT @i_planId
			END
			ELSE
			BEGIN
				SET @errorCode = 5 -- access denied
			END
		END
		ELSE
		BEGIN
			SET @errorCode = 5 -- access denied
		END
    END
END
IF @errorCode = 0 BEGIN -- check if requested plan exists
IF NOT EXISTS (SELECT id FROM App_Plan WHERE id = @i_planId AND ((flag & 0x00004) = 0) AND ((flag & 0x40000000) = 0)) BEGIN
        SET @errorCode = 2 -- not found
    END
END
IF @errorCode = 0 BEGIN
	DECLARE @level INT = 0
	SELECT  @level = ref.value('@propertyLevel', 'INT')
		FROM    @x_xmlData.nodes('Api_GetPlanDetailsReq') R ( ref )
	IF @level <> 15
		SET @level = 0
    EXEC AppPlanGetPlanComponentsV2 @i_planId
DECLARE @basePlanId      INT = (SELECT CAST(attrVal AS INT) FROM #PlanDetails_PlanProps WHERE attrName = 'Base plan')
    DECLARE @basePlanSubtype INT = (SELECT subtype FROM APP_Plan WHERE id = @basePlanId)
    -- get list of possible, required and forbidden entities. it will help to make a decision on client and user group creation
    DECLARE @const_entityRequired  INT  = 1,
            @const_entityForbidden INT  = 2,
            @const_entityPossible  INT  = 3,
            @const_entityPrivate   INT  = 4,
            @const_entityEnforced  INT  = 5
    INSERT INTO #planConfig(entityType, entityId)
SELECT DISTINCT @const_entityRequired, CAST(_ID AS INT) FROM dbo.SplitIDString((SELECT attrVal FROM #PlanDetails_PlanProps WHERE attrName = 'Defintion entities : required')) A
        UNION ALL
SELECT DISTINCT @const_entityForbidden, CAST(_ID AS INT) FROM dbo.SplitIDString((SELECT attrVal FROM #PlanDetails_PlanProps WHERE attrName = 'Defintion entities : forbidden')) B
        UNION ALL
SELECT DISTINCT @const_entityPossible, CAST(_ID AS INT) FROM dbo.SplitIDString((SELECT attrVal FROM #PlanDetails_PlanProps WHERE attrName = 'Defintion entities : possible')) C
        UNION ALL
SELECT DISTINCT @const_entityPrivate, CAST(_ID AS INT) FROM dbo.SplitIDString((SELECT attrVal FROM #PlanDetails_PlanProps WHERE attrName = 'Private entities')) D
        UNION ALL
SELECT DISTINCT @const_entityEnforced, CAST(_ID AS INT) FROM dbo.SplitIDString((SELECT attrVal FROM #PlanDetails_PlanProps WHERE attrName = 'Descendants enforced entities')) E
    DELETE FROM #PlanDetails_PlanProps
        WHERE entityTypeId != 0 AND entityTypeId NOT IN (SELECT entityId FROM #planConfig WHERE entityType = @const_entityPossible)
    -- -----------------------------------------------------------------------------------------------------------------------------------------------------
    IF (@i_planSubtype = 33554439) BEGIN
        -- make sure that entities for the plan exist
        -- -- user groups
        DECLARE @x_xmlGroupResp XML = NULL
        DECLARE @userGroupId    INT = NULL
        EXEC AppPlanEnsureUserGroupV2  @i_planId, @userGroupId OUTPUT, @x_xmlGroupResp OUTPUT
    END
    DECLARE @securityAssociations XML
    EXEC sec_getSecurityForEntity @i_userId, @securityAssociations OUTPUT, 158, @i_planId
    EXEC sec_getPermissionsOnEntity '#planPermissions', @i_userId, 158, @i_planId
    IF NOT EXISTS(SELECT 1 FROM #planPermissions where permissionId = 31)
        INSERT INTO #planPermissions(permissionId) VALUES(31)
    --Get users that user has rights on
    DECLARE @usersFlagExclude INT = CAST(0x200 AS INT)| CAST(0x004 AS INT) | CAST(0x080 AS INT) | CAST(0x100 AS INT)
    DECLARE @usersFlagInclude INT = CAST(0x001 AS INT)
    EXEC sec_getUsersForThisUser '#usersSec_getUsersNewTbl', @i_userId, 0, 3, @usersFlagExclude, @usersFlagInclude
    --Get user groups that user has rights on
    EXEC sec_getUserGroupsForThisUser '#usergroupsSec_getUsersNewTbl', @i_userId
    --
	-- When getting user count from associated user group, then exlclude users which are not visible to calling user id (this will also take care of hidden or system defined users)
    DECLARE @numOfPlanUsers INT = ( SELECT Count(DISTINCT T.userID)
                                    FROM (SELECT UMG.userId AS userID FROM #usersSec_getUsersNewTbl UT INNER JOIN UMUserGroup UMG ON UMG.groupId = @userGroupId AND UT.userId = UMG.userId
                                    UNION
                                    SELECT UMG.userId AS userID
FROM #usergroupsSec_getUsersNewTbl UGT INNER JOIN APP_PlanProp APP ON CAST(UGT.userGroupId AS NVARCHAR(32))= APP.attrVal AND APP.attrName IN ('Associated internal user group', 'Associated external user group') AND APP.componentNameId = @i_planId
                                           INNER JOIN UMUserGroup UMG ON UMG.groupId=UGT.userGroupId
										   INNER JOIN #usersSec_getUsersNewTbl UT ON UT.userId=UMG.userId
LEFT OUTER JOIN UMUsersProp UUP  on UUP.componentNameId =  UT.userId AND UUP.attrName ='Associated Plan' AND UUP.modified = 0  AND UUP.cs_attrName = CHECKSUM(N'Associated Plan')
										   WHERE UUP.id IS NULL) T)
DECLARE @clientGroupId          INT = (SELECT CAST(attrVal AS INT) FROM #PlanDetails_PlanProps WHERE attrName = 'Assigned client group')
     -- feature and access policies roles
    DECLARE @featureRoleId INT = NULL, @featureRoleId_defined INT = NULL, @featureRoleId_override INT = NULL
SELECT  @featureRoleId = CAST(attrVal AS INT), @featureRoleId_defined = IIF(depth = 0, 1, 0) FROM #PlanDetails_PlanProps WHERE attrName = 'Feature'
SET     @featureRoleId_override = IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityPrivate AND entityId = 8), 1, IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityEnforced AND entityId = 8), 2, 0 ))
    DECLARE @accessRoleId INT = NULL, @accessRoleId_defined INT = NULL, @accessRoleId_override INT = NULL
SELECT  @accessRoleId = CAST(attrVal AS INT), @accessRoleId_defined = IIF(depth = 0, 1, 0) FROM #PlanDetails_PlanProps WHERE attrName = 'Access policy'
SET     @accessRoleId_override = IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityPrivate AND entityId = 64), 1, IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityEnforced AND entityId = 64), 2, 0 ))
    -- schedules and storages
    DECLARE @scheduleId INT = NULL, @scheduleId_defined INT = NULL, @scheduleId_override INT = NULL
SELECT  @scheduleId = CAST(attrVal AS INT), @scheduleId_defined = IIF(depth = 0, 1, 0) FROM #PlanDetails_PlanProps WHERE attrName = 'Schedule policy'
SET     @scheduleId_override = IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityPrivate AND entityId = 4), 1, IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityEnforced AND entityId = 4), 2, 0 ))
    DECLARE @storageId INT = NULL, @storageId_defined INT = NULL, @storageId_override INT = NULL
SELECT  @storageId = CAST(attrVal AS INT), @storageId_defined = IIF(depth = 0, 1, 0)FROM #PlanDetails_PlanProps WHERE attrName = 'Storage policy'
SET     @storageId_override = IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityPrivate AND entityId = 1), 1, IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityEnforced AND entityId = 1), 2, 0 ))
	DECLARE @storageRules	XML = NULL
	IF @level = 15
	BEGIN
		SET @storageRules = (SELECT [propertyLevel] = @level FOR XML PATH (''))
	END
	DECLARE @isElastic		INT = 0
EXEC PlanRulesGetV2 @i_userId, 0 /*localeId*/, 158, @i_planId, @storageRules OUTPUT
	IF @storageRules.exist('//./rule') = 1
		SET @isElastic = 1
	DECLARE @entityRulesXml XML = NULL
SET @entityRulesXml = (SELECT CAST(CAST(attrval AS XML).value('text()[1]','nvarchar(max)') AS XML) FROM #PlanDetails_PlanProps WHERE attrName = 'Entity rules')
    -- PlanDBInfo  : database schedule, storage and sla level
    DECLARE @logScheduleId INT = NULL, @logScheduleId_defined INT = NULL, @logScheduleId_override INT = NULL
SELECT  @logScheduleId = CAST(attrVal AS INT), @logScheduleId_defined = IIF(depth = 0, 1, 0) FROM #PlanDetails_PlanProps WHERE attrName = 'Log schedule policy'
SET     @logScheduleId_override = IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityPrivate AND entityId = 16384), 1, IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityEnforced AND entityId = 16384), 2, 0 ))
    DECLARE @logStorageId INT = NULL, @logStorageId_defined INT = NULL, @logStorageId_override INT = NULL
SELECT  @logStorageId = CAST(attrVal AS INT), @logStorageId_defined = IIF(depth = 0, 1, 0) FROM #PlanDetails_PlanProps WHERE attrName = 'Log storage policy'
SET     @logStorageId_override = IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityPrivate AND entityId = 8192), 1, IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityEnforced AND entityId = 8192), 2, 0 ))
DECLARE @logSLA INT = ISNULL((SELECT CAST(attrVal AS INT) FROM #PlanDetails_PlanProps WHERE attrName = 'Log RPO In Minutes'), 0)
	-- If value is not set at plan level, take the default value. This logic is taken from JMCalculateNextBackupLevel.sp
DECLARE @daysBetweenAutoConvertBackup INT = ISNULL((SELECT CAST(attrVal AS INT) FROM #PlanDetails_PlanProps WHERE attrName = 'Days between auto convert of DB backup job'), ISNULL((SELECT CAST(value AS NVARCHAR(MAX)) FROM GXGlobalParam WITH (NOLOCK) WHERE name='NumberOfDaysBetweenAutoConvertBackupLevel'), 7))
    -- PlanExchangeInfo : mailbox confuguration policies
    DECLARE @mbArchiving INT = NULL, @mbArchiving_defined INT = NULL, @mbArchiving_override INT = NULL
SELECT  @mbArchiving = CAST(attrVal AS INT), @mbArchiving_defined = IIF(depth = 0, 1, 0) FROM #PlanDetails_PlanProps WHERE attrName = 'Exchange mailbox archiving policy'
SET     @mbArchiving_override = IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityPrivate AND entityId = 65536), 1, IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityEnforced AND entityId = 65536), 2, 0 ))
    DECLARE @mbRetention INT = NULL, @mbRetention_defined INT = NULL, @mbRetention_override INT = NULL
SELECT  @mbRetention = CAST(attrVal AS INT), @mbRetention_defined = IIF(depth = 0, 1, 0) FROM #PlanDetails_PlanProps WHERE attrName = 'Exchange mailbox retention policy'
SET     @mbRetention_override = IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityPrivate AND entityId = 65537), 1, IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityEnforced AND entityId = 65537), 2, 0 ))
    DECLARE @mbCleanup INT = NULL, @mbCleanup_defined INT = NULL, @mbCleanup_override INT = NULL
SELECT  @mbCleanup = CAST(attrVal AS INT), @mbCleanup_defined = IIF(depth = 0, 1, 0) FROM #PlanDetails_PlanProps WHERE attrName = 'Exchange mailbox cleanup policy'
SET     @mbCleanup_override = IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityPrivate AND entityId = 65538), 1, IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityEnforced AND entityId = 65538), 2, 0 ))
    DECLARE @mbJournal INT = NULL, @mbJournal_defined INT = NULL, @mbJournal_override INT = NULL
SELECT  @mbJournal = CAST(attrVal AS INT), @mbJournal_defined = IIF(depth = 0, 1, 0) FROM #PlanDetails_PlanProps WHERE attrName = 'Exchange mailbox journal policy'
SET     @mbJournal_override = IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityPrivate AND entityId = 65539), 1, IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityEnforced AND entityId = 65539), 2, 0 ))
	-- DC Policy Info
	DECLARE @dataClassification INT = NULL, @dataClassification_defined INT = NULL, @dataClassification_override INT = NULL
SELECT  @dataClassification = CAST(attrVal AS INT), @dataClassification_defined = IIF(depth = 0, 1, 0) FROM #PlanDetails_PlanProps WHERE attrName = 'Data classification policy'
SET     @dataClassification_override = IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityPrivate AND entityId = 65542), 1, IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityEnforced AND entityId = 65542), 2, 0 ))
	-- Content Indexing Policy Info
	DECLARE @contentIndexPolicy INT = NULL, @contentIndexPolicy_defined INT = NULL, @contentIndexPolicy_override INT = NULL
SELECT  @contentIndexPolicy = CAST(attrVal AS INT), @contentIndexPolicy_defined = IIF(depth = 0, 1, 0) FROM #PlanDetails_PlanProps WHERE attrName = 'Content Indexing Policy'
SET     @contentIndexPolicy_override = IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityPrivate AND entityId = 65543), 1, IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityEnforced AND entityId = 65543), 2, 0 ))
	-- PlanCloudOfficeInfo : Office 365 CloudOffice confuguration policies
	DECLARE @caBackup INT = NULL, @caBackup_defined INT = NULL, @caBackup_override INT = NULL
SELECT  @caBackup = CAST(attrVal AS INT), @caBackup_defined = IIF(depth = 0, 1, 0) FROM #PlanDetails_PlanProps WHERE attrName = 'Office 365 backup policy'
SET     @caBackup_override = IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityPrivate AND entityId = 65547), 1, IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityEnforced AND entityId = 65547), 2, 0 ))
    DECLARE @caCleanup INT = NULL, @caCleanup_defined INT = NULL, @caCleanup_override INT = NULL
SELECT  @caCleanup = CAST(attrVal AS INT), @caCleanup_defined = IIF(depth = 0, 1, 0) FROM #PlanDetails_PlanProps WHERE attrName = 'Office 365 cleanup policy'
SET     @caCleanup_override = IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityPrivate AND entityId = 65546), 1, IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityEnforced AND entityId = 65546), 2, 0 ))
    DECLARE @caRetention INT = NULL, @caRetention_defined INT = NULL, @caRetention_override INT = NULL
SELECT  @caRetention = CAST(attrVal AS INT), @caRetention_defined = IIF(depth = 0, 1, 0) FROM #PlanDetails_PlanProps WHERE attrName = 'Office 365 retention policy'
SET     @caRetention_override = IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityPrivate AND entityId = 65548), 1, IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityEnforced AND entityId = 65548), 2, 0 ))
	-- PlanExchangeInfo : Office 365 Mailbox confuguration policies
    DECLARE @o365mbArchiving INT = NULL, @o365mbArchiving_defined INT = NULL, @o365mbArchiving_override INT = NULL
SELECT  @o365mbArchiving = CAST(attrVal AS INT), @o365mbArchiving_defined = IIF(depth = 0, 1, 0) FROM #PlanDetails_PlanProps WHERE attrName = 'Office 365 Mailbox archive policy'
SET     @o365mbArchiving_override = IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityPrivate AND entityId = 65557), 1, IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityEnforced AND entityId = 65557), 2, 0 ))
    DECLARE @o365mbRetention INT = NULL, @o365mbRetention_defined INT = NULL, @o365mbRetention_override INT = NULL
SELECT  @o365mbRetention = CAST(attrVal AS INT), @o365mbRetention_defined = IIF(depth = 0, 1, 0) FROM #PlanDetails_PlanProps WHERE attrName = 'Office 365 Mailbox retention policy'
SET     @o365mbRetention_override = IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityPrivate AND entityId = 65558), 1, IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityEnforced AND entityId = 65558), 2, 0 ))
    DECLARE @o365mbCleanup INT = NULL, @o365mbCleanup_defined INT = NULL, @o365mbCleanup_override INT = NULL
SELECT  @o365mbCleanup = CAST(attrVal AS INT), @o365mbCleanup_defined = IIF(depth = 0, 1, 0) FROM #PlanDetails_PlanProps WHERE attrName = 'Office 365 Mailbox cleanup policy'
SET     @o365mbCleanup_override = IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityPrivate AND entityId = 65559), 1, IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityEnforced AND entityId = 65559), 2, 0 ))
    -- cloud entities
    DECLARE @analyticsIndexServer INT = NULL, @analyticsIndexServer_defined INT = NULL, @analyticsIndexServer_override INT = NULL
SELECT  @analyticsIndexServer = CAST(attrVal AS INT), @analyticsIndexServer_defined = IIF(depth = 0, 1, 0) FROM #PlanDetails_PlanProps WHERE attrName = 'Analytics Index Server Id'
SET     @analyticsIndexServer_override = IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityPrivate AND entityId = 65540), 1, IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityEnforced AND entityId = 65540), 2, 0 ))
    DECLARE @analyticsIndexServerName NVARCHAR(MAX) = (SELECT name FROM App_Client WHERE id = @analyticsIndexServer)
    DECLARE @cloudAnalyzer INT = NULL, @cloudAnalyzer_defined INT = NULL, @cloudAnalyzer_override INT = NULL
SELECT  @cloudAnalyzer = CAST(attrVal AS INT), @cloudAnalyzer_defined = IIF(depth = 0, 1, 0) FROM #PlanDetails_PlanProps WHERE attrName = 'Content Analyzer Cloud Id'
SET     @cloudAnalyzer_override = IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityPrivate AND entityId = 65541), 1, IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityEnforced AND entityId = 65541), 2, 0 ))
    DECLARE @cloudAnalyzerName NVARCHAR(MAX) = (SELECT name FROM DM2Cloud WHERE cloudId = @cloudAnalyzer)
    -- PlanReplicationTargets : replication targets
    DECLARE @replicationTargets_defined INT = NULL, @replicationTargets_override INT = NULL
SELECT  @replicationTargets_defined  = IIF(depth = 0, 1, 0) FROM #PlanDetails_PlanProps WHERE attrName = 'Replication schedule policy'
SET     @replicationTargets_override = IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityPrivate AND entityId = 32768), 1, IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityEnforced AND entityId = 32768), 2, 0 ))
    DECLARE @replicationTargets TABLE (taskId INT)
    INSERT INTO @replicationTargets
SELECT CAST(_ID AS INT) FROM dbo.SplitIDString((SELECT attrVal FROM #PlanDetails_PlanProps WHERE attrName = 'Replication schedule policy'))
    -- subclient policies
    DECLARE @planSubclientPolicies TABLE (policyType INT PRIMARY KEY, policyId INT)
    INSERT INTO @planSubclientPolicies
SELECT 2, CAST(attrVal AS INT) FROM #PlanDetails_PlanProps WHERE attrName LIKE 'Subclient policy 2' UNION
SELECT 3, CAST(attrVal AS INT) FROM #PlanDetails_PlanProps WHERE attrName LIKE 'Subclient policy 3' UNION
SELECT 4, CAST(attrVal AS INT) FROM #PlanDetails_PlanProps WHERE attrName LIKE 'Subclient policy 4'
    DELETE FROM @planSubclientPolicies WHERE policyId IS NULL
    DECLARE @planSubclientPolicy_2_defined    INT = NULL,  @planSubclientPolicy_2_override    INT = NULL,
            @planSubclientPolicy_3_defined    INT = NULL,  @planSubclientPolicy_3_override    INT = NULL,
            @planSubclientPolicy_4_defined    INT = NULL,  @planSubclientPolicy_4_override    INT = NULL,
            @planSubclientContent_2_defined   INT = NULL,  @planSubclientContent_2_override   INT = NULL,
            @planSubclientContent_3_defined   INT = NULL,  @planSubclientContent_3_override   INT = NULL,
            @planSubclientContent_4_defined   INT = NULL,  @planSubclientContent_4_override   INT = NULL,
            @planSubclientRetention_2_defined INT = NULL,  @planSubclientRetention_2_override INT = NULL,
            @planSubclientRetention_3_defined INT = NULL,  @planSubclientRetention_3_override INT = NULL,
            @planSubclientRetention_4_defined INT = NULL,  @planSubclientRetention_4_override INT = NULL,
			@planSubclientArcRules_2_defined INT = NULL,  @planSubclientArcRules_2_override INT = NULL,
            @planSubclientArcRules_3_defined INT = NULL,  @planSubclientArcRules_3_override INT = NULL
SELECT  @planSubclientPolicy_2_defined       = IIF(depth = 0, 1, 0) FROM #PlanDetails_PlanProps WHERE attrName = 'Subclient policy 2'
SELECT  @planSubclientPolicy_3_defined       = IIF(depth = 0, 1, 0) FROM #PlanDetails_PlanProps WHERE attrName = 'Subclient policy 3'
SELECT  @planSubclientPolicy_4_defined       = IIF(depth = 0, 1, 0) FROM #PlanDetails_PlanProps WHERE attrName = 'Subclient policy 4'
SELECT  @planSubclientContent_2_defined      = IIF(depth = 0, 1, 0) FROM #PlanDetails_PlanProps WHERE attrName = 'Subclient content 2'
SELECT  @planSubclientContent_3_defined      = IIF(depth = 0, 1, 0) FROM #PlanDetails_PlanProps WHERE attrName = 'Subclient content 3'
SELECT  @planSubclientContent_4_defined      = IIF(depth = 0, 1, 0) FROM #PlanDetails_PlanProps WHERE attrName = 'Subclient content 4'
SELECT  @planSubclientRetention_2_defined    = IIF(depth = 0, 1, 0) FROM #PlanDetails_PlanProps WHERE attrName = 'Subclient retentions 2'
SELECT  @planSubclientRetention_3_defined    = IIF(depth = 0, 1, 0) FROM #PlanDetails_PlanProps WHERE attrName = 'Subclient retentions 3'
SELECT  @planSubclientRetention_4_defined    = IIF(depth = 0, 1, 0) FROM #PlanDetails_PlanProps WHERE attrName = 'Subclient retentions 4'
SELECT  @planSubclientArcRules_2_defined     = IIF(depth = 0, 1, 0) FROM #PlanDetails_PlanProps WHERE attrName = 'Subclient archival rules 2'
SELECT  @planSubclientArcRules_3_defined     = IIF(depth = 0, 1, 0) FROM #PlanDetails_PlanProps WHERE attrName = 'Subclient archival rules 3'
SET     @planSubclientPolicy_2_override     = IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityPrivate AND entityId = 256), 1, IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityEnforced AND entityId = 256), 2, 0 ))
SET     @planSubclientPolicy_3_override     = IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityPrivate AND entityId = 512), 1, IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityEnforced AND entityId = 512), 2, 0 ))
SET     @planSubclientPolicy_4_override     = IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityPrivate AND entityId = 1024), 1, IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityEnforced AND entityId = 1024), 2, 0 ))
SET     @planSubclientContent_2_override    = IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityPrivate AND entityId = 65552), 1, IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityEnforced AND entityId = 65552), 2, 0 ))
SET     @planSubclientContent_3_override    = IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityPrivate AND entityId = 65553), 1, IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityEnforced AND entityId = 65553), 2, 0 ))
SET     @planSubclientContent_4_override    = IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityPrivate AND entityId = 65554), 1, IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityEnforced AND entityId = 65554), 2, 0 ))
SET     @planSubclientRetention_2_override  = IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityPrivate AND entityId = 65549), 1, IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityEnforced AND entityId = 65549), 2, 0 ))
SET     @planSubclientRetention_3_override  = IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityPrivate AND entityId = 65550), 1, IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityEnforced AND entityId = 65550), 2, 0 ))
SET     @planSubclientRetention_4_override  = IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityPrivate AND entityId = 65551), 1, IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityEnforced AND entityId = 65551), 2, 0 ))
SET     @planSubclientArcRules_2_override   = IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityPrivate AND entityId = 65555), 1, IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityEnforced AND entityId = 65555), 2, 0 ))
SET     @planSubclientArcRules_3_override   = IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityPrivate AND entityId = 65556), 1, IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityEnforced AND entityId = 65556), 2, 0 ))
    -- edge drive
    DECLARE @edgeDriveId INT = NULL, @edgeDriveId_defined INT = NULL, @edgeDriveId_override INT = NULL
SELECT  @edgeDriveId = CAST(attrVal AS INT), @edgeDriveId_defined = IIF(depth = 0, 1, 0) FROM #PlanDetails_PlanProps WHERE attrName = 'Assgined Edge Drive'
SET     @edgeDriveId_override = IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityPrivate AND entityId = 4096), 1, IIF(EXISTS(SELECT 1 FROM #planConfig WHERE entityType = @const_entityEnforced AND entityId = 4096), 2, 0 ))
    DECLARE @planAlerts TABLE (alertId INT PRIMARY KEY, alertName NVARCHAR(256))
    INSERT INTO @planAlerts
SELECT _ID, NULL FROM dbo.SplitIDString((SELECT attrVal FROM #PlanDetails_PlanProps WHERE attrName = 'Alert'))
    UPDATE @planAlerts SET alertName = (SELECT notificationName FROM NTnotificationRule WHERE id = alertId)
    -- groups internal and external
    DECLARE @planGroups TABLE (groupId INT PRIMARY KEY, internal INT)
    INSERT INTO @planGroups
SELECT _ID, 1 FROM dbo.SplitIDString((SELECT attrVal FROM #PlanDetails_PlanProps WHERE attrName = 'Associated internal user group'))
        UNION
SELECT _ID, 0 FROM dbo.SplitIDString((SELECT attrVal FROM #PlanDetails_PlanProps WHERE attrName = 'Associated external user group'))
	DECLARE @encryptionXML XML
	--Encryption start
	SET @encryptionXML = (SELECT
ISNULL((SELECT attrVal FROM #PlanDetails_PlanProps where attrName = 'Encryption Settings'),3) as  '@encryptionSettings',
ISNULL((SELECT attrVal FROM #PlanDetails_PlanProps where attrName = 'Encrypt: Type'),2) as '@cipherType',
ISNULL((SELECT attrVal FROM #PlanDetails_PlanProps where attrName = 'Encrypt: drToolAccess'),0) as '@directMediaAccess',
ISNULL((SELECT attrVal FROM #PlanDetails_PlanProps where attrName = 'Encrypt: Key Length'),128) as '@encryptKeyLength'
                            FOR XML PATH('encryptionInfo'),TYPE)
	-- Get Value set for Target App
	-- ContentIndexing_Target_App in API.x
DECLARE @targetAppStatus INT = (SELECT attrVal FROM #PlanDetails_PlanProps WHERE attrName = 'Target app')
	DECLARE @targetAppTbl TABLE(bitValueSet INT)
	INSERT INTO @targetAppTbl
	SELECT @targetAppStatus & 1
	UNION
	SELECT @targetAppStatus & 2
	UNION
	SELECT @targetAppStatus & 4
	UNION
	SELECT @targetAppStatus & 6
	UNION
	SELECT @targetAppStatus & 8
	UNION
	SELECT @targetAppStatus & 16
	DECLARE @rpoMinutes INT = 0
SELECT @rpoMinutes = ISNULL((SELECT attrVal FROM #PlanDetails_PlanProps WHERE attrName = 'RPO In Minutes'), 0)
	DECLARE @backupCopyRPOMins INT = 0
SELECT @backupCopyRPOMins = ISNULL((SELECT attrVal FROM #PlanDetails_PlanProps WHERE attrName = 'Backup copy RPO In Minutes'), 0)
	DECLARE @operationWindow INT = 0
	DECLARE @fullOperationWindow INT = 0
	SELECT @fullOperationWindow = ID FROM APP_OpWindowRule WHERE schedulePolicyId = @scheduleId AND opType = 1 -- Full backup level
	SELECT @operationWindow = ID FROM APP_OpWindowRule WHERE schedulePolicyId = @scheduleId AND ID <> @fullOperationWindow
	-- Get Devices Count  only for Laptop clients
	-- For other client, it doesn't make sense
	DECLARE @numDeviceCount INT  = 0
IF EXISTS (SELECT 1 FROM App_plan WITH (READUNCOMMITTED) WHERE id = @i_planId AND subType=33554439)
	BEGIN
		EXEC sec_getIdaObjectsForUser @i_userId, 3 /*CLIENT_ENTITY*/ , 0, 0, '#userClients'
		SET  @numDeviceCount  = (SELECT  COUNT(1)
									  FROM    APP_ClientProp CP WITH (READUNCOMMITTED)
									  INNER JOIN APP_Client AC
ON AC.id=CP.componentNameId AND (AC.status & 0x1000 = 0x1000 )
									  INNER JOIN #userClients UC
ON UC.t_clientId=CP.componentNameId AND CP.attrName = 'Associated Plan' AND CP.modified = 0 AND CP.attrVal = CAST(@i_planId AS VARCHAR(32)))
	END
	DECLARE @indexCopyScheduleId INT = NULL, @indexCopyScheduleId_defined INT = NULL
SELECT  @indexCopyScheduleId = CAST(attrVal AS INT), @indexCopyScheduleId_defined = IIF(depth = 0, 1, 0) FROM #PlanDetails_PlanProps WHERE attrName = 'Index copy schedule policy'
    -- error message for entity failure. We will extend this to more generic logic we start saving more errors
	DECLARE @indexServerFailureReasonDB NVARCHAR(1024)
SELECT  @indexServerFailureReasonDB = (SELECT attrVal FROM #PlanDetails_PlanProps WHERE attrName = 'Analytics Index Server failure reason')
	-- GET system default SLA
DECLARE @defaultSystemSLA INT = ISNULL((SELECT TOP 1 longVal FROM APP_ComponentProp WITH (NOLOCK) WHERE componentType = 1 AND propertyTypeId = 3300 AND modified = 0), 0)
	-- Return list of associations
	DECLARE	@i_getDetails INT =0,
	@companyId INT = 0,
	@allEntities INT = 1,
	@clientEntities INT = 0,
	@subclientEntities INT =0,
	@companyEntities INT = 0,
	@backupsetEntities INT =0,
	@instanceEntities INT =0,
	@getChildEntities int = 0
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
  DECLARE @companyGroupId INT = 0
  DECLARE @mailboxCount INT
IF OBJECT_ID('tempdb.dbo.#companyclients') IS NOT NULL
        DROP TABLE #companyclients
CREATE TABLE #companyclients
(
	clientId INT	primary key
)
IF OBJECT_ID('tempdb.dbo.#getPermissionsOnEntities_InputTable') IS NOT NULL
        DROP TABLE #getPermissionsOnEntities_InputTable
CREATE TABLE #getPermissionsOnEntities_InputTable
(
	entityId1 INT,
	entityId2 INT DEFAULT 0,
	entityId3 INT DEFAULT 0,
	entityId4 INT DEFAULT 0,
	entityId5 INT DEFAULT 0
)
IF OBJECT_ID('tempdb.dbo.#getPermissionsOnEntities_OutputTable') IS NOT NULL
	DROP TABLE #getPermissionsOnEntities_OutputTable
CREATE TABLE #getPermissionsOnEntities_OutputTable
(
	entityId1 INT,
	entityId2 INT,
	entityId3 INT,
	entityId4 INT,
	entityId5 INT,
	permissionsString VARCHAR(512),
	isChildRow BIT DEFAULT 0
)
IF OBJECT_ID('tempdb.dbo.#AssociatedEnties') IS NOT NULL
	DROP TABLE #AssociatedEnties
CREATE TABLE #AssociatedEnties
(
	entityId1 INT,
	entityId1Name nvarchar(255),
	entityId1DisplayName nvarchar(255),
	entityId2 INT,
	entityId2Name nvarchar(255),
	entityId2DisplayName nvarchar(255),
	entityId3 INT,
	entityId3Name nvarchar(255),
	entityId4 INT,
	entityId4Name nvarchar(255),
	entityId5 INT,
	entityId5Name nvarchar(255),
	permissionsString VARCHAR(512),
	isChildRow BIT DEFAULT 0,
	planParentEntityType INT DEFAULT NULL,
	planParentEntityID INT DEFAULT NULL
)
IF OBJECT_ID('tempdb.dbo.#AssociatedCompanies') IS NOT NULL
	DROP TABLE #AssociatedCompanies
CREATE TABLE #AssociatedCompanies
(	providerId INT,
	ownerCompany INT DEFAULT 0,
	[name] NVARCHAR(510) DEFAULT NULL
)
IF @allEntities=1 OR @subclientEntities=1 --SUBCLIENT_ENTITY
BEGIN
	INSERT INTO #getPermissionsOnEntities_InputTable (entityId1, entityId2, entityId3, entityId4, entityId5)
	SELECT A.clientId, A.appTypeId, A.instance, A.backupSet,A.id
FROM APP_Application A WITH(NOLOCK) INNER JOIN APP_SubclientProp SP WITH(NOLOCK) ON A.id = SP.componentNameId AND SP.attrName IN ('Associated Plan', 'Associated DC Plan') AND SP.modified = 0 AND CAST (@i_planId AS NVARCHAR(32)) = SP.attrVal
AND SP.cs_attrName IN (CHECKSUM(N'Associated Plan'),CHECKSUM(N'Associated DC Plan'))
	WHERE	A.subclientStatus & 0x00004 = 0 AND A.subclientStatus & 0x00002 = 0
END
IF @allEntities=1 OR @clientEntities=1 --CLIENT_ENTITY
BEGIN
	INSERT INTO #getPermissionsOnEntities_InputTable (entityId1, entityId2, entityId3, entityId4, entityId5)
	SELECT CP.componentNameId,0,0,0,0
	FROM APP_CLIENT C INNER JOIN APP_ClientProp CP ON C.id = CP.componentNameId
WHERE (CP.attrName = 'Associated Plan' OR CP.attrName like 'Default % Plan' OR CP.attrName = 'Associated DC Plan') AND CP.modified = 0 AND CAST (@i_planId AS NVARCHAR(32)) = CP.attrVal
AND C.status & 0x00004 = 0 AND C.status & 0x00002 = 0
END
IF @allEntities=1 OR @backupsetEntities=1 --BACKUPSET_ENTITY
BEGIN
	INSERT INTO #getPermissionsOnEntities_InputTable (entityId1, entityId2, entityId3, entityId4, entityId5)
	SELECT DISTINCT A.clientId, A.appTypeId, A.instance, A.backupSet,0
FROM APP_Application A WITH(NOLOCK) INNER JOIN APP_BackupSetProp SP WITH(NOLOCK) ON A.backupSet = SP.componentNameId AND SP.attrName = 'Associated Plan' AND SP.modified = 0 AND CAST (@i_planId AS NVARCHAR(32)) = SP.attrVal
	WHERE A.appTypeId!=1030
END
IF @allEntities=1 OR @instanceEntities=1 --BACKUPSET_ENTITY
BEGIN
	INSERT INTO #getPermissionsOnEntities_InputTable (entityId1, entityId2, entityId3, entityId4, entityId5)
	SELECT DISTINCT A.clientId, A.appTypeId, A.instance, 0,0
	FROM APP_Application A WITH(NOLOCK) INNER JOIN APP_InstanceProp SP WITH(NOLOCK) ON A.instance = SP.componentNameId AND SP.attrName = 'Associated Plan' AND SP.modified = 0 AND CAST (@i_planId AS NVARCHAR(32)) = SP.attrVal
	WHERE A.appTypeId!=1030
END
EXEC sec_getPermissionsOnEntities @i_userId, 7  /* 7 (7) */
-- have to delete the entities which user has no permission on as above sp doesnt remove entities that user doesnt have rights on
DELETE FROM #getPermissionsOnEntities_OutputTable
WHERE (SUBSTRING(permissionsString,1,1) != CAST(1 AS NVARCHAR(1)))
--for client level we need ida information too
UPDATE O
SET entityId2 = app.appTypeId
FROM #getPermissionsOnEntities_OutputTable O
   INNER JOIN (SELECT O1.entityId1, MIN(A.id) AS id, A.appTypeId
				FROM APP_APPLICATION A
                INNER JOIN  #getPermissionsOnEntities_OutputTable O1 ON O1.entityId1 = A.clientId
				WHERE O1.entityId5=0 AND O1.entityId4=0 AND O1.entityId3=0 AND O1.entityId2=0
				GROUP BY O1.entityId1, A.appTypeId) AS app
	ON O.entityId1=app.entityId1
	WHERE O.entityId5=0 AND O.entityId4=0 AND O.entityId3=0 AND O.entityId2=0
--Get names if the details is true
INSERT INTO #AssociatedEnties (entityId1, entityId1Name,entityId1DisplayName,entityId2,entityId2Name,entityId2DisplayName, entityId3,entityId3Name,  entityId4,entityId4Name,  entityId5, entityId5Name)
SELECT entityId1, c.name, c.displayName, entityId2, ida.name, ida.displayName, entityId3, i.name, entityId4,b.name, entityId5, a.subclientName
FROM #getPermissionsOnEntities_OutputTable o
LEFT JOIN app_client c on  @i_getDetails = 1 and o.entityId1 > 0 and o.entityId1=c.id
LEFT JOIN APP_iDAType  IDA on @i_getDetails = 1 and o.entityId2 > 0 and  IDA.type = o.entityId2
LEFT JOIN APP_InstanceName I on  @i_getDetails = 1 and  o.entityId3 > 0 and o.entityId3 = i.id
LEFT JOIN APP_BackupSetName B ON  @i_getDetails = 1 and  o.entityId4 > 0 and o.entityId4 = B.id
LEFT JOIN APP_Application a on  @i_getDetails = 1 and  o.entityId5 > 0 and o.entityId5 = a.id
IF (@i_planSubtype <> 117506053)
BEGIN
	UPDATE SCL
	SET SCL.planParentEntityType=ACP1.attrVal,
	SCL.planParentEntityID=ACP2.attrVal
	FROM #AssociatedEnties SCL
	INNER JOIN APP_SubClientProp ACP1 WITH(NOLOCK)
ON ACP1.componentNameId=SCL.entityId5 AND ACP1.attrName = 'Associated Plan Parent EntityType' AND ACP1.modified=0 AND ACP1.cs_attrName=CHECKSUM(N'Associated Plan Parent EntityType')
	INNER JOIN APP_SubClientProp ACP2 WITH(NOLOCK)
ON ACP2.componentNameId=SCL.entityId5 AND ACP2.attrName = 'Associated Plan Parent EntityId' AND ACP2.modified=0 AND ACP2.cs_attrName=CHECKSUM(N'Associated Plan Parent EntityId')
END
ELSE
BEGIN
	UPDATE SCL
	SET SCL.planParentEntityType=ACP1.attrVal,
	SCL.planParentEntityID=ACP2.attrVal
	FROM #AssociatedEnties SCL
	INNER JOIN APP_SubClientProp ACP1 WITH(NOLOCK)
ON ACP1.componentNameId=SCL.entityId5 AND ACP1.attrName = 'Associated DC Plan Parent EntityType' AND ACP1.modified=0 AND ACP1.cs_attrName=CHECKSUM(N'Associated DC Plan Parent EntityType')
	INNER JOIN APP_SubClientProp ACP2 WITH(NOLOCK)
ON ACP2.componentNameId=SCL.entityId5 AND ACP2.attrName = 'Associated DC Plan Parent EntityId' AND ACP2.modified=0 AND ACP2.cs_attrName=CHECKSUM(N'Associated DC Plan Parent EntityId')
END
--now get companies
--DECLARE @securityAssociations XML
--EXEC sec_getSecurityForEntity @i_userId, @securityAssociations OUTPUT, 158, @i_planId
IF @allEntities=1 OR @companyEntities=1
BEGIN
	INSERT INTO #AssociatedCompanies (providerId)
	SELECT distinct ref.value('userOrGroup[1]/@providerId', 'INT') FROM @securityAssociations.nodes('associations') R ( ref )
INNER JOIN UMGroups ug ON ug.id = ref.value('userOrGroup[1]/@groupId', 'INT') AND ug.groupFlags &0x10000 <> 0
END
UPDATE CT
SET     CT.ownerCompany = CASE UD.serviceType WHEN 5 THEN UD.id
WHEN 2 THEN UD.ownerCompany
WHEN 12 THEN UD.ownerCompany
                                WHEN 0 THEN 0
                                                  ELSE 0 END,
            CT.[name] = UD.domainName
    FROM    #AssociatedCompanies CT INNER JOIN UMDSProviders UD ON UD.id = CT.providerId
    WHERE CT.providerId != 0
DELETE FROM #AssociatedCompanies where ownerCompany=0 or providerId is null
--update the backupset parent entity if client entity is set for it's subclient. Do not include these entities in the list as
UPDATE o
SET o.planParentEntityID= o1.planParentEntityID,  o.planParentEntityType = o1.planParentEntityType
FROM #AssociatedEnties o
INNER JOIN #AssociatedEnties o1 ON ((o1.entityId1= o.entityId1 AND  o1.planParentEntityType=3) or (o1.entityId3= o.entityId3 AND  o1.planParentEntityType=5))
WHERE o.entityId5=0 AND o.entityId4<>0 AND o.planParentEntityID IS NULL
--set planParentEntity to null for the entities that has companyId set as parent entity. These entities needs to counted in the list.
UPDATE #AssociatedEnties SET  planParentEntityID=NULL, planParentEntityType=NULL   WHERE planParentEntityType = 61
IF(@getChildEntities =0)
BEGIN
 DELETE FROM #AssociatedEnties WHERE planParentEntityID IS NOT NULL
END
--frame a response
  DECLARE @assocEntityCount XML
    SET @assocEntityCount = (SELECT 0 AS '@snapSubclients',
(SELECT  COUNT(*) as '@count' , (SELECT '4' as '@_type_', entityId2 as  '@applicationId',A.displayName '@appName' FOR XML PATH ('appType'), TYPE)
                     FROM    #AssociatedEnties O
                        INNER JOIN APP_iDAType A WITH(NOLOCK) ON O.entityId2 = A.type
                     WHERE  O.entityId5 > 0  AND o.planParentEntityID is null
                     GROUP BY O.entityId2, A.displayName
                     FOR XML PATH('otherSubclients'), type),
(SELECT  COUNT(*) as '@count', (SELECT  '4'as '@_type_', O.entityId2 as  '@applicationId',I.displayName '@appName' FOR XML PATH ('appType'), TYPE)
                     FROM   #AssociatedEnties O
                        INNER JOIN APP_iDAType I WITH(NOLOCK) ON I.type = O.entityId2
						  WHERE   O.entityId5 = 0  AND o.planParentEntityID is null
                     GROUP BY O.entityId2, I.displayName
                     FOR XML PATH('allClients'), type)
                    FOR XML PATH('associatedEntitiesCount'), TYPE)
	DECLARE @subTasks TABLE (subtaskId INT, operationType INT)
	DECLARE @backupCopyScheduleId INT = NULL
SELECT  @backupCopyScheduleId = CAST(attrVal AS INT) FROM #PlanDetails_PlanProps WHERE attrName = 'Backup copy schedule policy'
	IF @level = 15
	BEGIN
		-- Get all schedule Ids
		INSERT INTO @subTasks
		SELECT ST.subTaskId, ST.operationType
			FROM TM_AssocEntity AE
				INNER JOIN archGroupCopy AGC
					ON (AE.policyId = AGC.archGroupId
						AND AE.copyId = 0)
						OR AE.copyId = AGC.id
				INNER JOIN [archGroup]
					ON AGC.id = [archGroup].defaultCopy
				INNER JOIN TM_SubTask ST
					ON ST.taskId = AE.taskId
				WHERE AGC.archGroupId = @storageId
					AND AGC.type <> 5
	END
	DECLARE @isDefaultCopyDistributedStorage INT = 0
	DECLARE @errorMsg    NVARCHAR(MAX) = '', @storagePolicyId INT = @storageId
	IF @storagePolicyId IS NOT NULL
	BEGIN
		-- GET DISTRIBUTED STORAGE ID GIVEN storagePolicyId
		DECLARE @copyId INT, @distributedStorageId INT
		SET @copyId = (SELECT defaultCopy FROM archGroup (NOLOCK) WHERE id = @storagePolicyId)
		IF @copyId IS NOT NULL
		BEGIN
			DECLARE @dsTable TABLE (mmMountId INT, distributedStorageId INT)
			INSERT INTO @dsTable
			EXEC MMGetDistributedStorageForCopy @copyId
			SET @distributedStorageId = (SELECT TOP 1 distributedStorageId FROM @dsTable)
			IF @distributedStorageId IS NOT NULL
			BEGIN
				DECLARE @hasRight INT
EXEC sec_checkPermissionOnEntity @i_userId, 261, @hasRight OUTPUT, 195, @distributedStorageId
				IF @hasRight <> 1
				BEGIN
EXEC sec_checkPermissionOnEntity @i_userId, 260, @hasRight OUTPUT, 195, @distributedStorageId
					IF @hasRight <> 1
					BEGIN
DECLARE @distributedStorageName NVARCHAR(255) = ISNULL((SELECT name FROM App_DistributedStorage (NOLOCK) WHERE id = @distributedStorageId), '')
						SET @errorCode = 4; SET @errorMsg = 'User does not have Use or Manage permissions on distributed storage [' + @distributedStorageName + '] to use it for Instant Clone optimization.'
					END
				END
			END
			ELSE
			BEGIN
				SET @errorCode = 3; SET @errorMsg = 'Distributed storage info not found'
			END
		END
		ELSE
		BEGIN
			SET @errorCode = 3; SET @errorMsg = 'Storage copy info not found'
		END
	END
	ELSE
	BEGIN
		SET @errorCode = 3; SET @errorMsg = 'Storage policy info not found'
	END
	IF @distributedStorageId IS NOT NULL
	BEGIN
		SET @isDefaultCopyDistributedStorage = 1
	END
	--
	-- START - GET RESOURCE POOL DETAILS FOR EACH STORAGEPOOL ---------------------------------------------------------------------------------------
	DECLARE @resourcePoolMap XML
	SET @resourcePoolMap =
		(SELECT
			(SELECT
				S.storagePoolId as 'storage/@storagePoolId',
				S.storagePoolName as 'storage/@storagePoolName',
				(SELECT appType AS '@appType', resourcePoolId AS 'resourcePool/@resourcePoolId' FROM APP_ResourcePool
WHERE storagePoolId = S.storagePoolId AND appType = IIF(@i_planSubtype = 33554439, 12/*cloud laptop*/, appType)
					FOR XML PATH('resources'), TYPE)
			FROM
			(
				SELECT AG.id as storagePoolId, AG.name as storagePoolName
				FROM
				(
					SELECT ref.value('@storagePoolId','INT') AS storagePoolId
					FROM  @storageRules.nodes('/PlanRulesInfoResp/rules/storagePool') R(ref)
					UNION
					SELECT DC2GC.globalPolicyId AS storagePoolId
					FROM ArchGroup DAG
					INNER JOIN ArchCopyToGlobalPolicy DC2GC ON DAG.defaultCopy = DC2GC.copyId
					WHERE DAG.id = @storageId
				) TEMP
				INNER JOIN archGroup AG ON AG.id = TEMP.storagePoolId
			) S
			FOR XML PATH('storageResourcePoolMap'), TYPE)
		)
	-- END   - GET RESOURCE POOL DETAILS FOR EACH STORAGEPOOL ---------------------------------------------------------------------------------------
	--
    SET @x_xmlData =
    (
    SELECT
        (SELECT      0  AS '@errorCode' ,
                    ''  AS '@errorMessage'
         FOR XML PATH('error'), TYPE),
    -- plan info
        (SELECT
            -- summary
            (SELECT  P.[type]                                                                                     AS '@type',
                     P.subType                                                                                    AS '@subtype',
                     P.[description]                                                                              AS '@descripiton',
                     P.flag                                                                                       AS '@planStatusFlag',
                     @numOfPlanUsers                                                                              AS '@numUsers',
					 @isElastic																					  AS '@isElastic',
                     @numDeviceCount 																			  AS '@numDevices',
ISNULL((SELECT attrVal FROM #PlanDetails_PlanProps WHERE attrName = 'Derivation restrictions'), 0) AS '@restrictions',
ISNULL((SELECT attrVal FROM #PlanDetails_PlanProps WHERE attrName = 'SLA In Minutes'), 0) AS '@slaInterval',
					 @rpoMinutes AS '@rpoInMinutes',
					 @rpoMinutes AS '@slaInMinutes',
                     (SELECT P.id    AS '@planId',
                             P.name  AS '@planName',
						     P.[type]	AS '@planType',
							 P.subType  AS '@planSubtype',
                             158     AS '@_type_'
                      FOR XML PATH('plan'), TYPE),
					    (SELECT
(SELECT attrVal FROM #PlanDetails_PlanProps WHERE attrName = 'Database Addon') AS '@database',
(SELECT IIF(attrVal = '2',NULL,attrVal) FROM #PlanDetails_PlanProps WHERE attrName = 'Snap Addon') AS '@snap',
CASE WHEN P.subType = 33554437
THEN ISNULL((SELECT attrVal FROM #PlanDetails_PlanProps WHERE attrName = 'Snap Addon'),2)
								ELSE NULL END AS '@snapStatus',
(SELECT attrVal FROM #PlanDetails_PlanProps WHERE attrName = 'FileSystem Addon') AS '@filesystem',
(SELECT attrVal FROM #PlanDetails_PlanProps WHERE attrName = 'Index Copy Addon') AS '@indexCopy'
                      FOR XML PATH('addons'), TYPE),
                     (SELECT ownerId AS '@userId',
                             ISNULL((SELECT TOP 1 name FROM UMUsers U WHERE U.id = P.ownerId), '') AS '@userName',
                             13      AS '@_type_'
                      FOR XML PATH('planOwner'), TYPE),
                     (SELECT permissionId '@permissionId' FROM #planPermissions
                      FOR XML PATH('permissions'), TYPE),
                     (SELECT PP.id		AS '@planId',
                             PP.name	AS '@planName',
						     PP.[type]	AS '@planType',
							 PP.subType AS '@planSubtype',
							 158		AS '@_type_'
                      FROM   APP_Plan PP
WHERE  PP.id IN (SELECT CAST(attrVal AS INT) FROM APP_PlanProp WHERE componentNameId = P.id AND attrName = 'Base plan')
                      FOR XML PATH('parent'), TYPE),
                     (SELECT B.entityId  AS '@id',
                             C.[Message] AS '@name'
FROM dbo.SplitIDString((SELECT attrVal FROM APP_PlanProp WHERE componentNameId = P.id AND attrName = 'Defintion entities : missing')) A
                      INNER JOIN APP_PlanEntity   B ON B.entityId = A._ID
                      INNER JOIN EvLocaleMsgs     C ON C.MessageID = B.displayNameId AND C.LocaleID = @i_localeId
                      FOR XML PATH('missingEntities'), TYPE)
            FOR XML PATH('summary'), TYPE),
            -- alerts
            (SELECT  (SELECT alertId     AS '@alertId',
                             alertName   AS '@alertName'
                      FROM   @planAlerts
                      FOR XML PATH('alerts'), TYPE)
             FOR XML PATH('alerts'), TYPE),
            -- schedule (excluding snap to tape schedule as it is retrieved from snapinfo)
            [definesSchedule/@definesEntity] = ISNULL(@scheduleId_defined, 0),
			[definesSchedule/@overrideEntity] = ISNULL(@scheduleId_override, 0),
            (SELECT
				[task/@taskId] = IIF(@scheduleId = -32000, 4294935296, @scheduleId),
				DBO.GetSubTaskDetails(0, @scheduleId,  @level),
				(SELECT DBO.GetSubTaskDetails(subtaskId, 0,  @level) FROM @subTasks WHERE operationType <> 4028 FOR XML PATH(''), TYPE) -- Snap Copy schedules
			FOR XML PATH('schedule'), TYPE),
            -- storage
			[definesStorage/@definesEntity] = ISNULL(@storageId_defined, 0),
			[definesStorage/@overrideEntity] = ISNULL(@storageId_override, 0),
            (SELECT
				@isDefaultCopyDistributedStorage AS '@isDefaultCopyDistributedStorage',
				[storagePolicy/@storagePolicyId] = @storageId,
				DBO.GetStoragePolicyCopyDetails(@storageId, @level)
			FOR XML PATH('storage'), TYPE),
			-- storage rules
			(CASE WHEN @isElastic = 1 THEN (SELECT @storageRules.query('PlanRulesInfoResp/rules') FOR XML PATH('storageRules'), TYPE) ELSE NULL END),
			-- resource pools
			@resourcePoolMap,
			(SELECT
					@entityRulesXml.value('(/Api_PlanEntityRulesInfoResp/@ruleOperation)[1]', 'INT') as '@ruleOperation',
					@entityRulesXml.query('Api_PlanEntityRulesInfoResp/*')
				FOR XML PATH('entityRules'), TYPE),
			-- backupcopy details
			(SELECT @backupCopyRPOMins AS '@backupCopyRPO',
				(SELECT	[task/@taskId] = IIF(@backupCopyScheduleId = -32000, 4294935296, @backupCopyScheduleId),
					(SELECT TOP 1 DBO.GetSubTaskDetails(S.subtaskId, @backupCopyScheduleId,  @level) FROM @subTasks S
						INNER JOIN TM_Subtask ST WITH(NOLOCK) ON ST.subTaskId = S.subtaskId
AND ST.flags & 0x2000000 > 0
						ORDER BY S.subtaskId
						)
					FOR XML PATH('snapTask'), TYPE
				)
			FOR XML PATH('snapInfo'), TYPE),
             -- laptop
            (SELECT
                -- features
                (SELECT ISNULL(@featureRoleId_defined, 0) AS '@definesEntity', ISNULL(@featureRoleId_override, 0) AS '@overrideEntity' FOR XML PATH('definesFeatures'), TYPE),
                (SELECT  (SELECT (SELECT UP.id AS '@permissionId',
                                         UP.permissionName AS '@permissionName'
                                  FROM   UMRolesPermissions URP INNER JOIN UMPermissions UP ON URP.permissionId = UP.id
                                  WHERE  URP.roleId = @featureRoleId
                                  FOR XML PATH('categoriesPermissionList'), TYPE)
                          FOR XML PATH('categoryPermission'), TYPE),
                         (SELECT  id    AS '@roleId',
                                  name  AS '@roleName'
                          FROM    UMRoles
                          WHERE   id = @featureRoleId
                          FOR XML PATH('role'), TYPE)
                 FOR XML PATH('features'), TYPE),
                 -- access policies
                (SELECT ISNULL(@accessRoleId_defined, 0) AS '@definesEntity', ISNULL(@accessRoleId_override, 0) AS '@overrideEntity' FOR XML PATH('definesAccessPolicies'), TYPE),
                (SELECT  (SELECT (SELECT UP.id AS '@permissionId',
                                         UP.permissionName AS '@permissionName'
                                  FROM   UMRolesPermissions URP INNER JOIN UMPermissions UP ON URP.permissionId = UP.id
                                  WHERE  URP.roleId = @accessRoleId
                                  FOR XML PATH('categoriesPermissionList'), TYPE)
                          FOR XML PATH('categoryPermission'), TYPE),
                         (SELECT  id    AS '@roleId',
                                  name  AS '@roleName'
                          FROM    UMRoles
                          WHERE   id = @accessRoleId
                          FOR XML PATH('role'), TYPE)
                 FOR XML PATH('accessPolicies'), TYPE),
                 -- content
                 (SELECT
                        (SELECT ISNULL(@planSubclientPolicy_2_defined, 0) AS '@definesEntity', ISNULL(@planSubclientPolicy_2_override, 0) AS '@overrideEntity' FOR XML PATH('definesSubclientWin'), TYPE),
                        (SELECT ISNULL(@planSubclientPolicy_3_defined, 0) AS '@definesEntity', ISNULL(@planSubclientPolicy_3_override, 0) AS '@overrideEntity' FOR XML PATH('definesSubclientLin'), TYPE),
                        (SELECT ISNULL(@planSubclientPolicy_4_defined, 0) AS '@definesEntity', ISNULL(@planSubclientPolicy_4_override, 0) AS '@overrideEntity' FOR XML PATH('definesSubclientMac'), TYPE),
                        (SELECT ISNULL(@planSubclientContent_2_defined, 0) AS '@definesEntity', ISNULL(@planSubclientContent_2_override, 0) AS '@overrideEntity' FOR XML PATH('definesSubclientContentWin'), TYPE),
                        (SELECT ISNULL(@planSubclientContent_3_defined, 0) AS '@definesEntity', ISNULL(@planSubclientContent_3_override, 0) AS '@overrideEntity' FOR XML PATH('definesSubclientContentLin'), TYPE),
                        (SELECT ISNULL(@planSubclientContent_4_defined, 0) AS '@definesEntity', ISNULL(@planSubclientContent_4_override, 0) AS '@overrideEntity' FOR XML PATH('definesSubclientContentMac'), TYPE),
                        (SELECT ISNULL(@planSubclientRetention_2_defined, 0) AS '@definesEntity', ISNULL(@planSubclientRetention_2_override, 0) AS '@overrideEntity' FOR XML PATH('definesSubclientRetentionWin'), TYPE),
                        (SELECT ISNULL(@planSubclientRetention_3_defined, 0) AS '@definesEntity', ISNULL(@planSubclientRetention_3_override, 0) AS '@overrideEntity' FOR XML PATH('definesSubclientRetentionLin'), TYPE),
                        (SELECT ISNULL(@planSubclientRetention_4_defined, 0) AS '@definesEntity', ISNULL(@planSubclientRetention_4_override, 0) AS '@overrideEntity' FOR XML PATH('definesSubclientRetentionMac'), TYPE),
						(SELECT ISNULL(@planSubclientArcRules_2_defined, 0) AS '@definesEntity', ISNULL(@planSubclientArcRules_2_override, 0) AS '@overrideEntity' FOR XML PATH('definesSubclientArcRulesWin'), TYPE),
                        (SELECT ISNULL(@planSubclientArcRules_3_defined, 0) AS '@definesEntity', ISNULL(@planSubclientArcRules_3_override, 0) AS '@overrideEntity' FOR XML PATH('definesSubclientArcRulesLin'), TYPE),
                        (SELECT policyType AS '@idatype',
                                 (SELECT (SELECT policyId AS '@backupsetId'
                                          FOR XML PATH('backupSetEntity'), TYPE),
                                      DBO.GetSubClientDetailList(@i_planId, policyType, policyId, @level)
                                  FOR XML PATH('subClientPolicy'), TYPE)
                          FROM    @planSubclientPolicies
                          FOR XML PATH('backupContent'), TYPE)
                  FOR XML PATH('content'), TYPE),
                  -- users
                 (SELECT (SELECT U.email AS '@email',
                                 (SELECT U.id AS '@userId', U.login AS '@userName'
                                  FOR XML PATH('user'), TYPE)
                          FROM     UMUsers U INNER JOIN UMUserGroup UG ON UG.userId = U.id INNER JOIN #usersSec_getUsersNewTbl SEC ON SEC.userId = U.id
                          WHERE    UG.groupId = @userGroupId
                          FOR XML PATH('users'), TYPE),
                         (SELECT (SELECT U.id AS '@userGroupId', U.name AS '@userGroupName'
                                  FOR XML PATH('userGroup'), TYPE)
                          FROM    UMGroups U  INNER JOIN UMDSProviders UP ON UP.id = U.umdsProviderId
                                              INNER JOIN #usergroupsSec_getUsersNewTbl SEC on SEC.userGroupId=u.id
                          WHERE   U.id IN (SELECT groupId FROM @planGroups PG WHERE UP.serviceType = 1)
                          FOR XML PATH('users'), TYPE),
                         (SELECT (SELECT U.id AS '@groupId', U.name AS '@externalGroupName', U.umdsProviderId AS '@providerId', UP.domainName AS '@providerDomainName'
                                  FOR XML PATH('externalUserGroup'), TYPE)
                          FROM    UMGroups U INNER JOIN UMDSProviders UP ON UP.id = U.umdsProviderId
                                             INNER JOIN #usergroupsSec_getUsersNewTbl SEC on SEC.userGroupId=u.id
                          WHERE   U.id IN (SELECT  groupId FROM @planGroups PG WHERE UP.serviceType != 1)
                          FOR XML PATH('users'), TYPE)
                  FOR XML PATH('users'), TYPE)
             FOR XML PATH('laptop'), TYPE),
            -- database
            (SELECT
                    @logSLA AS '@rpoInMinutes',
					@logSLA AS '@slaInMinutes',
					@daysBetweenAutoConvertBackup AS '@daysBetweenAutoConvertBackup',
                     -- log schedule
                    [definesScheduleLog/@definesEntity] =  ISNULL(@logScheduleId_defined, 0),
					[definesScheduleLog/@overrideEntity] = ISNULL(@logScheduleId_override, 0),
					(SELECT
						[task/@taskId] = IIF(@logScheduleId = -32000, 4294935296, @logScheduleId),
						DBO.GetSubTaskDetails(0, @logScheduleId,  @level)
					FOR XML PATH('scheduleLog'), TYPE),
                    -- storage
                    [definesStorageLog/@definesEntity] = ISNULL(@logStorageId_defined, 0),
					[definesStorageLog/@overrideEntity] = ISNULL(@logStorageId_override, 0),
					(SELECT
						[storagePolicy/@storagePolicyId] = @logStorageId,
						DBO.GetStoragePolicyCopyDetails(@logStorageId, @level)
					FOR XML PATH('storageLog'), TYPE)
             FOR XML PATH('database'), TYPE),
            -- options
            (SELECT
(ISNULL((SELECT attrVal FROM #PlanDetails_PlanProps WHERE attrName = 'Optimize for instant clone'), 0)) AS '@optimizeForInstantClone',
(SELECT attrVal FROM #PlanDetails_PlanProps WHERE attrName = 'Quota') AS '@quota',
(SELECT attrVal FROM #PlanDetails_PlanProps WHERE attrName = 'Edge Drive Quota Size') AS '@edgeDriveQuota',
(SELECT attrVal FROM #PlanDetails_PlanProps WHERE attrName = 'Forced Archiving') AS '@forcedArchiving',
(SELECT attrVal FROM #PlanDetails_PlanProps WHERE attrName = 'Enable Indexing') AS '@enableIndexing',
(SELECT attrVal FROM #PlanDetails_PlanProps WHERE attrName = 'Cloud Mode indexing setup status') AS '@indexingStatus',
(SELECT attrVal FROM #PlanDetails_PlanProps WHERE attrName = 'Cloud Mode indexing setup message') AS '@indexingStatusMessage',
(SELECT ISNULL((SELECT attrVal FROM #PlanDetails_PlanProps WHERE attrName = 'Cloud Mode Enabled'),0)) AS '@bCloudModeEnabled',
					(SELECT
						C.id AS '@clientId',
						C.name AS '@clientName',
						C.displayName as '@displayName',
						C.GUID as '@clientGUID'
						FROM App_Client C
WHERE C.id = ISNULL((SELECT attrVal FROM #PlanDetails_PlanProps WHERE attrName = 'Cloud Mode Index Server Id'), 0)
						FOR XML PATH('cloudModeIndexServer'), TYPE),
					(SELECT bitValueSet AS '@val' FROM @targetAppTbl WHERE bitValueSet!=0  FOR XML PATH('targetApps'), TYPE),
                    (SELECT
ISNULL((SELECT attrVal FROM #PlanDetails_PlanProps WHERE attrName = 'Force delete devices after days' AND modified = 0),-1) as '@forceDeleteDevicesAfterDays',
ISNULL((SELECT attrVal FROM #PlanDetails_PlanProps WHERE attrName = 'Retire devices after days' AND modified = 0),-1) as '@retireDevicesAfterDays'
                        FOR XML PATH('autoRetireDevices'),TYPE),
					(SELECT 1 AS '@enableThrottle',
							(SELECT 1 AS '@shareBandwidth',
								(SELECT NetworkThrottleOptions.query('App_ThrottleScheduleOptionList/throttle')
								 FROM   APP_NetworkThrottleOptions
                                 WHERE  clientGroupId = ISNULL((SELECT attrVal FROM #PlanDetails_PlanProps WHERE attrName = 'Assigned client group'), 0))
WHERE ISNULL((SELECT attrVal FROM #PlanDetails_PlanProps WHERE attrName = 'Network throttle'), 0) != 0
							 FOR XML PATH('throttle'), TYPE)
WHERE EXISTS (SELECT * FROM APP_NetworkThrottleOptions WHERE clientGroupId = ISNULL((SELECT attrVal FROM #PlanDetails_PlanProps WHERE attrName = 'Assigned client group'), 0))
                     FOR XML PATH ('network'), TYPE ),
		     		(SELECT
(SELECT attrVal FROM #PlanDetails_PlanProps WHERE attrName = 'SLA option') AS  '@level',
(SELECT attrVal FROM #PlanDetails_PlanProps WHERE attrName = 'SLA option description') AS '@slaDescription',
(SELECT attrVal FROM #PlanDetails_PlanProps WHERE attrName = 'SLA option in days') AS '@slaDays',
(SELECT attrVal FROM #PlanDetails_PlanProps WHERE attrName = 'SLA option exclusion delay interval') AS '@delayInterval',
(SELECT attrVal FROM #PlanDetails_PlanProps WHERE attrName = 'SLA option excluded') AS '@excludeSLA',
						@defaultSystemSLA AS 'inheritedSLA/@slaDays',
1 AS 'inheritedSLA/@entityType'
						FOR XML PATH('slaOptions'), TYPE),
					 @encryptionXML
            FOR XML PATH('options'), TYPE),
            (SELECT
                     -- client group
                     (SELECT  @clientGroupId AS '@clientGroupId',
                              name           AS '@clientGroupName'
                      FROM    APP_ClientGroup
                      WHERE   id = @clientGroupId
                      FOR XML PATH('clientGroup'), TYPE),
                      -- user group
                      (SELECT @userGroupId   AS '@userGroupId',
                              name           AS '@userGroupName'
                      FROM    UMGroups
                      WHERE   id = @userGroupId
                      FOR XML PATH('localUserGroup'), TYPE)
             WHERE ISNULL(@userGroupId, 0) != 0 OR ISNULL(@clientGroupId, 0) != 0
             FOR XML PATH('autoCreatedEntities'), TYPE),
            -- base plan
            (SELECT  @basePlanId    AS '@planId',
                     name           AS '@planName'
             FROM    App_Plan PP
             WHERE   id = @basePlanId
             FOR XML PATH('baseEntity'), TYPE),
             -- security associations
            (SELECT @securityAssociations
             WHERE @securityAssociations IS NOT NULL
			 FOR XML PATH ('securityAssociations'), TYPE),
            -- replicationTargets
            (SELECT ISNULL(@replicationTargets_defined, 0) AS '@definesEntity', ISNULL(@replicationTargets_override, 0) AS '@overrideEntity' FOR XML PATH('definesRelicationTargets'), TYPE),
            (SELECT (SELECT (SELECT taskId AS '@taskId' FOR XML PATH('task'), TYPE) FROM @replicationTargets FOR XML PATH('taskInfo'), TYPE) FOR XML PATH ('replicationTargets'), TYPE),
            -- exchange mailbox configuration policies
            (SELECT
                    -- archiving policy
                    (SELECT ISNULL(@mbArchiving_defined, 0) AS '@definesEntity', ISNULL(@mbArchiving_override, 0) AS '@overrideEntity' FOR XML PATH('definesMBArchiving'), TYPE),
                    (SELECT (SELECT @mbArchiving AS '@policyId' FOR XML PATH('policyEntity'), TYPE) WHERE ISNULL(@mbArchiving, 0) != 0 FOR XML PATH('mbArchiving'), TYPE),
                     -- retention policy group
                    (SELECT ISNULL(@mbRetention_defined, 0) AS '@definesEntity', ISNULL(@mbRetention_override, 0) AS '@overrideEntity' FOR XML PATH('definesMBRetention'), TYPE),
                    (SELECT (SELECT @mbRetention AS '@policyId' FOR XML PATH('policyEntity'), TYPE) WHERE ISNULL(@mbRetention, 0) != 0 FOR XML PATH('mbRetention'), TYPE),
                     -- clean up policy
                    (SELECT ISNULL(@mbCleanup_defined, 0) AS '@definesEntity', ISNULL(@mbCleanup_override, 0) AS '@overrideEntity' FOR XML PATH('definesMBCleanup'),   TYPE),
                    (SELECT (SELECT @mbCleanup AS '@policyId' FOR XML PATH('policyEntity'), TYPE) WHERE ISNULL(@mbCleanup, 0) != 0 FOR XML PATH('mbCleanup'), TYPE),
                    -- journal policy
                    (SELECT ISNULL(@mbJournal_defined, 0) AS '@definesEntity', ISNULL(@mbJournal_override, 0) AS '@overrideEntity' FOR XML PATH('definesMBJournal'),   TYPE),
                    (SELECT (SELECT @mbJournal AS '@policyId' FOR XML PATH('policyEntity'), TYPE) WHERE ISNULL(@mbJournal, 0) != 0 FOR XML PATH('mbJournal'), TYPE)
             FOR XML PATH('exchange'), TYPE),
             -- additional features info
			 (SELECT
                    (SELECT ISNULL(@edgeDriveId_defined, 0) AS '@definesEntity', ISNULL(@edgeDriveId_override, 0) AS '@overrideEntity' FOR XML PATH('definesEdgeDriveInfo'), TYPE),
					(SELECT
ISNULL((SELECT CLP.attrVal FROM APP_ClientProp CLP WITH(NOLOCK) WHERE CLP.componentNameId = @edgeDriveId AND CLP.modified = 0 AND CLP.attrName = 'Edge Drive Enable Audit'),0) AS '@auditDriveActivities',
ISNULL((SELECT CLP.attrVal FROM APP_ClientProp CLP WITH(NOLOCK) WHERE CLP.componentNameId = @edgeDriveId AND CLP.modified = 0 AND CLP.attrName = 'Edge Drive Enable Push Notification'),0) AS '@enableNotificationsForShares',
						 (SELECT (SELECT CL.ID   AS '@clientId',
										 CL.Name AS '@clientName',
										 EA.entityType AS '@_type_'   -- CLIENTENTITY (Index Server)
								  FROM  APP_EdgeDriveAssociation EA INNER JOIN App_Client CL ON EA.EntityID = CL.ID
								  WHERE entityType = 3 AND EA.clientId = @edgeDriveId
								  FOR XML PATH('indexServer'), TYPE),
								 (SELECT CL.id   AS '@clientId',
										 CL.Name AS '@clientName',
										 3       AS '@_type_'    -- defined in CVEntities.x
								  FROM APP_Client CL WITH(NOLOCK)
								  WHERE CL.id = @edgeDriveId
								  FOR XML PATH('clientEntity'), TYPE)
						  FOR XML PATH('edgeDriveAssociations'), TYPE)
					FOR XML PATH('edgedriveInfo'), TYPE)
			  FOR XML PATH('featureInfo'), TYPE),
              --eDiscoveryInfo
			  (SELECT
                    -- cloud analytics
                    (SELECT ISNULL(@analyticsIndexServer_defined, 0) AS '@definesEntity', ISNULL(@analyticsIndexServer_override, 0) AS '@overrideEntity' FOR XML PATH('definesAnalyticsIndexServer'), TYPE),
                    (SELECT @analyticsIndexServer AS '@clientId', @analyticsIndexServerName AS '@clientName',  3 AS '@_type_' WHERE ISNULL(@analyticsIndexServer, 0) != 0 FOR XML PATH('analyticsIndexServer'), TYPE),
                    -- cloud analyzer
                    (SELECT ISNULL(@cloudAnalyzer_defined, 0) AS '@definesEntity', ISNULL(@cloudAnalyzer_override, 0) AS '@overrideEntity' FOR XML PATH('definesContentAnalyzerCloud'), TYPE),
                    (SELECT @cloudAnalyzer AS '@cloudId', @cloudAnalyzerName AS '@cloudDisplayName',  169 AS '@_type_' WHERE ISNULL(@cloudAnalyzer, 0) != 0 FOR XML PATH('contentAnalyzerCloud'), TYPE)
			   FOR XML PATH('eDiscoveryInfo'), TYPE),
			   -- EEPolicy Info
			   (SELECT ISNULL(@dataClassification_defined, 0) AS '@definesEntity', ISNULL(@dataClassification_override, 0) AS '@overrideEntity' FOR XML PATH('definesEEPolicy'),   TYPE),
               (SELECT (SELECT @dataClassification AS '@policyId' FOR XML PATH('policyEntity'), TYPE) WHERE ISNULL(@dataClassification, 0) != 0 FOR XML PATH('eePolicy'), TYPE),
			   -- CIPolicy Info
			   (SELECT ISNULL(@contentIndexPolicy_defined, 0) AS '@definesEntity', ISNULL(@contentIndexPolicy_override, 0) AS '@overrideEntity' FOR XML PATH('definesCIPolicy'),   TYPE),
               (SELECT (SELECT @contentIndexPolicy AS '@policyId' FOR XML PATH('policyEntity'), TYPE) WHERE ISNULL(@contentIndexPolicy, 0) != 0 FOR XML PATH('ciPolicy'), TYPE),
			    -- office 365 configuration policies
				(SELECT
					-- O365 CloudOffice configuration policies
					(SELECT
							-- backup policy
							(SELECT ISNULL(@caBackup_defined, 0) AS '@definesEntity', ISNULL(@caBackup_override, 0) AS '@overrideEntity' FOR XML PATH('definesCABackup'), TYPE),
							(SELECT (SELECT @caBackup AS '@policyId' FOR XML PATH('policyEntity'), TYPE) WHERE ISNULL(@caBackup, 0) != 0 FOR XML PATH('caBackup'), TYPE),
							 -- retention policy group
							(SELECT ISNULL(@caRetention_defined, 0) AS '@definesEntity', ISNULL(@caRetention_override, 0) AS '@overrideEntity' FOR XML PATH('definesCARetention'), TYPE),
							(SELECT (SELECT @caRetention AS '@policyId' FOR XML PATH('policyEntity'), TYPE) WHERE ISNULL(@caRetention, 0) != 0 FOR XML PATH('caRetention'), TYPE),
							 -- clean up policy
							(SELECT ISNULL(@caCleanup_defined, 0) AS '@definesEntity', ISNULL(@caCleanup_override, 0) AS '@overrideEntity' FOR XML PATH('definesCACleanup'),   TYPE),
							(SELECT (SELECT @caCleanup AS '@policyId' FOR XML PATH('policyEntity'), TYPE) WHERE ISNULL(@caCleanup, 0) != 0 FOR XML PATH('caCleanup'), TYPE)
					 FOR XML PATH('o365CloudOffice'), TYPE),
					  -- O365 Exchange mailbox configuration policies
					(SELECT
							-- archiving policy
							(SELECT ISNULL(@o365mbArchiving_defined, 0) AS '@definesEntity', ISNULL(@o365mbArchiving_override, 0) AS '@overrideEntity' FOR XML PATH('definesMBArchiving'), TYPE),
							(SELECT (SELECT @o365mbArchiving AS '@policyId' FOR XML PATH('policyEntity'), TYPE) WHERE ISNULL(@o365mbArchiving, 0) != 0 FOR XML PATH('mbArchiving'), TYPE),
							 -- retention policy group
							(SELECT ISNULL(@o365mbRetention_defined, 0) AS '@definesEntity', ISNULL(@o365mbRetention_override, 0) AS '@overrideEntity' FOR XML PATH('definesMBRetention'), TYPE),
							(SELECT (SELECT @o365mbRetention AS '@policyId' FOR XML PATH('policyEntity'), TYPE) WHERE ISNULL(@o365mbRetention, 0) != 0 FOR XML PATH('mbRetention'), TYPE),
							 -- clean up policy
							(SELECT ISNULL(@o365mbCleanup_defined, 0) AS '@definesEntity', ISNULL(@o365mbCleanup_override, 0) AS '@overrideEntity' FOR XML PATH('definesMBCleanup'),   TYPE),
							(SELECT (SELECT @o365mbCleanup AS '@policyId' FOR XML PATH('policyEntity'), TYPE) WHERE ISNULL(@o365mbCleanup, 0) != 0 FOR XML PATH('mbCleanup'), TYPE)
					 FOR XML PATH('o365Exchange'), TYPE)
				FOR XML PATH('office365Info'),TYPE),
              (SELECT @basePlanSubtype AS '@basePlanSubtype',
                      (SELECT entityId  AS '@val' FROM #planConfig WHERE entityType = @const_entityRequired  FOR XML PATH('required'),  TYPE),
                      (SELECT entityId  AS '@val' FROM #planConfig WHERE entityType = @const_entityForbidden FOR XML PATH('forbidden'), TYPE),
                      (SELECT entityId  AS '@val' FROM #planConfig WHERE entityType = @const_entityPossible  FOR XML PATH('possible'),  TYPE)
               FOR XML PATH('definition'), TYPE),
(SELECT IIF(ISNULL((SELECT attrVal FROM #PlanDetails_PlanProps WHERE attrName = 'Derivation restrictions'), 0) = 0, 0, 1) AS '@isSealed',
                      (SELECT entityId AS '@val' FROM #planConfig WHERE entityType = @const_entityEnforced FOR XML PATH('enforcedEntities'), TYPE),
                      (SELECT entityId AS '@val' FROM #planConfig WHERE entityType = @const_entityPrivate  FOR XML PATH('privateEntities'), TYPE)
               FOR XML PATH('inheritance'), TYPE),
               -- Operation Window
               (SELECT DBO.GetOperationWindowDetails(@operationWindow, @level) FOR XML PATH('operationWindow'), TYPE),
			   (SELECT DBO.GetOperationWindowDetails(@fullOperationWindow, @level) FOR XML PATH('fullOperationWindow'), TYPE),
			   (SELECT
				(SELECT (SELECT IIF(@indexCopyScheduleId = -32000, 4294935296, @indexCopyScheduleId) AS '@taskId' FOR XML PATH('task'), TYPE) FOR XML PATH('schedule'), TYPE)
				FOR XML PATH('indexCopy'),TYPE),
				-- error Messages
CASE WHEN @indexServerFailureReasonDB IS NOT NULL THEN  (SELECT 65540 AS '@planEntity',
						(SELECT @indexServerFailureReasonDB AS '@errorMessage' FOR XML PATH('status'), TYPE)
				 FOR XML PATH('errors'), TYPE) END,
			   -- Associated entities count
			   @assocEntityCount
         FROM APP_Plan P
         WHERE id = @i_planId
         FOR XML PATH('plan'), TYPE)
    FOR XML PATH(''), ROOT('Api_GetPlanDetailsResp')
    )
END ELSE BEGIN
    SET @x_xmlData =
    (
        SELECT
            (SELECT @errorCode                                                                                             AS '@errorCode',
                    (CASE @errorCode WHEN 2 THEN 'Plan not found' WHEN 5 THEN 'Access denied' ELSE 'Processing error' END) AS '@errorMessage'
             FOR    XML PATH('error'), TYPE)
        FOR XML PATH(''), ROOT('Api_GetPlanDetailsResp')
    )
END
IF OBJECT_ID('tempdb.dbo.#planConfig' )                 IS NOT NULL DROP TABLE #planConfig
IF OBJECT_ID('tempdb.dbo.#planPermissions')             IS NOT NULL DROP TABLE #planPermissions
IF OBJECT_ID('tempdb.dbo.#planList')                    IS NOT NULL DROP TABLE #planList
IF OBJECT_ID('tempdb.dbo.#usersSec_getUsersNewTbl')     IS NOT NULL DROP TABLE #usersSec_getUsersNewTbl
IF OBJECT_ID('tempdb.dbo.#usergroupsSec_getUsersNewTbl')IS NOT NULL DROP TABLE #usergroupsSec_getUsersNewTbl
IF OBJECT_ID('tempdb.dbo.#PlanDetails_PlanProps')       IS NOT NULL DROP TABLE #PlanDetails_PlanProps
IF object_id('tempdb.dbo.#tempPlanDetailsTbl') IS NOT null
BEGIN -- if output temp table is present, populate result
   INSERT INTO #tempPlanDetailsTbl VALUES (@x_xmlData)
END
ELSE
BEGIN
	SELECT @x_xmlData
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanGetDetailsV2')
	delete from GxQscripts where name = 'AppPlanGetDetailsV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanGetDetailsV2')
	delete from GXDBVersions where aliasname = 'AppPlanGetDetailsV2'
GO

insert into GXDBVersions values(2, 'AppPlanGetDetailsV2',  'v1.1.2.93.4.1', 'AppPlanGetDetailsV2', 'v1.1.2.93.4.1')
GO

