

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanGetDetails.sp] ---------- 

-- MODIFIED FOR (CCP)
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanGetDetails.sp,v $ $Id: AppPlanGetDetails.sp,v 1.1.2.35 2018/07/05 16:33:25 nshah Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   AppGetProfileDetails   -
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppPlanGetDetails <<<'

IF EXISTS (select * from sysobjects where name='AppPlanGetDetails')
	drop procedure AppPlanGetDetails
IF EXISTS (select * from GxQscripts where name='AppPlanGetDetails')
	delete from GxQscripts where name = 'AppPlanGetDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanGetDetails')
	delete from GXDBVersions where aliasname = 'AppPlanGetDetails'
GO
print '... Creating Procedure: AppPlanGetDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPlanGetDetails
  @i_planId INT,
  @i_userId INT,
  @i_planClass INT,
  @i_planType INT,
  @i_planSubtype INT,
  @x_xmlData XML OUTPUT
AS
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
-------------------------------------------------------------------------------------------------------------------------------------------
--Code Below Here is From AppPlanConstants.spb
-- declare plan properties definition shared values
DECLARE @constAttrType_BasePlan					INT = 260
DECLARE @constAttrName_BasePlan					NVARCHAR(32) = N'BasePlan'
DECLARE @constAttrType_Feature					INT = 261
DECLARE @constAttrName_Feature					NVARCHAR(32) = N'Feature'
DECLARE @constAttrType_Alert					INT = 262
DECLARE @constAttrName_Alert					NVARCHAR(32) = N'Alert'
DECLARE @constAttrType_AccessPolicy				INT = 263
DECLARE @constAttrName_AccessPolicy				NVARCHAR(32) = N'Access policy'
DECLARE @constAttrType_Policy_Subclient			INT = 264
DECLARE @constAttrName_Policy_Subclient			NVARCHAR(32) = N'Subclient policy'
DECLARE @constAttrType_Policy_Schedule			INT = 265
DECLARE @constAttrName_Policy_Schedule			NVARCHAR(32) = N'Schedule policy'
DECLARE @constAttrType_Policy_Storage			INT = 266
DECLARE @constAttrName_Policy_Storage			NVARCHAR(32) = N'Storage policy'
DECLARE @constAttrType_Options					INT = 267
DECLARE @constAttrName_Options_Quota			NVARCHAR(32) = 'Quota'
DECLARE @constAttrName_Options_EdgeDriveQuota	NVARCHAR(32) = 'Edge Drive Quota Size'
DECLARE @constAttrName_Options_Throttle			NVARCHAR(32) = 'Network Throttle'
DECLARE @constAttrType_UserGroupAssigned		INT = 268
DECLARE @constAttrName_UserGroupAssigned		NVARCHAR(32) = 'Assigned user group'
DECLARE @constAttrType_UserGroupIAssoc			INT = 269
DECLARE @constAttrName_UserGroupIAssoc			NVARCHAR(32) = 'Associated internal user group'
DECLARE @constAttrType_UserGroupEAssoc			INT = 270
DECLARE @constAttrName_UserGroupEAssoc			NVARCHAR(32) = 'Associated external user group'
DECLARE @constAttrType_Restrictions				INT = 271
DECLARE @constAttrName_Restrictions				NVARCHAR(32) = 'Entity restrictions'
DECLARE @constAttrType_AssociatedPlan			INT = 272
DECLARE @constAttrName_AssociatedPlan			NVARCHAR(32) = 'Associated Plan'
DECLARE @constAttrType_ClientGroupAssigned		INT = 273
DECLARE @constAttrName_ClientGroupAssigned		NVARCHAR(32) = 'Assigned client group'
DECLARE @constAttType_ScheduledForDeletion		INT = 274
DECLARE @constAttName_ScheduledForDeletion		NVARCHAR(32) = 'Scheduled for deletion'
DECLARE @constAttType_EdgeDriveAssigned  		INT = 275
DECLARE @constAttName_EdgeDriveAssigned 		NVARCHAR(32) = 'Assgined Edge Drive'
DECLARE @constAttrType_Policy_SubclientWin		INT = 276
DECLARE @constAttrName_Policy_SubclientWin		NVARCHAR(32) = N'Subclient policy 2'
DECLARE @constAttrType_Policy_SubclientLin		INT = 277
DECLARE @constAttrName_Policy_SubclientLin		NVARCHAR(32) = N'Subclient policy 3'
DECLARE @constAttrType_Policy_SubclientMac		INT = 278
DECLARE @constAttrName_Policy_SubclientMac		NVARCHAR(32) = N'Subclient policy 4'
DECLARE @constAttType_SubclientRetention		INT = 279
DECLARE @constAttName_SubclientRetention		NVARCHAR(32) = 'Subclient retention period'
DECLARE @constAttType_SubclientVersions			INT = 280
DECLARE @constAttName_SubclientVersions			NVARCHAR(32) = 'Number of Synth Full Versions'
DECLARE @constAttrType_Policy_ScheduleLog   		INT = 281
DECLARE @constAttrName_Policy_ScheduleLog   		NVARCHAR(32) = N'Log schedule policy'
DECLARE @constAttrType_Policy_StorageLog    		INT = 282
DECLARE @constAttrName_Policy_StorageLog   		 NVARCHAR(32) = N'Log storage policy'
DECLARE @constAttType_SlaInMinutes			INT = 283
DECLARE @constAttName_SlaInMinutes			NVARCHAR(32) = N'SLA In Minutes'
DECLARE @constAttType_LogSlaInMinutes			INT = 285
DECLARE @constAttName_LogSlaInMinutes			NVARCHAR(32) = N'Log SLA In Minutes'
DECLARE @constAttType_ReplicationTargets    		INT = 284
DECLARE @constAttName_ReplicationTargets   		 NVARCHAR(32) = N'Replication schedule policy'
DECLARE @constAttType_ForcedArchiving   		INT = 286
DECLARE @constAttName_ForcedArchiving   		 NVARCHAR(32) = N'Forced Archiving'
-- plan entity identifiers are declared in http:--ncvs/source/xref/win/vaultcx/Source/Common/XmlMessage/Api.x : enum PlanEntities
DECLARE @constPlanEntity_StoragePolicy		 INT =   1
DECLARE @constPlanEntity_SubclientPolicy	 INT =   2
DECLARE @constPlanEntity_SchedulePolicy		 INT =   4
DECLARE @constPlanEntity_Features			 INT =   8
DECLARE @constPlanEntity_Users				 INT =  16
DECLARE @constPlanEntity_Alerts				 INT =  32
DECLARE @constPlanEntity_AccessPolicies		 INT =  64
DECLARE @constPlanEntity_Options			 INT = 128
DECLARE @constPlanEntity_SubclientPolicy_Win INT = 256
DECLARE @constPlanEntity_SubclientPolicy_Lin INT = 512
DECLARE @constPlanEntity_SubclientPolicy_Mac INT = 1024
DECLARE @constPlanEntity_ClientGroup		 INT = 2048
DECLARE @constPlanEntity_EdgeDrive           INT = 4096
DECLARE @constPlanEntity_StoragePolicyLog	 INT = 8192
DECLARE @constPlanEntity_SchedulePolicyLog   INT = 16384
DECLARE @constPlanEntity_ReplicationTargets	 INT = 32768
-- entity operations. declared in http:--ncvs/source/xref/11.0-win/vaultcx/Source/Common/XmlMessage/CVGui.x#197 : enum ListOperationType
DECLARE @constOpType_NONE					INT = 0
DECLARE @constOpType_OVERWRITE				INT = 1
DECLARE @constOpType_ADD					INT = 2
DECLARE @constOpType_DELETE					INT = 3
DECLARE @constOpType_CLEAR					INT = 4
-------------------------------------------------------------------------------------------------------------------------------------------
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @errorCode INT = 0
IF @i_planId = 0 BEGIN
    IF @i_planClass IN (0, 1)  BEGIN
		DECLARE @name NVARCHAR(64) = 'Plan ' + CAST(@i_planSubtype AS NVARCHAR(32)) +
									 (CASE @i_planClass WHEN 0 THEN ' master record' WHEN 1 THEN ' template record' ELSE CAST(@i_planClass AS NVARCHAR(32)) + ' record' END)
        SELECT @x_xmlData = ISNULL(value, '<Api_GetPlanDetailsResp />') FROM GXGlobalParam WHERE name = @name
		RETURN
	END ELSE IF @i_planClass = 2 BEGIN
		SET @i_planId = (SELECT id FROM APP_Plan WHERE pclass = 2 AND [type] = @i_planType AND subType = @i_planSubtype)
		IF @i_planId IS NULL BEGIN
			SET @errorCode = 2
		END
    END ELSE BEGIN
        SET @errorCode = 2
    END
END
IF @errorCode = 0 BEGIN
	-- sla values for validation
	DECLARE @slaMinutes int = ISNULL((SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE attrType = @constAttType_SlaInMinutes AND componentNameId = @i_planId),0)
	DECLARE @LogSlaMinutes int = ISNULL((SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE attrType = @constAttType_LogSlaInMinutes AND componentNameId = @i_planId),0)
	-- make sure that entities for the plan exist
	-- -- user groups
	DECLARE @x_xmlGroupResp XML = NULL
	DECLARE @groupId		INT = NULL
    SELECT @i_planSubtype = subType FROM APP_Plan WHERE id = @i_planId
    IF @i_planSubtype = 33554439 BEGIN
	    EXEC AppPlanEnsureUserGroup  @i_planId, @groupId OUTPUT, @x_xmlGroupResp OUTPUT
    END
    -- to check if user has rights to retrieve information about plan
    -- Get the list of plan ids which are visible to user
    IF OBJECT_ID('tempdb.dbo.#planList') IS NOT NULL
    BEGIN
	    DROP TABLE #planList
    END
    CREATE TABLE #planList (planId integer NOT NULL)
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 158, 0, '#planList'
    IF ( (NOT EXISTS (SELECT 1 FROM #planList planList WHERE planid = @i_planId)) AND
	     (NOT EXISTS (SELECT 1 FROM App_plan WHERE id = @i_planId and ownerId=@i_userId)) ) BEGIN
        SET @errorCode = 5
    END
IF (@errorCode = 0) AND (NOT EXISTS (SELECT id FROM App_Plan WHERE id = @i_planId AND ((flag & 0x00004) = 0) AND ((flag & 0x40000000) = 0))) BEGIN
        SET @errorCode = 2
    END
    IF @errorCode = 0 BEGIN
        DECLARE @securityAssociations XML
EXEC sec_getSecurityForEntity @i_userId, @securityAssociations OUTPUT, 158, @i_planId
        IF OBJECT_ID('tempdb.dbo.#planPermissions') IS NOT NULL
            DROP TABLE #planPermissions
        CREATE TABLE #planPermissions (permissionId INT)
EXEC sec_getPermissionsOnEntity '#planPermissions', @i_userId, 158, @i_planId
if not exists(select 1 from #planPermissions where permissionId=31)
        begin
	        insert into #planPermissions
select 31
        end
		--Get users that user has rights on
		IF OBJECT_ID('tempdb.dbo.#UsersSec_getUsersNewTbl')  IS NOT NULL
			DROP TABLE #UsersSec_getUsersNewTbl
		CREATE TABLE  #UsersSec_getUsersNewTbl  ( userId int  primary key);
		DECLARE @includeUsersFlags int = -1;
		DECLARE @excludeUsersFlags int = 0;
SET @includeUsersFlags = ( CAST (0x001 AS INT) )
SET @excludeUsersFlags = ( CAST (0x200 AS INT) | CAST (0x004 AS INT) | CAST (0x080 AS INT) | CAST(0x100 AS INT) )
		EXEC sec_getUsersForThisUser '#UsersSec_getUsersNewTbl' ,@i_userId,0,3,@excludeUsersFlags,@includeUsersFlags
		--select * from umusers where id in(select * from #UsersSec_getUsersNewTbl)
		--Get user groups that user has rights on
		IF OBJECT_ID('tempdb.dbo.#UsergroupsSec_getUsersNewTbl')  IS NOT NULL
			DROP TABLE #UsergroupsSec_getUsersNewTbl
		CREATE TABLE #UsergroupsSec_getUsersNewTbl  ( userGroupId int primary key);
		exec sec_getUserGroupsForThisUser '#UsergroupsSec_getUsersNewTbl',@i_userId
		--select * From umgroups where id in(select userGroupId from #UsergroupsSec_getUsersNewTbl)
        SET @x_xmlData = (
            SELECT
				(SELECT 0 AS '@errorCode' , '' AS '@errorMessage'
					         FOR XML PATH('error'), TYPE),
                (SELECT
                    -- plan info
                   (SELECT  P.type      AS '@type',
                        P.subType       AS '@subtype',
                        P.description   AS '@descripiton',
                        P.flag			AS '@planStatusFlag',
                        (SELECT Count(DISTINCT T.userID) FROM
							(SELECT UMG.userId AS userID FROM #UsersSec_getUsersNewTbl UT
												INNER JOIN UMUserGroup UMG
												    ON UMG.groupId=@groupId AND UT.userId=UMG.userId
							UNION
							SELECT UMG.userId AS userID FROM #UsergroupsSec_getUsersNewTbl UGT
								INNER JOIN APP_PlanProp APP
								ON UGT.userGroupId = CAST(APP.attrVal AS INT) AND APP.attrType IN (@constAttrType_UserGroupIAssoc, @constAttrType_UserGroupEAssoc)
									AND APP.componentNameId=@i_planId
								INNER JOIN UMUserGroup UMG
								ON UMG.groupId=UGT.userGroupId) T) AS '@numUsers',
                            (SELECT  COUNT(1)
                                     FROM    APP_ClientProp CP WITH (READUNCOMMITTED)
WHERE       CP.attrName = 'Associated Plan'
                                             AND modified = 0
                                             AND attrVal = CAST(P.id AS VARCHAR(32)))  AS '@numDevices',
                            ISNULL((SELECT CAST(attrVal AS INT) FROM APP_PlanProp WHERE componentNameId = P.id AND attrType = @constAttrType_Restrictions), 0)  AS '@restrictions',
						@slaMinutes AS '@slaInMinutes',
		                (
                          SELECT P.id           AS '@planId',
					             P.name	        AS '@planName',
					             158            AS '@_type_'    -- defined in CVEntities.x
                          FOR XML PATH('plan'), TYPE
                        ),
                        (
			              SELECT  ownerId                                                               AS '@userId',
					              ISNULL((SELECT TOP 1 name FROM UMUsers U WHERE U.id = P.ownerId), '') AS '@userName',
					              13                                                                    AS '@_type_' -- defined in CVEntities.x
			              FOR XML PATH('planOwner'), TYPE
                        ),
					    (
							select PlanList.permissionId '@permissionId'
							from #planPermissions PlanList
							FOR XML PATH('permissions'),TYPE
						),
						(
						  SELECT PP.id           AS '@planId',
								 PP.name	     AS '@planName',
								 158             AS '@_type_'    -- defined in CVEntities.x
						  FROM	 APP_Plan PP
						  WHERE	 PP.id IN (SELECT CAST(attrVal AS INT) FROM APP_PlanProp WHERE componentNameId = P.id AND attrType = @constAttrType_BasePlan)
						  FOR XML PATH('parent'), TYPE
						)
						FOR XML PATH('summary'), TYPE),
                    -- alerts
                    (SELECT
		                (SELECT   RTRIM(LTRIM(SUBSTRING(attrName, LEN(@constAttrName_Alert) + 1, 32))) AS '@alertId',
                                  (SELECT notificationName FROM NTnotificationRule WHERE id = CAST( RTRIM(LTRIM(SUBSTRING(attrName, LEN(@constAttrName_Alert) + 1, 32))) AS INT)) AS '@alertName'
		                 FROM	  App_PlanProp PP
		                 WHERE    PP.componentNameId = P.id
				              AND PP.attrType = @constAttrType_Alert
				              AND PP.attrVal <> 0 -- return just active ones
		                 FOR XML PATH('alerts'), TYPE)
                     FOR XML PATH('alerts'), TYPE),
                     (SELECT
                    -- features
                    (SELECT
				        (SELECT
					        (SELECT   UP.id AS '@permissionId',
							          UP.permissionName AS '@permissionName'
					         FROM	  App_PlanProp PP
						        INNER JOIN UMRolesPermissions URP ON PP.attrVal = URP.roleId -- AND URP.hierarchyLevel = 122
						        INNER JOIN UMPermissions UP ON URP.permissionId = UP.id
					         WHERE    PP.componentNameId = P.id
						          AND PP.attrType = @constAttrType_Feature
					         FOR XML PATH('categoriesPermissionList'), TYPE)
				         FOR XML PATH('categoryPermission'), TYPE),
				         (SELECT PP.attrVal AS '@roleId'
				         FROM App_PlanProp PP
				         WHERE  PP.componentNameId = P.id AND PP.attrType = @constAttrType_Feature
				         FOR XML PATH('role'), TYPE
				         )
                     FOR XML PATH('features'), TYPE),
                    -- access policies
			        (SELECT
				        (SELECT
					        (SELECT   UP.id AS '@permissionId',
							          UP.permissionName AS '@permissionName'
					         FROM	  App_PlanProp PP
						        INNER JOIN UMRolesPermissions URP ON PP.attrVal = URP.roleId AND URP.hierarchyLevel = 122
						        INNER JOIN UMPermissions UP ON URP.permissionId = UP.id
					         WHERE    PP.componentNameId = P.id
						          AND PP.attrType = @constAttrType_AccessPolicy
					         FOR XML PATH('categoriesPermissionList'), TYPE)
				         FOR XML PATH('categoryPermission'), TYPE),
				         (SELECT PP.attrVal AS '@roleId'
				         FROM App_PlanProp PP
				         WHERE  PP.componentNameId = P.id AND PP.attrType = @constAttrType_AccessPolicy
				         FOR XML PATH('role'), TYPE
				         )
                     FOR XML PATH('accessPolicies'), TYPE),
                        -- content
                        (SELECT
		                    (SELECT
			                    RTRIM(LTRIM(SUBSTRING(attrName, LEN(@constAttrName_Policy_Subclient) + 1, 32))) AS '@idatype',
			                    (SELECT
				                    (SELECT PP.attrVal AS '@backupsetId'
                                     FOR XML PATH('backupSetEntity'), TYPE)
			                     FOR XML PATH('subClientPolicy'), TYPE)
		                     FROM   App_PlanProp PP
		                     WHERE	    PP.componentNameId = P.id
				                    AND PP.attrType = @constAttrType_Policy_Subclient
				                    AND CAST(PP.attrVal AS INT) > 0
		                     FOR XML PATH('backupContent'), TYPE)
                        FOR XML PATH('content'), TYPE),
                        -- users
					(SELECT
                        (SELECT u.email as '@email',
                               (SELECT U.id AS '@userId', U.login AS '@userName'
                                FOR XML PATH('user'), TYPE)
                         FROM     UMUsers U INNER JOIN UMUserGroup UG ON UG.userId = U.id
						  INNER JOIN  #UsersSec_getUsersNewTbl SEC ON SEC.userId= U.id
                         WHERE    UG.groupId = @groupId
                         FOR XML PATH('users'), TYPE),
                        (SELECT
                               (SELECT U.id AS '@userGroupId', U.name AS '@userGroupName'
                                FOR XML PATH('userGroup'), TYPE)
                         FROM     UMGroups U  INNER JOIN
						 UMDSProviders UP ON UP.id = U.umdsProviderId
						 INNER JOIN #UsergroupsSec_getUsersNewTbl sec on sec.userGroupId=u.id
                         WHERE    U.id IN (SELECT CAST(attrVal AS INT) FROM App_PlanProp PP WHERE PP.componentNameId = P.id AND PP.attrType = @constAttrType_UserGroupIAssoc AND up.serviceType=1)
                         FOR XML PATH('users'), TYPE),
                        (SELECT
                               (SELECT U.id AS '@groupId', U.name AS '@externalGroupName', U.umdsProviderId AS '@providerId', UP.domainName AS '@providerDomainName'
                                FOR XML PATH('externalUserGroup'), TYPE)
                         FROM     UMGroups U
						 INNER JOIN UMDSProviders UP ON UP.id = U.umdsProviderId
						 INNER JOIN #UsergroupsSec_getUsersNewTbl sec on sec.userGroupId=u.id
                         WHERE    U.id IN (SELECT CAST(attrVal AS INT) FROM App_PlanProp PP WHERE PP.componentNameId = P.id AND (PP.attrType = @constAttrType_UserGroupEAssoc or PP.attrType = @constAttrType_UserGroupIAssoc AND up.serviceType=5))
                         FOR XML PATH('users'), TYPE)
				         FOR XML PATH('users'), TYPE)
                    FOR XML PATH('laptop'), TYPE),
                    -- schedule
                    (SELECT    (SELECT PP.attrVal AS '@taskId' FOR XML PATH('task'), TYPE)
		             FROM	   App_PlanProp PP
		             WHERE     PP.componentNameId = P.id
                           AND PP.attrType = @constAttrType_Policy_Schedule
                           AND CAST(PP.attrVal AS INT) > 0
                     FOR XML PATH('schedule'), TYPE),
                     -- storage
                    (SELECT    (SELECT PP.attrVal AS '@storagePolicyId' FOR XML PATH('storagePolicy'), TYPE)
		             FROM	   App_PlanProp PP
		             WHERE     PP.componentNameId = P.id
                           AND PP.attrType = @constAttrType_Policy_Storage
                           AND CAST(PP.attrVal AS INT) > 0
                     FOR XML PATH('storage'), TYPE),
					 (SELECT
						@LogSlaMinutes AS '@slaInMinutes',
						 -- log schedule
	                    (SELECT    (SELECT PP.attrVal AS '@taskId' FOR XML PATH('task'), TYPE)
			             FROM	   App_PlanProp PP
			             WHERE     PP.componentNameId = P.id
	                           AND PP.attrType = @constAttrType_Policy_ScheduleLog
	                           AND CAST(PP.attrVal AS INT) > 0
	                     FOR XML PATH('scheduleLog'), TYPE),
	                     -- log storage
	                    (SELECT    (SELECT PP.attrVal AS '@storagePolicyId' FOR XML PATH('storagePolicy'), TYPE)
			             FROM	   App_PlanProp PP
			             WHERE     PP.componentNameId = P.id
	                           AND PP.attrType = @constAttrType_Policy_StorageLog
	                           AND CAST(PP.attrVal AS INT) > 0
							 FOR XML PATH('storageLog'), TYPE)
					 FOR XML PATH('database'), TYPE),
		            -- options
		            (SELECT
                        (SELECT PP.attrVal FROM App_PlanProp PP WHERE PP.componentNameId = P.id AND PP.attrType = @constAttrType_Options AND PP.attrName = @constAttrName_Options_Quota) AS '@quota',
						(SELECT PP.attrVal FROM App_PlanProp PP WHERE PP.componentNameId = P.id AND PP.attrType = @constAttrType_Options AND PP.attrName = @constAttrName_Options_EdgeDriveQuota) AS '@edgeDriveQuota',
(SELECT dbo.AppPlanGetEntityValueV2(@i_planId, 'Forced Archiving', default)) AS '@forcedArchiving',
						(SELECT 1 AS '@enableThrottle',
							(SELECT 1 AS '@shareBandwidth',
								(SELECT NetworkThrottleOptions.query('App_ThrottleScheduleOptionList/throttle')
								 FROM   APP_NetworkThrottleOptions
								 WHERE      clientGroupId = ISNULL((SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE attrType = @constAttrType_ClientGroupAssigned AND componentNameId = P.id),0))
							 WHERE (SELECT CAST(attrVal AS INT) FROM App_PlanProp PP WHERE PP.componentNameId = P.id AND PP.attrType = @constAttrType_Options AND PP.attrName = @constAttrName_Options_Throttle) != 0
							 FOR XML PATH('throttle'), TYPE)
						 WHERE EXISTS (SELECT * FROM APP_NetworkThrottleOptions WHERE clientGroupId = ISNULL((SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE attrType = @constAttrType_ClientGroupAssigned AND componentNameId = P.id),0))
						 FOR XML PATH ('network'), TYPE )
		            FOR XML PATH('options'), TYPE),
					-- client group
					(SELECT
						(SELECT  PP.attrVal AS '@clientGroupId',
								 (SELECT name FROM APP_ClientGroup WHERE id = CAST(PP.attrVal AS INT)) AS '@clientGroupName'
						 FROM	 App_PlanProp PP
						 WHERE	    PP.componentNameId = P.id
								AND PP.attrType = @constAttrType_ClientGroupAssigned
						 FOR XML PATH('clientGroup'), TYPE)
					 FOR XML PATH('autoCreatedEntities'), TYPE),
					 -- user group
					(SELECT
						(SELECT  PP.attrVal AS '@userGroupId',
								 (SELECT name FROM UMGroups WHERE id = CAST(PP.attrVal AS INT)) AS '@userGroupName'
						 FROM	 App_PlanProp PP
						 WHERE	    PP.componentNameId = P.id
								AND PP.attrType = @constAttrType_UserGroupAssigned
						 FOR XML PATH('localUserGroup'), TYPE)
					 FOR XML PATH('autoCreatedEntities'), TYPE),
                     -- base plan
					(SELECT  PP.attrVal AS '@planId',
                             (SELECT name FROM App_Plan WHERE id = CAST(PP.attrVal AS INT)) AS '@planName'
		             FROM	 App_PlanProp PP
		             WHERE	    PP.componentNameId = P.id
				            AND PP.attrType = @constAttrType_BasePlan
					 FOR XML PATH('baseEntity'), TYPE),
		         -- Security associations
			         (
				        SELECT @securityAssociations
				        FOR XML PATH ('securityAssociations'),TYPE
			         ),
					 -- replication details
                    (SELECT    (SELECT PP.attrVal AS '@taskId' FOR XML PATH('task'), TYPE)
		             FROM	   App_PlanProp PP
		             WHERE     PP.componentNameId = P.id
                           AND PP.attrType = @constAttType_ReplicationTargets
                           AND CAST(PP.attrVal AS INT) > 0
                     FOR XML PATH('taskInfo'),root('replicationTargets'), TYPE),
			-- AdditionalFeatureInfo
			 (SELECT
				(SELECT
					(SELECT
						CL.ID AS '@clientId',
						CL.Name AS '@clientName',
						EA.entityType AS '@_type_'   -- CLIENTENTITY (Index Server)
					FROM APP_EdgeDriveAssociation EA INNER JOIN App_Client CL ON EA.EntityID = CL.ID
					WHERE entityType=3 AND EA.clientId = CAST(PLP.attrVal AS INT)
					FOR XML PATH('indexServer'), TYPE),
                    (SELECT
                        CL.id AS '@clientId',
                        CL.NAme AS '@clientName',
                        3 AS '@_type_'    -- defined in CVEntities.x
                       FROM APP_Client CL WITH(NOLOCK)
                       WHERE CL.id = CAST(PLP.attrVal AS INT)
                     FOR XML PATH('clientEntity'), TYPE)
					FROM  App_PlanProp PLP
                WHERE PLP.componentNameId = @i_planId AND PLP.attrType = @constAttType_EdgeDriveAssigned
				FOR XML PATH('edgedriveInfo'), TYPE)
			FOR XML PATH('featureInfo'), TYPE)
                 FROM App_Plan P
                 WHERE id = @i_planId
                 FOR XML PATH('plan'), TYPE)
            FOR XML PATH(''), ROOT('Api_GetPlanDetailsResp')
            )
    END
END
IF @errorCode != 0 BEGIN
    SET @x_xmlData =
    (
        SELECT
            (SELECT @errorCode '@errorCode', (CASE @errorCode WHEN 2 THEN 'Plan not found' WHEN 5 THEN 'Access denied' ELSE 'Processing error' END) '@errorMessage'
	         FOR	XML PATH('error'), TYPE)
        FOR XML PATH(''), ROOT('Api_GetPlanDetailsResp')
    )
END
SELECT @x_xmlData
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanGetDetails')
	delete from GxQscripts where name = 'AppPlanGetDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanGetDetails')
	delete from GXDBVersions where aliasname = 'AppPlanGetDetails'
GO

insert into GXDBVersions values(2, 'AppPlanGetDetails',  '00010001000200350000', 'AppPlanGetDetails', '00010001000200350000')
GO

