

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanGetDerivedUsersGroups.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanGetDerivedUsersGroups.sp,v $ $Id: AppPlanGetDerivedUsersGroups.sp,v 1.1.2.1 2018/12/12 11:59:45 alakra Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppPlanGetDerivedUsersGroups')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanGetDerivedUsersGroups <<<'
	drop procedure AppPlanGetDerivedUsersGroups
END
IF EXISTS (select * from GxQscripts where name='AppPlanGetDerivedUsersGroups')
	delete from GxQscripts where name = 'AppPlanGetDerivedUsersGroups'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanGetDerivedUsersGroups')
	delete from GXDBVersions where aliasname = 'AppPlanGetDerivedUsersGroups'
GO
print '... Creating Procedure: AppPlanGetDerivedUsersGroups'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPlanGetDerivedUsersGroups
  @i_userId INTEGER,
  @i_localeId INTEGER,
  @i_planId INTEGER,
  @x_xmlData XML OUTPUT ,
  @o_errCode INTEGER OUTPUT,
  @o_errString VARCHAR(1024) OUTPUT
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET @o_errCode = 0
	SET @o_errString = ''
	-- IF OBJECT_ID('tempdb.dbo.#planList')                    IS NOT NULL DROP TABLE #planList
	-- CREATE TABLE #planList					(planId INT NOT NULL)
	--
	-- -- to check if user has rights to retrieve information about plan get the list of plan ids which are visible to user
-- EXEC sec_getNonIdaObjectsForThisUser @i_userId, 158, 31, '#planList'
-- EXEC sec_getNonIdaObjectsForThisUser @i_userId, 158, 159, '#planList'
-- EXEC sec_getNonIdaObjectsForThisUser @i_userId, 158, 158, '#planList'
-- EXEC sec_getNonIdaObjectsForThisUser @i_userId, 158, 157, '#planList'
	--
	-- IF ( (NOT EXISTS (SELECT 1 FROM #planList planList WHERE planid = @i_planId)) AND
	-- 		(NOT EXISTS (SELECT 1 FROM App_plan WHERE id = @i_planId and ownerId = @i_userId)) )
	-- BEGIN
	-- 	SET @o_errCode = 5 -- access denied
	-- 	SET @o_errString = 'Access denied'
	-- END
	IF OBJECT_ID('tempdb.dbo.#AppPlanProcess_tmp__Plans_Derived') IS NOT NULL DROP TABLE #AppPlanProcess_tmp__Plans_Derived
	IF OBJECT_ID('tempdb.dbo.#usergroups_Plan')IS NOT NULL DROP TABLE #usergroups_Plan
	CREATE TABLE #AppPlanProcess_tmp__Plans_Derived(planId INT PRIMARY KEY, basePlanId INT, planSubType INT)
	CREATE TABLE #usergroups_Plan  (userGroupId INT , userGroupName NVARCHAR(MAX), providerId INT, providerName NVARCHAR(MAX), isExternalGroup INT)
	-- get list of all derived plans
	;WITH T(planId, basePlanId, planSubType) AS
	(
		SELECT  P.id, CAST(PP.attrVal AS INT), p.subType
FROM    APP_Plan P WITH(NOLOCK) INNER JOIN APP_PlanProp PP WITH(NOLOCK) ON PP.attrName = 'Base plan' AND  attrVal = @i_planId AND PP.componentNameId = P.id
		UNION ALL
		SELECT  PP.componentNameId, T.planId, P.subType
FROM    APP_PlanProp PP WITH(NOLOCK) INNER JOIN T ON PP.attrVal = CAST(T.planId AS VARCHAR) AND attrName = 'Base plan'
												INNER JOIN APP_Plan P WITH(NOLOCK) ON P.id = PP.componentNameId
	)
	INSERT INTO #AppPlanProcess_tmp__Plans_Derived
	SELECT DISTINCT * FROM T
	INSERT INTO #usergroups_Plan
	SELECT  Ug.id, UG.name, UD.id,UD.domainName, CASE WHEN UD.serviceType=1 THEN 0 ELSE 1 END
		FROM App_PlanProp APP
		INNER JOIN #AppPlanProcess_tmp__Plans_Derived APT
ON APT.planId=APP.componentNameId AND APP.attrName IN ('Assigned user group','Associated internal user group','Associated external user group')
		INNER JOIN UMGroups UG
			ON CAST(UG.id AS NVARCHAR(1024))=APP.attrVal
		INNER JOIN UMDSProviders UD
			ON UD.id=UG.umdsProviderId
	SET @x_xmlData = (SELECT
				(SELECT (SELECT userGroupId AS '@userGroupId', userGroupName AS '@userGroupName'
                                  FOR XML PATH('userGroup'), TYPE)
                          FROM    #usergroups_Plan WHERE isExternalGroup=0
                          FOR XML PATH('users'), TYPE),
				(SELECT (SELECT userGroupId AS '@groupId', userGroupName AS '@externalGroupName', providerId AS '@providerId', providerName AS '@providerDomainName'
                                  FOR XML PATH('externalUserGroup'), TYPE)
                          FROM    #usergroups_Plan WHERE isExternalGroup=1
                          FOR XML PATH('users'), TYPE)
				FOR XML PATH('Api_PlanUsers'),TYPE)
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanGetDerivedUsersGroups')
	delete from GxQscripts where name = 'AppPlanGetDerivedUsersGroups'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanGetDerivedUsersGroups')
	delete from GXDBVersions where aliasname = 'AppPlanGetDerivedUsersGroups'
GO

insert into GXDBVersions values(2, 'AppPlanGetDerivedUsersGroups',  '00010001000200010000', 'AppPlanGetDerivedUsersGroups', '00010001000200010000')
GO

