

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanGetDerivedPlansV2.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- --------------------------------------------------------------------------------------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanGetDerivedPlansV2.sp,v $ $Id: AppPlanGetDerivedPlansV2.sp,v 1.1.2.1 2020/01/31 06:28:45 evolohov Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppPlanGetDerivedPlansV2')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanGetDerivedPlansV2 <<<'
	drop procedure AppPlanGetDerivedPlansV2
END
IF EXISTS (select * from GxQscripts where name='AppPlanGetDerivedPlansV2')
	delete from GxQscripts where name = 'AppPlanGetDerivedPlansV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanGetDerivedPlansV2')
	delete from GXDBVersions where aliasname = 'AppPlanGetDerivedPlansV2'
GO
print '... Creating Procedure: AppPlanGetDerivedPlansV2'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPlanGetDerivedPlansV2
  @i_planId INT,
  @i_mode INT,
  @i_userId INT,
  @i_localeId INT
AS
    -- added to prevent extra result sets from interfering with SELECT statements.
    SET NOCOUNT ON
    DECLARE @rv     INT = 0
    DECLARE @debug  INT = 0
    IF OBJECT_ID('tempdb.dbo.#AppPlanHierarchy_tmp__Plans') IS NOT NULL DROP TABLE #AppPlanHierarchy_tmp__Plans
    CREATE TABLE #AppPlanHierarchy_tmp__Plans(planId INT PRIMARY KEY, planName NVARCHAR(512), basePlanId INT,  basePlanName NVARCHAR(512), depth INT)
    IF OBJECT_ID('tempdb.dbo.#AppPlanHierarchy_tmp__VisiblePlans') IS NOT NULL DROP TABLE #AppPlanHierarchy_tmp__VisiblePlans
    CREATE TABLE #AppPlanHierarchy_tmp__VisiblePlans(planId INT PRIMARY KEY)
    -- get list of all derived plans, note that base plan names are not being gathered here as it will requre separate SELECT call for every row
    ;WITH T(planId, planName, basePlanId, basePlanName, depth) AS
    (
        SELECT  P.id, P.[name], CAST(PP.attrVal AS INT), '', 0
FROM    APP_Plan P WITH(NOLOCK) INNER JOIN APP_PlanProp PP WITH(NOLOCK) ON PP.attrName = 'Base plan' AND  attrVal = @i_planId AND PP.componentNameId = P.id
        UNION ALL
        SELECT  PP.componentNameId, P.[name], T.planId, '', (T.depth + 1)
FROM    APP_PlanProp PP WITH(NOLOCK) INNER JOIN T ON PP.attrVal = CAST(T.planId AS VARCHAR) AND attrName = 'Base plan'
                                             INNER JOIN APP_Plan P WITH(NOLOCK) ON P.id = PP.componentNameId
    )
    INSERT INTO #AppPlanHierarchy_tmp__Plans SELECT DISTINCT * FROM T
    -- get base plan names in a single shot
    UPDATE  #AppPlanHierarchy_tmp__Plans SET basePlanName = P.name
    FROM    App_Plan P
    WHERE   P.id = #AppPlanHierarchy_tmp__Plans.basePlanId
    IF @debug != 0 SELECT 'full hierarchy', * FROM #AppPlanHierarchy_tmp__Plans
    DELETE FROM #AppPlanHierarchy_tmp__Plans
    WHERE @i_mode = 1 AND depth > 0
    IF @debug != 0 SELECT 'depth filtered hierarchy', * FROM #AppPlanHierarchy_tmp__Plans
    -- adjust plan owners for those plans for which owner was deleted from the system.
    -- just make admin user new owner of such plans
    DECLARE @adminUser INT = ISNULL((SELECT TOP 1 UG.userId
                              FROM UMUserGroup UG INNER JOIN UMGroups G ON G.id = UG.groupId
							                      INNER JOIN UMUsers  U ON U.id = UG.groupId AND G.allAssociations = 1 AND G.allCapabilities = 1 AND G.selfAssociation = 1 AND U.enabled = 1), 0)
    UPDATE App_Plan SET ownerId  = @adminUser
    WHERE  (ownerId != @adminUser) AND (ownerId IN (SELECT id FROM UMUsers WHERE flags = 0 AND [login] LIKE '%deleted%'))
    -- remove plans not visible for user
    -- get list of plans visible to the user @i_userId
    INSERT INTO #AppPlanHierarchy_tmp__VisiblePlans
        EXEC sec_getNonIdaObjectsForThisUserWrapperV2 1, 158, '31,157,158,159' -- visible, edit, delete, (de-)associate
    -- remove all records which contain plan id or base plan id not present in the list of user visible plans
    DELETE  FROM #AppPlanHierarchy_tmp__Plans
    FROM    #AppPlanHierarchy_tmp__Plans P
    WHERE       P.planId     NOT IN (SELECT planId FROM #AppPlanHierarchy_tmp__VisiblePlans)
            OR  P.basePlanId NOT IN (SELECT planId FROM #AppPlanHierarchy_tmp__VisiblePlans)
    -- return value
    SELECT @rv = COUNT(1) FROM #AppPlanHierarchy_tmp__Plans
    -- do not change order of the output columns as webserver relies on this order
    SELECT planId, planName, basePlanId, basePlanName, depth AS 'level' FROM #AppPlanHierarchy_tmp__Plans
    IF OBJECT_ID('tempdb.dbo.#AppPlanHierarchy_tmp__VisiblePlans') IS NOT NULL DROP TABLE #AppPlanHierarchy_tmp__VisiblePlans
    IF OBJECT_ID('tempdb.dbo.#AppPlanHierarchy_tmp__Plans') IS NOT NULL DROP TABLE #AppPlanHierarchy_tmp__Plans
    SET NOCOUNT OFF
    RETURN @rv
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanGetDerivedPlansV2')
	delete from GxQscripts where name = 'AppPlanGetDerivedPlansV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanGetDerivedPlansV2')
	delete from GXDBVersions where aliasname = 'AppPlanGetDerivedPlansV2'
GO

insert into GXDBVersions values(2, 'AppPlanGetDerivedPlansV2',  '00010001000200010000', 'AppPlanGetDerivedPlansV2', '00010001000200010000')
GO

