

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanGetDefaultPlanWrapper.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanGetDefaultPlanWrapper.sp,v $ $Id: AppPlanGetDefaultPlanWrapper.sp,v 1.1.6.2 2018/04/12 03:03:57 anagrale Exp $";
--	+===================================================================+
--	|  			AppPlanGetDefaultPlanWrapper  								|
--	|		 Procedure to get default plan information						|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppPlanGetDefaultPlanWrapper <<<'

IF EXISTS (select * from sysobjects where name='AppPlanGetDefaultPlanWrapper')
	drop procedure AppPlanGetDefaultPlanWrapper
IF EXISTS (select * from GxQscripts where name='AppPlanGetDefaultPlanWrapper')
	delete from GxQscripts where name = 'AppPlanGetDefaultPlanWrapper'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanGetDefaultPlanWrapper')
	delete from GXDBVersions where aliasname = 'AppPlanGetDefaultPlanWrapper'
GO
print '... Creating Procedure: AppPlanGetDefaultPlanWrapper'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPlanGetDefaultPlanWrapper
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
   -- Temp result tables - plan ID table
   IF object_id('tempdb.dbo.#tempPlanIdTbl') IS NOT null DROP TABLE #tempPlanIdTbl
   CREATE TABLE #tempPlanIdTbl
   (
      planId INT,
      errCode INT,
      errString VARCHAR(1024)
   )
   -- Temp result tables - plan Details table
   IF object_id('tempdb.dbo.#tempPlanDetailsTbl') IS NOT null DROP TABLE #tempPlanDetailsTbl
   CREATE TABLE #tempPlanDetailsTbl
   (
     spOutput XML
   )
   DECLARE @o_xmlString  XML -- output string
   DECLARE @errCode      INTEGER = 0 -- error code
   DECLARE @errString    VARCHAR(1024)  ='' -- error string
   -- Plan ID
   DECLARE @i_planId INT = ISNULL (( SELECT ref.value('@planId', 'INT')
           FROM @i_xmlString.nodes ('Api_GetDefaultPlanReq/plan') R(ref)), 0)
   -- Plan class
   -- Assume regular plan
   DECLARE @i_planClass INT
   SET @i_planClass = 3
   -- Plan type
   -- if not passed, assume any
   DECLARE @i_planType  INT = ISNULL (( SELECT ref.value('@planType', 'INT')
           FROM @i_xmlString.nodes ('Api_GetDefaultPlanReq/plan') R(ref)), 0)
   -- Plan subtype
   -- if not passed, assume any
   DECLARE @i_planSubtype INT = ISNULL (( SELECT ref.value('@planSubtype', 'INT')
           FROM @i_xmlString.nodes ('Api_GetDefaultPlanReq/plan') R(ref)), 0)
   -- User Id
   DECLARE @i_userId INT = ISNULL((SELECT ref.value('@userId', 'INT')
           FROM @i_xmlString.nodes('Api_GetDefaultPlanReq/processinginstructioninfo/user') r (ref)), 1)
   -- Locale
   DECLARE @i_localeId INT = ISNULL((SELECT  ref.value('@localeId', 'int')
           FROM @i_xmlString.nodes('App_GetAssociatedEntities/processinginstructioninfo/locale') R ( ref )),0)
   -- Property level (default property is list only)
   DECLARE @i_propertyLevel INT = ISNULL (( SELECT ref.value('@ePropertyLevel', 'INT')
           FROM @i_xmlString.nodes ('Api_GetDefaultPlanReq') R(ref)), 1)
   -- Plan ID is not passed fetch the plan ID for given entity
   IF @i_planId = 0
   BEGIN
      -- get entity ID
      DECLARE @i_entityId INT = ISNULL (( SELECT ref.value('@entityId', 'INT')
           FROM @i_xmlString.nodes ('Api_GetDefaultPlanReq/entity') R(ref)), 0)
      -- get entity Type
      DECLARE @i_entityType INT = ISNULL (( SELECT ref.value('@entityType', 'INT')
           FROM @i_xmlString.nodes ('Api_GetDefaultPlanReq/entity') R(ref)), 0)
      -- get client ID
      DECLARE @i_clientId INT = ISNULL (( SELECT ref.value('@clientId', 'INT')
           FROM @i_xmlString.nodes ('Api_GetDefaultPlanReq/entity/client') R(ref)), 0)
	  IF @i_entityId > 0
      BEGIN
	     DECLARE @temp_planId INT
         EXEC AppPlanGetEnitityDefaultPlan @i_userId, @i_localeId, @i_entityId, @i_entityType, 1, @i_clientId, @i_planSubtype, @temp_planId , @errCode, @errString
		 SELECT @temp_planId = TBL.planId, @errCode = TBL.errCode, @errString = TBL.errString  FROM #tempPlanIdTbl TBL
      END
	  ELSE
	  BEGIN
	     SET @errCode = -1
		 SET @errString = 'Entity not initialized'
	  END
      -- SET the plan ID
      IF @errCode = 0
         SET @i_planId = @temp_planId
   END
   IF @errCode = 0
   BEGIN
	 IF @i_planId > 0
	 BEGIN
		IF @i_propertyLevel >= 10  -- Fetch plan properties
		BEGIN
	      EXEC AppPlanGetDetailsV2 @i_planId, @i_userId, @i_planClass, @i_planType, @i_planSubtype, @o_xmlString OUTPUT
          SELECT @o_xmlString= spOutput from #tempPlanDetailsTbl
		END
	    ELSE -- list only plan Id
	    BEGIN
          SET @o_xmlString = (
              SELECT
                (SELECT 0 AS '@errorCode' , '' AS '@errorMessage'
                   FOR XML PATH('error'), TYPE),
                      (SELECT
                          -- plan info
                          (SELECT  @i_planType AS '@type',
                                  @i_planSubtype   AS '@subtype',
                                  (
                                      SELECT PP.id   AS '@planId',
                                             PP.name AS '@planName',
                                             158     AS '@_type_'    -- defined in CVEntities.x
                                             FROM   APP_Plan PP WITH(NOLOCK)
                                             WHERE  PP.id = @i_planId
                                      FOR XML PATH('plan'), TYPE)
                            FOR XML PATH('summary'), TYPE)
                         FOR XML PATH('plan'), TYPE)
                  FOR XML PATH(''), ROOT('Api_GetPlanDetailsResp'))
           END
      END -- plan ID is non-zero
   END
   IF @errCode <> 0
   BEGIN
     SET @o_xmlString =
     (
         SELECT
           (SELECT @errCode  AS '@errCode',
              (CASE @errCode
                 WHEN 2
                    THEN 'Plan not found'
                 WHEN 5
                    THEN 'Access denied'
                 ELSE
                    CONCAT ('Processing error: ', @errString)
                 END) AS '@errorMessage'
				FOR    XML PATH('error'), TYPE)
                   FOR XML PATH(''), ROOT('Api_GetPlanDetailsResp')
	  )
   END
   -- Drop intermediate tables
   DROP TABLE #tempPlanIdTbl
   DROP TABLE #tempPlanDetailsTbl
   IF @o_xmlString IS NULL
      SET @o_xmlString = '<Api_GetPlanDetailsResp/>'
   SELECT @o_xmlString  as o_xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanGetDefaultPlanWrapper')
	delete from GxQscripts where name = 'AppPlanGetDefaultPlanWrapper'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanGetDefaultPlanWrapper')
	delete from GXDBVersions where aliasname = 'AppPlanGetDefaultPlanWrapper'
GO

insert into GXDBVersions values(2, 'AppPlanGetDefaultPlanWrapper',  '00010001000600020000', 'AppPlanGetDefaultPlanWrapper', '00010001000600020000')
GO

