

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanGetClientsAssociated.sp] ---------- 

--  +=====================================================================================================================+
--  |		 		 Name:  AppPlanGetUsersAssociated()
--  | Description:  Allows to GET Users count for all plan that user have some sort of right on.
--  +=====================================================================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanGetClientsAssociated.sp,v $ $Id: AppPlanGetClientsAssociated.sp,v 1.1.2.6 2019/06/12 06:31:13 evolohov Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppPlanGetClientsAssociated')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanGetClientsAssociated <<<'
	drop procedure AppPlanGetClientsAssociated
END
IF EXISTS (select * from GxQscripts where name='AppPlanGetClientsAssociated')
	delete from GxQscripts where name = 'AppPlanGetClientsAssociated'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanGetClientsAssociated')
	delete from GXDBVersions where aliasname = 'AppPlanGetClientsAssociated'
GO
print '... Creating Procedure: AppPlanGetClientsAssociated'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPlanGetClientsAssociated
  @i_planId INTEGER,
  @i_planType INTEGER,
  @i_userId INTEGER,
  @o_xmlClients XML OUTPUT
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
DECLARE @debug INT = 0;
DECLARE @errorCode	  INT = 0
DECLARE @errorMessage NVARCHAR(MAX) = ''
IF OBJECT_ID('tempdb.dbo.#AppPlanGetClientsAssociated_tmp__planList') IS NOT null DROP TABLE #AppPlanGetClientsAssociated_tmp__planList
CREATE TABLE #AppPlanGetClientsAssociated_tmp__planList (planId integer NOT NULL)
DECLARE @clients AS TABLE (clientId             INT PRIMARY KEY,
                           clientName           NVARCHAR(510),
                           clientHost           NVARCHAR(510),
                           clientGUID           VARCHAR(510),
                           ciientDisplayName    NVARCHAR(510),
                           accessible    INT)
BEGIN TRY
	DECLARE @subtype INT = ISNULL(@i_planType, 0)
	IF @subtype = 0 BEGIN	-- request for subclients associated with the plan
		EXEC sec_getNonIdaObjectsForThisUser @i_userId, 158, 0, '#AppPlanGetClientsAssociated_tmp__planList'
        IF @debug != 0 BEGIN
            SELECT 'plans', * FROM #AppPlanGetClientsAssociated_tmp__planList
        END
		IF ((NOT EXISTS (SELECT 1 FROM #AppPlanGetClientsAssociated_tmp__planList WHERE planid = @i_planId)) AND
            (NOT EXISTS (SELECT 1 FROM App_plan WHERE id = @i_planId AND ownerId = @i_userId))) BEGIN
				SET @errorCode = 5
				SET @errorMessage = 'Access denied'
		END
IF (@errorCode = 0) AND (NOT EXISTS (SELECT id FROM App_Plan WHERE id = @i_planId AND ((flag & 0x00004) = 0) AND ((flag & 0x40000000) = 0))) BEGIN
			SET @errorCode = 2
			SET @errorMessage = 'Not found'
		END
		IF @errorCode = 0 BEGIN
            TRUNCATE TABLE #AppPlanGetClientsAssociated_tmp__planList
            INSERT INTO #AppPlanGetClientsAssociated_tmp__planList
                SELECT @i_planId
        END
	END ELSE BEGIN			-- request for the clients associated with plan subtype
        INSERT INTO #AppPlanGetClientsAssociated_tmp__planList
            SELECT id FROM App_Plan WHERE subType = @subtype
    END
    IF @errorCode = 0 BEGIN
        INSERT INTO @clients
            SELECT  DISTINCT id, name, net_hostname, GUID, displayName, NULL
            FROM    APP_Client
            WHERE   id IN (SELECT  CAST(componentNameId AS INT)
                           FROM        APP_ClientProp WHERE modified = 0
                                   AND attrName LIKE 'Associated plan%'
                                   AND attrVal IN (SELECT CAST(planId AS NVARCHAR(32)) FROM #AppPlanGetClientsAssociated_tmp__planList))
        IF @debug != 0 BEGIN
            SELECT 'clients', * FROM @clients
		END
        -- remove those subclients which are not accessible by the user
        DECLARE @accessible INT = 0
        DECLARE @iterationId INT = (SELECT MIN(clientId) FROM @clients)
        WHILE @iterationId IS NOT NULL BEGIN
            SET @accessible = 0
            -- check capability
            EXEC sec_checkPermissionOnEntity @i_userId, 0, @accessible OUTPUT, 7, @iterationId
            -- update temporary table
            UPDATE @clients SET accessible = @accessible WHERE clientId = @iterationId
            -- next iteration
            SELECT @iterationId = MIN(clientId) FROM @clients WHERE clientId > @iterationId
        END
        IF @debug != 0 BEGIN
            SELECT 'permissions resolved', * FROM @clients
        END
        -- remove entries user has no capabilities on
        DELETE FROM @clients WHERE accessible = 0
        IF @debug != 0 BEGIN
            SELECT 'clients filtered', * FROM @clients
        END
        SET @o_xmlClients = (
            SELECT
            (
                SELECT clientId             AS '@clientId',
                       clientName           AS '@clientName',
                       clientHost           AS '@hostName',
                       clientGUID           AS '@clientGUID',
                       ciientDisplayName    AS '@displayName'
                FROM @clients
                FOR XML PATH('clients'), TYPE
            ) FOR XML PATH(''), ROOT('Api_GetAssociatedClientListResp')
        )
    END ELSE BEGIN
        SET @o_xmlClients = (SELECT @errorCode '@errorCode', @errorMessage '@errorMessage' FOR XML PATH('Api_GenericResp'))
    END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
END CATCH
IF @debug != 0 BEGIN
    SELECT 'response', @o_xmlClients
END
IF OBJECT_ID('tempdb.dbo.#AppPlanGetClientsAssociated_tmp__planList') IS NOT null DROP TABLE #AppPlanGetClientsAssociated_tmp__planList
SET NOCOUNT OFF

IF EXISTS (select * from GxQscripts where name = 'AppPlanGetClientsAssociated')
	delete from GxQscripts where name = 'AppPlanGetClientsAssociated'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanGetClientsAssociated')
	delete from GXDBVersions where aliasname = 'AppPlanGetClientsAssociated'
GO

insert into GXDBVersions values(2, 'AppPlanGetClientsAssociated',  '00010001000200060000', 'AppPlanGetClientsAssociated', '00010001000200060000')
GO

