

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanGetBasePlanDetailsV2.sp] ---------- 

-- MODIFIED FOR (CCP)
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanGetBasePlanDetailsV2.sp,v $ $Id: AppPlanGetBasePlanDetailsV2.sp,v 1.1.4.2 2018/05/25 19:23:33 evolohov Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   AppPlanGetBasePlanDetailsV2   -
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppPlanGetBasePlanDetailsV2 <<<'

IF EXISTS (select * from sysobjects where name='AppPlanGetBasePlanDetailsV2')
	drop procedure AppPlanGetBasePlanDetailsV2
IF EXISTS (select * from GxQscripts where name='AppPlanGetBasePlanDetailsV2')
	delete from GxQscripts where name = 'AppPlanGetBasePlanDetailsV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanGetBasePlanDetailsV2')
	delete from GXDBVersions where aliasname = 'AppPlanGetBasePlanDetailsV2'
GO
print '... Creating Procedure: AppPlanGetBasePlanDetailsV2'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPlanGetBasePlanDetailsV2
  @i_planId INT,
  @i_userId INT,
  @x_xmlData XML OUTPUT,
  @i_mode INT = 0
AS
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
DECLARE @const_modeInheritance  INT          = 1
DECLARE @const_modeDirectAssoc  INT          = 2
DECLARE @rv                     INT          = 0
DECLARE @basePlanId             INT          = NULL
-- first chack if user has right to get @i_planId's parent
DECLARE @userHasCapability INT = 0
EXEC sec_checkPermissionOnEntity @i_userId, 31, @userHasCapability OUTPUT, 158, @i_planId
IF @userHasCapability != 0 BEGIN
    SET @i_mode = IIF(@i_mode IN (@const_modeInheritance, @const_modeDirectAssoc), @i_mode, @const_modeInheritance)
    IF @i_mode = @const_modeDirectAssoc
        -- just get immediate parent.
        -- If there is no base plan then info for @i_planId will be returned and @rv value will be set to
SET @basePlanId = ISNULL((SELECT CAST(attrVal AS INT) FROM APP_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Base plan'),  @i_planId)
    ELSE
        -- iterate through the plans hierarchy
        -- it could be done using while loop and using CTE and it seems that simple loop in this case is more effective
        --
        -- |               |      % relative to the batch        |
        -- |hierarchy dept +-------------------------------------+
        -- |               | cte implementation | loop (combined)|
        -- +---------------+--------------------+----------------+
        -- |             1 |        37          |       6        |
        -- |             2 |        31          |       12       |
        -- |             3 |        26          |       16       |
        -- |             4 |        22          |       19       |
        --
        -- deepest hierarchy level expected is 3.
        --
        -- If there is no base plan then info for @i_planId will be returned and @rv value will be set to
        WHILE (@i_planId IS NOT NULL) BEGIN
            SET @basePlanId = @i_planId
SET @i_planId = (SELECT CAST(attrVal AS INT) FROM APP_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Base plan')
        END
    -- if there is no base plan then sp will return information on @i_planId and return value set to 0
    -- if sp returns info on base plan then it returns 1 (@const_modeInheritance) if info on the very base plan being returned and it
    -- returns 2 (@const_modeDirectAssoc) if info on immediate parent plan is being returned.
    SET @rv = IIF(@i_planId = @basePlanId, 0, @i_mode)
    -- gather info on the plan
    -- no need to check users permissions on @basePlanId. AppPlanGetDetailsV2 does all necessary checking
    EXEC AppPlanGetDetailsV2 @basePlanId, @i_userId, 0, 0, 0, @x_xmlData OUTPUT
END
ELSE
    SET @x_xmlData =
        (SELECT
            (SELECT 5               AS '@errorCode',
                    'Access denied' AS '@errorMessage'
             FOR XML PATH('error'), TYPE)
        FOR XML PATH(''), ROOT('Api_GetPlanDetailsResp'))
SET NOCOUNT OFF
RETURN @rv
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanGetBasePlanDetailsV2')
	delete from GxQscripts where name = 'AppPlanGetBasePlanDetailsV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanGetBasePlanDetailsV2')
	delete from GXDBVersions where aliasname = 'AppPlanGetBasePlanDetailsV2'
GO

insert into GXDBVersions values(2, 'AppPlanGetBasePlanDetailsV2',  '00010001000400020000', 'AppPlanGetBasePlanDetailsV2', '00010001000400020000')
GO

