

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanGetAssociationsV2.sp] ---------- 

-- MODIFIED FOR (CCP)
-- ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                                                                                                  All rights reserved.
--                                                                                                                                                              --------------------
-- This is unpublished proprietary source code of CommVault Systems, Inc.  The  copyright  notice  above  does not  evidence any actual or intended publication of such source code.
-- ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanGetAssociationsV2.sp,v $ $Id: AppPlanGetAssociationsV2.sp,v 1.1.2.3 2019/11/22 08:17:04 evolohov Exp $";
-- ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--   AppPlanGetAssociationsV2 - retrieves all entities associated with the given plan
-- ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppPlanGetAssociationsV2')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanGetAssociationsV2 <<<'
	drop procedure AppPlanGetAssociationsV2
END
IF EXISTS (select * from GxQscripts where name='AppPlanGetAssociationsV2')
	delete from GxQscripts where name = 'AppPlanGetAssociationsV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanGetAssociationsV2')
	delete from GXDBVersions where aliasname = 'AppPlanGetAssociationsV2'
GO
print '... Creating Procedure: AppPlanGetAssociationsV2'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPlanGetAssociationsV2
  @i_planId INT,
  @i_userId INT,
  @i_localeId INT,
  @x_xmlData XML OUTPUT
AS
SET NOCOUNT ON
DECLARE @PLAN_ENTITY                    INT = 158
DECLARE @USER_ENTITY                    INT = 13
DECLARE @SUBCLIENT_ENTITY               INT = 7
DECLARE @USERGROUP_ENTITY               INT = 15
DECLARE @EXTERNAL_GROUP_ENTITY          INT = 62
DECLARE @CONFIGURATION_POLICY_ENTITY    INT = 154 -- CONFIGURATION_POLICY_ENTITY
DECLARE @CLIENT_ENTITY                  INT = 3
DECLARE @PROVIDER_ENTITY                INT = 61
DECLARE @debug INT = 0
-- drop stale temp tables
IF OBJECT_ID('tempdb.dbo.#GetPlanAssociationsV2_Entities') IS NOT NULL DROP TABLE #GetPlanAssociationsV2_Entities
IF OBJECT_ID('tempdb.dbo.#GetPlanAssociationsV2_VisibleIDAEntities') IS NOT NULL DROP TABLE #GetPlanAssociationsV2_VisibleIDAEntities
IF OBJECT_ID('tempdb.dbo.#GetPlanAssociationsV2_VisibleNonIDAEntities') IS NOT NULL DROP TABLE #GetPlanAssociationsV2_VisibleNonIDAEntities
IF OBJECT_ID('tempdb.dbo.#GetPlanAssociationsV2_VisibleEntities') IS NOT NULL DROP TABLE #GetPlanAssociationsV2_VisibleEntities
IF OBJECT_ID('tempdb.dbo.#GetPlanAssociationsV2_Providers') IS NOT NULL DROP TABLE #GetPlanAssociationsV2_Providers
-- create temporary tables
CREATE TABLE #GetPlanAssociationsV2_Entities (entityId INT, entityName VARCHAR(MAX), entityType INT,  preventsDel BIT, includeEntity INT)
CREATE CLUSTERED INDEX  #GetPlanAssociationsV2_Entities_entityIdType_idx ON #GetPlanAssociationsV2_Entities (entityId, entityType)
CREATE INDEX #GetPlanAssociationsV2_Entities_entityInclude_idx ON #GetPlanAssociationsV2_Entities(includeEntity DESC)
CREATE TABLE #GetPlanAssociationsV2_VisibleIDAEntities    (clientId INT, appTypeId INT, instanceId INT,  backupsetId INT, subclientId INT)
CREATE TABLE #GetPlanAssociationsV2_VisibleNonIDAEntities (entityId INT)
CREATE TABLE #GetPlanAssociationsV2_VisibleEntities       (entityType INT, entityId INT, PRIMARY KEY(entityType, entityId))
CREATE TABLE #GetPlanAssociationsV2_Providers             (providerId INT, ownerCompany INT, providerName VARCHAR(MAX))
-- get list of associated entities
-- derived plans, users, internal user groups, external user groups, subclients, mailbox policies, clients
INSERT INTO #GetPlanAssociationsV2_Entities
    -- -- derived plans. forbidding
    SELECT
            CAST(attrVal AS INT), P.name, @PLAN_ENTITY, 1, 0
    FROM    App_PlanProp PP WITH(NOLOCK) INNER JOIN App_Plan P WITH(NOLOCK)  ON PP.componentNameId = P.id
WHERE   attrName = 'Base plan' AND attrVal = @i_planId
    -- -- users associated with plans. forbidding
	UNION SELECT
            componentNameId, U.name, @USER_ENTITY, 1, 0
	FROM	UMUsersProp UP WITH(NOLOCK) INNER JOIN UMUsers U WITH (NOLOCK) ON UP.componentNameId = U.id
WHERE	attrName = 'Associated Plan' AND attrVal = CAST(@i_planId AS VARCHAR(32)) AND UP.modified = 0 AND U.enabled = 1
	-- -- internal and external groups. not forbidding
	UNION SELECT
            componentNameId, IIF(P.serviceType = 1, G.name, P.domainName + '\'+ G.name), IIF(P.serviceType = 1, @USERGROUP_ENTITY, @EXTERNAL_GROUP_ENTITY), 0, 0
    FROM    UMGroupsProp GP WITH(NOLOCK) INNER JOIN UMGroups G		WITH(NOLOCK) ON GP.componentNameId = G.id
                                         INNER JOIN UMDSProviders P WITH(NOLOCK) ON P.id = G.umdsProviderId AND (P.flags & 0x00002) = 0
WHERE	attrName = 'Associated Plan' AND attrVal = CAST(@i_planId AS VARCHAR(32)) AND GP.modified = 0
	-- -- plans own user group. not forbidding
	UNION SELECT
            CAST(attrVal AS INT), G.name, @USERGROUP_ENTITY, 0, 0
	FROM	App_PlanProp PP WITH(NOLOCK) INNER JOIN APP_Plan P WITH(NOLOCK) ON PP.componentNameId = P.id
                                         INNER JOIN UMGroups G WITH(NOLOCK) ON CAST(PP.attrVal AS INT) = G.id
WHERE	attrName = 'Associated Plan' AND componentNameId = @i_planId
	-- -- subclients. forbidding
	UNION SELECT
            SCPROP.componentNameId, APP.subclientName, @SUBCLIENT_ENTITY, 1, 0
	FROM	APP_SubClientProp SCPROP WITH (NOLOCK) INNER JOIN APP_Application APP WITH (NOLOCK) ON APP.id = SCPROP.componentNameId
WHERE	(SCPROP.attrName = 'Associated Plan') AND (SCPROP.modified = 0) AND (SCPROP.attrVal =  CAST(@i_planId AS NVARCHAR(32))) AND ((APP.subclientStatus & 0x00004 ) = 0) AND ((APP.subclientStatus & 0x00002) = 0)
	-- -- mailbox users, databases, exchange db. forbidding
	UNION SELECT DISTINCT
            CP.policyId, CP.policyName, @CONFIGURATION_POLICY_ENTITY, 1, 0
    FROM    APP_EmailConfigPolicyAssoc ECPA WITH (NOLOCK) INNER JOIN APP_EmailConfigPolicies ECP WITH(NOLOCK) ON ECPA.assocId = ECP.componentNameId
                                                          INNER JOIN APP_ConfigurationPolicy  CP WITH(NOLOCK) ON ECP.policyId = CP.policyId
    WHERE	deleted = 0 AND planId = @i_planId AND ECPA.modified = 0
    -- -- clients (CV_STATUS_PERSONAL_WKSTN - laptop clients), forbidding
    UNION SELECT
            CL.id, CL.name, @CLIENT_ENTITY, 1, 0
FROM    APP_Client CL WITH(NOLOCK) INNER JOIN APP_ClientProp CLP WITH(NOLOCK) ON CL.id = CLP.componentNameId AND CLP.attrName = 'Associated Plan'
    WHERE       CLP.modified = 0 AND CLP.attrVal = CAST(@i_planId AS NVARCHAR(32))
AND ((CL.status & 0x1000) != 0)
            AND iSNULL((SELECT attrVal FROM APP_ClientProp WHERE attrName = 'platformDeleted 4' AND componentNameId = CL.id), 0) = 0
AND ((CL.status & 0x00004) = 0) AND ((CL.status & 0x00002) = 0)
-- get list of associated companies
DECLARE @securityAssociations XML = NULL
EXEC sec_getSecurityForEntity @i_userId, @securityAssociations OUTPUT, 158, @i_planId
-- -- -- list of providers
INSERT INTO #GetPlanAssociationsV2_Providers
SELECT ISNULL(ref.value('userOrGroup[1]/@providerId', 'INT'),0), NULL, NULL FROM @securityAssociations.nodes('associations') R ( ref )
-- -- -- get corresponded company id
UPDATE  CT SET CT.ownerCompany = (   CASE UD.serviceType
WHEN 5 THEN UD.id
WHEN 2    THEN UD.ownerCompany
WHEN 12         THEN UD.ownerCompany
WHEN 1        THEN 0
                                        ELSE 0 END  ),
                CT.providerName = UD.domainName
FROM    #GetPlanAssociationsV2_Providers CT INNER JOIN UMDSProviders UD ON UD.id = CT.providerId
WHERE   CT.providerId != 0
-- move collected data to #GetPlanAssociationsV2_Entities - table that contains all associated entities
INSERT INTO #GetPlanAssociationsV2_Entities
    SELECT  providerId, providerName, @PROVIDER_ENTITY, 1, 0
    FROM    #GetPlanAssociationsV2_Providers
    WHERE   ownerCompany <> 0
-- verify that userId has permissions on each associated entity and update corresponded flag if necessary
-- -- get list of subclients available for the user
EXEC sec_getIdaObjectsForUser @i_userId, @SUBCLIENT_ENTITY, 0, 1, '#GetPlanAssociationsV2_VisibleIDAEntities'
IF @debug != 0 SELECT 'subclients', * FROM #GetPlanAssociationsV2_VisibleIDAEntities
-- -- move ids to the common table
INSERT INTO #GetPlanAssociationsV2_VisibleEntities
    SELECT DISTINCT @SUBCLIENT_ENTITY, subclientId FROM #GetPlanAssociationsV2_VisibleIDAEntities
-- clean up before next use
TRUNCATE TABLE #GetPlanAssociationsV2_VisibleIDAEntities
-- -- get list of clients available for the user
EXEC sec_getIdaObjectsForUser @i_userId, @CLIENT_ENTITY, 0, 1, '#GetPlanAssociationsV2_VisibleIDAEntities'
IF @debug != 0 SELECT 'clients', * FROM #GetPlanAssociationsV2_VisibleIDAEntities
-- -- move ids to the common table
INSERT INTO #GetPlanAssociationsV2_VisibleEntities
    SELECT DISTINCT @CLIENT_ENTITY, clientId FROM #GetPlanAssociationsV2_VisibleIDAEntities
-- clean up before next use
TRUNCATE TABLE #GetPlanAssociationsV2_VisibleIDAEntities
-- -- get list of non-ida entities available for the user
-- -- -- plans
EXEC sec_getNonIdaObjectsForThisUser @i_userId, @PLAN_ENTITY, 0, '#GetPlanAssociationsV2_VisibleNonIDAEntities'
IF @debug != 0 SELECT 'visible plans', * FROM #GetPlanAssociationsV2_VisibleNonIDAEntities
-- -- move ids to the common table
INSERT INTO #GetPlanAssociationsV2_VisibleEntities
    SELECT DISTINCT @PLAN_ENTITY, entityId FROM #GetPlanAssociationsV2_VisibleNonIDAEntities
-- clean up before next use
TRUNCATE TABLE #GetPlanAssociationsV2_VisibleNonIDAEntities
-- -- -- users
EXEC sec_getNonIdaObjectsForThisUser @i_userId, @USER_ENTITY, 0, '#GetPlanAssociationsV2_VisibleNonIDAEntities'
IF @debug != 0 SELECT 'visible users', * FROM #GetPlanAssociationsV2_VisibleNonIDAEntities
-- -- move ids to the common table
INSERT INTO #GetPlanAssociationsV2_VisibleEntities
    SELECT DISTINCT @USER_ENTITY, entityId FROM #GetPlanAssociationsV2_VisibleNonIDAEntities
-- clean up before next use
TRUNCATE TABLE #GetPlanAssociationsV2_VisibleNonIDAEntities
-- -- -- internal user groups
EXEC sec_getNonIdaObjectsForThisUser @i_userId, @USERGROUP_ENTITY, 0, '#GetPlanAssociationsV2_VisibleNonIDAEntities'
IF @debug != 0 SELECT 'visible internal groups', * FROM #GetPlanAssociationsV2_VisibleNonIDAEntities
-- -- move ids to the common table
INSERT INTO #GetPlanAssociationsV2_VisibleEntities
    SELECT DISTINCT @USERGROUP_ENTITY, entityId FROM #GetPlanAssociationsV2_VisibleNonIDAEntities
-- clean up before next use
TRUNCATE TABLE #GetPlanAssociationsV2_VisibleNonIDAEntities
-- -- -- external user groups
EXEC sec_getNonIdaObjectsForThisUser @i_userId, @EXTERNAL_GROUP_ENTITY, 0, '#GetPlanAssociationsV2_VisibleNonIDAEntities'
IF @debug != 0 SELECT 'visible external groups', * FROM #GetPlanAssociationsV2_VisibleNonIDAEntities
-- -- move ids to the common table
INSERT INTO #GetPlanAssociationsV2_VisibleEntities
    SELECT DISTINCT @EXTERNAL_GROUP_ENTITY, entityId FROM #GetPlanAssociationsV2_VisibleNonIDAEntities
-- clean up before next use
TRUNCATE TABLE #GetPlanAssociationsV2_VisibleNonIDAEntities
-- -- -- mailboxes
EXEC sec_getNonIdaObjectsForThisUser @i_userId, @CONFIGURATION_POLICY_ENTITY, 0, '#GetPlanAssociationsV2_VisibleNonIDAEntities'
IF @debug != 0 SELECT 'visible mailboxes', * FROM #GetPlanAssociationsV2_VisibleNonIDAEntities
-- -- move ids to the common table
INSERT INTO #GetPlanAssociationsV2_VisibleEntities
    SELECT DISTINCT @CONFIGURATION_POLICY_ENTITY, entityId FROM #GetPlanAssociationsV2_VisibleNonIDAEntities
-- clean up before next use
TRUNCATE TABLE #GetPlanAssociationsV2_VisibleNonIDAEntities
-- -- -- companies
EXEC sec_getNonIdaObjectsForThisUser @i_userId, @PROVIDER_ENTITY, 0, '#GetPlanAssociationsV2_VisibleNonIDAEntities'
IF @debug != 0 SELECT 'visible companies', * FROM #GetPlanAssociationsV2_VisibleNonIDAEntities
-- -- move ids to the common table
INSERT INTO #GetPlanAssociationsV2_VisibleEntities
    SELECT DISTINCT @PROVIDER_ENTITY, entityId FROM #GetPlanAssociationsV2_VisibleNonIDAEntities
-- clean up before next use
TRUNCATE TABLE #GetPlanAssociationsV2_VisibleNonIDAEntities
-- at this point
-- temporary table #GetPlanAssociationsV2_VisibleEntities contains entityType, entityId pairs visible to the @i_user.
-- temporary table #GetPlanAssociationsV2_Entities contains entities associated with the plan
-- Mark as to be included all entities existing in bot #GetPlanAssociationsV2_Entities and #GetPlanAssociationsV2_VisibleEntities tables
UPDATE  E SET includeEntity = 1
FROM    #GetPlanAssociationsV2_Entities E INNER JOIN #GetPlanAssociationsV2_VisibleEntities V ON E.entityType = V.entityType AND E.entityId = V.entityId
IF @debug != 0 SELECT 'output entities', * FROM #GetPlanAssociationsV2_Entities
-- generate response including only entities available for the user
DECLARE @isFiltered INT = 0
IF EXISTS(SELECT 1 FROM #GetPlanAssociationsV2_Entities WHERE includeEntity = 0)
    SET @isFiltered  = 1
-- remove all entities that should not be shown to the @i_userId.
DELETE FROM #GetPlanAssociationsV2_Entities WHERE includeEntity = 0
SET @x_xmlData = (
SELECT @isFiltered '@filtered',
        (SELECT P.id		 AS '@planId',
		        P.name		 AS '@planName',
                @PLAN_ENTITY AS '@_type_',
			    P.[type]	 AS '@planType',
			    P.subType    AS '@planSubtype'
         FROM   App_Plan P WITH(NOLOCK)
         WHERE  P.id = @i_planId
         FOR XML PATH('plan'), TYPE),
         -- derived plans
         (SELECT E.preventsDel AS '@preventsDeletion',
                 (SELECT P.id         AS '@planId',
		                 P.name       AS '@planName',
                         @PLAN_ENTITY AS '@_type_',
                         P.[type]     AS '@planType',
			             P.subType    AS '@planSubtype'
                  FOR XML PATH('entity'), TYPE)
          FROM #GetPlanAssociationsV2_Entities E INNER JOIN App_Plan P ON P.id = E.entityId AND E.entityType = @PLAN_ENTITY
          FOR XML PATH('associations'), TYPE),
          -- associated users
         (SELECT preventsDel AS '@preventsDeletion',
                 (SELECT entityType AS '@_type_',
                    -- associated users
                    IIF(entityType = @USER_ENTITY, entityId, NULL) AS '@userId',
                    IIF(entityType = @USER_ENTITY, entityName, NULL) AS '@userName',
                    -- associated internal user groups
                    IIF(entityType = @USERGROUP_ENTITY, entityId, NULL) AS '@userGroupId',
                    IIF(entityType = @USERGROUP_ENTITY, entityName, NULL) AS '@userGroupName',
                    -- associated external user groups
                    IIF(entityType = @EXTERNAL_GROUP_ENTITY, entityId, NULL) AS '@groupId',
                    IIF(entityType = @EXTERNAL_GROUP_ENTITY, entityName, NULL) AS '@externalGroupName',
                    -- associated subclients
                    IIF(entityType = @SUBCLIENT_ENTITY, entityId, NULL) AS '@subclientId',
                    IIF(entityType = @SUBCLIENT_ENTITY, entityName, NULL) AS '@subclientName',
                    -- associated configuration policies
                    IIF(entityType = @CONFIGURATION_POLICY_ENTITY, entityId, NULL) AS '@policyId',
                    IIF(entityType = @CONFIGURATION_POLICY_ENTITY, entityName, NULL) AS '@poicyName',
                    -- associated laptops
                    IIF(entityType = @CLIENT_ENTITY, entityId, NULL) AS '@clientId',
                    IIF(entityType = @CLIENT_ENTITY, entityName, NULL) AS '@clientName',
                    -- associated companies
                    IIF(entityType = @PROVIDER_ENTITY, entityId, NULL) AS '@providerId',
                    IIF(entityType = @PROVIDER_ENTITY, entityName, NULL) AS '@providerDomainName'
                  FOR XML PATH('entity'), TYPE)
          FROM #GetPlanAssociationsV2_Entities
          WHERE entityType != @PLAN_ENTITY
          FOR XML PATH('associations'), TYPE)
FOR XML PATH('Api_PlanAssociatedEntity'))
IF OBJECT_ID('tempdb.dbo.#GetPlanAssociationsV2_Entities') IS NOT NULL DROP TABLE #GetPlanAssociationsV2_Entities
IF OBJECT_ID('tempdb.dbo.#GetPlanAssociationsV2_VisibleIDAEntities') IS NOT NULL DROP TABLE #GetPlanAssociationsV2_VisibleIDAEntities
IF OBJECT_ID('tempdb.dbo.#GetPlanAssociationsV2_VisibleNonIDAEntities') IS NOT NULL DROP TABLE #GetPlanAssociationsV2_VisibleNonIDAEntities
IF OBJECT_ID('tempdb.dbo.#GetPlanAssociationsV2_VisibleEntities') IS NOT NULL DROP TABLE #GetPlanAssociationsV2_VisibleEntities
IF OBJECT_ID('tempdb.dbo.#GetPlanAssociationsV2_Providers') IS NOT NULL DROP TABLE #GetPlanAssociationsV2_Providers
SELECT @x_xmlData
RETURN 1
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanGetAssociationsV2')
	delete from GxQscripts where name = 'AppPlanGetAssociationsV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanGetAssociationsV2')
	delete from GXDBVersions where aliasname = 'AppPlanGetAssociationsV2'
GO

insert into GXDBVersions values(2, 'AppPlanGetAssociationsV2',  '00010001000200030000', 'AppPlanGetAssociationsV2', '00010001000200030000')
GO

