

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanGetAssociatedEntitiesCountV2.sp] ---------- 

-- MODIFIED FOR (CCP)
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanGetAssociatedEntitiesCountV2.sp,v $ $Id: AppPlanGetAssociatedEntitiesCountV2.sp,v 1.1.2.14 2020/09/11 16:45:53 nshah Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   AppPlanGetSummaryList   - get list of available profiles
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppPlanGetAssociatedEntitiesCountV2')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanGetAssociatedEntitiesCountV2 <<<'
	drop procedure AppPlanGetAssociatedEntitiesCountV2
END
IF EXISTS (select * from GxQscripts where name='AppPlanGetAssociatedEntitiesCountV2')
	delete from GxQscripts where name = 'AppPlanGetAssociatedEntitiesCountV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanGetAssociatedEntitiesCountV2')
	delete from GXDBVersions where aliasname = 'AppPlanGetAssociatedEntitiesCountV2'
GO
print '... Creating Procedure: AppPlanGetAssociatedEntitiesCountV2'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPlanGetAssociatedEntitiesCountV2
  @o_xmlText XML OUTPUT,
  @reqEntities XML = NULL
AS
DECLARE
  @i_userId INT=0,
  @i_localeId INT=0,
  @i_planId INT=0 ,
  @i_getDetails INT =1,
  @companyId INT = 0,
  @allEntities INT = 1,
  @clientEntities INT = 0,
  @subclientEntities INT =0,
  @companyEntities INT = 0,
  @backupsetEntities INT =0,
  @instanceEntities INT =0,
  @getChildEntities int = 0,
  @i_planSubtype		INT = 0
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET @i_planId = ( SELECT ref.value('@planId', 'INT')
                        FROM @o_xmlText.nodes ('/Api_PlanAssociatedEntitiesReq/plan') R(ref))
SET @i_localeId = ISNULL (( SELECT ref.value('@localeId', 'INT')
                        FROM @o_xmlText.nodes ('/Api_PlanAssociatedEntitiesReq/processinginstructioninfo/locale') R(ref)), 0)
SET @i_userId = ISNULL (( SELECT ref.value('@userId', 'INT')
                        FROM @o_xmlText.nodes ('/Api_PlanAssociatedEntitiesReq/processinginstructioninfo/user') R(ref)), 0)
DECLARE @level INT = ISNULL(@o_xmlText.value('(/Api_PlanAssociatedEntitiesReq/@propertyLevel)[1]', 'int'), 30)
SET @getChildEntities = ISNULL(@o_xmlText.value('(/Api_PlanAssociatedEntitiesReq/@getChildEntities)[1]', 'int'), 0)
IF(@level > 1)
BEGIN
	SET @i_getDetails=1
END
SET @companyId = ISNULL (( SELECT ref.value('@providerId', 'INT')
                        FROM @o_xmlText.nodes ('/Api_PlanAssociatedEntitiesReq/company ') R(ref)),0)
--If this is for company inpersonate it with tenant admin -- security check?
IF(@companyId > 0)
BEGIN
 SET @i_userId  =  ISNULL((SELECT TOP 1 u.id FROM UMGroups G
									INNER JOIN UMUserGroup UG ON UG.groupId=G.id
									INNER JOIN umusers U ON U.ID = UG.userId and u.umDSproviderId=@companyId
WHERE g.umdsProviderId=@companyId AND  ((groupFlags & 0x10000) != 0)
),0)
END
IF OBJECT_ID('tempdb.dbo.#entityType_InputTable') IS NOT NULL
        DROP TABLE #entityType_InputTable
CREATE TABLE #entityType_InputTable
(
	entityType INT
)
INSERT #entityType_InputTable(entityType)
SELECT DISTINCT ref.value('(.)[1]', 'NVARCHAR(MAX)')FROM  @o_xmlText.nodes('/Api_PlanAssociatedEntitiesReq/entityType/@val') doc(ref)
IF(@@ROWCOUNT > 0)
BEGIN
	SET @allEntities =0
END
IF EXISTS (SELECT 1 FROM #entityType_InputTable WHERE entityType=7)--SUBCLIENT_ENTITY
BEGIN
	SET @subclientEntities =1
END
IF EXISTS (SELECT 1 FROM #entityType_InputTable WHERE entityType=3)--CLIENT_ENTITY
BEGIN
	SET @clientEntities =1
END
IF EXISTS (SELECT 1 FROM #entityType_InputTable WHERE entityType=6)--BACKUPSET_ENTITY
BEGIN
	SET @backupsetEntities =1
END
IF EXISTS (SELECT 1 FROM #entityType_InputTable WHERE entityType=5)--INSTANCE_ENTITY
BEGIN
	SET @instanceEntities =1
END
IF EXISTS (SELECT 1 FROM #entityType_InputTable WHERE entityType=61)--PROVIDER_ENTITY
BEGIN
	SET @companyEntities =1
END
IF ISNULL(@i_planSubtype, 0) = 0
        SELECT @i_planSubtype = subType FROM App_Plan WHERE id = @i_planId
DECLARE @securityAssociations XML
EXEC sec_getSecurityForEntity @i_userId, @securityAssociations OUTPUT, 158, @i_planId
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
  DECLARE @companyGroupId INT = 0
  DECLARE @mailboxCount INT
IF OBJECT_ID('tempdb.dbo.#companyclients') IS NOT NULL
        DROP TABLE #companyclients
CREATE TABLE #companyclients
(
	clientId INT	primary key
)
IF OBJECT_ID('tempdb.dbo.#getPermissionsOnEntities_InputTable') IS NOT NULL
        DROP TABLE #getPermissionsOnEntities_InputTable
CREATE TABLE #getPermissionsOnEntities_InputTable
(
	entityId1 INT,
	entityId2 INT DEFAULT 0,
	entityId3 INT DEFAULT 0,
	entityId4 INT DEFAULT 0,
	entityId5 INT DEFAULT 0
)
IF OBJECT_ID('tempdb.dbo.#getPermissionsOnEntities_OutputTable') IS NOT NULL
	DROP TABLE #getPermissionsOnEntities_OutputTable
CREATE TABLE #getPermissionsOnEntities_OutputTable
(
	entityId1 INT,
	entityId2 INT,
	entityId3 INT,
	entityId4 INT,
	entityId5 INT,
	permissionsString VARCHAR(512),
	isChildRow BIT DEFAULT 0
)
IF OBJECT_ID('tempdb.dbo.#AssociatedEnties') IS NOT NULL
	DROP TABLE #AssociatedEnties
CREATE TABLE #AssociatedEnties
(
	entityId1 INT,
	entityId1Name nvarchar(255),
	entityId1DisplayName nvarchar(255),
	entityId2 INT,
	entityId2Name nvarchar(255),
	entityId2DisplayName nvarchar(255),
	entityId3 INT,
	entityId3Name nvarchar(255),
	entityId4 INT,
	entityId4Name nvarchar(255),
	entityId5 INT,
	entityId5Name nvarchar(255),
	permissionsString VARCHAR(512),
	isChildRow BIT DEFAULT 0,
	planParentEntityType INT DEFAULT NULL,
	planParentEntityID INT DEFAULT NULL
)
IF OBJECT_ID('tempdb.dbo.#AssociatedCompanies') IS NOT NULL
	DROP TABLE #AssociatedCompanies
CREATE TABLE #AssociatedCompanies
(	providerId INT,
	ownerCompany INT DEFAULT 0,
	[name] NVARCHAR(510) DEFAULT NULL
)
IF @allEntities=1 OR @subclientEntities=1 --SUBCLIENT_ENTITY
BEGIN
	INSERT INTO #getPermissionsOnEntities_InputTable (entityId1, entityId2, entityId3, entityId4, entityId5)
	SELECT A.clientId, A.appTypeId, A.instance, A.backupSet,A.id
FROM APP_Application A WITH(NOLOCK) INNER JOIN APP_SubclientProp SP WITH(NOLOCK) ON A.id = SP.componentNameId AND SP.attrName IN ('Associated Plan', 'Associated DC Plan') AND SP.modified = 0 AND CAST (@i_planId AS NVARCHAR(32)) = SP.attrVal
AND SP.cs_attrName IN (CHECKSUM(N'Associated Plan'),CHECKSUM(N'Associated DC Plan'))
	WHERE	A.subclientStatus & 0x00004 = 0 AND A.subclientStatus & 0x00002 = 0
END
IF @allEntities=1 OR @clientEntities=1 --CLIENT_ENTITY
BEGIN
	INSERT INTO #getPermissionsOnEntities_InputTable (entityId1, entityId2, entityId3, entityId4, entityId5)
	SELECT CP.componentNameId,0,0,0,0
	FROM APP_CLIENT C INNER JOIN APP_ClientProp CP ON C.id = CP.componentNameId
WHERE (CP.attrName = 'Associated Plan' OR CP.attrName like 'Default % Plan' OR CP.attrName = 'Associated DC Plan') AND CP.modified = 0 AND CAST (@i_planId AS NVARCHAR(32)) = CP.attrVal
AND C.status & 0x00004 = 0 AND C.status & 0x00002 = 0
END
IF @allEntities=1 OR @backupsetEntities=1 --BACKUPSET_ENTITY
BEGIN
	INSERT INTO #getPermissionsOnEntities_InputTable (entityId1, entityId2, entityId3, entityId4, entityId5)
	SELECT DISTINCT A.clientId, A.appTypeId, A.instance, A.backupSet,0
FROM APP_Application A WITH(NOLOCK) INNER JOIN APP_BackupSetProp SP WITH(NOLOCK) ON A.backupSet = SP.componentNameId AND SP.attrName = 'Associated Plan' AND SP.modified = 0 AND CAST (@i_planId AS NVARCHAR(32)) = SP.attrVal
	WHERE A.appTypeId!=1030
END
IF @allEntities=1 OR @instanceEntities=1 --BACKUPSET_ENTITY
BEGIN
	INSERT INTO #getPermissionsOnEntities_InputTable (entityId1, entityId2, entityId3, entityId4, entityId5)
	SELECT DISTINCT A.clientId, A.appTypeId, A.instance, 0,0
	FROM APP_Application A WITH(NOLOCK) INNER JOIN APP_InstanceProp SP WITH(NOLOCK) ON A.instance = SP.componentNameId AND SP.attrName = 'Associated Plan' AND SP.modified = 0 AND CAST (@i_planId AS NVARCHAR(32)) = SP.attrVal
	WHERE A.appTypeId!=1030
END
EXEC sec_getPermissionsOnEntities @i_userId, 7  /* 7 (7) */
-- have to delete the entities which user has no permission on as above sp doesnt remove entities that user doesnt have rights on
DELETE FROM #getPermissionsOnEntities_OutputTable
WHERE (SUBSTRING(permissionsString,1,1) != CAST(1 AS NVARCHAR(1)))
--for client level we need ida information too
UPDATE O
SET entityId2 = app.appTypeId
FROM #getPermissionsOnEntities_OutputTable O
   INNER JOIN (SELECT O1.entityId1, MIN(A.id) AS id, A.appTypeId
				FROM APP_APPLICATION A
                INNER JOIN  #getPermissionsOnEntities_OutputTable O1 ON O1.entityId1 = A.clientId
				WHERE O1.entityId5=0 AND O1.entityId4=0 AND O1.entityId3=0 AND O1.entityId2=0
				GROUP BY O1.entityId1, A.appTypeId) AS app
	ON O.entityId1=app.entityId1
	WHERE O.entityId5=0 AND O.entityId4=0 AND O.entityId3=0 AND O.entityId2=0
--Get names if the details is true
INSERT INTO #AssociatedEnties (entityId1, entityId1Name,entityId1DisplayName,entityId2,entityId2Name,entityId2DisplayName, entityId3,entityId3Name,  entityId4,entityId4Name,  entityId5, entityId5Name)
SELECT entityId1, c.name, c.displayName, entityId2, ida.name, ida.displayName, entityId3, i.name, entityId4,b.name, entityId5, a.subclientName
FROM #getPermissionsOnEntities_OutputTable o
LEFT JOIN app_client c on  @i_getDetails = 1 and o.entityId1 > 0 and o.entityId1=c.id
LEFT JOIN APP_iDAType  IDA on @i_getDetails = 1 and o.entityId2 > 0 and  IDA.type = o.entityId2
LEFT JOIN APP_InstanceName I on  @i_getDetails = 1 and  o.entityId3 > 0 and o.entityId3 = i.id
LEFT JOIN APP_BackupSetName B ON  @i_getDetails = 1 and  o.entityId4 > 0 and o.entityId4 = B.id
LEFT JOIN APP_Application a on  @i_getDetails = 1 and  o.entityId5 > 0 and o.entityId5 = a.id
IF (@i_planSubtype <> 117506053)
BEGIN
	UPDATE SCL
	SET SCL.planParentEntityType=ACP1.attrVal,
	SCL.planParentEntityID=ACP2.attrVal
	FROM #AssociatedEnties SCL
	INNER JOIN APP_SubClientProp ACP1 WITH(NOLOCK)
ON ACP1.componentNameId=SCL.entityId5 AND ACP1.attrName = 'Associated Plan Parent EntityType' AND ACP1.modified=0 AND ACP1.cs_attrName=CHECKSUM(N'Associated Plan Parent EntityType')
	INNER JOIN APP_SubClientProp ACP2 WITH(NOLOCK)
ON ACP2.componentNameId=SCL.entityId5 AND ACP2.attrName = 'Associated Plan Parent EntityId' AND ACP2.modified=0 AND ACP2.cs_attrName=CHECKSUM(N'Associated Plan Parent EntityId')
END
ELSE
BEGIN
	UPDATE SCL
	SET SCL.planParentEntityType=ACP1.attrVal,
	SCL.planParentEntityID=ACP2.attrVal
	FROM #AssociatedEnties SCL
	INNER JOIN APP_SubClientProp ACP1 WITH(NOLOCK)
ON ACP1.componentNameId=SCL.entityId5 AND ACP1.attrName = 'Associated DC Plan Parent EntityType' AND ACP1.modified=0 AND ACP1.cs_attrName=CHECKSUM(N'Associated DC Plan Parent EntityType')
	INNER JOIN APP_SubClientProp ACP2 WITH(NOLOCK)
ON ACP2.componentNameId=SCL.entityId5 AND ACP2.attrName = 'Associated DC Plan Parent EntityId' AND ACP2.modified=0 AND ACP2.cs_attrName=CHECKSUM(N'Associated DC Plan Parent EntityId')
END
--now get companies
--DECLARE @securityAssociations XML
--EXEC sec_getSecurityForEntity @i_userId, @securityAssociations OUTPUT, 158, @i_planId
IF @allEntities=1 OR @companyEntities=1
BEGIN
	INSERT INTO #AssociatedCompanies (providerId)
	SELECT distinct ref.value('userOrGroup[1]/@providerId', 'INT') FROM @securityAssociations.nodes('associations') R ( ref )
INNER JOIN UMGroups ug ON ug.id = ref.value('userOrGroup[1]/@groupId', 'INT') AND ug.groupFlags &0x10000 <> 0
END
UPDATE CT
SET     CT.ownerCompany = CASE UD.serviceType WHEN 5 THEN UD.id
WHEN 2 THEN UD.ownerCompany
WHEN 12 THEN UD.ownerCompany
                                WHEN 0 THEN 0
                                                  ELSE 0 END,
            CT.[name] = UD.domainName
    FROM    #AssociatedCompanies CT INNER JOIN UMDSProviders UD ON UD.id = CT.providerId
    WHERE CT.providerId != 0
DELETE FROM #AssociatedCompanies where ownerCompany=0 or providerId is null
--update the backupset parent entity if client entity is set for it's subclient. Do not include these entities in the list as
UPDATE o
SET o.planParentEntityID= o1.planParentEntityID,  o.planParentEntityType = o1.planParentEntityType
FROM #AssociatedEnties o
INNER JOIN #AssociatedEnties o1 ON ((o1.entityId1= o.entityId1 AND  o1.planParentEntityType=3) or (o1.entityId3= o.entityId3 AND  o1.planParentEntityType=5))
WHERE o.entityId5=0 AND o.entityId4<>0 AND o.planParentEntityID IS NULL
--set planParentEntity to null for the entities that has companyId set as parent entity. These entities needs to counted in the list.
UPDATE #AssociatedEnties SET  planParentEntityID=NULL, planParentEntityType=NULL   WHERE planParentEntityType = 61
IF(@getChildEntities =0)
BEGIN
 DELETE FROM #AssociatedEnties WHERE planParentEntityID IS NOT NULL
END
--frame a response
  DECLARE @assocEntityCount XML
    SET @assocEntityCount = (SELECT 0 AS '@snapSubclients',
(SELECT  COUNT(*) as '@count' , (SELECT '4' as '@_type_', entityId2 as  '@applicationId',A.displayName '@appName' FOR XML PATH ('appType'), TYPE)
                     FROM    #AssociatedEnties O
                        INNER JOIN APP_iDAType A WITH(NOLOCK) ON O.entityId2 = A.type
                     WHERE  O.entityId5 > 0  AND o.planParentEntityID is null
                     GROUP BY O.entityId2, A.displayName
                     FOR XML PATH('otherSubclients'), type),
(SELECT  COUNT(*) as '@count', (SELECT  '4'as '@_type_', O.entityId2 as  '@applicationId',I.displayName '@appName' FOR XML PATH ('appType'), TYPE)
                     FROM   #AssociatedEnties O
                        INNER JOIN APP_iDAType I WITH(NOLOCK) ON I.type = O.entityId2
						  WHERE   O.entityId5 = 0  AND o.planParentEntityID is null
                     GROUP BY O.entityId2, I.displayName
                     FOR XML PATH('allClients'), type)
                    FOR XML PATH('associatedEntitiesCount'), TYPE)
IF(@reqEntities IS NOT NULL )
BEGIN
	IF OBJECT_ID('tempdb.dbo.#RequestedEnties') IS NOT NULL
	DROP TABLE #RequestedEnties
	CREATE TABLE #RequestedEnties
	(
	entityId1 INT,
	entityId2 INT,
	entityId3 INT,
	entityId4 INT,
	entityId5 INT
	)
	INSERT INTO #RequestedEnties (entityId1,entityId2,entityId3,entityId4,entityId5)
	SELECT 	y.value('@clientId[1]', 'INT'),y.value('@applicationId[1]', 'INT'),y.value('@instanceId[1]', 'INT'),y.value('@backupsetId[1]', 'INT'),y.value('@subclientId[1]', 'INT')
	FROM @reqEntities.nodes('Api_AssociatePlanReq/entities') AS x(y)
	DELETE A
	--SELECT *
	FROM #AssociatedEnties A
	LEFT JOIN #RequestedEnties  R
	ON
	(A.entityId1=R.entityId1 AND R.entityId4=0 AND R.entityId5=0)
	OR
	(A.entityId1=R.entityId1 AND A.entityId4=R.entityId4 AND R.entityId5=0 AND (A.entityId5 =0 OR (a.entityId5 > 0 AND a.planParentEntityID IS NOT NULL))) ---keep child entity
	OR (A.entityId1=R.entityId1 AND A.entityId4=R.entityId4 AND R.entityId5=A.entityId5 and R.entityId4>0  AND R.entityId5>0 )
	WHERE R.entityId1 IS NULL
	--companies
	IF OBJECT_ID('tempdb.dbo.#RequestedCompanies') IS NOT NULL
	DROP TABLE #RequestedCompanies
	CREATE TABLE #RequestedCompanies
	(
		companyId int
	)
	INSERT INTO #RequestedCompanies (companyId)
	SELECT 	y.value('@providerId[1]', 'INT')
	FROM @reqEntities.nodes('Api_AssociatePlanReq/entities') AS x(y)
	WHERE y.value('@_type_[1]', 'INT') = 61
	DELETE A
	--SELECT *
	FROM #AssociatedCompanies A
	LEFT JOIN #RequestedCompanies  R
	ON
	A.providerId=R.companyId
	WHERE R.companyId IS NULL
END
SET @o_xmlText =(SELECT @assocEntityCount,
(SELECT CASE WHEN entityId5 > 0 THEN '7'  WHEN entityId4 > 0 THEN '6' WHEN entityId3 > 0 THEN '5' ELSE '3' END AS '@_type_',
							entityId1 as '@clientId', entityId1Name '@clientName', entityId1DisplayName '@displayName',
entityId2 AS  '@applicationId', entityId2DisplayName '@appName' ,entityId3 as '@instanceId',  IIF(entityId2 IN (6,7,51,52,59,60,77,90,654), dbo.EncodeInvalidXMLChar(entityId3Name), entityId3Name) '@instanceName',
							entityId4 as '@backupsetId', entityId4Name '@backupsetName',
							entityId5 as '@subclientId', entityId5Name '@subclientName'
                    FROM    #AssociatedEnties O
					WHERE  @i_getDetails = 1
                    FOR XML PATH('entities'), type),
				(SELECT
( SELECT CASE WHEN entityId5 > 0 THEN '7'  WHEN entityId4 > 0 THEN '6' WHEN entityId3 > 0 THEN '5' ELSE '3' END AS '@_type_',
							entityId1 as '@clientId', entityId1Name '@clientName', entityId1DisplayName '@displayName',
entityId2 AS  '@applicationId', entityId2DisplayName '@appName' ,entityId3 as '@instanceId',  IIF(entityId2 IN (6,7,51,52,59,60,77,90,654), dbo.EncodeInvalidXMLChar(entityId3Name), entityId3Name) '@instanceName',
							entityId4 as '@backupsetId', entityId4Name '@backupsetName',
							entityId5 as '@subclientId', entityId5Name '@subclientName' FOR XML PATH('entity'), type),
					(SELECT
						CASE WHEN planParentEntityID IS NOT NULL THEN
							( SELECT
CASE WHEN planParentEntityType=6 THEN
(SELECT 6 AS '@_type_',
																		entityId4 as '@backupsetId', entityId4Name '@backupsetName',
entityId3 as '@instanceId',  IIF(entityId2 IN (6,7,51,52,59,60,77,90,654), dbo.EncodeInvalidXMLChar(entityId3Name), entityId3Name) '@instanceName',
																		entityId1 as '@clientId', entityId1Name '@clientName', entityId1DisplayName '@displayName'
																				  FOR XML PATH ('definedIn'),TYPE)
WHEN planParentEntityType=5 THEN
(SELECT 5 AS '@_type_',
entityId3 as '@instanceId',  IIF(entityId2 IN (6,7,51,52,59,60,77,90,654), dbo.EncodeInvalidXMLChar(entityId3Name), entityId3Name) '@instanceName',
																		entityId1 as '@clientId', entityId1Name '@clientName', entityId1DisplayName '@displayName'
																				  FOR XML PATH ('definedIn'),TYPE)
WHEN planParentEntityType=3 THEN
(SELECT 3 AS '@_type_',
																	entityId1 as '@clientId', entityId1Name '@clientName', entityId1DisplayName '@displayName'
																				  FOR XML PATH ('definedIn'),TYPE)
WHEN planParentEntityType=61 THEN
(SELECT  61 AS '@_type_', UD.id AS '@providerId' , UD.domainName As '@providerDomainName'
																		FOR XML PATH ('definedIn'),TYPE)
								END)
							END)
                    FROM    #AssociatedEnties O
					LEFT OUTER JOIN UMDSProviders UD
ON UD.id=O.planParentEntityID AND O.planParentEntityType=61
					WHERE  @i_getDetails = 1
                    FOR XML PATH('planEntities'), type),
(SELECT '61' as '@_type_', providerId as '@providerId', name as '@providerDomainName' FROM #AssociatedCompanieS  FOR XML PATH('companies'), type)
		    FOR XML PATH('Api_PlanAssociatedEntities'), TYPE)
IF(@o_xmlText is null)
	SET @o_xmlText = '<Api_PlanAssociatedEntities />'
SELECT @o_xmlText
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanGetAssociatedEntitiesCountV2')
	delete from GxQscripts where name = 'AppPlanGetAssociatedEntitiesCountV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanGetAssociatedEntitiesCountV2')
	delete from GXDBVersions where aliasname = 'AppPlanGetAssociatedEntitiesCountV2'
GO

insert into GXDBVersions values(2, 'AppPlanGetAssociatedEntitiesCountV2',  '00010001000200140000', 'AppPlanGetAssociatedEntitiesCountV2', '00010001000200140000')
GO

