

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanEntityRulesGetV2.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanEntityRulesGetV2.sp,v $ $Id: AppPlanEntityRulesGetV2.sp,v 1.1.2.1 2020/11/25 06:13:19 alakra Exp $";
--	+===================================================================================+
--	|  								PlanRulesGetV2										|
--	|																					|
--  |  PARAMETERS																		|
--  |    userId     = id of the caller												|
--  |    localeId   = Locale id														|
--  |    i_entityId   = id of plan/planrule												|
--  |    i_entityType = Plan_Entity -> 158, Plan_Rule_Entity -> 159						|
--  |  OUTPUTS																			|
--  |	 x_XmlData	  = Api::PlanRulesInfoResp message									|
--	+===================================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppPlanEntityRulesGetV2')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanEntityRulesGetV2 <<<'
	drop procedure AppPlanEntityRulesGetV2
END
IF EXISTS (select * from GxQscripts where name='AppPlanEntityRulesGetV2')
	delete from GxQscripts where name = 'AppPlanEntityRulesGetV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanEntityRulesGetV2')
	delete from GXDBVersions where aliasname = 'AppPlanEntityRulesGetV2'
GO
print '... Creating Procedure: AppPlanEntityRulesGetV2'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppPlanEntityRulesGetV2
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @userId INT,
  @localeId INT,
  @i_entityType INT,
  @i_entityId INT,
  @x_XmlData XML OUTPUT
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
	DECLARE @errorCode				INT = 0,
			@errorString			NVARCHAR(MAX) = ''
	DECLARE @propertyLevel INT = 0
	DECLARE @entityAssignmentRules XML
	BEGIN TRY
IF @i_entityType = 158 /*PLAN_ENTITY*/
		BEGIN
			-- VALIDATE IF PLAN IS VALID
			IF NOT EXISTS (SELECT 1 FROM App_Plan WITH(NOLOCK) WHERE id = @i_entityId)
			BEGIN
SET @errorCode = (3442 | (CAST(POWER(2, 24) AS BIGINT) * 35)) /*GUIMSG_PLAN_NOT_FOUND*/
				SET @errorString = (SELECT message FROM EvLocaleMsgs WITH (NOLOCK) WHERE messageId = @errorCode AND [localeId] = @localeId)
				;THROW @errorCode, @errorString, 1
			END
			-- GET THE rule XML FROM App_PlanProp TABLE
SET @entityAssignmentRules = ISNULL(dbo.AppPlanGetEntityValueV2(@i_entityId, 'Entity rules', default), '<Api_PlanEntityRulesInfoResp />')
		END
		-- POPULATE THE OUTPUT XML WITH THE RESPONSE
		SET @x_xmlData = @entityAssignmentRules
	END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	IF @errorCode = 0
		SELECT @errorCode = ERROR_NUMBER(), @errorString = ERROR_MESSAGE()
	SET @x_XmlData = (SELECT @errorCode as '@erroCode', @errorString as '@errorMessage'
						FOR XML PATH('error'), ROOT('Api_PlanEntityRulesInfoResp')
					 )
END CATCH
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanEntityRulesGetV2')
	delete from GxQscripts where name = 'AppPlanEntityRulesGetV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanEntityRulesGetV2')
	delete from GXDBVersions where aliasname = 'AppPlanEntityRulesGetV2'
GO

insert into GXDBVersions values(2, 'AppPlanEntityRulesGetV2',  '00010001000200010000', 'AppPlanEntityRulesGetV2', '00010001000200010000')
GO

