

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanEntityRulesDeleteV2.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanEntityRulesDeleteV2.sp,v $ $Id: AppPlanEntityRulesDeleteV2.sp,v 1.1.2.2 2020/12/21 08:28:53 alakra Exp $";
-- 	+---------------------------------------------------------------------------------------+
--	| 			Procedure : "AppPlanEntityRulesDeleteV2"
--	|	This Procedure is used to do delete plan entity rules
-- 	+---------------------------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppPlanEntityRulesDeleteV2')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanEntityRulesDeleteV2 <<<'
	drop procedure AppPlanEntityRulesDeleteV2
END
IF EXISTS (select * from GxQscripts where name='AppPlanEntityRulesDeleteV2')
	delete from GxQscripts where name = 'AppPlanEntityRulesDeleteV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanEntityRulesDeleteV2')
	delete from GXDBVersions where aliasname = 'AppPlanEntityRulesDeleteV2'
GO
print '... Creating Procedure: AppPlanEntityRulesDeleteV2'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppPlanEntityRulesDeleteV2
  @i_userId INT,
  @i_localeId INT,
  @planId INT,
  @xmlData XML,
  @o_errorCode INT OUTPUT,
  @o_errorString NVARCHAR(MAX) OUTPUT
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
----DECLARE @xmlText XML ='<Api_PlanEntityRulesInfoResp>
--  <rules rank="1" opType="3">
--    <clientGroup clientGroupId="40"/>
--    <rule ruleName="arvind_1_10_ClientGroupRule_1" ruleId="15"/>
--    <agents>
--      <agent applicationId="33"/>
--    </agents>
--  </rules>
--  <rules rank="1" opType="3">
--    <clientGroup clientGroupId="34"/>
--    <rule ruleName="arvind_1_6_ClientGroupRule_1" ruleId="16"/>
--    <agents>
--      <agent applicationId="33"/>
--    </agents>
--  </rules>
--</Api_PlanRulesInfoResp>'
BEGIN TRY
	SET @o_errorCode = 0
	SET @o_errorString = ''
	IF object_id('tempdb.dbo.#RulesTbl')	IS NOT null						DROP TABLE #RulesTbl
	-- Initial Input
	-- Keeping temp table as we might have to add more handling later.
	CREATE TABLE #RulesTbl
	(
		ruleId				INT
	)
	-- Keeping like this
	INSERT INTO #RulesTbl
	SELECT ISNULL(ruleInfo.R.value('(@ruleId)', 'INT'), 0)
    FROM @xmlData.nodes('Api_PlanEntityRulesInfoResp/rules') X ( ref )
	cross apply X.ref.nodes('rule') as  ruleInfo(R)
	DELETE APR
	FROM App_PlanEntityRule APR
	INNER JOIN #RulesTbl RT
		ON RT.ruleId=APR.ruleId
END TRY
----=====================================================================
----==============  COME HERE IF THERE WAS A PROBLEM!     ===============
----=====================================================================
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @o_errorCode    = ERROR_NUMBER()
	SET @o_errorString  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanEntityRulesDeleteV2')
	delete from GxQscripts where name = 'AppPlanEntityRulesDeleteV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanEntityRulesDeleteV2')
	delete from GXDBVersions where aliasname = 'AppPlanEntityRulesDeleteV2'
GO

insert into GXDBVersions values(2, 'AppPlanEntityRulesDeleteV2',  '00010001000200020000', 'AppPlanEntityRulesDeleteV2', '00010001000200020000')
GO

