

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanEntityRuleCreateUpdateV2.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanEntityRuleCreateUpdateV2.sp,v $ $Id: AppPlanEntityRuleCreateUpdateV2.sp,v 1.1.2.2 2020/12/21 08:28:56 alakra Exp $";
--	+===================================================================+
--	|  					  AppPlanEntityRuleCreateUpdateV2				|
--	|																	|
--  |  PARAMETERS                                                       |
--  |    userId     = id of the creator									|
--  |    localeId   = Locale id											|
--  |    inXml		  = Api_CreateUpdatePlanEntityRuleReq object xml	|
--  |  OUTPUTS                                                          |
--  |       returns planRuleId and App_GenericResp in input				|
--	|				param for errors (if any)							|
--	+===================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppPlanEntityRuleCreateUpdateV2')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanEntityRuleCreateUpdateV2 <<<'
	drop procedure AppPlanEntityRuleCreateUpdateV2
END
IF EXISTS (select * from GxQscripts where name='AppPlanEntityRuleCreateUpdateV2')
	delete from GxQscripts where name = 'AppPlanEntityRuleCreateUpdateV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanEntityRuleCreateUpdateV2')
	delete from GXDBVersions where aliasname = 'AppPlanEntityRuleCreateUpdateV2'
GO
print '... Creating Procedure: AppPlanEntityRuleCreateUpdateV2'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppPlanEntityRuleCreateUpdateV2
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @userId INT,
  @localeId INT,
  @inXml XML OUTPUT
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
	DECLARE @errorCode					INT = 0,
			@errorString				NVARCHAR(MAX) = 'Rule creation successful.',
			@inPlanId					INT,
			@nowTime					INT = dbo.GetUnixTime (GetUTCdate()),
			@ruleName					NVARCHAR(255),
			@summary					NVARCHAR(2048),
			@regionIds					XML,
			@agentTypeIds				XML,
			@serverGroups				XML,
			@planId						INTEGER,
			@flag						INTEGER,
			@rank						INTEGER,
			@isFound					INT = 0,
			@ruleType					INT = 0,
			@serverGroupsOperator		INT,
			@agentsOperator				INT,
			@regionsOperator			INT,
			@tagsOperator				INT,
			@ruleOperation				INT,
			@tags						XML
	DECLARE @cRegionTbl					TABLE (regionId INT, regionName NVARCHAR(255), displayName NVARCHAR(255))
	DECLARE @cAgentTbl					TABLE (applicationid INT, name NVARCHAR(1024), isGroup INT)
	DECLARE @cServerGroupTbl			TABLE (clientGroupId INT, clientGroupName NVARCHAR(255))
	DECLARE @tagsTbl					TABLE (tagId INT, tagName NVARCHAR(512))
	-- return value
	DECLARE @rv_planRuleId		INT = 0
--
	BEGIN TRY
		-- QUERY PLAN RULE DEFINTION VALUES -- ------------------------------------------------------------------------------------------------------
		SELECT
			@ruleName					=	ISNULL((ref.value('(rule/@ruleName)[1]', 'nvarchar(255)')), ''),
			@rv_planRuleId				=	ISNULL((ref.value('(rule/@ruleId)[1]', 'int')), 0),
			@regionIds					=	(SELECT ref.query('regions') FOR XML PATH('RegionsRoot'), TYPE),
			@agentTypeIds				=	(SELECT ref.query('agents') FOR XML PATH('AgentsRoot'), TYPE),
			@serverGroups				=	(SELECT ref.query('serverGroups') FOR XML PATH('ServerGroupRoot'), TYPE),
			@ruleType					=	ref.value('@type', 'INT'),	-- If no rule type is passed, we will not allow it
			@flag						=	ISNULL(ref.value('@flag', 'INT'), 0),
			@tags						=	(ref.query('tags')),
			@rank						=	ISNULL(ref.value('@rank', 'int'), 0),
			@serverGroupsOperator		=	ref.value('@serverGroupsOperator', 'INT'),
			@agentsOperator				=	ref.value('@agentsOperator', 'INT'),
			@regionsOperator			=	ref.value('@regionsOperator', 'INT'),
			@tagsOperator				=	ref.value('@tagsOperator', 'INT'),
			@ruleOperation				=	ISNULL(ref.value('@ruleOperation', 'INT'), 0)	-- AND
		FROM
		@inXml.nodes('/Api_CreateUpdatePlanEntityRuleReq/ruleInfo') doc(ref)
		-- get planId
		SELECT @inPlanId = ISNULL(ref.value('@planId', 'int'), @inPlanId)
		FROM @inXml.nodes('/Api_CreateUpdatePlanEntityRuleReq/plan') doc(ref)
		-- insert regions
		INSERT INTO @cRegionTbl
			SELECT
				ISNULL(rg.id, 0), ISNULL(rg.name, 'ANY'), ISNULL(rg.displayName, 'ANY')
			FROM @regionIds.nodes('//regions') R(ref)
				LEFT OUTER JOIN App_Region rg WITH(READUNCOMMITTED) ON rg.id = ref.value('@regionId', 'INT')
		-- Insert Agent
		INSERT INTO @cAgentTbl
			SELECT
				a.type, a.name, 0 /*isGroup*/
			FROM @agentTypeIds.nodes('//agents') R(ref)
				JOIN APP_iDAType a WITH(READUNCOMMITTED) ON a.type = ref.value('@applicationId', 'INT')
		-- Insert Tags
		INSERT INTO @tagsTbl
		SELECT
			ref.value('@tagId', 'INT'), ref.value('@tagName', 'NVARCHAR(MAX)')
			FROM @tags.nodes('//tags') R(ref)
		-- Insert Client Groups
		INSERT INTO @cServerGroupTbl
		SELECT
				ref.value('@clientGroupId', 'INT'), AG.name
			FROM @serverGroups.nodes('//serverGroups') R(ref)
			LEFT OUTER JOIN APP_ClientGroup AG WITH(READUNCOMMITTED)
				ON AG.id = ref.value('@clientGroupId', 'INT')
		-- -- ---------------------------------------------------------------------------------------------------------------------------------------
		-- VALIDATION FOR valid Client Group
		IF EXISTS (SELECT TOP 1 1 FROM @cServerGroupTbl)
		BEGIN
			IF EXISTS (SELECT TOP 1 1 FROM @cServerGroupTbl WHERE clientGroupName IS NULL)
			BEGIN
				DECLARE @invalidIds NVARCHAR(MAX)
				SELECT @invalidIds = COALESCE(@invalidIds+', ' ,'') + CAST(clientGroupId AS NVARCHAR(16))
					FROM  @cServerGroupTbl IVM
					WHERE clientGroupName IS NULL
SET @errorCode = (4700 | (CAST(POWER(2, 24) AS BIGINT) * 35)) /*GUIMSG_PLAN_ENTITY_RULE_INVALID_CLIENT_GROUP*/
				SET @errorString = (SELECT message FROM EvLocaleMsgs WITH (NOLOCK) WHERE messageId = @errorCode AND [localeId] = @localeId)
				SET @errorString = REPLACE(@errorString, '^1%d', @invalidIds)
				;THROW @errorCode, @errorString, 1
			END
			IF OBJECT_ID('tempdb.dbo.#sec_CGTbl') IS NOT NULL     DROP TABLE #sec_CGTbl
			CREATE  TABLE #sec_CGTbl ( entityId INT)
EXEC sec_getNonIdaObjectsForThisUser @userId, 28 , 1 ,'#sec_CGTbl'
			IF EXISTS (SELECT 1 FROM @cServerGroupTbl CG_Input
						LEFT OUTER JOIN #sec_CGTbl CG
							ON CG.entityId=CG_Input.clientGroupId
						WHERE CG.entityId IS NULL)
            BEGIN
				DECLARE @sec_CGNoRights NVARCHAR(MAX)
				SELECT @sec_CGNoRights = COALESCE(@sec_CGNoRights+', ' ,'') + CG_Input.clientGroupName FROM @cServerGroupTbl CG_Input
					LEFT OUTER JOIN #sec_CGTbl CG
						ON CG.entityId=CG_Input.clientGroupId
					WHERE CG.entityId IS NULL
SET @errorCode = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35)) /*GUIMSG_SEC_ERROR_MESSAGE_WITH_TYPE  */
				SET @errorString = (SELECT message FROM EvLocaleMsgs WITH (NOLOCK) WHERE messageId = @errorCode AND [localeId] = @localeId)
				SET @errorString = REPLACE(@errorString, '^1%s', ISNULL((SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers WITH(NOLOCK) WHERE id = @userId),@userId))
SET @errorString = REPLACE(@errorString, '^2%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (970 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId))
SET @errorString = REPLACE(@errorString, '^3%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (1429 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = 0))
				SET @errorString = REPLACE(@errorString, '^4%s', @sec_CGNoRights)
				;THROW @errorCode, @errorString, 1
            END
		END
		-- -- ---------------------------------------------------------------------------------------------------------------------------------------
		-- Regions right validation
		--IF EXISTS (SELECT TOP 1 1 FROM @cRegionTbl)
		--BEGIN
		--	-- Add similar to client group logic
		--END
		-- TAGS right validation or might have to update some tag values
		--IF EXISTS (SELECT TOP 1 1 FROM @tagsTbl)
		--BEGIN
		--	-- Add similar to client group logic
		--END
		-- Now add some logic for rule type and basic definition
		IF NOT EXISTS (SELECT TOP 1 1 FROM @cServerGroupTbl)	AND
		   NOT EXISTS (SELECT TOP 1 1 FROM @cRegionTbl)			AND
		   NOT EXISTS (SELECT TOP 1 1 FROM @tagsTbl)
		BEGIN
			-- Error Message - Invalid Rule type specified
SET @errorCode = (4705 | (CAST(POWER(2, 24) AS BIGINT) * 35)) /*GUIMSG_PLAN_ENTITY_RULE_TYPE_INVALID*/
			SET @errorString = (SELECT message FROM EvLocaleMsgs WITH (NOLOCK) WHERE messageId = @errorCode AND [localeId] = @localeId)
			;THROW @errorCode, @errorString, 1
		END
		-- Default -- ----------------------------------------------------------------------------------------------------------------------------
		IF @regionIds.exist('regions') = 0
			SET @regionIds = '<regions regionId="0" regionName="ANY" displayName="ANY"/>'
		IF @agentTypeIds.exist('agents') = 0
			SET @agentTypeIds = '<agents applicationId="0" appName="ANY" />'
		-- Default Till here ----------------------------------------------------------------------------------------------------------------------------
		-- FORMULATE FIELD VALUES -- ----------------------------------------------------------------------------------------------------------------
		-- Re-Create regionIds and agentTypeIds xml from the table variables
			-- This will make sure that the xml being saved in the DB has correct data. User can send duplicate/invalid items.
		IF EXISTS (SELECT 1 FROM @cRegionTbl)
			SET @regionIds = (SELECT
								regionId AS '@regionId',
								regionName AS '@regionName',
								displayName AS '@displayName'
							 FROM @cRegionTbl
							 FOR XML PATH('regions'), TYPE)
		IF EXISTS (SELECT 1 FROM @cAgentTbl)
			SET @agentTypeIds = (SELECT
										applicationId AS '@applicationId',
										name AS '@appName'
									FROM @cAgentTbl
									FOR XML PATH('agents'), TYPE)
		----------------- CREATE SUMMARY----------------------------------------------------------------------------------
		DECLARE @regionStr			NVARCHAR(MAX) = NULL,
				@agentStr			NVARCHAR(MAX) = NULL,
				@agentGrpStr		NVARCHAR(MAX) = NULL,
				@tagsStr			NVARCHAR(MAX) = NULL,
				@serverGroupsStr	NVARCHAR(MAX) = NULL,
				@msgId				INT = 0
		DECLARE @rulesXML XML
		--
		SELECT @regionStr = COALESCE(@regionStr + ',', '') + regionName FROM @cRegionTbl
		SELECT @agentStr = COALESCE(@agentStr + ',', '') + name FROM @cAgentTbl
		SELECT @serverGroupsStr = COALESCE(@serverGroupsStr + ',', '') + clientGroupName FROM @cServerGroupTbl
		SET @rulesXML = (SELECT @rank AS '@rank', @ruleType AS '@type', @summary AS '@summary', @flag AS '@flag',
								@serverGroupsOperator AS '@serverGroupsOperator',@agentsOperator AS '@agentsOperator',
								@regionsOperator AS '@regionsOperator',@tagsOperator AS '@tagsOperator',
								@ruleOperation AS '@ruleOperation',
									(SELECT @ruleName AS '@ruleName', 0 AS '@ruleId'
									FOR XML PATH('rule'), TYPE),
									(SELECT	clientGroupId AS '@clientGroupId', clientGroupName AS '@clientGroupName'
											FROM @cServerGroupTbl
										FOR XML PATH('serverGroups'), TYPE),
									(SELECT @inPlanId AS '@planId'
									FOR XML PATH('plan'), TYPE),
									@agentTypeIds,
									@regionIds,
									@tags
									FOR XML PATH('Api_PlanEntityRuleInfo'))
IF (@ruleType = 1)
		BEGIN
SET @msgId = (4699 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @summary = ISNULL((select message from EvLocaleMsgs WITH (NOLOCK) Where messageId = @msgId AND [localeId] = @localeId),
					'Subclients of clients matching clientGroups [^1%s] agentType [^2%s] will be backed up using this plan.')
			SET @summary = REPLACE(@summary, '^1%s', @serverGroupsStr)
			SET @summary = REPLACE(@summary, '^2%s', ISNULL(@agentStr, 'Any'))
		END
ELSE IF (@ruleType = 2)
		BEGIN
SET @msgId = (4698 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @summary = ISNULL((select message from EvLocaleMsgs WITH (NOLOCK) Where messageId = @msgId AND [localeId] = @localeId),
				'Subclients matching regions [^1%s] will be backed up using this plan.')
			SET @summary = REPLACE(@summary, '^1%s', ISNULL(@regionStr, 'Any'))
		END
ELSE IF (@ruleType = 3)
		BEGIN
SET @msgId = (4704 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @summary = ISNULL((select message from EvLocaleMsgs WITH (NOLOCK) Where messageId = @msgId AND [localeId] = @localeId),
				'Subclients matching tags [^1%s] will be backed up using this plan.')
			SET @summary = REPLACE(@summary, '^1%s', ISNULL(@tagsStr, 'Any'))
		END
		ELSE
		BEGIN
			SET @msgId = -1 -- Will be added in next form
			SET @summary = ISNULL((select message from EvLocaleMsgs WITH (NOLOCK) Where messageId = @msgId AND [localeId] = @localeId),
				'Workloads of clients matching clientGroups [^1%s] agentType [^2%s], regions [^3%s],  matching tags [^4%s] will be backed up using this plan.')
			SET @summary = REPLACE(@summary, '^1%s', ISNULL(@serverGroupsStr, 'Any'))
			SET @summary = REPLACE(@summary, '^2%s', ISNULL(@agentStr, 'Any'))
			SET @summary = REPLACE(@summary, '^3%s', ISNULL(@regionStr, 'Any'))
			SET @summary = REPLACE(@summary, '^4%s', ISNULL(@tagsStr, 'Any'))
		END
		----------------- CREATE SUMMARY - END----------------------------------------------------------------------------------
		-- -- ---------------------------------------------------------------------------------------------------------------------------------------
--
		IF @rv_planRuleId = 0 /*New rule*/
		BEGIN
			-- Check for Duplicate Rule. If duplicate Rule, set isFound as 1
			--SET @isFound = 1
			-- will have to add some check
			-- Like duplicate rules we want to avoid
			-- example - We cannot have same apptype for client group allowed for 2 plans under same subtype
			--	Will come up with this check in next form
			-- INSERT PLANRULE
			BEGIN TRAN
			INSERT INTO App_PlanEntityRule (ruleName, summary, flag, created, modified, rules, planId)
			VALUES					 (@ruleName, @summary, @flag, @nowTime, 0, CAST(@rulesXML AS NVARCHAR(MAX)), @inPlanId)
			SET @rv_planRuleId = SCOPE_IDENTITY()
--
			IF @rv_planRuleId = 0
			BEGIN
				SET @errorCode = 1
				SET @errorString = 'Insert to App_PlanEntityRule table failed.'
				;THROW @errorCode, @errorString, 1
			END
			ELSE
			BEGIN
				-- Lets update the XML
				-- We have to add summary, rule Id, flags
				SET @rulesXML.modify('replace value of (/Api_PlanEntityRuleInfo/rule/@ruleId)[1] with sql:variable("@rv_planRuleId")')
			END
		END
		ELSE
		BEGIN
			-- We will support overwrite
			-- No extra check to be performed
			UPDATE App_PlanEntityRule
				SET rules = CAST(@rulesXML AS NVARCHAR(MAX))
			WHERE ruleId=@rv_planRuleId AND planId=@inPlanId
			IF (@@ROWCOUNT =0)
			BEGIN
				-- TBD - Will create tab file message file for this
				SET @errorCode = 1
				SET @errorString = 'No valid rule found for provided combination of plan and rule id.'
				;THROW @errorCode, @errorString, 1
			END
			IF @@ERROR <> 0
			BEGIN
				SET @errorCode = @@ERROR
				SET @errorString = 'Update to App_PlanEntityRule table failed.'
				;THROW @errorCode, @errorString, 1
			END
		END
--
	END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	IF @errorCode = 0
		SELECT @errorCode = ERROR_NUMBER(), @errorString = ERROR_MESSAGE()
		SET @rv_planRuleId = 0
END CATCH
--
IF @errorCode <> 0
BEGIN
	IF XACT_STATE() <> 0
	BEGIN
		ROLLBACK TRAN
	END
	IF @errorString = ''
	BEGIN
SET @errorCode = (1287 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @errorString = dbo.fn_EvFormatEventMsgText(0, @localeId, @errorCode, 0, 2)
	END
	SET @inXml = (SELECT
				@errorCode AS '@errorCode',
				@errorString AS '@errorMessage'
			FOR XML PATH('Api_GenericResp'), TYPE)
END
ELSE IF XACT_STATE() = 1
BEGIN
	COMMIT TRAN
	SET @inXML = @rulesXML
END
END
--
SET NOCOUNT OFF
--
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanEntityRuleCreateUpdateV2')
	delete from GxQscripts where name = 'AppPlanEntityRuleCreateUpdateV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanEntityRuleCreateUpdateV2')
	delete from GXDBVersions where aliasname = 'AppPlanEntityRuleCreateUpdateV2'
GO

insert into GXDBVersions values(2, 'AppPlanEntityRuleCreateUpdateV2',  '00010001000200020000', 'AppPlanEntityRuleCreateUpdateV2', '00010001000200020000')
GO

