

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanEnsureUserGroup.sp] ---------- 

-- MODIFIED FOR (CCP)
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanEnsureUserGroup.sp,v $ $Id: AppPlanEnsureUserGroup.sp,v 1.1.2.3 2017/04/12 15:34:47 evolohov Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   Creates or recreates plan associated client group   - marks existing profile as deleted
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppPlanEnsureUserGroup <<<'

IF EXISTS (select * from sysobjects where name='AppPlanEnsureUserGroup')
	drop procedure AppPlanEnsureUserGroup
IF EXISTS (select * from GxQscripts where name='AppPlanEnsureUserGroup')
	delete from GxQscripts where name = 'AppPlanEnsureUserGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanEnsureUserGroup')
	delete from GXDBVersions where aliasname = 'AppPlanEnsureUserGroup'
GO
print '... Creating Procedure: AppPlanEnsureUserGroup'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPlanEnsureUserGroup
  @i_planId INTEGER,
  @o_groupId INTEGER OUTPUT,
  @x_xmlData XML OUTPUT 
AS
SET NOCOUNT ON
DECLARE @planName   NVARCHAR(510) = NULL
DECLARE @adminUserId INT = (SELECT TOP 1 UG.userId
							FROM UMUserGroup UG INNER JOIN UMGroups G ON G.id = UG.groupId AND G.allAssociations = 1 AND G.allCapabilities = 1 AND G.selfAssociation = 1
												INNER JOIN UMUsers  U ON U.id = UG.groupId AND U.enabled = 1)
SET @planName = (SELECT name FROM App_Plan WHERE id = @i_planId AND flag & 0x00004 = 0 AND flag & 0x40000000 = 0)
--  get current time
DECLARE @currentTime INT = (SELECT DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE()))
IF @planName IS NOT NULL BEGIN
    -- get plan explicit user group id
SET @o_groupId = dbo.AppPlanGetEntityValue(@i_planId, 'Assigned user group', default)
    -- get list of users that should be associated with the group
    DECLARE @groupUsers AS TABLE(id INT)
    INSERT INTO @groupUsers
SELECT componentNameId FROM UMUsersProp WHERE (@o_groupId IS NOT NULL) AND (attrName = 'Associated Plan') AND (attrVal = CAST(@i_planId AS NVARCHAR(32))) AND (modified = 0)
    IF (@o_groupId IS NULL) OR (NOT EXISTS (SELECT * FROM UMGroups WHERE id  = @o_groupId)) BEGIN -- group is not assigned or was deleted. create/or recreate it
        -- build group name
        DECLARE @userGroupName NVARCHAR(1020) = @planName + ' users'
EXEC AppGetUniqueEntityName 15, @userGroupName , 0/*for group names user id is irrelevant*/, @userGroupName OUTPUT
        -- create group itself
        INSERT INTO UMGroups (groupFlags, allCapabilities, allAssociations, selfAssociation, name, [description], origCCId, [GUID], umdsProviderId, email, lastCredSetTime)
        VALUES( 1, 0, 0, 1, @userGroupName,  N'Contains users associated with ''' + @planName +  N''' plan', 2, NEWID(), 0, '', 0)
        SET @o_groupId  = SCOPE_IDENTITY()
        -- register it with App_PlanProp table
        DECLARE @groupIdvarchar VARCHAR(32) = CAST(@o_groupId AS NVARCHAR)
        DECLARE @errorCode INT = 0
        DECLARE @errorMsg  VARCHAR(MAX) = NULL
EXEC AppPlanSetEntityValue @i_planId, 'Assigned user group', @groupIdvarchar, @errorCode OUTPUT, @errorMsg OUTPUT
		-- set quota for the group
DECLARE @quotaForTheGroup INT = dbo.AppPlanGetEntityValue(@i_planId, 'Quota', default)
		DECLARE @enforceQuota     INT = (CASE WHEN ISNULL(@quotaForTheGroup, 0) = 0 THEN 0 ELSE 1 END)
		SET @quotaForTheGroup = (CASE WHEN ISNULL(@quotaForTheGroup, 0) = 0 THEN 100 ELSE @quotaForTheGroup END)
		EXEC dbo.AppPlanUpdateUserGroupProp @adminUserId, 1, @i_planId, 2, @enforceQuota, @quotaForTheGroup, @o_groupId, @x_xmlData OUTPUT
    END
    IF @o_groupId IS NOT NULL BEGIN -- if group exists/created/recreated make sure that it has users associations
        MERGE   UMUserGroup AS TGT
        USING   (SELECT id FROM  @groupUsers) AS SRC(userId)
        ON      TGT.userId = SRC.userId AND TGT.groupId = @o_groupId
        WHEN    NOT MATCHED THEN INSERT
                    VALUES (SRC.userId, @o_groupId, 0);
    END
END
RETURN @o_groupId
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanEnsureUserGroup')
	delete from GxQscripts where name = 'AppPlanEnsureUserGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanEnsureUserGroup')
	delete from GXDBVersions where aliasname = 'AppPlanEnsureUserGroup'
GO

insert into GXDBVersions values(2, 'AppPlanEnsureUserGroup',  '00010001000200030000', 'AppPlanEnsureUserGroup', '00010001000200030000')
GO

