

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanDeleteV2.sp] ---------- 

-- MODIFIED FOR (CCP)
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanDeleteV2.sp,v $ $Id: AppPlanDeleteV2.sp,v 1.1.2.16 2020/07/22 20:45:07 evolohov Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   AppProfileDelete   - marks existing profile as deleted
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppPlanDeleteV2')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanDeleteV2 <<<'
	drop procedure AppPlanDeleteV2
END
IF EXISTS (select * from GxQscripts where name='AppPlanDeleteV2')
	delete from GxQscripts where name = 'AppPlanDeleteV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanDeleteV2')
	delete from GXDBVersions where aliasname = 'AppPlanDeleteV2'
GO
print '... Creating Procedure: AppPlanDeleteV2'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPlanDeleteV2
  @i_planId INT,
  @i_userId INT,
  @o_xmlText XML OUTPUT
AS
DECLARE @executionTime AS DATETIME = GETUTCDATE()
DECLARE @currentTime   INT = (SELECT DATEDIFF(s, '1970-01-01 00:00:00', @executionTime))
DECLARE @errorCode    INT = 0
DECLARE @errorString  NVARCHAR(1024) = N'Plan deleted successfully'
DECLARE @planIdStr     NVARCHAR(20) = CAST(@i_planId AS NVARCHAR(20))
SET @o_xmlText = NULL
-- SET NOCOUNT ON added to prevent extra result sets from interfering with SELECT statements.
SET NOCOUNT ON
DECLARE @planName AS VARCHAR(510) = (SELECT name FROM App_Plan WHERE id = @i_planId AND ((flag & 0x00004) = 0))
-- check if such plan exists
IF @planName IS NULL BEGIN
	SET @errorCode = 2
	SET @errorString = N'Plan not found'
END
-- check if user has an ability / permission to delete the plan
DECLARE @userHasCapability INT = 0
EXEC sec_checkPermissionOnEntity @i_userId, 158, @userHasCapability OUTPUT, 158, @i_planId
IF @errorCode = 0 BEGIN
	-- check if user is the plan owner/global admin and profile is not of special type
	IF NOT EXISTS ( SELECT  id
                    FROM    App_Plan
                    WHERE       Id = @i_planId
AND (flag & 0x00004) = 0
                            AND  pclass NOT IN (0, 1) -- not master (0), template (1)
                            AND ((ownerId = @i_userId) OR (@userHasCapability = 1)))  BEGIN
		SET @errorCode = 5
		SET @errorString = N'Access is denied'
	END
END
-- mark plan as deleted if there were no errors.
IF @errorCode = 0 BEGIN
    -- Remove recipient cache for all alerts in request so that they are refreshed again
	DELETE  FROM NTNotificationProp
WHERE       (attrName = 'Recipient UserId' OR attrName = 'Recipient UserGroupId')
AND componentNameId IN (SELECT  CAST(RTRIM(LTRIM(SUBSTRING(attrName, LEN('Alert') + 1, 32)))  AS INT)
                                    FROM    App_PlanProp
WHERE       attrName LIKE 'Alert' + ' %'
                                            AND componentNameId = @i_planId
                                    UNION
                                    SELECT  _ID
FROM    dbo.SplitIDString(dbo.AppPlanGetEntityValueV2(@i_planId, 'Alert', 2)))
	-- remove subclient to plan associations
UPDATE APP_SubclientProp SET modified = CONVERT(INT, @executionTime) WHERE attrName = 'Associated Plan' AND attrVal = @planIdStr
    -- client group operations
DECLARE @clientGroup    INT = dbo.AppPlanGetEntityValueV2(@i_planId, 'Assigned client group', 2)
DECLARE @scheduleId     INT = dbo.AppPlanGetEntityValueV2(@i_planId, 'Schedule policy',    2)
    -- -- de-associate client group with the schedule
    IF (@clientGroup IS NOT NULL) OR (@scheduleId  IS NOT NULL) BEGIN
DECLARE @clientGroupEffective    INT = dbo.AppPlanGetEntityValueV2(@i_planId, 'Assigned client group', default)
DECLARE @scheduleIdEffective     INT = dbo.AppPlanGetEntityValueV2(@i_planId, 'Schedule policy',    default)
        IF (@clientGroupEffective IS NOT NULL) AND (@scheduleIdEffective  IS NOT NULL) BEGIN
            DELETE FROM TM_AssocEntity WHERE taskId = @scheduleIdEffective AND clientGroupId = @clientGroupEffective AND assocType = 28
        END
    END
    -- -- remove client group smart rule. simple delete corresponded record
    DELETE FROM App_SCGRule WHERE scgId = @clientGroup
    -- -- remove all security association from the client group
EXEC sec_deleteSecurityAssociationsForEntity 28, @clientGroup
    -- -- remove throttling record for the client group
    DELETE FROM APP_NetworkThrottleOptions WHERE clientGroupId = @clientGroup
    DELETE FROM APP_NetworkThrottle WHERE @clientGroup IN (clientGroupId, forClientGroupId)
    -- -- remove existing associations
    DELETE FROM APP_ClientGroupAssoc WHERE clientGroupId = @clientGroup
    -- -- and finaly remove client group itself
    DELETE FROM APP_ClientGroup WHERE id = @clientGroup
    -- default plans for companies
    DELETE  FROM App_CompanyProp
    WHERE   attrVal = CAST(@i_planId AS VARCHAR)
AND ((attrName = 'Default Server Plan'        AND cs_attrName = checksum('Default Server Plan'))
OR (attrName = 'Default Laptop Plan'          AND cs_attrName = checksum('Default Laptop Plan'))
OR (attrName = 'Default Snap Plan'            AND cs_attrName = checksum('Default Snap Plan'))
OR (attrName = 'Default DB Plan'              AND cs_attrName = checksum('Default DB Plan'))
OR (attrName = 'Default File System Plan'      AND cs_attrName = checksum('Default File System Plan'))
OR (attrName = 'Default Virtual Server Backup Plan'      AND cs_attrName = checksum('Default Virtual Server Backup Plan'))
OR (attrName = 'Default Virtual Server Replication Plan' AND cs_attrName = checksum('Default Virtual Server Replication Plan')))
    -- users operations
    -- -- remove user to plan associations
DELETE FROM UMUsersProp WHERE attrName = 'Associated Plan' AND attrVal = @planIdStr
    -- -- internal and external groups associations
DELETE FROM UMGroupsProp WHERE attrName = 'Associated Plan' AND attrVal = @planIdStr
    -- -- implicit user group operations
DECLARE @userGroup INT = dbo.AppPlanGetEntityValueV2(@i_planId, 'Assigned user group', default)
    -- -- remove quotas from groups
    DECLARE @groupsList NVARCHAR(MAX)
    DECLARE @errorsXML XML = NULL
SELECT @groupsList = COALESCE(@groupsList + ',', '') + attrVal FROM App_PlanProp WHERE  (componentNameId = @i_planId) AND (attrName IN ('Assigned user group', 'Associated internal user group', 'Associated external user group'))
    IF (@groupsList IS NOT NULL)
    BEGIN
        EXEC AppPlanUpdateUserGroupProp @i_userId, 0, @i_planId, 3, 0, 100, @groupsList, @errorsXML
    END
    -- -- remove existing associations and group itself
    DELETE FROM UMUserGroup WHERE groupId = @userGroup
    DELETE FROM UMGroupsProp WHERE componentNameId = @userGroup
    DELETE FROM UMGroups WHERE id = @userGroup
	-- -- remove storage rules.
	   -- need to get storage rules prop directly for the plan and not from its parent (if configured)
DECLARE @storageRules   XML = CAST(dbo.AppPlanGetEntityValueV2(@i_planId, 'Storage Rules', 2) AS XML)
	IF @storageRules IS NOT NULL
		DELETE FROM App_PlanRule WHERE ruleId IN (select ref.value('@ruleId', 'int') as ruleId FROM @storageRules.nodes('/Api_PlanRuleMaps/rules/rule') R(ref))
    -- delete security associations that belong to this plan
EXEC sec_deleteSecurityAssociationsForEntity 158, @i_planId
	-- delete tppm related configurations for the Plan for Index server and Content Extractor
	EXEC RemoveTPPMConfigurationForCA @i_planId , 0
	-- -- delete plan records
    DELETE FROM APP_PlanProp WHERE componentNameId = @i_planId
    DELETE FROM APP_Plan     WHERE id = @i_planId
    -- audit operation ---------------------------------------------------------------------------------------------------------------------------------------------------------
DECLARE @opMsgId   INT = (608 | (CAST(POWER(2, 24) AS BIGINT) * 84)) -- 'Delete existing plan'
    DECLARE @opId      INT
    DECLARE @opEvMsgId INT -- dummy not used.
    EXEC EvGuiAuditSetOperation @opMsgId, @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
DECLARE @paramMsgId INT = (1638 | (CAST(POWER(2, 24) AS BIGINT) * 85))  -- Plan deleted : '^1%s'
    EXEC EvGuiAuditSetParamData @opId, @planName, 0
    EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
    -- -------------------------------------------------------------------------------------------------------------------------------------------------------------------------
END
-- set output value
SET @o_xmlText = (SELECT @errorCode '@errorCode', @errorString '@errorMessage' FOR XML PATH('Api_GenericResp'))
SELECT @o_xmlText
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanDeleteV2')
	delete from GxQscripts where name = 'AppPlanDeleteV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanDeleteV2')
	delete from GXDBVersions where aliasname = 'AppPlanDeleteV2'
GO

insert into GXDBVersions values(2, 'AppPlanDeleteV2',  '00010001000200160000', 'AppPlanDeleteV2', '00010001000200160000')
GO

