

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanDeleteAssociationsV2.sp] ---------- 

-- MODIFIED FOR (CCP)
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanDeleteAssociationsV2.sp,v $ $Id: AppPlanDeleteAssociationsV2.sp,v 1.1.2.8 2020/09/27 09:57:59 jswaminathan Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   AppProfileDelete   - marks existing profile as deleted
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppPlanDeleteAssociationsV2')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanDeleteAssociationsV2 <<<'
	drop procedure AppPlanDeleteAssociationsV2
END
IF EXISTS (select * from GxQscripts where name='AppPlanDeleteAssociationsV2')
	delete from GxQscripts where name = 'AppPlanDeleteAssociationsV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanDeleteAssociationsV2')
	delete from GXDBVersions where aliasname = 'AppPlanDeleteAssociationsV2'
GO
print '... Creating Procedure: AppPlanDeleteAssociationsV2'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPlanDeleteAssociationsV2
  @i_planId INT,
  @i_userId INT,
  @i_localeId INT,
  @o_xmlText XML OUTPUT,
  @selectOutput INT=0
AS
IF OBJECT_ID('tempdb.dbo.#AppPlanDeleteAssoc_tmp__Entites') IS NOT NULL DROP TABLE #AppPlanDeleteAssoc_tmp__Entites
IF OBJECT_ID('tempdb.dbo.#AppPlanDeleteAssoc_tmp__ProvidersTable') IS NOT NULL DROP TABLE #AppPlanDeleteAssoc_tmp__ProvidersTable
IF OBJECT_ID('tempdb.dbo.#tempRemovePlanForIdaTbl') IS NOT NULL DROP TABLE #tempRemovePlanForIdaTbl
CREATE TABLE #AppPlanDeleteAssoc_tmp__Entites(rowId INT IDENTITY(1,1) PRIMARY KEY, id INT, entityId INT, [name] NVARCHAR(510), entityType INT DEFAULT NULL)
CREATE TABLE #AppPlanDeleteAssoc_tmp__ProvidersTable(rowId INT IDENTITY(1,1) PRIMARY KEY, providerId INT, ownerCompany INT DEFAULT 0, [name] NVARCHAR(510) DEFAULT NULL)
CREATE TABLE #tempRemovePlanForIdaTbl(errCode INT, errString VARCHAR(1024))
DECLARE @executionTime AS DATETIME = GETUTCDATE()
DECLARE @currentTime   INT = (SELECT DATEDIFF(s, '1970-01-01 00:00:00', @executionTime))
DECLARE @errorCode     INT = 0
DECLARE @errorString   NVARCHAR(1024) = N''
DECLARE @planName NVARCHAR(510) = NULL
-- audit variables
DECLARE @opMsgId    INT = (657 | (CAST(POWER(2, 24) AS BIGINT) * 84))
DECLARE @opEvMsgId  INT = NULL
DECLARE @opId       INT = 0
DECLARE @entityName NVARCHAR(510) = NULL
DECLARE @entityId   INT = 0
DECLARE @entityType INT = 0
DECLARE @paramMsgId INT = NULL
-- iteration variable
DECLARE @iterator INT = 0
SET @o_xmlText = NULL
-- SET NOCOUNT ON added to prevent extra result sets from interfering with SELECT statements.
SET NOCOUNT ON
-- check if such plan exists
IF NOT EXISTS (SELECT * FROM App_Plan WITH(NOLOCK) WHERE id = @i_planId AND ((flag & 0x00004) = 0)) BEGIN
	SET @errorCode = 2
	SET @errorString = N'Plan not found'
END
IF @errorCode = 0 BEGIN
    -- check if user has an ability / permission to modify the plan
    DECLARE @userHasCapability INT = 0
EXEC sec_checkPermissionOnEntity @i_userId, 157, @userHasCapability OUTPUT, 158, @i_planId
	-- retrieve plan name, failure to retrieve plan indicates that user has no plan capabilities or plan is of special type
    SET @planName = (SELECT  [name]
                     FROM    App_Plan WITH(NOLOCK)
                     WHERE       Id = @i_planId
AND (flag & 0x00004) = 0
                            AND  pclass NOT IN (0, 1) -- not master (0), template (1)
                            AND ((ownerId = @i_userId) OR (@userHasCapability = 1)))
	IF @planName IS NULL  BEGIN
		SET @errorCode = 5
		SET @errorString = N'Access denied'
	END
END
IF @errorCode = 0 BEGIN -- everything is fine. remove associations
    DECLARE @rowCount INT = 0
    DECLARE @rowCurrent INT = 0
    -- users associated with the plan : just update modification time to indicate that record is no longer active
    BEGIN
        -- remove all entries from the table
        TRUNCATE TABLE #AppPlanDeleteAssoc_tmp__Entites
        -- get list of users to be de-associated from the plan
        INSERT INTO #AppPlanDeleteAssoc_tmp__Entites (id, entityId, [name], entityType)
            SELECT  UP.id, U.[Id], U.[name], NULL
FROM    UMUsersProp UP WITH(NOLOCK) INNER JOIN UMUsers U WITH(NOLOCK) ON U.id = UP.componentNameId WHERE U.enabled = 1 AND UP.attrName = 'Associated Plan' AND UP.modified = 0 AND UP.attrVal = CAST(@i_planId AS NVARCHAR(32))
        -- audit -- ----------------------------------------------------------------------------------------------------------------------------------------------------------------
        SET @rowCount = (SELECT MAX(rowId) FROM #AppPlanDeleteAssoc_tmp__Entites)
        SET @rowCurrent = 1
        WHILE @rowCurrent <= @rowCount BEGIN
            SET @iterator = (SELECT id FROM #AppPlanDeleteAssoc_tmp__Entites WHERE rowId = @rowCurrent)
            IF @iterator IS NOT NULL BEGIN
                -- name of the entity for which audit record is being inserted
                SET @entityName = (SELECT [name] FROM #AppPlanDeleteAssoc_tmp__Entites WHERE id = @iterator)
                IF LEN(ISNULL(@entityName, '')) > 0 BEGIN
                    SET @opId = 0; SET @opEvMsgId = 0;
                    EXEC EvGuiAuditSetOperation  @opMsgId, @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
SET @paramMsgId = (1769 | (CAST(POWER(2, 24) AS BIGINT) * 85))  -- Association between user ['^1%s'] and plan ['^2%s'] removed
                    -- audit record parameter values
                    EXEC EvGuiAuditSetParamData @opId, @entityName, 0
                    EXEC EvGuiAuditSetParamData @opId, @planName, 0
                    -- tie up
                    EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
                END
            END
            -- next iteration
            SET @rowCurrent += 1
        END
        -- -------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        -- mark table entry as inactive my specifying modification time
        UPDATE UMUsersProp SET modified = @currentTime WHERE id IN (SELECT id FROM #AppPlanDeleteAssoc_tmp__Entites)
    END
    -- mailbox users, databases, exchange db : get list of
    BEGIN
        -- remove all entries from the table
        TRUNCATE TABLE #AppPlanDeleteAssoc_tmp__Entites
        -- -- -- query for all configuration entities associated with the plan
        INSERT INTO #AppPlanDeleteAssoc_tmp__Entites (id, entityId, [name], entityType)
            SELECT  assocId, 0, [displayName], NULL
            FROM    APP_EmailConfigPolicyAssoc WITH(NOLOCK) WHERE deleted = 0 AND planId = @i_planId AND modified = 0
        -- audit -- ----------------------------------------------------------------------------------------------------------------------------------------------------------------
        SET @rowCount = (SELECT MAX(rowId) FROM #AppPlanDeleteAssoc_tmp__Entites)
        SET @rowCurrent = 1
        WHILE @rowCurrent <= @rowCount BEGIN
            SET @iterator = (SELECT id FROM #AppPlanDeleteAssoc_tmp__Entites WHERE rowId = @rowCurrent)
            IF @iterator IS NOT NULL BEGIN
                -- name of the entity for which audit record is being inserted
                SET @entityName = (SELECT [name] FROM #AppPlanDeleteAssoc_tmp__Entites WHERE id = @iterator)
                IF LEN(ISNULL(@entityName, '')) > 0 BEGIN
                    SET @opId = 0; SET @opEvMsgId = 0;
                    EXEC EvGuiAuditSetOperation  @opMsgId, @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
SET @paramMsgId = (1767 | (CAST(POWER(2, 24) AS BIGINT) * 85))  -- Association between email configuration policy ['^1%s'] and plan ['^2%s'] removed
                    -- audit record parameter values
                    EXEC EvGuiAuditSetParamData @opId, @entityName, 0
                    EXEC EvGuiAuditSetParamData @opId, @planName, 0
                    -- tie up
                    EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
                END
            END
            -- next iteration
            SET @rowCurrent += 1
        END
        -- -------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        -- zero-up configuration policy plan field
        UPDATE APP_EmailConfigPolicyAssoc SET planId = 0 WHERE assocId IN (SELECT id FROM #AppPlanDeleteAssoc_tmp__Entites)
    END
    -- clients associated with the plan
    BEGIN
        -- remove all entries from the table
        TRUNCATE TABLE #AppPlanDeleteAssoc_tmp__Entites
        -- get list of all regular clients associated with the plan that can prevent plan deletion
        INSERT INTO #AppPlanDeleteAssoc_tmp__Entites (id, entityId, [name], entityType)
            SELECT  CLP.id, CL.id, CL.[name], NULL
FROM    APP_Client CL WITH(NOLOCK) INNER JOIN APP_ClientProp CLP WITH(NOLOCK) ON CL.id = CLP.componentNameId AND CLP.attrName = 'Associated Plan'
            WHERE       CLP.modified = 0
                    AND CLP.attrVal = CAST(@i_planId AS NVARCHAR(32))
AND (((CL.status & 0x1000) != 0) OR ( 1 = (SELECT 1 FROM APP_ClientProp CLP2 WITH(NOLOCK) where CLP2.modified=0 and CL.id = CLP2.componentNameId
AND CLP2.attrName = 'System Drive Type' AND  CLP2.attrVal = CAST(6 AS NVARCHAR(32)))))--EdgeSystemDriveTypes_EDISCOVERY
                    -- AND ISNULL((SELECT attrVal FROM APP_ClientProp WHERE attrName = 'platformDeleted 4' AND componentNameId = CL.id), 0) = 0
AND ((CL.status & 0x00004) = 0) AND ((CL.status & 0x00002) = 0)
	    -- clients associated with data collection plan. Behavior of DC plan is slightly different, that it is associated to client
	    -- to keep query simple, lets execute new query instead of adding more clauses to above one.
	    INSERT INTO #AppPlanDeleteAssoc_tmp__Entites (id, entityId, [name], entityType)
            SELECT  DISTINCT CLP.id, CL.id, CL.[name], NULL
            FROM    APP_Client CL WITH(NOLOCK)  INNER JOIN APP_ClientProp CLP WITH(NOLOCK)  ON CL.id = CLP.componentNameId
INNER JOIN APP_Plan AP WITH(NOLOCK)  ON AP.id = @i_planId AND AP.subtype=117506053
			WHERE       CLP.modified = 0
                    AND CLP.attrVal = CAST(@i_planId AS NVARCHAR(32))
AND CLP.attrName IN ('Associated Plan', 'Default Data classification Plan')
                    -- AND ISNULL((SELECT attrVal FROM APP_ClientProp WHERE attrName = 'platformDeleted 4' AND componentNameId = CL.id), 0) = 0
AND ((CL.status & 0x00004) = 0) AND ((CL.status & 0x00002) = 0)
        -- audit -- ----------------------------------------------------------------------------------------------------------------------------------------------------------------
        SET @rowCount = (SELECT MAX(rowId) FROM #AppPlanDeleteAssoc_tmp__Entites)
        SET @rowCurrent = 1
        WHILE @rowCurrent <= @rowCount BEGIN
            SET @iterator = (SELECT id FROM #AppPlanDeleteAssoc_tmp__Entites WHERE rowId = @rowCurrent)
            IF @iterator IS NOT NULL BEGIN
                -- name of the entity for which audit record is being inserted
                SET @entityName = (SELECT [name] FROM #AppPlanDeleteAssoc_tmp__Entites WHERE id = @iterator)
                IF LEN(ISNULL(@entityName, '')) > 0 BEGIN
                    SET @opId = 0; SET @opEvMsgId = 0;
                    EXEC EvGuiAuditSetOperation  @opMsgId, @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
SET @paramMsgId = (1764 | (CAST(POWER(2, 24) AS BIGINT) * 85))  -- Association between client ['^1%s'] and plan ['^2%s'] removed
                    -- audit record parameter values
                    EXEC EvGuiAuditSetParamData @opId, @entityName, 0
                    EXEC EvGuiAuditSetParamData @opId, @planName, 0
                    -- tie up
                    EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
                END
            END
            -- next iteration
            SET @rowCurrent += 1
        END
        -- -------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        -- APP_ClientProp table does not support versions so just remove plan association records
        DELETE FROM APP_ClientProp WHERE id IN (SELECT id FROM #AppPlanDeleteAssoc_tmp__Entites)
    END
    -- instances associated with plan
    BEGIN
        -- remove all entries from the table
        TRUNCATE TABLE #AppPlanDeleteAssoc_tmp__Entites
        INSERT INTO #AppPlanDeleteAssoc_tmp__Entites (id, entityId, [name], entityType)
            SELECT  [IP].id, [IN].id, [IN].[name], NULL
FROM    APP_InstanceProp [IP] WITH(NOLOCK) INNER JOIN APP_InstanceName [IN] WITH(NOLOCK) ON [IN].id = [IP].componentNameId AND [IP].attrName = 'Associated Plan'
            WHERE   [IP].attrVal = CAST(@i_planId AS NVARCHAR(32)) AND [IP].modified = 0
        SET @rowCount = (SELECT MAX(rowId) FROM #AppPlanDeleteAssoc_tmp__Entites)
        SET @rowCurrent = 1
        WHILE @rowCurrent <= @rowCount BEGIN
            SET @iterator = (SELECT id FROM #AppPlanDeleteAssoc_tmp__Entites WHERE rowId = @rowCurrent)
            IF @iterator IS NOT NULL BEGIN
                -- id and name of the entity which is being processed and for which audit record is being inserted
                SELECT @entityId = entityId, @entityName = [name] FROM #AppPlanDeleteAssoc_tmp__Entites WHERE id = @iterator
                -- remove associations
EXEC AppRemovePlanForIdaEntity @i_userId, @i_localeId, 5, @entityId, @i_planId, '', @errorCode OUTPUT, @errorString OUTPUT
                -- audit -- --------------------------------------------------------------------------------------------------------------------------------------------------------
                IF LEN(ISNULL(@entityName, '')) > 0 BEGIN
                    SET @opId = 0; SET @opEvMsgId = 0;
                    EXEC EvGuiAuditSetOperation  @opMsgId, @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
SET @paramMsgId = (1848 | (CAST(POWER(2, 24) AS BIGINT) * 85))  -- Association between backupset ['^1%s'] and plan ['^2%s'] removed
                    -- audit record parameter values
                    EXEC EvGuiAuditSetParamData @opId, @entityName, 0
                    EXEC EvGuiAuditSetParamData @opId, @planName, 0
                    -- tie up
                    EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
                    -- -------------------------------------------------------------------------------------------------------------------------------------------------------------
                END
            END
            -- next iteration
            SET @rowCurrent += 1
        END
    END
    -- backupsets associated with plan
    BEGIN
        -- remove all entries from the table
        TRUNCATE TABLE #AppPlanDeleteAssoc_tmp__Entites
        -- get list of all regular backupsets associated with the plan that can prevent plan deletion
        INSERT INTO #AppPlanDeleteAssoc_tmp__Entites (id, entityId, [name], entityType)
            SELECT  BSP.id, BS.id, BS.[name], NULL
FROM    APP_BackupSetProp BSP WITH(NOLOCK) INNER JOIN APP_BackupSetName BS WITH(NOLOCK) ON BS.id = BSP.componentNameId AND BSP.attrName = 'Associated Plan'
            WHERE   BSP.attrVal = CAST(@i_planId AS NVARCHAR(32)) AND BSP.modified = 0
        SET @rowCount = (SELECT MAX(rowId) FROM #AppPlanDeleteAssoc_tmp__Entites)
        SET @rowCurrent = 1
        WHILE @rowCurrent <= @rowCount BEGIN
            SET @iterator = (SELECT id FROM #AppPlanDeleteAssoc_tmp__Entites WHERE rowId = @rowCurrent)
            IF @iterator IS NOT NULL BEGIN
                -- id and name of the entity which is being processed and for which audit record is being inserted
                SELECT @entityId = entityId, @entityName = [name] FROM #AppPlanDeleteAssoc_tmp__Entites WHERE id = @iterator
                -- remove associations
EXEC AppRemovePlanForIdaEntity @i_userId, @i_localeId, 6, @entityId, @i_planId, '', @errorCode OUTPUT, @errorString OUTPUT
                -- audit -- --------------------------------------------------------------------------------------------------------------------------------------------------------
                IF LEN(ISNULL(@entityName, '')) > 0 BEGIN
                    SET @opId = 0; SET @opEvMsgId = 0;
                    EXEC EvGuiAuditSetOperation  @opMsgId, @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
SET @paramMsgId = (1791 | (CAST(POWER(2, 24) AS BIGINT) * 85))  -- Association between backupset ['^1%s'] and plan ['^2%s'] removed
                    -- audit record parameter values
                    EXEC EvGuiAuditSetParamData @opId, @entityName, 0
                    EXEC EvGuiAuditSetParamData @opId, @planName, 0
                    -- tie up
                    EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
                    -- -------------------------------------------------------------------------------------------------------------------------------------------------------------
                END
            END
            -- next iteration
            SET @rowCurrent += 1
        END
    END
    -- subclient entities associated with the plan
    BEGIN
         -- remove all entries from the table
        TRUNCATE TABLE #AppPlanDeleteAssoc_tmp__Entites
        -- -- -- query for all subclient entities associated with the plan
        INSERT INTO #AppPlanDeleteAssoc_tmp__Entites (id, entityId, [name], entityType)
            SELECT  SCPROP.id, APP.id, APP.subclientName, APP.appTypeId
            FROM    APP_SubClientProp SCPROP WITH (NOLOCK) INNER JOIN APP_Application APP WITH (NOLOCK) ON APP.id = SCPROP.componentNameId
WHERE       (SCPROP.cs_attrName = CHECKSUM(N'Associated Plan'))
AND (SCPROP.attrName = 'Associated Plan')
                    AND (SCPROP.modified = 0)
                    AND (SCPROP.attrVal =  CAST(@i_planId AS NVARCHAR(32)))
AND ((APP.subclientStatus & 0x00004) = 0) AND ((APP.subclientStatus &  0x00002) = 0)
                    AND (APP.appTypeId != 1030)
        -- iterate through the list of subclients and for each subclient call dissociation sp and create audit record
        SET @rowCount = (SELECT MAX(rowId) FROM #AppPlanDeleteAssoc_tmp__Entites)
        SET @rowCurrent = 1
        WHILE @rowCurrent <= @rowCount BEGIN
            SET @iterator = (SELECT id FROM #AppPlanDeleteAssoc_tmp__Entites WHERE rowId = @rowCurrent)
            IF @iterator IS NOT NULL BEGIN
                -- id an name of the entity to be dissociated and for which audit record is being inserted
                SELECT @entityId = entityId, @entityName = [name], @entityType = entityType FROM #AppPlanDeleteAssoc_tmp__Entites WHERE id = @iterator
                -- dissociation -- -------------------------------------------------------------------------------------------------------------------------------------------------
                IF @entityId IS NOT NULL BEGIN
DECLARE @attrName VARCHAR(64) = IIF(@entityType IN (63),                                     'Subclient policy 4',
IIF(@entityType IN (17, 18, 19, 20, 21, 29, 36, 38, 64, 74), 'Subclient policy 3',
IIF(@entityType IN (11, 33, 34, 42, 43),                     'Subclient policy 2', 'Subclient policy 2')))
                    IF @attrName IS NOT NULL BEGIN
EXEC AppRemovePlanForIdaEntity @i_userId, @i_localeId, 7, @entityId, @i_planId, @attrName, @errorCode OUTPUT, @errorString OUTPUT
                    END
                END
                -- -----------------------------------------------------------------------------------------------------------------------------------------------------------------
                -- audit -- -------------------------------------------------------------------------------------------------------------------------------------------------------
                IF LEN(ISNULL(@entityName, '')) > 0 BEGIN
                    SET @opId = 0; SET @opEvMsgId = 0;
                    EXEC EvGuiAuditSetOperation @opMsgId, @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
SET @paramMsgId = (1768 | (CAST(POWER(2, 24) AS BIGINT) * 85))  -- Association between subclient ['^1%s'] and plan ['^2%s'] removed
                    -- -- audit record parameter values
                    EXEC EvGuiAuditSetParamData @opId, @entityName, 0
                    EXEC EvGuiAuditSetParamData @opId, @planName, 0
                    -- -- tie up
                    EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
                END
            END
            -- ---------------------------------------------------------------------------------------------------------------------------------------------------------------------
            -- next iteration
            SET @rowCurrent += 1
        END
        -- mark table entry as inactive by specifying modification time
        UPDATE APP_SubClientProp SET modified = @currentTime WHERE id IN (SELECT id FROM #AppPlanDeleteAssoc_tmp__Entites)
    END
    -- company associated with the plan
    BEGIN
        -- remove all entries from the table
        TRUNCATE TABLE #AppPlanDeleteAssoc_tmp__Entites
        -- query companies associated with the plan
DECLARE @adminUserId INT = (SELECT TOP 1 id FROM UMUsers WHERE flags & 0x040 <> 0)
	    DECLARE @xml XML
EXEC sec_getSecurityForEntity @adminuserId, @xml OUTPUT, 158, @i_planId
        INSERT INTO #AppPlanDeleteAssoc_tmp__ProvidersTable (providerId)
            SELECT ISNULL(ref.value('userOrGroup[1]/@providerId', 'INT'),0) FROM @xml.nodes('associations') R ( ref )
        UPDATE CT
SET     CT.ownerCompany = CASE UD.serviceType WHEN 5  THEN UD.id
WHEN 2     THEN UD.ownerCompany
WHEN 12          THEN UD.ownerCompany
WHEN 1         THEN 0
                                                      ELSE 0 END,
                CT.[name] = UD.domainName
        FROM    #AppPlanDeleteAssoc_tmp__ProvidersTable CT INNER JOIN UMDSProviders UD ON UD.id = CT.providerId
        WHERE CT.providerId != 0
        -- delete duplicated records from providers table.
        ;WITH cte AS
        (
            SELECT rowId, providerId, ownerCompany, [name],
                   ROW_NUMBER() OVER (PARTITION BY providerId, ownerCompany, [name] ORDER BY providerId, ownerCompany, [name]) rowNum
            FROM   #AppPlanDeleteAssoc_tmp__ProvidersTable
        )
        DELETE FROM cte
        WHERE  rowNum > 1
        SET @rowCount = (SELECT MAX(rowId) FROM #AppPlanDeleteAssoc_tmp__ProvidersTable)
        SET @rowCurrent = 1
        DECLARE @providerId   INT = NULL
        DECLARE @ownerCompany INT = NULL
        WHILE @rowCurrent <= @rowCount BEGIN
            SET @providerId   = NULL
            SET @ownerCompany = NULL
            SELECT @providerId = providerId, @ownerCompany = ownerCompany, @entityName = [name] FROM #AppPlanDeleteAssoc_tmp__ProvidersTable WHERE rowId = @rowCurrent
            IF ISNULL(@providerId, 0) > 0 BEGIN
                -- create update organization request
                SET @xml =
                ( SELECT
                    ( SELECT @adminUserId AS '@userId' FOR XML PATH('user'), TYPE),
                    ( SELECT 3 AS '@planDetailsOperationType',
                            (SELECT (SELECT @i_planId   AS '@planId' FOR XML PATH('plan'),      TYPE) FOR XML PATH('planDetails'),  TYPE),
                            (SELECT (SELECT @providerId AS '@id'     FOR XML PATH('shortName'), TYPE) FOR XML PATH('organization'), TYPE),
                            (SELECT 3 AS '@defaultPlansOperationType' FOR XML PATH ('organizationProperties'), TYPE)
                      FOR XML PATH('organizationInfo'), TYPE)
                  FOR XML PATH(''), ROOT('Api_UpdateOrganizationPropertiesRequest')
                )
                -- figure out other parameters
DECLARE @tenantAdminGroupId INT = (SELECT UG.id FROM UMGroups UG WHERE     UG.groupFlags & 0x10000 != 0
                                                                                       AND UG.umdsProviderId = @ownerCompany)
                -- call stored procedure
                DECLARE @o_errCode INT
                DECLARE @o_errString NVARCHAR(max)
                -- call stored procedure that de-associates plan from company
                EXEC AppSetCompanyPlans @xml, @ownerCompany, @tenantAdminGroupId, @o_errCode OUTPUT, @o_errString OUTPUT
                -- audit -- --------------------------------------------------------------------------------------------------------------------------------------------------------
                IF LEN(ISNULL(@entityName, '')) > 0 BEGIN
                    SET @opId = 0; SET @opEvMsgId = 0;
                    EXEC EvGuiAuditSetOperation  @opMsgId, @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
SET @paramMsgId = (1765 | (CAST(POWER(2, 24) AS BIGINT) * 85))  -- Association between company ['^1%s'] and plan ['^2%s'] removed
                    -- audit record parameter values
                    EXEC EvGuiAuditSetParamData @opId, @entityName, 0
                    EXEC EvGuiAuditSetParamData @opId, @planName, 0
                    -- tie up
                    EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
                END
                -- -----------------------------------------------------------------------------------------------------------------------------------------------------------------
            END
            SET @rowCurrent += 1
        END
    END
    -- plan is default
    BEGIN
        -- remove all entries from the table
        TRUNCATE TABLE #AppPlanDeleteAssoc_tmp__Entites
        -- get list of companies for which plan registerd as default
        INSERT INTO #AppPlanDeleteAssoc_tmp__Entites (id, entityId, [name], entityType)
            SELECT  CP.id, UD.id, UD.domainName, NULL
            FROM    App_CompanyProp CP INNER JOIN UMDSProviders UD ON UD.id = CP.componentNameId AND UD.id > 0
            WHERE   (attrVal = CAST(@i_planId AS VARCHAR(32)))
AND(   (attrName = 'Default Server Plan' AND cs_attrName = checksum('Default Server Plan'))
OR (attrName = 'Default Laptop Plan' AND cs_attrName = checksum('Default Laptop Plan'))
OR (attrName = 'Default Snap Plan' AND cs_attrName = checksum('Default Snap Plan'))
OR (attrName = 'Default DB Plan' AND cs_attrName = checksum('Default DB Plan'))
OR (attrName = 'Default File System Plan' AND cs_attrName = checksum('Default File System Plan'))
OR (attrName = 'Default Virtual Server Backup Plan' AND cs_attrName = checksum('Default Virtual Server Backup Plan'))
OR (attrName = 'Default Virtual Server Replication Plan' AND cs_attrName = checksum('Default Virtual Server Replication Plan'))
                       )
        -- audit -- ----------------------------------------------------------------------------------------------------------------------------------------------------------------
        SET @rowCount = (SELECT MAX(rowId) FROM #AppPlanDeleteAssoc_tmp__Entites)
        SET @rowCurrent = 1
        WHILE @rowCurrent <= @rowCount BEGIN
            SET @iterator = (SELECT id FROM #AppPlanDeleteAssoc_tmp__Entites WHERE rowId = @rowCurrent)
            IF @iterator IS NOT NULL BEGIN
                -- name of the entity for which audit record is being inserted
                SET @entityName = (SELECT [name] FROM #AppPlanDeleteAssoc_tmp__Entites WHERE id = @iterator)
                IF LEN(ISNULL(@entityName, '')) > 0 BEGIN
                    SET @opId = 0; SET @opEvMsgId = 0;
                    EXEC EvGuiAuditSetOperation  @opMsgId, @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
SET @paramMsgId = (1766 | (CAST(POWER(2, 24) AS BIGINT) * 85)) -- Plan ['^1%s'] is no longer the default plan for company ['^2%s'].
                    -- audit record parameter values
                    EXEC EvGuiAuditSetParamData @opId, @planName, 0
                    EXEC EvGuiAuditSetParamData @opId, @entityName, 0
                    -- tie up
                    EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
                END
            END
            -- next iteration
            SET @rowCurrent += 1
        END
        -- -------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        -- App_CompanyProp table does not support versions so just remove plan association records
        DELETE FROM App_CompanyProp WHERE id IN (SELECT id FROM #AppPlanDeleteAssoc_tmp__Entites)
    END
END
-- set output value
SET @o_xmlText = (SELECT @errorCode '@errorCode', @errorString '@errorMessage' FOR XML PATH('Api_GenericResp'))
IF OBJECT_ID('tempdb.dbo.#tempRemovePlanForIdaTbl') IS NOT NULL DROP TABLE #tempRemovePlanForIdaTbl
IF OBJECT_ID('tempdb.dbo.#AppPlanDeleteAssoc_tmp__Entites') IS NOT NULL DROP TABLE #AppPlanDeleteAssoc_tmp__Entites
IF OBJECT_ID('tempdb.dbo.#AppPlanDeleteAssoc_tmp__ProvidersTable') IS NOT NULL DROP TABLE #AppPlanDeleteAssoc_tmp__ProvidersTable
SET NOCOUNT OFF
IF(@selectOutput =1)
	SELECT @o_xmlText
RETURN @errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanDeleteAssociationsV2')
	delete from GxQscripts where name = 'AppPlanDeleteAssociationsV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanDeleteAssociationsV2')
	delete from GXDBVersions where aliasname = 'AppPlanDeleteAssociationsV2'
GO

insert into GXDBVersions values(2, 'AppPlanDeleteAssociationsV2',  '00010001000200080000', 'AppPlanDeleteAssociationsV2', '00010001000200080000')
GO

