

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanDelete.sp] ---------- 

-- MODIFIED FOR (CCP)
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanDelete.sp,v $ $Id: AppPlanDelete.sp,v 1.1.2.12 2018/03/27 08:51:05 jiechen Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   AppProfileDelete   - marks existing profile as deleted
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppPlanDelete <<<'

IF EXISTS (select * from sysobjects where name='AppPlanDelete')
	drop procedure AppPlanDelete
IF EXISTS (select * from GxQscripts where name='AppPlanDelete')
	delete from GxQscripts where name = 'AppPlanDelete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanDelete')
	delete from GXDBVersions where aliasname = 'AppPlanDelete'
GO
print '... Creating Procedure: AppPlanDelete'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPlanDelete
  @i_planId INT,
  @i_userId INT,
  @o_xmlText XML OUTPUT
AS
DECLARE @executionTime AS DATETIME = GETUTCDATE()
DECLARE @currentTime   INT = (SELECT DATEDIFF(s, '1970-01-01 00:00:00', @executionTime))
DECLARE @errorCode    INT = 0
DECLARE @errorString  NVARCHAR(1024) = N'Plan deleted successfully'
SET @o_xmlText = NULL
-- SET NOCOUNT ON added to prevent extra result sets from interfering with SELECT statements.
SET NOCOUNT ON
-- check if such plan exists
IF NOT EXISTS (SELECT * FROM App_Plan WHERE id = @i_planId AND ((flag & 0x00004) = 0)) BEGIN
	SET @errorCode = 2
	SET @errorString = N'Plan not found'
END
-- check if user has an ability / permission to delete the plan
DECLARE @userHasCapability INT = 0
EXEC sec_checkPermissionOnEntity @i_userId, 158, @userHasCapability OUTPUT, 158, @i_planId
IF @errorCode = 0 BEGIN
	-- check if user is the plan owner/global admin and profile is not of special type
	IF NOT EXISTS ( SELECT  id
                    FROM    App_Plan
                    WHERE       Id = @i_planId
AND (flag & 0x00004) = 0
                            AND  pclass NOT IN (0, 1) -- not master (0), template (1)
                            AND ((ownerId = @i_userId) OR (@userHasCapability = 1)))  BEGIN
		SET @errorCode = 5
		SET @errorString = N'Access is denied'
	END
END
-- check if plan serves as a base plan for the other plan(s)
IF @errorCode = 0 BEGIN
IF EXISTS (SELECT id FROM APP_PlanProp WHERE attrName = 'Base plan' AND attrVal = CAST(@i_planId AS NVARCHAR(32))) BEGIN
		SET @errorCode = 170
		SET @errorString = N'Plan is in use.'
    END
END
-- check if there are still users, clients or subclients associated with the plan
IF @errorCode = 0 BEGIN
IF EXISTS (SELECT id FROM UMUsersProp WHERE attrName = 'Associated Plan' AND modified = 0 AND attrVal = CAST(@i_planId AS NVARCHAR(32))) OR
       EXISTS (SELECT 1 FROM APP_Client CL WITH(NOLOCK) INNER JOIN APP_ClientProp CLP WITH(NOLOCK) ON CL.id = CLP.componentNameId AND CLP.attrName = 'PLAN_ATTRNAME__ASSOCIATED_PLAN' AND attrVal = CAST(@i_planId AS NVARCHAR(32))
WHERE CLP.modified = 0 AND  ((CL.status & 0x00004) = 0) AND ((CL.status & 0x00002) = 0) ) OR
	   EXISTS (SELECT APP.id FROM APP_SubClientProp SCPROP WITH (NOLOCK) INNER JOIN APP_Application APP WITH (NOLOCK) ON APP.id = SCPROP.componentNameId
WHERE (SCPROP.attrName = 'Associated Plan') AND (SCPROP.modified = 0) AND (SCPROP.attrVal =  CAST(@i_planId AS NVARCHAR(32))) AND ((APP.subclientStatus & 0x00004) = 0) AND ((APP.subclientStatus & 0x00002) = 0))
    BEGIN
		SET @errorCode = 170
		SET @errorString = N'Plan is in use.'
	END
END
-- Check If Any Company has been allocated this plan
IF @errorCode = 0
BEGIN
	DECLARE @securityAssociations XML
EXEC sec_getSecurityForEntity @i_userId, @securityAssociations OUTPUT, 158, @i_planId
	DECLARE @companyAssocTable TABLE (roleId int, permissionId int)
	INSERT into @companyAssocTable
		SELECT ISNULL(ref.value('@roleId', 'INT'),0), 0 FROM @securityAssociations.nodes('associations/properties/role') R ( ref )
		UNION ALL
		SELECT 0, ISNULL(ref.value('@permissionId', 'INT'),0) FROM @securityAssociations.nodes('associations/properties/categoryPermission/categoriesPermissionList') R ( ref )
DECLARE @rolePlanCreatorId INT =ISNULL((SELECT id FROM UMRoles WHERE name = 'Plan Creator Role' ),0)
	IF EXISTS (SELECT TOP 1 * from @companyAssocTable WHERE (@rolePlanCreatorId <> 0) AND (permissionId <> 0 OR roleId <> @rolePlanCreatorId))
	BEGIN
		SET @errorCode = 170
		SET @errorString = N'Plan is assigned to some companies. Please de-associate plan from companies and try again.'
	END
END
-- mark plan as deleted if there were no errors.
IF @errorCode = 0 BEGIN
    -- Remove recipient cache for all alerts in request so that they are refreshed again
	DELETE  FROM NTNotificationProp
WHERE       (attrName = 'Recipient UserId' OR attrName = 'Recipient UserGroupId')
AND componentNameId IN (SELECT  CAST(RTRIM(LTRIM(SUBSTRING(attrName, LEN('Alert') + 1, 32)))  AS INT)
                                    FROM    App_PlanProp
WHERE       attrName LIKE 'Alert' + ' %'
                                            AND componentNameId = @i_planId
                                    UNION
                                    SELECT  _ID
FROM    dbo.SplitIDString(dbo.AppPlanGetEntityValue(@i_planId, 'Alert', default)))
	-- remove subclient to plan associations
UPDATE APP_SubclientProp SET modified = CONVERT(INT, @executionTime) WHERE attrName = 'Associated Plan' AND attrVal = CAST(@i_planId AS NVARCHAR(32))
    -- client group operations
DECLARE @clientGroup    INT = dbo.AppPlanGetEntityValue(@i_planId, 'Assigned client group', 2)
DECLARE @scheduleId     INT = dbo.AppPlanGetEntityValue(@i_planId, 'Schedule policy',    2)
    -- -- de-associate client group with the schedule
    IF (@clientGroup IS NOT NULL) OR (@scheduleId  IS NOT NULL) BEGIN
DECLARE @clientGroupEffective    INT = dbo.AppPlanGetEntityValue(@i_planId, 'Assigned client group', default)
DECLARE @scheduleIdEffective     INT = dbo.AppPlanGetEntityValue(@i_planId, 'Schedule policy',    default)
        IF (@clientGroupEffective IS NOT NULL) AND (@scheduleIdEffective  IS NOT NULL) BEGIN
            DELETE FROM TM_AssocEntity WHERE taskId = @scheduleIdEffective AND clientGroupId = @clientGroupEffective AND assocType = 28
    END
    END
    -- -- remove client group smart rule. simple delete corresponded record
    DELETE FROM App_SCGRule WHERE scgId = @clientGroup
    -- -- remove all security association from the client group
EXEC sec_deleteSecurityAssociationsForEntity 28, @clientGroup
    -- -- remove throttling record for the client group
    DELETE FROM APP_NetworkThrottleOptions WHERE clientGroupId = @clientGroup
    DELETE FROM APP_NetworkThrottle WHERE @clientGroup IN (clientGroupId, forClientGroupId)
    -- -- remove existing associations
    DELETE FROM APP_ClientGroupAssoc WHERE clientGroupId= @clientGroup
    -- -- and finaly remove client group itself
    DELETE FROM APP_ClientGroup WHERE id = @clientGroup
    -- default plans for companies
    DELETE  FROM App_CompanyProp
    WHERE   attrVal = CAST(@i_planId AS VARCHAR)
AND ((attrName = 'Default Server Plan'          AND cs_attrName = checksum('Default Laptop Plan'))
OR (attrName = 'Default Snap Plan'            AND cs_attrName = checksum('Default Snap Plan'))
OR (attrName = 'Default DB Plan'              AND cs_attrName = checksum('Default DB Plan'))
OR (attrName = 'Default File System Plan'      AND cs_attrName = checksum('Default File System Plan'))
OR (attrName = 'Default Virtual Server Backup Plan'      AND cs_attrName = checksum('Default Virtual Server Backup Plan'))
OR (attrName = 'Default Virtual Server Replication Plan' AND cs_attrName = checksum('Default Virtual Server Replication Plan')))
    -- users operations
    -- -- remove user to plan associations
DELETE FROM UMUsersProp WHERE attrName = 'Associated Plan' AND CAST(attrVal AS INT) = @i_planId
    -- -- internal and external groups associations
DELETE FROM UMGroupsProp WHERE attrName = 'Associated Plan' AND CAST(attrVal AS INT) = @i_planId
    -- -- implicit user group operations
DECLARE @userGroup INT = dbo.AppPlanGetEntityValue(@i_planId, 'Assigned user group', default)
    -- -- remove quotas from groups
    DECLARE @groupsList NVARCHAR(MAX)
    DECLARE @errorsXML XML = NULL
SELECT @groupsList = COALESCE(@groupsList + ',', '') + attrVal FROM App_PlanProp WHERE  (componentNameId = @i_planId) AND (attrName IN ('Assigned user group', 'Associated internal user group', 'Associated external user group'))
    IF (@groupsList IS NOT NULL)
    BEGIN
        EXEC AppPlanUpdateUserGroupProp @i_userId, 0, @i_planId, 3, 0, 100, @groupsList, @errorsXML
    END
    -- -- remove existing associations and group itself
    DELETE FROM UMUserGroup WHERE groupId = @userGroup
    DELETE FROM UMGroupsProp WHERE componentNameId = @userGroup
    DELETE FROM UMGroups WHERE id = @userGroup
    -- delete security associations that belong to this plan
EXEC sec_deleteSecurityAssociationsForEntity 158, @i_planId
	-- -- delete plan records
    DELETE FROM APP_PlanProp WHERE componentNameId = @i_planId
    DELETE FROM APP_Plan     WHERE id = @i_planId
END
-- set output value
SET @o_xmlText = (SELECT @errorCode '@errorCode', @errorString '@errorMessage' FOR XML PATH('Api_GenericResp'))
SELECT @o_xmlText
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanDelete')
	delete from GxQscripts where name = 'AppPlanDelete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanDelete')
	delete from GXDBVersions where aliasname = 'AppPlanDelete'
GO

insert into GXDBVersions values(2, 'AppPlanDelete',  '00010001000200120000', 'AppPlanDelete', '00010001000200120000')
GO

