

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanDeferEntityAssociationSetV2.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanDeferEntityAssociationSetV2.sp,v $ $Id: AppPlanDeferEntityAssociationSetV2.sp,v 1.1.2.4 2019/05/17 17:37:09 njain Exp $";
--	+===============================================================================+
--	|  			        AppPlanDeferEntityAssociationSetV2								|
--	|																				|
--  |  PARAMETERS			  														|
--  |    i_planId	  = id of plan													|
--  |    i_entityId	  = id of client/subclient/backupset/instance					|
--  |    i_entityType = Client -> 3, subclient -> 7, backupset -> 6, instance -> 5	|
--  |    i_userId	  = id of the requestor											|
--  |    i_flag		  = PLAN_DEFERRED_ASSOCIATION_STATUS_PENDING by default			|
--  |	 i_opType	  = 1=Update, 2=Add												|
--	+===============================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppPlanDeferEntityAssociationSetV2')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanDeferEntityAssociationSetV2 <<<'
	drop procedure AppPlanDeferEntityAssociationSetV2
END
IF EXISTS (select * from GxQscripts where name='AppPlanDeferEntityAssociationSetV2')
	delete from GxQscripts where name = 'AppPlanDeferEntityAssociationSetV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanDeferEntityAssociationSetV2')
	delete from GXDBVersions where aliasname = 'AppPlanDeferEntityAssociationSetV2'
GO
print '... Creating Procedure: AppPlanDeferEntityAssociationSetV2'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPlanDeferEntityAssociationSetV2
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_entityType INT,
  @i_entityId INT,
  @i_planId INT = 0,
  @i_userId INT = 0,
  @i_flag INT = 1,
  @i_opType INT = 1 /*Update = 1, Add = 2*/,
  @i_retResultSet INT
-----------------------------------------------------------
AS
  DECLARE @rowsAffected INT = 0
SET NOCOUNT ON
DECLARE @nowTime INT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @isExist INT = ISNULL((SELECT 1 FROM App_PlanDeferredEntityAssoc WHERE entityId = @i_entityId AND entityType = @i_entityType), 0)
BEGIN TRY
--
	-- ADD/UPDATE AN ENTRY IN TO THE TABLE WHICH IS MONITORED BY THE EVMGRS THREAD FOR ASSOCIATION COMPLETION.
		-- @i_opType = 1 WILL BE CALLED FROM WHERE EVER EVENT 'PROCESSDEFERREDPLANASSOCIATIONEVENT' GETS SIGNALED, i.e. WHEN THE CLIENT/CLIENTGROUP IS TAGGED TO A REGION
			-- OR GEO LCOATION IS SET.
		-- @i_opType = 2 WILL BE CALLED WHEN CLIENT ACTIVATION/ASSOCIATION TO ELASTIC PLAN FAILS DUE TO REGION NOT TAGGED.
IF @i_entityType = 28
	BEGIN
		UPDATE EA
			SET EA.flags = @i_flag
		FROM App_PlanDeferredEntityAssoc EA
		JOIN APP_AdvanceSettings S WITH(NOLOCK) ON S.entityId = EA.entityId AND S.entityType = EA.entityType
		WHERE S.sourceEntityType = @i_entityType AND S.sourceId = @i_entityId AND EA.flags <> @i_flag
	END
	ELSE IF @i_opType = 2 AND @isExist = 0
		INSERT INTO App_PlanDeferredEntityAssoc (entityId, entityType, planId, userId, flags, created, modified)
		VALUES (@i_entityId, @i_entityType, @i_planId, @i_userId, @i_flag, @nowTime, 0)
	ELSE
	BEGIN
		-- No need to check optype here. In case row already present, we still want to update flag in below clause.
		-- We will not change actual plan id and user id in update
		UPDATE App_PlanDeferredEntityAssoc SET flags = @i_flag WHERE entityId = @i_entityId AND entityType = @i_entityType AND flags <> @i_flag
		SET @rowsAffected = @@ROWCOUNT
IF @i_entityType = 3
		BEGIN
			-- In csae region gets tagged, then its child entities should also get triggered for completing pending plan associations
			UPDATE EA
				SET EA.flags = @i_flag
				FROM App_PlanDeferredEntityAssoc EA
				INNER JOIN APP_Application AAP WITH(NOLOCK)
					ON AAP.clientId=@i_entityId
						AND (
((EA.entityType = 5) AND (EA.entityId=AAP.instance))
								OR
((EA.entityType = 6) AND (EA.entityId=AAP.backupSet))
								OR
((EA.entityType = 7) AND (EA.entityId=AAP.id))
							)
			WHERE EA.flags <> @i_flag
		END
	END
	SET @rowsAffected = @rowsAffected + @@ROWCOUNT
--
--
	----- TAG REGION --------------------------------------------------------------------------------------------------------------------------
	-- This proc is called from three places (region tagged to the client, clientgroup or when geo location is set for a
		-- client during cvd startup)
	-- TAG Region TO THE CLIENT IF IT NOT ALREADY ASSOCIATED, TO HANDLE SCENARIO WHEN GEO LOCATION IS SET FOR A CLIENT.
	-- BELOW CODE WILL BE CALLED ALWAYS, AS WE CANNOT DETERMINE GEO LOCATION SET CASE. REALXING TO CALL IT ALWAYS AS IF REGION IS TAGGED THEN THE PROC WILL NOT DO ANYTHING.
	-- get storage rules for the plan (if exist)
	IF @i_planId = 0
		SET @i_planId = ISNULL((SELECT planId FROM App_PlanDeferredEntityAssoc WHERE entityId = @i_entityId AND entityType = @i_entityType), 0)
IF @i_planId > 0 AND @i_flag <> 1
	BEGIN
DECLARE @storageRules XML = dbo.AppPlanGetEntityValueV2(@i_planId, 'Storage Rules', default)
		IF @storageRules.exist('//rules/rule') = 1
		BEGIN
			-- GET STORAGE RULE DETAILS ---------------------------------------------------------------------------------------------------------------
			DECLARE @ruleIds	TABLE(id INT PRIMARY KEY, rank INT)
			INSERT INTO @ruleIds (id, [rank])
				SELECT
					ref.value('(rule/@ruleId)[1]', 'INT'),
					ISNULL((ref.value('@rank', 'INT')), 0)
				FROM @storageRules.nodes ('Api_PlanRuleMaps/rules') R(ref)
			--
			-- GET REGION IDs FOR THE RULES -------------------------------------------------------------------------------------------------------
				-- THIS TABLE IS USED BY PlanRuleGetFieldsValuesForEntityV2.sp
			IF OBJECT_ID('tempdb.dbo.#planRegions') IS NOT NULL
				DROP TABLE #planRegions
			CREATE TABLE #planRegions(regionId	INT)
			INSERT INTO #planRegions
				SELECT
					regionIds.value('(/regions/region/@regionId)[1]', 'INT')
				FROM App_PlanRule PR WITH(NOLOCK)
				JOIN @ruleIds R ON R.id = PR.ruleId
			DECLARE @clientRuleValues XML
			EXEC PlanRuleGetFieldsValuesForEntityV2 @i_entityId,  @i_entityType, @i_userId, 0/*localeId*/, @clientRuleValues OUTPUT
		END
	END
	----- TAG REGION --------------------------------------------------------------------------------------------------------------------------
--
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
END CATCH
--
--
IF @i_retResultSet = 1
	SELECT @rowsAffected AS rowsAffected
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanDeferEntityAssociationSetV2')
	delete from GxQscripts where name = 'AppPlanDeferEntityAssociationSetV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanDeferEntityAssociationSetV2')
	delete from GXDBVersions where aliasname = 'AppPlanDeferEntityAssociationSetV2'
GO

insert into GXDBVersions values(2, 'AppPlanDeferEntityAssociationSetV2',  '00010001000200040000', 'AppPlanDeferEntityAssociationSetV2', '00010001000200040000')
GO

