

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanDeferEntityAssociationGetV2.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanDeferEntityAssociationGetV2.sp,v $ $Id: AppPlanDeferEntityAssociationGetV2.sp,v 1.1.2.2 2018/11/27 18:31:24 njain Exp $";
--	+===============================================================================+
--	|  			        AppPlanDeferEntityAssociationGetV2							|
--	|																				|
--  |  PARAMETERS			  														|
--  |    @i_flagStatus	  = 1 for pending and 2 for ready							|
--  |    i_ignoreFlag	  = id of client/subclient/backupset/instance				|
--  |  OUTPUTS																		|
--  |	 entityId																	|
--  |	 entityType																	|
--  |	 planId																		|
--  |	 userId																		|
--	+===============================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppPlanDeferEntityAssociationGetV2')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanDeferEntityAssociationGetV2 <<<'
	drop procedure AppPlanDeferEntityAssociationGetV2
END
IF EXISTS (select * from GxQscripts where name='AppPlanDeferEntityAssociationGetV2')
	delete from GxQscripts where name = 'AppPlanDeferEntityAssociationGetV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanDeferEntityAssociationGetV2')
	delete from GXDBVersions where aliasname = 'AppPlanDeferEntityAssociationGetV2'
GO
print '... Creating Procedure: AppPlanDeferEntityAssociationGetV2'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPlanDeferEntityAssociationGetV2
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_entityId INT,
  @i_entityType INT,
  @i_flagStatus INT = 2 /*PLAN_DEFERRED_ASSOCIATION_STATUS_READY*/,
  @i_ignoreFlag INT = 0 /*Default to not ignore*/
-----------------------------------------------------------
AS
-- Variable to return in select statement. This is required as the proc gets called from CPP and SQL layer both.
-- CPP code doesn't understand the OUTPUT variable
  DECLARE @entityId INTEGER
  DECLARE @entityType INTEGER
  DECLARE @planId INTEGER
  DECLARE @userId INTEGER
SET NOCOUNT ON
BEGIN TRY
--
	IF @i_entityId <> 0 AND @i_entityType <> 0
		SELECT
			entityId, entityType, planId, userId
		FROM App_PlanDeferredEntityAssoc WITH(NOLOCK)
		WHERE entityId = @i_entityId AND entityType = @i_entityType
	ELSE
		SELECT
			entityId, entityType, planId, userId
		FROM App_PlanDeferredEntityAssoc WITH(NOLOCK)
		WHERE (@i_ignoreFlag = 1 OR flags & @i_flagStatus = @i_flagStatus)
--
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
END CATCH
--
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanDeferEntityAssociationGetV2')
	delete from GxQscripts where name = 'AppPlanDeferEntityAssociationGetV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanDeferEntityAssociationGetV2')
	delete from GXDBVersions where aliasname = 'AppPlanDeferEntityAssociationGetV2'
GO

insert into GXDBVersions values(2, 'AppPlanDeferEntityAssociationGetV2',  '00010001000200020000', 'AppPlanDeferEntityAssociationGetV2', '00010001000200020000')
GO

