

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanDeferEntityAssociationDeleteV2.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanDeferEntityAssociationDeleteV2.sp,v $ $Id: AppPlanDeferEntityAssociationDeleteV2.sp,v 1.1.2.2 2018/12/15 20:07:15 njain Exp $";
--	+===============================================================================+
--	|  			        AppPlanDeferEntityAssociationDeleteV2						|
--	|																				|
--  |  PARAMETERS			  														|
--  |    i_entityId	  = id of client/subclient/backupset/instance					|
--  |    i_entityType = Client -> 3, subclient -> 7, backupset -> 6, instance -> 5	|
--	+===============================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppPlanDeferEntityAssociationDeleteV2')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanDeferEntityAssociationDeleteV2 <<<'
	drop procedure AppPlanDeferEntityAssociationDeleteV2
END
IF EXISTS (select * from GxQscripts where name='AppPlanDeferEntityAssociationDeleteV2')
	delete from GxQscripts where name = 'AppPlanDeferEntityAssociationDeleteV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanDeferEntityAssociationDeleteV2')
	delete from GXDBVersions where aliasname = 'AppPlanDeferEntityAssociationDeleteV2'
GO
print '... Creating Procedure: AppPlanDeferEntityAssociationDeleteV2'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPlanDeferEntityAssociationDeleteV2
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_entityType INT,
  @i_entityId INT,
  @i_retResultSet INT,
  @i_cleanupModeOn INT = 0
-----------------------------------------------------------
AS
  DECLARE @entityId INT = 0
  DECLARE @entityType INT = 0
SET NOCOUNT ON
IF OBJECT_ID('tempdb.dbo.#deletedTbl') IS NOT NULL
	DROP TABLE #deletedTbl
CREATE TABLE #deletedTbl(entityId	INT, entityType INT)
BEGIN TRY
--
	-- DELETE A SINGLE ENTRY AS PASSED IN THE REQUEST
	IF @i_cleanupModeOn = 0
		DELETE
		FROM App_PlanDeferredEntityAssoc
		OUTPUT deleted.entityId, deleted.entityType INTO #deletedTbl
		WHERE entityId = @i_entityId AND entityType = @i_entityType
	ELSE
	-- CHECK ALL THE ENTITIES PRESENT AND REMOVE ALL OF THOSE WHICH ARE ASSOCIATED TO A PLAN
	BEGIN
		-- HANDLE CASE WHERE ENTITIES ARE NOT PRESENT (DELETED/REMOVED)
		DELETE DE
		OUTPUT deleted.entityId, deleted.entityType INTO #deletedTbl
		FROM App_PlanDeferredEntityAssoc DE
			LEFT JOIN APP_Application CP WITH(NOLOCK)
			ON DE.entityId =
						(CASE DE.entityType
WHEN 3 THEN CP.clientId
WHEN 5 THEN CP.instance
WHEN 6 THEN CP.backupSet
WHEN 7 THEN CP.id
							ELSE NULL
						END)
		WHERE CP.clientId IS NULL AND CP.instance IS NULL AND CP.backupSet IS NULL AND CP.id IS NULL
--
		-- DELETE ENTITIES WHICH ARE ASSOCIATED TO A PLAN
		DELETE DE
		OUTPUT deleted.entityId, deleted.entityType INTO #deletedTbl
		FROM App_PlanDeferredEntityAssoc DE
LEFT JOIN APP_ClientProp CP WITH(NOLOCK) ON DE.entityType = 3 AND CP.componentNameId = DE.entityId AND CP.attrName = 'Associated Plan' AND CP.modified = 0 AND CP.attrVal <> '0'
LEFT JOIN APP_InstanceProp IP WITH(NOLOCK) ON DE.entityType = 5 AND IP.componentNameId = DE.entityId AND IP.attrName = 'Associated Plan' AND IP.modified = 0 AND IP.attrVal <> '0'
LEFT JOIN APP_BackupSetProp BP WITH(NOLOCK) ON DE.entityType = 6 AND BP.componentNameId = DE.entityId AND BP.attrName = 'Associated Plan' AND BP.modified = 0 AND BP.attrVal <> '0'
LEFT JOIN APP_SubClientProp SP WITH(NOLOCK) ON DE.entityType = 7 AND SP.componentNameId = DE.entityId AND SP.attrName = 'Associated Plan' AND SP.modified = 0 AND SP.attrVal <> '0'
		WHERE CP.attrVal IS NOT NULL OR IP.attrVal IS NOT NULL OR BP.attrVal IS NOT NULL OR SP.attrVal IS NOT NULL
	END
--
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
END CATCH
--
--
IF @i_retResultSet = 1
	SELECT entityId, entityType FROM #deletedTbl
IF OBJECT_ID('tempdb.dbo.#deletedTbl') IS NOT NULL
	DROP TABLE #deletedTbl
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanDeferEntityAssociationDeleteV2')
	delete from GxQscripts where name = 'AppPlanDeferEntityAssociationDeleteV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanDeferEntityAssociationDeleteV2')
	delete from GXDBVersions where aliasname = 'AppPlanDeferEntityAssociationDeleteV2'
GO

insert into GXDBVersions values(2, 'AppPlanDeferEntityAssociationDeleteV2',  '00010001000200020000', 'AppPlanDeferEntityAssociationDeleteV2', '00010001000200020000')
GO

