

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanCreateV2.sp] ---------- 

-- --------------------------------------------------------------------------------------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanCreateV2.sp,v $ $Id: AppPlanCreateV2.sp,v 1.1.2.26 2020/08/19 05:57:07 alakra Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppPlanCreateV2')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanCreateV2 <<<'
	drop procedure AppPlanCreateV2
END
IF EXISTS (select * from GxQscripts where name='AppPlanCreateV2')
	delete from GxQscripts where name = 'AppPlanCreateV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanCreateV2')
	delete from GXDBVersions where aliasname = 'AppPlanCreateV2'
GO
print '... Creating Procedure: AppPlanCreateV2'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPlanCreateV2
  @i_userId INT,
  @i_localeId INT,
  @i_ownerId INT,
  @i_classId INT,
  @x_xmlData XML OUTPUT 
AS
-- added to prevent extra result sets from interfering with SELECT statements.
SET NOCOUNT ON
-- debug variabe
DECLARE @debug   INT = 0
DECLARE @__function__ SYSNAME = 'DB.AppPlanCreate '
DECLARE @allowPrintingLogMessages  BIT = ISNULL((SELECT CAST((CASE WHEN ISNUMERIC(value) = 1 THEN value ELSE 0 END) AS BIT) FROM GXGlobalParam WHERE name = 'Plan.allowPrintingLogMessages'), 0)
-- debug
IF (EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.TABLES  WHERE TABLE_NAME = 'App_PlanDebug')) AND (@debug = 0) BEGIN
    DECLARE @debugStmnt AS NVARCHAR(MAX) = 'INSERT INTO App_PlanDebug([procedure],[parameter],[value]) VALUES(''AppPlanCreate'', ''@x_xmlData'',''' +  CAST(@x_xmlData AS VARCHAR(MAX)) + ''')'
    EXEC sp_executesql @debugStmnt
END
IF OBJECT_ID('tempdb.dbo.#tmp__Entity_Id_List') IS NOT NULL DROP TABLE #tmp__Entity_Id_List
    CREATE TABLE #tmp__Entity_Id_List (planId integer NOT NULL)
IF OBJECT_ID('tempdb.dbo.#AppPlanUpdate_tmp__IdsSet')  IS NOT NULL DROP TABLE #AppPlanUpdate_tmp__IdsSet
IF OBJECT_ID('tempdb.dbo.#AppPlanUpdate_tmp__ExecutionErrors') IS NOT NULL DROP TABLE #AppPlanUpdate_tmp__ExecutionErrors
CREATE TABLE #AppPlanUpdate_tmp__IdsSet([type] INT, id INT)
CREATE TABLE #AppPlanUpdate_tmp__ExecutionErrors(__type__ INT, errCode INT, errMessage NVARCHAR(MAX))
-- tune up variables
-- -- set to 1 to alow plan to be derived from a plan which is also derived.
-- -- set to 0 to allow deriviation from the top-level (not derived from other) plan only
DECLARE @allowAnyLevelInheritance  BIT = 1
DECLARE @allowCrossTypeInheritance BIT = 1
-- errror variables
DECLARE @errorCode INT = 0, @errorMsg NVARCHAR(MAX) = ''
-- query plan defintion values and add entry to APP_Plan table
DECLARE @executionTime      DATETIME      = GETUTCDATE()
DECLARE @executionUnixTime  INT           = (SELECT DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE()))
DECLARE @planName           NVARCHAR(510) =        (SELECT ref.value('@planName',      'nvarchar(510)') AS [name]    FROM @x_xmlData.nodes('Api_CreatePlanReq/plan/summary/plan') R ( ref ))
DECLARE @basePlanId 	    INT           =        (SELECT ref.value('@planId',        'INT')           AS [name]    FROM @x_xmlData.nodes('Api_CreatePlanReq/plan/summary/parent') R ( ref ))
DECLARE @planDescription    NVARCHAR(max) = ISNULL((SELECT ref.value('@description',   'NVARCHAR(MAX)') AS [desc]    FROM @x_xmlData.nodes('Api_CreatePlanReq/plan/summary') R ( ref )), N'')
DECLARE @planType           INT           =        (SELECT ref.value('@type',          'INT')           AS [type]    FROM @x_xmlData.nodes('Api_CreatePlanReq/plan/summary') R ( ref ))
DECLARE @planSubType        INT           =        (SELECT ref.value('@subtype',       'INT')           AS [subtype] FROM @x_xmlData.nodes('Api_CreatePlanReq/plan/summary') R ( ref ))
DECLARE @planStatus         INT           = ISNULL((SELECT ref.value('@planStatusFlag','INT')           AS [status]  FROM @x_xmlData.nodes('Api_CreatePlanReq/plan/summary') R ( ref )), 0) | 0x02
DECLARE @restrictions       INT           = ISNULL((SELECT ref.value('@restrictions',  'INT')           AS [restric] FROM @x_xmlData.nodes('Api_CreatePlanReq/plan/summary') R ( ref )), 0)
DECLARE @sealed				INT           =        (SELECT ref.value('@isSealed',  'INT')               AS [sealed]  FROM @x_xmlData.nodes('Api_CreatePlanReq/plan/inheritance') R ( ref ))
DECLARE @permissionsList    NVARCHAR(510)
DECLARE @idsStr             VARCHAR(MAX)  = NULL
-- return value
DECLARE @rv_planId          INT = 0
DECLARE @adminUserId INT = (SELECT TOP 1 id FROM UMUsers WHERE flags & 0x040 <> 0)
--
IF @debug != 0 BEGIN
    SELECT 'Plan properties', @planName AS Name, @planDescription AS [Description], @planType AS [Type], @planSubType AS [Subtype], @basePlanId AS [Base Plan Id]
END
-- basic parameters check
-- -- verify if user has capability to create plan
IF @errorCode = 0  BEGIN
    DECLARE @userHasCapability INT = 0
EXEC sec_checkPermissionOnEntity @i_userId, 156, @userHasCapability OUTPUT, 1, 2
	IF (@userHasCapability = 0) BEGIN
	DECLARE @organizationId		INT	= dbo.AppGetOrganizationForUser(@i_userId)
EXEC sec_checkPermissionOnEntity @i_userId, 156, @userHasCapability OUTPUT, 61, @organizationId
	END
    IF (@userHasCapability = 0)  AND ISNULL(@basePlanId, 0) != 0 BEGIN
EXEC sec_checkPermissionOnEntity @i_userId, 156, @userHasCapability OUTPUT, 158, @basePlanId
    END
    IF (@userHasCapability = 0)  BEGIN
        SET @errorCode = 5; SET @errorMsg = 'Access denied. User has no plan creation capabilities.'
    END
END
-- -- class cannot be created if name, plan type or plan subtype is not defined
IF (@planName IS NULL) OR (LEN(@planName) = 0) OR (@planType IS NULL) OR (@planSubType IS NULL)  BEGIN
    SET @errorCode = 100; SET @errorMsg = 'Incomplete definition.'
END
-- -- plan name should be unique for the user
IF @errorCode = 0 BEGIN
    -- query id of the plan with spcified name
    DECLARE @existingPlanId INT, @existingPlanFlags INT
    SELECT @existingPlanId = id, @existingPlanFlags = ISNULL(flag, 0) FROM App_Plan WHERE name LIKE @planName AND ownerId = @i_ownerId
    -- if plan with such name already exists then check if it is still active, rename it if it is not,
    IF @existingPlanId IS NOT NULL BEGIN
IF ((@existingPlanFlags & 0x00004) = 0) AND ((@existingPlanFlags & 0x40000000) = 0) BEGIN
            -- plan not deleted and not scheduled for deletion. error out
            SET @errorCode = 101; SET @errorMsg = 'Plan ' + @planName + ' already exists.'
        END ELSE BEGIN
            -- plan been deleted. just rename it so the will be no constraint error.
            UPDATE App_Plan SET name = name + ', renamed ' + CONVERT(VARCHAR(24), @executionTime, 121) WHERE id = @existingPlanId
        END
    END
END
-- -- the case when pan MUST have a base plan (any or of a certain type). if base plan of any type is required then @basePlanSubtype will be 0;
-- -- specific type otherwise
DECLARE @requiredBasePlanSubtype INT = ISNULL((SELECT ref.value('@basePlanSubtype', 'NVARCHAR(32)') FROM @x_xmlData.nodes('Api_CreatePlanReq/plan/definition') R ( ref )), 0)
IF @requiredBasePlanSubtype != 0 AND ISNULL(@basePlanId, 0) = 0 BEGIN
    SET @errorCode = 103; SET @errorMsg = 'Invalid definition. Base plan required.'
END
-- -- check if plan is derived one. if so do a basic derivation check
-- -- note that deriving plan from different plan type/subtype is allowed
IF @errorCode = 0 AND ISNULL(@basePlanId, 0) != 0  BEGIN
    -- check base plan existence
DECLARE @basePlanName NVARCHAR(510) = (SELECT name FROM APP_Plan WHERE (id = @basePlanId) AND ((flag & 0x00004) = 0) AND ((flag & 0x40000000) = 0))
	IF @basePlanName IS NULL BEGIN
        SET @errorCode = 2; SET @errorMsg = 'Base plan ' + CAST(@basePlanId AS VARCHAR(32)) + ' not found.'
	END
	-- check users capabilities on base plan
	IF @errorCode = 0 BEGIN
        -- -- get list of all users for which base plan is available
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 158, 0, '#tmp__Entity_Id_List'
        IF (NOT EXISTS (SELECT 1 FROM #tmp__Entity_Id_List planList WHERE planid = @basePlanId)) AND  (NOT EXISTS (SELECT 1 FROM App_plan WHERE id = @basePlanId AND ownerId = @i_userId)) BEGIN
            SET @errorCode = 5; SET @errorMsg = 'Access denied. No capabilities on plan ' + CAST(@basePlanId AS nvarchar(32)) + '.'
        END
	END
    -- check if base plan is of correct subtype
    IF @errorCode = 0 BEGIN
        -- query base plan subtype
        DECLARE @basePlanSubtype INT = (SELECT subtype FROM App_Plan WHERE id = @basePlanId)
        IF @requiredBasePlanSubtype NOT IN (0, @basePlanSubtype) BEGIN
            SET @errorCode = 13; SET @errorMsg = 'Data is invalid. Base plan type mismatch. Required type ' + CAST(@requiredBasePlanSubtype AS nvarchar) + ', provided type ' + CAST(@basePlanSubtype AS nvarchar) + '.'
        END
        -- check if base plan subtype and new plan subtypes are matching or cross types inheritance is allowed
        IF (@errorCode = 0) AND (@allowCrossTypeInheritance = 0) BEGIN
            IF ISNULL(@basePlanSubtype, 0) != @planSubType  BEGIN
                SET @errorCode = 13; SET @errorMsg = 'Cross type inheritance is not allowed.'
            END
        END
    END
    -- check if base plan is not sealed
    IF @errorCode = 0 BEGIN
DECLARE @basePlanInheritanceRestrictions INT = CAST(dbo.AppPlanGetEntityValueV2(@basePlanId, 'Derivation restrictions', default) AS INT)
        IF (@basePlanInheritanceRestrictions & 1) != 0 BEGIN
            SET @errorCode = 13; SET @errorMsg = 'Data is invalid. Base plan is sealed.'
        END
    END
    -- check if base plan is top level plan and not derived one if necessary
	IF (@errorCode = 0) AND (@allowAnyLevelInheritance = 0) BEGIN
IF ISNULL((SELECT attrVal FROM APP_PlanProp WHERE (attrName = 'Base plan') AND (componentNameId = @basePlanId)), 0) != 0 BEGIN
            SET @errorCode = 13; SET @errorMsg = 'Data is invalid. Non-top level inheritance is not allowed. ' + @basePlanName + ' (' + CAST(@basePlanId AS VARCHAR(32)) + ') is not top level plan.'
		END
	END
END
-- if no errors were encountered so far then start create plan entries. open  transaction that will be committed if there is no error and
-- rolled back if one of the operation fails.
IF @errorCode = 0 BEGIN
    BEGIN TRY
        BEGIN TRANSACTION
        -- create main entry
        INSERT INTO APP_Plan (name,        GUID,     [type],      subtype,   [pclass],    ownerId,            created, modified, origCCId,        flag,    [description])
        VALUES			     (@planName, NEWID(), @planType, @planSubType, @i_classId, @i_ownerId, @executionUnixTime,        0,        2, @planStatus, @planDescription)
        SET @rv_planId = SCOPE_IDENTITY()
        IF @allowPrintingLogMessages = 1 PRINT @__function__ + CAST(@rv_planId AS VARCHAR) + ' : Plan table main entry created.'
        IF @debug != 0 SELECT 'Assigned plan id', @rv_planId
        -- create base plan entry
		IF ISNULL(@basePlanId, 0) != 0 BEGIN
			INSERT INTO APP_PlanProp (componentNameId, attrName, attrType, attrVal, created, modified)
VALUES (@rv_planId, 'Base plan', 7, CAST(@basePlanId AS NVARCHAR(32)), @executionUnixTime, 0)
		END
        -- -- logging record
        IF @allowPrintingLogMessages = 1  PRINT @__function__ + CAST(@rv_planId AS VARCHAR(32)) + ' : Plan base entry created. Entry id ' + CAST(SCOPE_IDENTITY() AS VARCHAR)
        -- plan inheritance restrictions
		-- -- individual setting always has precedence over restrictions bit field
		IF @sealed IS NOT NULL BEGIN
			DECLARE @adj INT = 0;
			IF		(@sealed = 1) AND ((@restrictions & 1) = 0) SET @adj =  1
			ELSE IF (@sealed = 0) AND ((@restrictions & 1) = 1) SET @adj = -1
			IF (@allowPrintingLogMessages = 1) AND (@adj != 0)
				PRINT @__function__ + CAST(@rv_planId AS VARCHAR(32)) + ' : plan inheritance definition differs from plan summary restriction, restrictions value adjusted : ' + CAST(@adj AS VARCHAR(3))
			SET @restrictions += @adj
		END
		INSERT INTO APP_PlanProp (componentNameId, attrName, attrType, attrVal, created, modified)
VALUES (@rv_planId, 'Derivation restrictions', 7, CAST(@restrictions AS NVARCHAR(64)), @executionUnixTime, 0)
        -- -- logging record
        IF @allowPrintingLogMessages = 1 PRINT @__function__ + CAST(@rv_planId AS VARCHAR(32)) + ' : Plan restrictions entry created. Entry id ' + CAST(SCOPE_IDENTITY() AS VARCHAR)
DECLARE @globalRestrictedEntitiesList NVARCHAR(1024) = ISNULL((SELECT TOP 1 value FROM GxGlobalParam WITH(NOLOCK) WHERE name = 'Plan entites derivation restricted' AND modified=0),'')
        SET @idsStr = NULL
		SELECT @idsStr = COALESCE(@idsStr+ ',', '') + CAST(TB.ID AS VARCHAR) FROM
							(SELECT ref.value('@val', 'INT') AS ID
        FROM @x_xmlData.nodes('Api_CreatePlanReq/plan/inheritance/enforcedEntities') R (ref)
							UNION
							SELECT _ID AS ID
							FROM dbo.SplitIDString(@globalRestrictedEntitiesList)) TB
		INSERT INTO APP_PlanProp (componentNameId, attrName, attrType, attrVal, created, modified)
VALUES (@rv_planId, 'Descendants enforced entities', 1, ISNULL(@idsStr, ''), @executionUnixTime, 0)
		-- Check that none of the <private> entities are intersecting with <restricted> entities.
		-- If yes, then plan creation should fail.
		IF EXISTS (SELECT 1 FROM @x_xmlData.nodes('Api_CreatePlanReq/plan/inheritance/privateEntities') R (ref)
							INNER JOIN dbo.SplitIDString(@globalRestrictedEntitiesList) TB
								ON TB._ID=ref.value('@val', 'INT'))
		BEGIN
			SET @errorCode = 54; SET @errorMsg = 'Bad restrictions definition'
			-- -- -- logging record
			IF @allowPrintingLogMessages = 1
			PRINT @__function__ + CAST(@rv_planId AS VARCHAR(32)) + ' : Restricted Enforced entities are provided in Private Entities. Error [' + CAST(@errorCode AS VARCHAR) + ' : ' + @errorMsg + ']'
			-- -- -- no need to continue. rollback changes and exit stored procedure
			;THROW @errorCode, @errorMsg, 1
		END
        SET @idsStr = NULL
        SELECT @idsStr = COALESCE(@idsStr+ ',', '') + CAST(ref.value('@val', 'INT') AS VARCHAR)
        FROM @x_xmlData.nodes('Api_CreatePlanReq/plan/inheritance/privateEntities') R (ref)
		INSERT INTO APP_PlanProp (componentNameId, attrName, attrType, attrVal, created, modified)
VALUES (@rv_planId, 'Private entities', 1, ISNULL(@idsStr, ''), @executionUnixTime, 0)
        SET @idsStr = NULL
        SELECT @idsStr = COALESCE(@idsStr+ ',', '') + CAST(ref.value('@val', 'INT') AS VARCHAR)
        FROM @x_xmlData.nodes('Api_CreatePlanReq/plan/definition/forbidden') R (ref)
		INSERT INTO APP_PlanProp (componentNameId, attrName, attrType, attrVal, created, modified)
VALUES (@rv_planId, 'Defintion entities : forbidden', 1, ISNULL(@idsStr, ''), @executionUnixTime, 0)
        SET @idsStr = NULL
        SELECT @idsStr = COALESCE(@idsStr+ ',', '') + CAST(ref.value('@val', 'INT') AS VARCHAR)
        FROM @x_xmlData.nodes('Api_CreatePlanReq/plan/definition/possible') R (ref)
		INSERT INTO APP_PlanProp (componentNameId, attrName, attrType, attrVal, created, modified)
VALUES (@rv_planId, 'Defintion entities : possible', 1, ISNULL(@idsStr, ''), @executionUnixTime, 0)
        SET @idsStr = NULL
        SELECT @idsStr = COALESCE(@idsStr+ ',', '') + CAST(ref.value('@val', 'INT') AS VARCHAR)
        FROM @x_xmlData.nodes('Api_CreatePlanReq/plan/definition/required') R (ref)
		INSERT INTO APP_PlanProp (componentNameId, attrName, attrType, attrVal, created, modified)
VALUES (@rv_planId, 'Defintion entities : required', 1, ISNULL(@idsStr, ''), @executionUnixTime, 0)
        -- get list of required and forbidden entities. it will help to make a decision on client and user group creation
        DECLARE @requiredEntities AS TABLE (entityId INT PRIMARY KEY)
        INSERT INTO @requiredEntities
            SELECT DISTINCT ref.value('@val', 'INT') FROM @x_xmlData.nodes('Api_CreatePlanReq/plan/definition/required') R ( ref )
        DECLARE @forbiddenEntities AS TABLE (entityId INT PRIMARY KEY)
        INSERT INTO @forbiddenEntities
            SELECT DISTINCT ref.value('@val', 'INT') FROM @x_xmlData.nodes('Api_CreatePlanReq/plan/definition/forbidden') R ( ref )
        -- -------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        -- create explicit plan client group if corresponded entity is in the list of required and not forbidden entities ----------------------------------------------------------
IF EXISTS(SELECT 1 FROM @requiredEntities WHERE entityId = 2048) AND NOT EXISTS(SELECT 1 FROM @forbiddenEntities WHERE entityId = 2048)
        BEGIN
            -- -- make sure that there is no duplicates in client group names ------------------------------------------------------------------------------------------------------
            DECLARE @clientGroupName NVARCHAR(1020) = @planName + ' clients'
            EXEC AppGetUniqueEntityName 28/*CLIENT_GROUP_ENTITY*/, @clientGroupName, @i_ownerId, @clientGroupName OUTPUT
            -- -- create entry in client group table
            INSERT INTO APP_ClientGroup(name, description, flag, status, userId, refTime, modified, origCCid, GUID)
VALUES(@clientGroupName, @planName + ' associated clients' , 4096 |  536870912 , 0, 1 /* @ownerId */, @executionUnixTime, @executionUnixTime, 2, NEWID())
            DECLARE @clientGroupId INT = SCOPE_IDENTITY()
            IF @allowPrintingLogMessages = 1 PRINT @__function__ + CAST(@rv_planId AS VARCHAR(32)) + ' : Plan client group entry "' + @clientGroupName + '" created. Entry id ' + CAST(@clientGroupId AS VARCHAR)
		    IF @debug != 0 BEGIN
                -- -- -- no need to continue. rollback changes and exit stored procedure
			    SELECT 'Plan client group ', @clientGroupId
		    END
		    -- -- smart client group definition
		    -- -- -- SCG_PKID_CLIENT_ASSOCIATED_WITH_PLAN = 34 = prodID
            DECLARE @scgDefintion XML = '<scgRule op="0"><rules><rule op="0"><rules>
                                         <rule filterID="12" propID="' + (SELECT CAST(id AS NVARCHAR(32)) FROM App_SCGProperty WITH(NOLOCK) WHERE name = 'CLIENT_ASSOCIATED_WITH_PLAN')+ '" propType="2" value="' + (SELECT @planName FOR XML PATH(''))  + '" />
                                         </rules></rule></rules></scgRule>'
		    DECLARE  @scgRule VARCHAR(max)
		    EXEC APPSCGV2GenerateQueryParams @scgDefintion, @errorCode OUTPUT, @errorMsg OUTPUT, @scgRule OUTPUT
		    INSERT	INTO	App_SCGRule (scgId, ruleXml, ruleQuery, ownerId, created, modified)
				    VALUES	(@clientGroupId, @scgDefintion, @scgRule, @i_ownerId, @executionUnixTime, 0)
      	    -- setting ownership for smart client group
		    SET @permissionsList = '1,2'
		    EXEC sec_setCreatorForEntity @i_ownerId, 0, @permissionsList, @errorCode OUTPUT, @errorMsg OUTPUT, 28, @clientGroupId
		    IF @errorCode != 0 BEGIN
                -- -- -- logging record
                IF @allowPrintingLogMessages = 1
                    PRINT @__function__ + CAST(@rv_planId AS VARCHAR(32)) + ' : sec_setCreatorForEntity call failed. Error [' + CAST(@errorCode AS VARCHAR) + ' : ' + @errorMsg + ']'
                -- -- -- no need to continue. rollback changes and exit stored procedure
                ;THROW @errorCode, @errorMsg, 1
		    END
			-- IF owner company is an actual company and not commserv , then change scope to that company
			DECLARE @ownerCompanyId INT = dbo.AppGetOrganizationForUser(@i_ownerId)
			IF (@ownerCompanyId > 0)
			BEGIN
				-- Set scope to that company clients
				UPDATE APSCG
SET APSCG.entityType = 61,
						APSCG.entityId = @ownerCompanyId
					FROM APP_SCGScope APSCG
					INNER JOIN App_SCGRule ASCG WITH(NOLOCK)
						ON ASCG.id=APSCG.scgRuleId
				WHERE
					ASCG.scgId=@clientGroupId
			END
			-- We have to provide owner permission on Plan SCG. So that once any laptop get activated by this plan, then all owners of those laptop get that permission set rights via this SCG
			DECLARE @spXML XML
			DECLARE @errorTable TABLE(
                                    errorCode INT,
                                    errorString NVARCHAR(MAX)
                                )
            SET @spXML =(SELECT 2 AS '@associationsOperationType',
							(SELECT
							   (SELECT 1 as '@categoriesPermissionOperationType',
(SELECT 102  as '@categoryId',
121 as '@_type_',
												  'Client' AS '@categoryName'  -- CATEGORY_CLIENT_NAME
										FOR XML PATH ('categoriesPermissionList'),TYPE),
(SELECT 102 as '@categoryId',
25 as '@permissionId',
122 as '@_type_',
												1 as 'flags/@exclude'
										FOR XML PATH('categoriesPermissionList'),TYPE)
								FOR XML PATH('categoryPermission'), TYPE)
							FOR XML PATH('ownerAssociations'),TYPE)
                    FOR XML PATH('App_SecurityAssociationForEntityList'))
            IF(@spXML IS NOT NULL)
            BEGIN
				INSERT INTO @errorTable
EXEC Sec_setSecurityAssociationsFromEntity @spXML,@i_ownerId,0,1,28,@clientGroupId,0,0,0,0,0,0,0,0
				IF EXISTS(SELECT 1 FROM @errorTable WHERE errorCode<>0)
				BEGIN
					SELECT @errorCode=errorCode,@errorMsg=errorString FROM @errorTable WHERE errorCode<>0
					IF @allowPrintingLogMessages = 1
						PRINT @__function__ + CAST(@rv_planId AS VARCHAR(32)) + ' : Sec_setSecurityAssociationsFromEntity call failed. Error [' + CAST(@errorCode AS VARCHAR) + ' : ' + @errorMsg + ']'
					-- -- -- no need to continue. rollback changes and exit stored procedure
					;THROW @errorCode, @errorMsg, 1
				END
            END
            -- -- store client group id in the Plan property table.
EXEC AppPlanSetEntityValueV2 @rv_planId, 'Assigned client group', @clientGroupId, @errorCode OUTPUT, @errorMsg OUTPUT
		    IF @errorCode != 0 BEGIN
                IF @allowPrintingLogMessages = 1
                    PRINT @__function__ + CAST(@rv_planId AS VARCHAR(32)) + ' : AppPlanSetEntityValueV2 call for client group failed. Error [' + CAST(@errorCode AS VARCHAR) + ' : ' + @errorMsg + ']'
                -- -- -- no need to continue. rollback changes and exit stored procedure
                ;THROW @errorCode, @errorMsg, 1
		    END ELSE BEGIN
                IF @allowPrintingLogMessages = 1 PRINT @__function__ + CAST(@rv_planId AS VARCHAR(32)) + ' : Plan client group entry "' + @clientGroupName + '" created. Entry id ' + CAST(@clientGroupId AS VARCHAR)
            END
        END
        -- -------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        -- user group --------------------------------------------------------------------------------------------------------------------------------------------------------------
        -- -- make sure that there is no duplicates in user group names also add owner to the group
IF EXISTS(SELECT 1 FROM @requiredEntities WHERE entityId = 16) AND NOT EXISTS(SELECT 1 FROM @forbiddenEntities WHERE entityId = 16) BEGIN
            DECLARE @userGroupName NVARCHAR(1020) = @planName + ' users'
            EXEC AppGetUniqueEntityName 15/*USERGROUP_ENTITY*/, @userGroupName , @i_ownerId, @userGroupName OUTPUT
            INSERT INTO UMGroups (groupFlags, allCapabilities, allAssociations, selfAssociation, name, [description], origCCId, [GUID], umdsProviderId, email, lastCredSetTime)
                VALUES( 1, 0, 0, 1, @userGroupName,  N'Contains users associated with ''' + @planName +  N''' plan', 2, NEWID(), 0, '', 0)
            DECLARE @usersGroupId INT = SCOPE_IDENTITY()
            IF @allowPrintingLogMessages = 1 PRINT @__function__ + CAST(@rv_planId AS VARCHAR(32)) + ' : Plan user group entry "' + @userGroupName + '" created. Entry id ' + CAST(@usersGroupId AS VARCHAR)
            IF @debug != 0 BEGIN
			    SELECT 'Plan client group ', @usersGroupId, @userGroupName
		    END
		    -- -- remove the view permission from the group. So the user can only see the that has explicit rights on.
		    DECLARE @roleName NVARCHAR(50) = 'View'
		    DECLARE @roleId INT = (SELECT id FROM UMROles WHERE name = @roleName AND flags & (1 | 2) <> 0)
		    DELETE UMSecurityAssociations WHERE isUser = 0 AND userOrGroupId = @usersGroupId AND entityType1 = 15/*USERGROUP_ENTITY*/ AND entityId1 = @usersGroupId and roleId = @roleId
            -- -- insert record that ties group to plan
EXEC AppPlanSetEntityValueV2 @rv_planId, 'Assigned user group', @usersGroupId, @errorCode OUTPUT, @errorMsg OUTPUT
		    IF @errorCode != 0 BEGIN
                IF @allowPrintingLogMessages = 1
                    PRINT @__function__ + CAST(@rv_planId AS VARCHAR(32)) + ' : AppPlanSetEntityValueV2 call for user group failed. Error [' + CAST(@errorCode AS VARCHAR) + ' : ' + @errorMsg + ']'
                -- -- -- no need to continue. rollback changes and exit stored procedure
                ;THROW @errorCode, @errorMsg, 1
		    END ELSE BEGIN
                IF @allowPrintingLogMessages = 1 PRINT @__function__ + CAST(@rv_planId AS VARCHAR(32)) + ' : Plan user group entry "' + @userGroupName + '" created. Entry id ' + CAST(@usersGroupId AS VARCHAR)
            END
            DECLARE @x_xmlGroupResp XML = NULL
            EXEC dbo.AppPlanUpdateUserGroupProp @i_userId, @i_localeId, @rv_planId, 2, 0, 100, @usersGroupId, @x_xmlGroupResp OUTPUT
            SELECT TOP 1 @errorCode = pe.value('@errorCode', 'INT'), @errorMsg = pe.value('@errorString', 'NVARCHAR(1024)') FROM @x_xmlGroupResp.nodes('Api_PlanComponentErrorList/error') R ( ref )
                                CROSS APPLY ref.nodes('./status') P(pe)
		    IF @errorCode != 0 BEGIN
                IF @allowPrintingLogMessages = 1
                    PRINT @__function__ + CAST(@rv_planId AS VARCHAR(32)) + ' : AppPlanUpdateUserGroupProp call for user group failed. Errors [' + CAST(@x_xmlGroupResp AS VARCHAR(MAX)) + ']'
                -- -- -- no need to continue. rollback changes and exit stored procedure
                ;THROW @errorCode, @errorMsg, 1
            END
        END
        -- -------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        -- register owner specified by @i_ownerId as plan creator ------------------------------------------------------------------------------------------------------------------
		SET @permissionsList = CAST(31 AS NVARCHAR(10)) + ',' + CAST(157 AS NVARCHAR(10)) + ',' + CAST(158 AS NVARCHAR(10)) + ',' + CAST(159 AS NVARCHAR(10))
DECLARE @rolePlanCreatorId INT = ISNULL((SELECT id FROM UMRoles WHERE name = 'Plan Creator Role' ),0)
		IF @rolePlanCreatorId = 0 BEGIN
			EXEC sec_setCreatorForEntity @i_ownerId, 0, @permissionsList, @errorCode OUTPUT, @errorMsg OUTPUT, 158, @rv_planId
		END ELSE BEGIN
			EXEC sec_setCreatorForEntity @i_ownerId, @rolePlanCreatorId , '', @errorCode OUTPUT, @errorMsg OUTPUT, 158, @rv_planId
		END
		IF @errorCode != 0 BEGIN
            IF LEN(ISNULL(@errorMsg, '')) = 0
			    SET @errorMsg = 'Unable to set creator for the plan.'
            IF @allowPrintingLogMessages = 1
                PRINT @__function__ + CAST(@rv_planId AS VARCHAR(32)) + ' : Unable to set plan creator role for owner [' + CAST(@i_ownerId AS VARCHAR(510)) + ']. Error : ' + @errorMsg
            -- -- -- no need to continue. rollback changes and exit stored procedure
            ;THROW @errorCode, @errorMsg, 1
		END
        -- -----------------------------------------------------------------------------------------------------------------------------------------------------
		IF ISNULL(@basePlanId, 0) != 0
		BEGIN
			EXEC AppPlanUpdateOptionsV2 @i_userId, @i_localeId, @rv_planId, @debug, @x_xmlData
		END
		-- -------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        DECLARE @roleDefintionXml XML = NULL
        DECLARE @executionStatus  TABLE (errorCode INT, errorMsg NVARCHAR(1024))
        --  give owners company and plan owner subscription role -----------------------------------------------------------------------------------------------
        BEGIN
DECLARE @tenantAdminGroupId INT = (SELECT id FROM UMGroups WITH (NOLOCK) WHERE ((groupFlags & 0x10000) != 0) AND (umdsProviderId = dbo.AppGetOrganizationForUser(@i_ownerId)))
DECLARE @subscriptionRoleId INT = (SELECT id FROM UMRoles  WITH (NOLOCK) WHERE ((flags & 64) != 0) AND (name = 'Plan Subscription Role'))
        -- -- company
        IF (ISNULL(@tenantAdminGroupId, 0) != 0) AND (ISNULL(@subscriptionRoleId, 0) != 0) BEGIN
            -- -- build xml
            SET @roleDefintionXml =
                (SELECT 2 AS '@associationsOperationType', -- Operation Type ADD AS 2
                    (SELECT
                        (SELECT
(SELECT 150 AS '@_type_',  158 AS '@entityType', @rv_planId AS '@entityId' FOR XML PATH('entity'), TYPE)
                         FOR XML PATH('entities'), TYPE),
                        (SELECT
                            (SELECT @subscriptionRoleId AS '@roleId' FOR XML PATH('role'), TYPE)
                         FOR XML PATH('properties'), TYPE)
                     FOR XML PATH('associations'), TYPE),
                    (SELECT
                        (SELECT
(SELECT 150 AS '@_type_',  158 AS '@entityType', @rv_planId as '@entityId' FOR XML PATH('entity'),TYPE)
                         FOR XML PATH('entities'), TYPE),
                        (SELECT
(SELECT 107 AS '@categoryId', 31                    AS '@permissionId'  FOR XML PATH('permissions'), TYPE)
                            -- according to Jagadeesh the line below is not necessary because role @subscriptionRoleId already has CAT_PLAN_ASSOCIATIONS_ADD_REMOVE
                            -- associated with it.
-- ,(SELECT 118   AS '@categoryId', 159 AS '@permissionId' FOR XML PATH('permissions'), TYPE)
                         FOR XML PATH('properties'), TYPE)
                     FOR XML PATH('associations'), TYPE)
                 FOR XML PATH('App_SecurityAssociationForUserOrGroupList'),TYPE)
            -- -- make the association
            INSERT INTO @executionStatus
                EXEC sec_setSecurityAssociationsFromUserOrUserGroup @roleDefintionXml, @adminUserId, 0, @tenantAdminGroupId, 0
            -- check for errors
            SELECT TOP 1 @errorCode = errorCode, @errorMsg = errorMsg FROM @executionStatus
            IF @errorCode != 0 BEGIN
                IF LEN(ISNULL(@errorMsg, '')) = 0
			        SET @errorMsg = 'Unable to set plan subscription role for the onwers company.'
                IF @allowPrintingLogMessages = 1
                    PRINT @__function__ + CAST(@rv_planId AS VARCHAR(32)) + ' : Unable to set plan subscription role for company [' + CAST(@tenantAdminGroupId AS VARCHAR(510)) + ']. Error : ' + @errorMsg
                -- -- -- no need to continue. rollback changes and exit stored procedure
                ;THROW @errorCode, @errorMsg, 1
		    END
        END
        -- -- for derived plans give owner plan subscription role ------------------------------------------------------------------------------------------------
        IF ISNULL(@basePlanId, 0) != 0 AND ISNULL(@i_ownerId, 0) != 0 BEGIN
            SET @roleDefintionXml =
                    (SELECT 2 AS '@associationsOperationType', -- Operation Type ADD AS 2
                    (SELECT
                        (SELECT
(SELECT 150 AS '@_type_',  158 AS '@entityType', @rv_planId AS '@entityId' FOR XML PATH('entity'), TYPE)
                         FOR XML PATH('entities'), TYPE),
                        (SELECT
                            (SELECT @subscriptionRoleId AS '@roleId' FOR XML PATH('role'), TYPE)
                         FOR XML PATH('properties'), TYPE)
                     FOR XML PATH('associations'), TYPE)
                 FOR XML PATH('App_SecurityAssociationForUserOrGroupList'),TYPE)
            -- -- make the association
            INSERT INTO @executionStatus
                EXEC sec_setSecurityAssociationsFromUserOrUserGroup @roleDefintionXml, @adminUserId, @i_ownerId, 0, 0
            SELECT TOP 1 @errorCode = errorCode, @errorMsg = errorMsg FROM @executionStatus
            IF @errorCode != 0 BEGIN
                IF LEN(ISNULL(@errorMsg, '')) = 0
			        SET @errorMsg = 'Unable to set plan subscription role for the plan owner.'
                IF @allowPrintingLogMessages = 1
                    PRINT @__function__ + CAST(@rv_planId AS VARCHAR(32)) + ' : Unable to set plan subscription role for plan owner [' + CAST(@i_ownerId AS VARCHAR(510)) + ']. Error : ' + @errorMsg
                -- -- -- no need to continue. rollback changes and exit stored procedure
                ;THROW @errorCode, @errorMsg, 1
		    END
        END
        END
        --  update status in plan definition table ---------------------------------------------------------------------------------------------------------------------------------
        -- -- master and template plans are hidden
        IF @i_classId = 0 OR @i_classId = 1 BEGIN
            SET @planStatus = @planStatus | 0x08 -- 0x0008
        END
        UPDATE App_Plan SET flag = @planStatus WHERE id = @rv_planId
        -- -------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        -- audit operation ---------------------------------------------------------------------------------------------------------------------------------------------------------
DECLARE @opMsgId   INT = (607 | (CAST(POWER(2, 24) AS BIGINT) * 84)) -- 'Add new plan'
        DECLARE @opEvMsgId INT -- dummy not used.
        DECLARE @opId      INT = 0
EXEC EvGuiAuditSetOpWithEntity @opMsgId, @i_userId, 158, @rv_planId, @opEvMsgId OUTPUT, @opId OUTPUT
DECLARE @paramMsgId INT = (1491 | (CAST(POWER(2, 24) AS BIGINT) * 85))  -- Plan : [^1%s]
        DECLARE @planSubTypeStr VARCHAR(32) = CAST(@planSubType AS VARCHAR(32))
        EXEC EvGuiAuditSetParamData @opId, @planName, 0
        EXEC EvGuiAuditSetParamData @opId, @planSubTypeStr, 0
        EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
        -- -------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        -- we are done
        IF @debug <> 0 BEGIN
            SELECT * FROM APP_Plan WHERE id = @rv_planId
            SELECT * FROM APP_PlanProp WHERE componentNameId = @rv_planId
            ROLLBACK TRANSACTION
        END ELSE IF @errorCode <> 0 BEGIN
            ROLLBACK TRANSACTION
        END ELSE BEGIN
            COMMIT TRANSACTION
        END
    END TRY
    BEGIN CATCH
        ROLLBACK TRANSACTION
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		IF @errorCode = 0 BEGIN
            SET @errorCode = ERROR_NUMBER()
            SET @errorMsg = 'Procedure [' + ISNULL(ERROR_PROCEDURE(), '<unknown proc>') + '] Error Line [' + Convert(VARCHAR(5), ISNULL(ERROR_LINE(), 0)) + ']. ' + ISNULL(ERROR_MESSAGE(), '')
        END
	    SET @rv_planId = 0
    END CATCH
END
SET @x_xmlData = (
    SELECT
        (SELECT
            (SELECT
                @planType         AS '@type',
                @planSubType      AS '@subtype',
                @planDescription  AS '@description',
                (SELECT
                    @rv_planId AS '@planId',
                    @planName  AS '@planName'
                 FOR XML PATH('plan'), TYPE)
             FOR XML PATH('summary'), TYPE)
         FOR XML PATH('plan'), TYPE),
        (SELECT
            (SELECT 158 AS '@__type__'
             FOR XML PATH('entity'), TYPE),
            (SELECT @errorCode  AS '@errorCode',
                    @errorMsg   AS '@errorMessage'
             FOR XML PATH('status'), TYPE)
         FOR XML PATH('errors'), TYPE)
    FOR XML PATH('Api_CreatePlanResp')
)
SELECT @x_xmlData
IF OBJECT_ID('tempdb.dbo.#tmp__Entity_Id_List') IS NOT NULL DROP TABLE #tmp__Entity_Id_List
RETURN @rv_planId;
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanCreateV2')
	delete from GxQscripts where name = 'AppPlanCreateV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanCreateV2')
	delete from GXDBVersions where aliasname = 'AppPlanCreateV2'
GO

insert into GXDBVersions values(2, 'AppPlanCreateV2',  '00010001000200260000', 'AppPlanCreateV2', '00010001000200260000')
GO

