

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanCreate.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanCreate.sp,v $ $Id: AppPlanCreate.sp,v 1.1.2.39 2018/06/16 12:38:12 vdevassy Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppPlanCreate <<<'

IF EXISTS (select * from sysobjects where name='AppPlanCreate')
	drop procedure AppPlanCreate
IF EXISTS (select * from GxQscripts where name='AppPlanCreate')
	delete from GxQscripts where name = 'AppPlanCreate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanCreate')
	delete from GXDBVersions where aliasname = 'AppPlanCreate'
GO
print '... Creating Procedure: AppPlanCreate'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPlanCreate
  @i_userId INT,
  @i_localeId INT,
  @i_ownerId INT,
  @i_classId INT,
  @o_xmlText XML OUTPUT 
AS
-- added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
-------------------------------------------------------------------------------------------------------------------------------------------
--Code Below Here is From AppPlanConstants.spb
-- declare plan properties definition shared values
DECLARE @constAttrType_BasePlan					INT = 260
DECLARE @constAttrName_BasePlan					NVARCHAR(32) = N'BasePlan'
DECLARE @constAttrType_Feature					INT = 261
DECLARE @constAttrName_Feature					NVARCHAR(32) = N'Feature'
DECLARE @constAttrType_Alert					INT = 262
DECLARE @constAttrName_Alert					NVARCHAR(32) = N'Alert'
DECLARE @constAttrType_AccessPolicy				INT = 263
DECLARE @constAttrName_AccessPolicy				NVARCHAR(32) = N'Access policy'
DECLARE @constAttrType_Policy_Subclient			INT = 264
DECLARE @constAttrName_Policy_Subclient			NVARCHAR(32) = N'Subclient policy'
DECLARE @constAttrType_Policy_Schedule			INT = 265
DECLARE @constAttrName_Policy_Schedule			NVARCHAR(32) = N'Schedule policy'
DECLARE @constAttrType_Policy_Storage			INT = 266
DECLARE @constAttrName_Policy_Storage			NVARCHAR(32) = N'Storage policy'
DECLARE @constAttrType_Options					INT = 267
DECLARE @constAttrName_Options_Quota			NVARCHAR(32) = 'Quota'
DECLARE @constAttrName_Options_EdgeDriveQuota	NVARCHAR(32) = 'Edge Drive Quota Size'
DECLARE @constAttrName_Options_Throttle			NVARCHAR(32) = 'Network Throttle'
DECLARE @constAttrType_UserGroupAssigned		INT = 268
DECLARE @constAttrName_UserGroupAssigned		NVARCHAR(32) = 'Assigned user group'
DECLARE @constAttrType_UserGroupIAssoc			INT = 269
DECLARE @constAttrName_UserGroupIAssoc			NVARCHAR(32) = 'Associated internal user group'
DECLARE @constAttrType_UserGroupEAssoc			INT = 270
DECLARE @constAttrName_UserGroupEAssoc			NVARCHAR(32) = 'Associated external user group'
DECLARE @constAttrType_Restrictions				INT = 271
DECLARE @constAttrName_Restrictions				NVARCHAR(32) = 'Entity restrictions'
DECLARE @constAttrType_AssociatedPlan			INT = 272
DECLARE @constAttrName_AssociatedPlan			NVARCHAR(32) = 'Associated Plan'
DECLARE @constAttrType_ClientGroupAssigned		INT = 273
DECLARE @constAttrName_ClientGroupAssigned		NVARCHAR(32) = 'Assigned client group'
DECLARE @constAttType_ScheduledForDeletion		INT = 274
DECLARE @constAttName_ScheduledForDeletion		NVARCHAR(32) = 'Scheduled for deletion'
DECLARE @constAttType_EdgeDriveAssigned  		INT = 275
DECLARE @constAttName_EdgeDriveAssigned 		NVARCHAR(32) = 'Assgined Edge Drive'
DECLARE @constAttrType_Policy_SubclientWin		INT = 276
DECLARE @constAttrName_Policy_SubclientWin		NVARCHAR(32) = N'Subclient policy 2'
DECLARE @constAttrType_Policy_SubclientLin		INT = 277
DECLARE @constAttrName_Policy_SubclientLin		NVARCHAR(32) = N'Subclient policy 3'
DECLARE @constAttrType_Policy_SubclientMac		INT = 278
DECLARE @constAttrName_Policy_SubclientMac		NVARCHAR(32) = N'Subclient policy 4'
DECLARE @constAttType_SubclientRetention		INT = 279
DECLARE @constAttName_SubclientRetention		NVARCHAR(32) = 'Subclient retention period'
DECLARE @constAttType_SubclientVersions			INT = 280
DECLARE @constAttName_SubclientVersions			NVARCHAR(32) = 'Number of Synth Full Versions'
DECLARE @constAttrType_Policy_ScheduleLog   		INT = 281
DECLARE @constAttrName_Policy_ScheduleLog   		NVARCHAR(32) = N'Log schedule policy'
DECLARE @constAttrType_Policy_StorageLog    		INT = 282
DECLARE @constAttrName_Policy_StorageLog   		 NVARCHAR(32) = N'Log storage policy'
DECLARE @constAttType_SlaInMinutes			INT = 283
DECLARE @constAttName_SlaInMinutes			NVARCHAR(32) = N'SLA In Minutes'
DECLARE @constAttType_LogSlaInMinutes			INT = 285
DECLARE @constAttName_LogSlaInMinutes			NVARCHAR(32) = N'Log SLA In Minutes'
DECLARE @constAttType_ReplicationTargets    		INT = 284
DECLARE @constAttName_ReplicationTargets   		 NVARCHAR(32) = N'Replication schedule policy'
DECLARE @constAttType_ForcedArchiving   		INT = 286
DECLARE @constAttName_ForcedArchiving   		 NVARCHAR(32) = N'Forced Archiving'
-- plan entity identifiers are declared in http:--ncvs/source/xref/win/vaultcx/Source/Common/XmlMessage/Api.x : enum PlanEntities
DECLARE @constPlanEntity_StoragePolicy		 INT =   1
DECLARE @constPlanEntity_SubclientPolicy	 INT =   2
DECLARE @constPlanEntity_SchedulePolicy		 INT =   4
DECLARE @constPlanEntity_Features			 INT =   8
DECLARE @constPlanEntity_Users				 INT =  16
DECLARE @constPlanEntity_Alerts				 INT =  32
DECLARE @constPlanEntity_AccessPolicies		 INT =  64
DECLARE @constPlanEntity_Options			 INT = 128
DECLARE @constPlanEntity_SubclientPolicy_Win INT = 256
DECLARE @constPlanEntity_SubclientPolicy_Lin INT = 512
DECLARE @constPlanEntity_SubclientPolicy_Mac INT = 1024
DECLARE @constPlanEntity_ClientGroup		 INT = 2048
DECLARE @constPlanEntity_EdgeDrive           INT = 4096
DECLARE @constPlanEntity_StoragePolicyLog	 INT = 8192
DECLARE @constPlanEntity_SchedulePolicyLog   INT = 16384
DECLARE @constPlanEntity_ReplicationTargets	 INT = 32768
-- entity operations. declared in http:--ncvs/source/xref/11.0-win/vaultcx/Source/Common/XmlMessage/CVGui.x#197 : enum ListOperationType
DECLARE @constOpType_NONE					INT = 0
DECLARE @constOpType_OVERWRITE				INT = 1
DECLARE @constOpType_ADD					INT = 2
DECLARE @constOpType_DELETE					INT = 3
DECLARE @constOpType_CLEAR					INT = 4
-------------------------------------------------------------------------------------------------------------------------------------------
DECLARE @debug INT = 0
-- query plan defintion values and add entry to APP_Plan table
DECLARE @currentTime     INT = (SELECT DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE()))
DECLARE @planName        NVARCHAR(510) = (SELECT ISNULL(ref.value('@planName', 'nvarchar(510)'),'') AS name FROM @o_xmlText.nodes('Api_CreatePlanReq/plan/summary/plan') R ( ref ))
DECLARE @basePlanId 	 INT = ISNULL((SELECT ISNULL(ref.value('@planId', 'INT'), 0) AS name FROM @o_xmlText.nodes('Api_CreatePlanReq/plan/summary/parent') R ( ref )), 0)
DECLARE @planDescription NVARCHAR(max) = (SELECT ISNULL(ref.value('@description', 'NVARCHAR(MAX)'),'') AS [description] from  @o_xmlText.nodes('Api_CreatePlanReq/plan/summary') R ( ref ))
DECLARE @planType        INT = (SELECT ref.value('@type', 'INT') AS [type] FROM @o_xmlText.nodes('Api_CreatePlanReq/plan/summary') R ( ref ))
DECLARE @planSubType     INT = (SELECT ref.value('@subtype', 'INT') AS subtype FROM @o_xmlText.nodes('Api_CreatePlanReq/plan/summary') R ( ref ))
DECLARE @planStatus      INT = (SELECT ref.value('@planStatusFlag', 'INT') AS [status] FROM @o_xmlText.nodes('Api_CreatePlanReq/plan/summary') R ( ref ))
DECLARE @errorCode		 INT = 0
DECLARE @errorString	 NVARCHAR(MAX) = NULL
DECLARE @permissionsList NVARCHAR(MAX)
DECLARE @executionErrors TABLE( __type__ INT, errCode INT, errMessage NVARCHAR(510))
DECLARE @continue BIT = 1
DECLARE @rolePlanCreatorId INT = 0
IF @debug != 0 BEGIN
    SELECT 'Plan properties', @planName AS Name, @planDescription AS [Description], @planType AS [Type], @planSubType AS Subtype, @i_classId AS Class, @basePlanId
END
IF LEN(@planName) = 0 OR (@planType IS NULL) OR (@planSubType IS NULL) OR (@i_classId IS NULL) BEGIN
INSERT INTO @executionErrors VALUES (158, -100, 'Incomplete definition.')
    SET @continue = 0
END
IF @continue = 1 BEGIN
    DECLARE @userHasCapability INT = 0
EXEC sec_checkPermissionOnEntity @i_userId, 156, @userHasCapability OUTPUT, 1, 2
    IF (@userHasCapability = 0)  BEGIN
INSERT INTO @executionErrors VALUES (158, 5, 'Access denied. User has no plan creation capabilities.')
        SET @continue = 0
    END
END
-- check if plan is derived one. if so do a basic deriviation check
IF @continue = 1 AND @basePlanId != 0 BEGIN
    -- check base plan existance
	DECLARE @basePlanName NVARCHAR(510) = (SELECT name FROM APP_Plan WHERE id = @basePlanId)
	IF @basePlanName IS NULL BEGIN
INSERT INTO @executionErrors VALUES (158, 2, 'Base plan ' + CAST(@basePlanId AS nvarchar(32)) + ' not found.')
        SET @continue = 0
	END
	-- check users capabilities on base plan
	IF @continue = 1 BEGIN
EXEC sec_checkPermissionOnEntity @i_userId, 157, @userHasCapability OUTPUT, 158, @basePlanId
		IF (@userHasCapability = 0)  BEGIN
INSERT INTO @executionErrors VALUES (158, 5, 'Access denied. User has no edit capabilities on plan ' + CAST(@basePlanId AS nvarchar(32)) + '.')
            SET @continue = 0
		END
	END
    -- check if base plan is top level plan and not derived one
	IF @continue = 1 BEGIN
		IF ISNULL((SELECT attrVal FROM APP_PlanProp WHERE attrType = @constAttrType_BasePlan AND componentNameId = @basePlanId), 0) != 0 BEGIN
INSERT INTO @executionErrors VALUES (158, 13, 'Data is invalid. Plan' + @basePlanName + '(' + CAST(@basePlanId AS nvarchar(32)) + ') is not top level plan.')
            SET @continue = 0
		END
	END
END
DECLARE @planId INT = 0
IF @continue = 1 BEGIN
    BEGIN TRY
        BEGIN TRANSACTION
        -- create main entry
        INSERT INTO APP_Plan (name,      GUID,   [type],    subtype,     [pclass],     ownerId,     created,      modified, origCCId, flag, [description])
        VALUES			     (@planName, NEWID(),@planType, @planSubType, @i_classId, @i_ownerId , @currentTime, 0,        2,        0,    @planDescription)
        SET @planId = SCOPE_IDENTITY()
        IF @debug != 0 BEGIN
            SELECT 'Assigned plan id', @planId
        END
        -- create base plan entry
		IF @basePlanId != 0 BEGIN
			INSERT INTO APP_PlanProp (componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@planId, @constAttrName_BasePlan, @constAttrType_BasePlan, CAST(@basePlanId AS NVARCHAR(32)), @currentTime, 0)
		END
        -- plan modification restrictions
		DECLARE @restrictions BIGINT = ISNULL((SELECT ref.value('@restrictions', 'BIGINT') AS name FROM @o_xmlText.nodes('Api_CreatePlanReq/plan/summary') R ( ref )), 0)
		INSERT INTO APP_PlanProp (componentNameId, attrName, attrType, attrVal, created, modified)
		VALUES (@planId, @constAttrName_Restrictions, @constAttrType_Restrictions, CAST(@restrictions AS NVARCHAR(64)), @currentTime, 0)
        -- create alerts portion
        INSERT INTO APP_PlanProp (componentNameId, attrName, attrType, attrVal, created, modified)
	        SELECT	@planId, @constAttrName_Alert + ' ' + ISNULL(ref.value('@alertId', 'nvarchar(32)'), '0') AS attrName, @constAttrType_Alert, 1, @currentTime, 0
	        FROM	@o_xmlText.nodes('Api_CreatePlanReq/plan/alerts/alerts') R ( ref )
	        WHERE	ISNULL(ref.value('@alertId', 'nvarchar(32)'), '') <> ''
		-- Remove recipient cache for all alerts in request so that they are refreshed again
		Delete from NTNotificationProp
where (attrName = 'Recipient UserId' or attrName='Recipient UserGroupId')
		and componentNameId in
		(
			SELECT	ISNULL(ref.value('@alertId', 'int'), '0') AS alertId
	        	FROM	@o_xmlText.nodes('Api_CreatePlanReq/plan/alerts/alerts') R ( ref )
		)
        -- create features portion
        DECLARE @featureRoleId NVARCHAR(32) = NULL
		IF (@basePlanId = 0) OR (@restrictions & @constPlanEntity_Features = 0)
			-- -- if this is not derived plan or 'Features' are not restricted (should not be inherited)
			SET @featureRoleId = (SELECT ISNULL(ref.value('@roleId', 'int'), '-1') AS roleId FROM @o_xmlText.nodes('Api_CreatePlanReq/plan/laptop/features/role') R ( ref ))
		ELSE
			-- -- this is derived plan and 'features' are restricted. get value from the base plan
			SET @featureRoleId = (SELECT attrVal FROM App_PlanProp WHERE componentNameId = @basePlanId AND attrType = @constAttrType_Feature)
        IF @featureRoleId IS NOT NULL BEGIN
            -- normalize value if necessary
            DECLARE @featureRoleIdNum bigint = CAST(@featureRoleId AS bigint)
            IF @featureRoleIdNum  > 0x7FFFFFFF BEGIN -- @@featureRoleId actually holds role creation error value. convert it back to signed integer to store in prop table
	            SET @featureRoleId = CAST(-(((0xFFFFFFFF - @featureRoleIdNum) + 1)) AS NVARCHAR(32))
            END
            INSERT INTO APP_PlanProp (componentNameId, attrName, attrType, attrVal, created, modified)
            VALUES (@planId, @constAttrName_Feature, @constAttrType_Feature, @featureRoleId, @currentTime, 0)
        END
        -- create access policies portion
		DECLARE @accessPolicyRoleId NVARCHAR(32) = NULL
		IF (@basePlanId = 0) OR (@restrictions & @constPlanEntity_AccessPolicies = 0)
			-- -- if this is not derived plan or 'Access policies' are not restricted (should not be inherited)
			SET @accessPolicyRoleId = (SELECT ISNULL(ref.value('@roleId', 'int'), '-1') AS roleId FROM @o_xmlText.nodes('Api_CreatePlanReq/plan/laptop/accessPolicies/role') R ( ref ))
		ELSE
			-- -- this is derived plan and 'access policies' are restricted. get value from the base plan
			SET @accessPolicyRoleId = (SELECT attrVal FROM App_PlanProp WHERE componentNameId = @basePlanId AND attrType = @constAttrType_AccessPolicy)
        IF @accessPolicyRoleId IS NOT NULL BEGIN
            -- normalize value if necessary
            DECLARE @accessPolicyRoleIdNum bigint = CAST(@accessPolicyRoleId AS BIGINT)
            IF @accessPolicyRoleIdNum  > 0x7FFFFFFF BEGIN -- @accessPolicyRoleIdNum actually holds role creation error value. convert it back to signed integer to store in prop table
	            SET @accessPolicyRoleId = CAST(-(((0xFFFFFFFF - @accessPolicyRoleIdNum) + 1)) AS NVARCHAR(32))
            END
            INSERT INTO APP_PlanProp (componentNameId, attrName, attrType, attrVal, created, modified)
            VALUES (@planId, @constAttrName_AccessPolicy, @constAttrType_AccessPolicy, @accessPolicyRoleId, @currentTime, 0)
        END
        -- create subclient policy entries
		IF (@basePlanId = 0) OR (@restrictions & @constPlanEntity_SubclientPolicy = 0) BEGIN
			-- -- if this is not derived plan or 'Subclient policies' are not restricted (should not be inherited)
			INSERT INTO APP_PlanProp (componentNameId, attrName, attrType, attrVal, created, modified)
				SELECT	@planId, @constAttrName_Policy_Subclient + ' ' + ISNULL(ref.value('(../../@idatype)[1]', 'nvarchar(32)'), '0') AS attrName,
						@constAttrType_Policy_Subclient, ref.value('@backupsetId', 'nvarchar(32)'), @currentTime, 0
				FROM	@o_xmlText.nodes('Api_CreatePlanReq/plan/laptop/content/backupContent/subClientPolicy/backupSetEntity') R ( ref )
				WHERE	ISNULL(ref.value('@backupsetId', 'nvarchar(32)'), '') <> ''
			-- -- set corresponded versions number value
			DECLARE @versionsNum INT = ISNULL((SELECT ref.value('@keepAtLeastPreviousVersions', 'INT') AS name FROM @o_xmlText.nodes('Api_CreatePlanReq/plan/laptop/content/backupContent[1]/subClientPolicy/subClientList/fsSubClientProp') R ( ref )), 5)
            INSERT INTO APP_PlanProp (componentNameId, attrName, attrType, attrVal, created, modified)
            VALUES (@planId, @constAttName_SubclientVersions, @constAttType_SubclientVersions, @versionsNum, @currentTime, 0)
		END ELSE
			-- -- this is derived plan and 'subclient policies' are restricted. get values from the base plan
			INSERT INTO APP_PlanProp (componentNameId, attrName, attrType, attrVal, created, modified)
				SELECT	@planId, attrName, @constAttrType_Policy_Subclient, attrVal, @currentTime, 0
				FROM	APP_PlanProp
				WHERE	componentNameId = @basePlanId AND attrType = @constAttrType_Policy_Subclient
        -- create schedule policy entry
        DECLARE @scheduleId NVARCHAR(32) = NULL
		IF (@basePlanId = 0) OR (@restrictions & @constPlanEntity_SchedulePolicy = 0)
			-- -- if this is not derived plan or 'Schedule policy' is not restricted (should not be inherited)
			SET @scheduleId = (SELECT ref.value('@taskId', 'nvarchar(32)') AS name FROM @o_xmlText.nodes('Api_CreatePlanReq/plan/schedule/task') R ( ref ))
		ELSE
			-- -- this is derived plan and 'Schedule policy' is restricted. get value from the base plan
			SET @scheduleId = (SELECT attrVal FROM App_PlanProp WHERE componentNameId = @basePlanId AND attrType = @constAttrType_Policy_Schedule)
        IF @scheduleId IS NOT NULL BEGIN
            -- normalize value if necessary
            DECLARE @scheduleIdNum bigint = CAST(@scheduleId AS bigint)
            IF @scheduleIdNum  > 0x7FFFFFFF BEGIN -- @scheduleId actually holds schedule creation error value. convert it back to signed integer to store in prop table
	            SET @scheduleId = CAST(-(((0xFFFFFFFF - @scheduleIdNum) + 1)) AS NVARCHAR(32))
            END
            INSERT INTO APP_PlanProp (componentNameId, attrName, attrType, attrVal, created, modified)
            VALUES (@planId, @constAttrName_Policy_Schedule, @constAttrType_Policy_Schedule, @scheduleId, @currentTime, 0)
        END
        -- create storage policy entry
        DECLARE @storageId NVARCHAR(32) = NULL
		IF (@basePlanId = 0) OR (@restrictions & @constPlanEntity_StoragePolicy = 0)
			-- -- if this is not derived plan or 'Storage policy' is not restricted (should not be inherited)
			SET @storageId = (SELECT ref.value('@storagePolicyId', 'nvarchar(32)') AS name FROM @o_xmlText.nodes('Api_CreatePlanReq/plan/storage/storagePolicy') R ( ref ))
		ELSE
			-- -- this is derived plan and 'Storage policy' is restricted. get value from the base plan
			SET @storageId = (SELECT attrVal FROM App_PlanProp WHERE componentNameId = @basePlanId AND attrType = @constAttrType_Policy_Storage)
        IF @storageId IS NOT NULL BEGIN
            -- normalize value if necessary
            DECLARE @storageIdNum bigint = CAST(@storageId AS bigint)
            IF @storageIdNum  > 0x7FFFFFFF BEGIN -- @storageId actually holds storage creation error value. convert it back to signed integer to store in prop table
	            SET @storageId = CAST(-(((0xFFFFFFFF - @storageIdNum) + 1)) AS NVARCHAR(32))
            END
            INSERT INTO APP_PlanProp (componentNameId, attrName, attrType, attrVal, created, modified)
            VALUES (@planId, @constAttrName_Policy_Storage, @constAttrType_Policy_Storage, @storageId, @currentTime, 0)
			-- -- set corresponded retention period value
			DECLARE @retentionPeriod INT = ISNULL((SELECT ref.value('@retainBackupDataForDays', 'INT') AS name FROM @o_xmlText.nodes('Api_CreatePlanReq/plan/storage/copy[1]/retentionRules') R ( ref )),
                                                  (SELECT retentionDays FROM archAgingRule WHERE copyId IN (SELECT defaultCopy FROM archGroup WHERE id = @storageId)))
            INSERT INTO APP_PlanProp (componentNameId, attrName, attrType, attrVal, created, modified)
            VALUES (@planId, @constAttName_SubclientRetention, @constAttType_SubclientRetention, CAST(@retentionPeriod AS nvarchar(32)), @currentTime, 0)
        END
		---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
		-- create and update SLA related fields
        ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
		DECLARE @slaTimeFromPattern int = 0
		DECLARE @policyID INT = 0
		SELECT @policyID = attrVal FROM App_PlanProp WHERE attrType=@constAttrType_Policy_Schedule AND componentNameId = @planId
		DECLARE @slaMinutes NVARCHAR(32) = (SELECT ref.value('@slaInMinutes','nvarchar(32)') FROM @o_xmlText.nodes('Api_CreatePlanReq/plan/summary') R ( ref ))
DECLARE @sTskId INT = (SELECT ST.subTaskId FROM TM_SubTask ST where ST.taskId = @policyID AND ST.flags = CONVERT(INT,0x10000))
		DECLARE @autoIncrPattXML XML = NULL
		DECLARE @hrs INT = 0
		DECLARE @min INT = 0
		IF @planSubType IN (33554437 /*Server*/, 33579013 /*Database*/ , 50331655 /*FSServer*/ , 67108869 /*Snap*/, 83886085 /*VSAServer*/, 83918853 /*VSAReplication*/ )
		BEGIN
			-- For plans with Incremental Schedules
			SELECT @slaTimeFromPattern = CAST(P.freq_subday_interval AS INT) FROM TM_Pattern P
				INNER JOIN TM_PatternAssoc PA WITH(NOLOCK) on P.patternId = PA.patternId
				WHERE PA.subTaskId = @sTskId
			IF @slaMinutes IS NOT NULL
			BEGIN
				INSERT INTO APP_PlanProp (componentNameId, attrName, attrType, attrVal, created, modified)
				VALUES (@planId, @constAttName_SlaInMinutes, @constAttType_SlaInMinutes	, @slaMinutes, @currentTime, 0)
				IF @slaTimeFromPattern/60 <> @slaMinutes
				BEGIN
					UPDATE P SET P.freq_subday_interval = @slaMinutes * 60
					FROM TM_Pattern P
					INNER JOIN TM_PatternAssoc PA WITH(NOLOCK)
						on P.patternId = PA.patternId
					WHERE PA.subTaskId = @sTskId
				END
			END
		END
		IF @planSubType IN ( 33554439/*Laptop*/, 16777223/*DLO*/)
		BEGIN
			-- For plans with Automatic Schedules
			SELECT @autoIncrPattXML = xmlValue FROM TM_SubTaskXMLOptions STXO
				WHERE STXO.subTaskId = @sTskId
			IF @autoIncrPattXML IS NOT NULL
			SELECT @slaTimeFromPattern = CAST(
				(SELECT ref.value('@maxBackupInterval','nvarchar(32)')
					FROM @autoIncrPattXML.nodes('TMMsg_JobOption/commonOpts/automaticSchedulePattern') R (ref)) AS INT ) * 60
				+  CAST((SELECT ref.value('@maxBackupIntervalMinutes','nvarchar(32)')
					FROM @autoIncrPattXML.nodes('TMMsg_JobOption/commonOpts/automaticSchedulePattern') R (ref)) AS INT )
			IF @slaMinutes IS NOT NULL
				INSERT INTO APP_PlanProp (componentNameId, attrName, attrType, attrVal, created, modified)
				VALUES (@planId, @constAttName_SlaInMinutes, @constAttType_SlaInMinutes	, @slaMinutes, @currentTime, 0)
				IF @slaTimeFromPattern <> @slaMinutes
				BEGIN
					SET @hrs = @slaMinutes/60
					SET @min = @slaMinutes % 60
					SET @autoIncrPattXML.modify('replace value of (/TMMsg_JobOption/commonOpts/automaticSchedulePattern/@maxBackupInterval)[1] with sql:variable("@hrs")')
					SET @autoIncrPattXML.modify('replace value of (/TMMsg_JobOption/commonOpts/automaticSchedulePattern/@maxBackupIntervalMinutes)[1] with sql:variable("@min")')
					UPDATE STXO SET STXO.xmlValue = @autoIncrPattXML
					FROM TM_SubTaskXMLOptions STXO
						WHERE STXO.subTaskId = @sTskId
				END
		END
		-- create log schedule policy entry
        DECLARE @logScheduleId NVARCHAR(32) = NULL
		IF (@basePlanId = 0) OR (@restrictions & @constPlanEntity_SchedulePolicyLog = 0)
			-- -- if this is not derived plan or 'Log schedule policy' is not restricted (should not be inherited)
			SET @logScheduleId = (SELECT ref.value('@taskId', 'nvarchar(32)') AS name FROM @o_xmlText.nodes('Api_CreatePlanReq/plan//database/scheduleLog/task') R ( ref ))
		ELSE
			-- -- this is derived plan and 'Log schedule policy' is restricted. get value from the base plan
			SET @logScheduleId = (SELECT attrVal FROM App_PlanProp WHERE componentNameId = @basePlanId AND attrType = @constAttrType_Policy_ScheduleLog)
        IF @logScheduleId IS NOT NULL BEGIN
            -- normalize value if necessary
            DECLARE @logScheduleIdNum bigint = CAST(@logScheduleId AS bigint)
            IF @logScheduleIdNum  > 0x7FFFFFFF BEGIN -- @logScheduleId actually holds log schedule creation error value. convert it back to signed integer to store in prop table
	            SET @logScheduleId = CAST(-(((0xFFFFFFFF - @logScheduleIdNum) + 1)) AS NVARCHAR(32))
            END
            INSERT INTO APP_PlanProp (componentNameId, attrName, attrType, attrVal, created, modified)
				VALUES (@planId, @constAttrName_Policy_ScheduleLog, @constAttrType_Policy_ScheduleLog, @logScheduleId, @currentTime, 0)
        END
        -- create log storage policy entry
        DECLARE @logStorageId NVARCHAR(32) = NULL
		IF (@basePlanId = 0) OR (@restrictions & @constPlanEntity_StoragePolicyLog = 0)
			-- -- if this is not derived plan or 'Log Storage policy' is not restricted (should not be inherited)
			SET @logStorageId = (SELECT ref.value('@storagePolicyId', 'nvarchar(32)') AS name FROM @o_xmlText.nodes('Api_CreatePlanReq/plan/database/storageLog/storagePolicy') R ( ref ))
		ELSE
			-- -- this is derived plan and 'Log storage policy' is restricted. get value from the base plan
			SET @logStorageId = (SELECT attrVal FROM App_PlanProp WHERE componentNameId = @basePlanId AND attrType = @constAttrType_Policy_StorageLog)
        IF @logStorageId IS NOT NULL BEGIN
            -- normalize value if necessary
            DECLARE @logStorageIdNum bigint = CAST(@logStorageId AS bigint)
            IF @logStorageIdNum  > 0x7FFFFFFF BEGIN -- @logStorageId actually holds log storage creation error value. convert it back to signed integer to store in prop table
	            SET @logStorageId = CAST(-(((0xFFFFFFFF - @logStorageIdNum) + 1)) AS NVARCHAR(32))
            END
            INSERT INTO APP_PlanProp (componentNameId, attrName, attrType, attrVal, created, modified)
				VALUES (@planId, @constAttrName_Policy_StorageLog, @constAttrType_Policy_StorageLog, @logStorageId, @currentTime, 0)
        END
		-- Updating Corresponding DB SLA Value
		IF @planSubType = 33579013 -- Database
		BEGIN
			-- For DB plan with LOG Automatic Schedule
				SELECT @policyID = attrVal FROM App_PlanProp WHERE attrType=@constAttrType_Policy_ScheduleLog AND componentNameId = @planId
				SET @slaMinutes = (SELECT ref.value('@slaInMinutes','nvarchar(32)') FROM @o_xmlText.nodes('Api_CreatePlanReq/plan/database') R ( ref ))
SET @sTskId = (SELECT ST.subTaskId FROM TM_SubTask ST where ST.taskId = @policyID AND ST.flags = CONVERT(INT,0x10000))
				IF @slaMinutes IS NOT NULL
					INSERT INTO APP_PlanProp (componentNameId, attrName, attrType, attrVal, created, modified)
						VALUES (@planId, @constAttName_LogSlaInMinutes, @constAttType_LogSlaInMinutes, @slaMinutes, @currentTime, 0)
				SELECT @autoIncrPattXML = xmlValue FROM TM_SubTaskXMLOptions STXO
				WHERE STXO.subTaskId = @sTskId
				IF @autoIncrPattXML IS NOT NULL
				SELECT @slaTimeFromPattern = CAST(
					(SELECT ref.value('@maxBackupInterval','nvarchar(32)')
						FROM @autoIncrPattXML.nodes('TMMsg_JobOption/commonOpts/automaticSchedulePattern') R (ref)) AS INT ) * 60
					+  CAST((SELECT ref.value('@maxBackupIntervalMinutes','nvarchar(32)')
						FROM @autoIncrPattXML.nodes('TMMsg_JobOption/commonOpts/automaticSchedulePattern') R (ref)) AS INT )
				IF @slaTimeFromPattern <> @slaMinutes
				BEGIN
					SET @hrs = @slaMinutes/60
					SET @min = @slaMinutes % 60
					SET @autoIncrPattXML.modify('replace value of (/TMMsg_JobOption/commonOpts/automaticSchedulePattern/@maxBackupInterval)[1] with sql:variable("@hrs")')
					SET @autoIncrPattXML.modify('replace value of (/TMMsg_JobOption/commonOpts/automaticSchedulePattern/@maxBackupIntervalMinutes)[1] with sql:variable("@min")')
					UPDATE STXO SET STXO.xmlValue = @autoIncrPattXML
						FROM TM_SubTaskXMLOptions STXO
							WHERE STXO.subTaskId = @sTskId
				END
		END
        IF @planSubType = 33554439 BEGIN
            -- -- create corresponded client group. make sure that there is no duplicates in client group names
            DECLARE @clientGroupNameTemplate NVARCHAR(1020) = @planName + ' clients'
            DECLARE @clientGroupName NVARCHAR(1020) = @clientGroupNameTemplate
            DECLARE @clientGroupNameCounter INT = 2
            WHILE EXISTS(SELECT * FROM APP_ClientGroup WHERE name = @clientGroupName) BEGIN
	            SET @clientGroupName = @clientGroupNameTemplate + ' (' + CAST(@clientGroupNameCounter AS NVARCHAR(32)) + ')'
	            SET @clientGroupNameCounter += 1
            END
            -- -- create entry in client group table
            INSERT INTO APP_ClientGroup(name, description, flag, status, userId, refTime, modified, origCCid, GUID)
            VALUES(@clientGroupName, @planName + ' associated clients' , 4096, 0, 1 /* @ownerId */, @currentTime, @currentTime, 2, NEWID())
            DECLARE @clientGroupId INT = SCOPE_IDENTITY()
		    -- -- smart client group definition
		    --SCG_PKID_CLIENT_ASSOCIATED_WITH_PLAN=34=prodID
            DECLARE @scgDefintion XML = '<scgRule op="0"><rules><rule op="0"><rules>
                                         <rule filterID="12" propID="' + (SELECT CAST(id AS NVARCHAR(32)) FROM App_SCGProperty WITH(NOLOCK) WHERE name = 'CLIENT_ASSOCIATED_WITH_PLAN')+ '" propType="2" value="' + @planName + '" />
                                         </rules></rule></rules></scgRule>'
		    DECLARE  @scgRule VARCHAR(max)
		    EXEC APPSCGV2GenerateQueryParams @scgDefintion, @errorCode OUTPUT, @errorString OUTPUT, @scgRule OUTPUT
		    INSERT	INTO	App_SCGRule (scgId, ruleXml, ruleQuery, ownerId, created, modified)
				    VALUES	(@clientGroupId, @scgDefintion, @scgRule, @i_ownerId, @currentTime, 0)
      	    -- Setting ownership for smart client group
SET @permissionsList = CAST(1 AS NVARCHAR(10)) + ',' + CAST(2 AS NVARCHAR(10))
EXEC sec_setCreatorForEntity @i_ownerId, 0, @permissionsList, @errorCode OUTPUT, @errorString OUTPUT, 28, @clientGroupId
		    IF @errorCode != 0 BEGIN
INSERT INTO @executionErrors VALUES (28, @errorCode, @errorString)
		    END
			-- We have to provide owner permission on Plan SCG. So that once any laptop get activated by this plan, then all owners of those laptop get that permission set rights via this SCG
			DECLARE @spXML XML
			DECLARE @errorTable TABLE(
                                    errorCode INT,
                                    errorString NVARCHAR(MAX)
                                )
            SET @spXML =(SELECT 2 AS '@associationsOperationType',
							(SELECT
							   (SELECT 1 as '@categoriesPermissionOperationType',
(SELECT 102  as '@categoryId',
121 as '@_type_',
												  'Client' AS '@categoryName'  -- CATEGORY_CLIENT_NAME
										FOR XML PATH ('categoriesPermissionList'),TYPE)
								FOR XML PATH('categoryPermission'), TYPE)
							FOR XML PATH('ownerAssociations'),TYPE)
                    FOR XML PATH('App_SecurityAssociationForEntityList'))
            IF(@spXML IS NOT NULL)
            BEGIN
				INSERT INTO @errorTable
EXEC Sec_setSecurityAssociationsFromEntity @spXML,@i_ownerId,0,1,28,@clientGroupId,0,0,0,0,0,0,0,0
				IF EXISTS(SELECT 1 FROM @errorTable WHERE errorCode<>0)
				BEGIN
					SET @clientGroupId = NULL
					INSERT INTO @executionErrors
SELECT 28, errorCode,errorString FROM @errorTable WHERE errorCode<>0
				END
            END
            -- -- store client group id in the Plan property table.
            INSERT INTO APP_PlanProp (componentNameId, attrName, attrType, attrVal, created, modified)
            VALUES (@planId, @constAttrName_ClientGroupAssigned, @constAttrType_ClientGroupAssigned, CAST(@clientGroupId AS NVARCHAR(32)), @currentTime, 0)
		    IF @debug != 0 BEGIN
			    SELECT 'Plan client group ', @clientGroupId
		    END
		    -- associate client group with the schedule
		    IF (CAST(@scheduleId AS INT) > 0) AND (@planSubtype = 33554439) BEGIN -- only for laptop plans and if schedule is valid
			    INSERT TM_AssocEntity (assocType, taskId, flags, created, clientGroupId, clientId, apptypeId, instanceId, backupsetId, subclientId, policyId, copyId, srmReportSet, srmReportType, exclude, trackingPolicyId, MediaAgentId, agentlessPolicyId, workflowId, sidbStoreId, libraryId, logMonitoringPolicyId)
			    VALUES(28, CAST(@scheduleId AS INT), 0, @currentTime, @clientGroupId, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
		    END
        END
        -- options entry
        -- -- create property table entry
        DECLARE @quota		 NVARCHAR(32) = (SELECT ref.value('@quota', 'nvarchar(32)') AS name FROM @o_xmlText.nodes('Api_CreatePlanReq/plan/options') R ( ref ))
        IF @quota IS NOT NULL BEGIN
            INSERT INTO APP_PlanProp (componentNameId, attrName, attrType, attrVal, created, modified)
            VALUES (@planId, @constAttrName_Options_Quota, @constAttrType_Options, @quota, @currentTime, 0)
        END
		-- Set edge drive quota
        DECLARE @edgeDriveQuota	NVARCHAR(32) = (SELECT TOP 1 ref.value('@edgeDriveQuota', 'nvarchar(32)') AS name FROM @o_xmlText.nodes('Api_CreatePlanReq/plan/options') R ( ref ))
        IF @edgeDriveQuota IS NOT NULL BEGIN
            INSERT INTO APP_PlanProp (componentNameId, attrName, attrType, attrVal, created, modified)
            VALUES (@planId, @constAttrName_Options_EdgeDriveQuota, @constAttrType_Options, @edgeDriveQuota, @currentTime, 0)
        END
		--Saving Default Plan Level Archiving
		IF @planSubType = 33554439 /*Laptop*/
		BEGIN
			DECLARE @forcedArchiving INT = (SELECT ISNULL(ref.value('@forcedArchiving', 'INT'),0) AS name FROM @o_xmlText.nodes('Api_CreatePlanReq/plan/options') R ( ref ))
			INSERT INTO APP_PlanProp (componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@planId, @constAttName_ForcedArchiving, @constAttType_ForcedArchiving, @forcedArchiving , @currentTime, 0)
		END
		-- Save the network throttle values to the throttle table
        IF ISNULL(@clientGroupId, 0) != 0 BEGIN
            DECLARE @networkThrottleEnabled INT = ISNULL((SELECT ref.value('@enableThrottle', 'nvarchar(32)') AS name FROM @o_xmlText.nodes('Api_CreatePlanReq/plan/options/network') R ( ref )),0)
		    IF @networkThrottleEnabled <> 0
		    BEGIN
			    DECLARE @cv_infra_cgid INT = ISNULL((SELECT TOP 1 id FROM App_ClientGroup WHERE flag & 0x80000 = 0x80000),0)
			    IF @cv_infra_cgid != 0 BEGIN
				    INSERT INTO APP_PlanProp (componentNameId, attrName, attrType, attrVal, created, modified)
				    VALUES (@planId, @constAttrName_Options_Throttle, @constAttrType_Options, 1, @currentTime, 0)
				    INSERT INTO APP_NetworkThrottle (clientId,clientGroupId,forClientId,forClientGroupId)
					     VALUES(0,@clientGroupId,0,@cv_infra_cgid)
				    -- Insert throttle options (Assuming shareBandwidth is true)
				    DECLARE @networkTbl TABLE (throttle XML)
				    INSERT INTO @networkTbl
					    SELECT @o_xmlText.query('*/plan/options/network/throttle/throttle')
				    DECLARE @throttleOptions XML = (SELECT '1' as '@shareBandwidth',throttle as [*] from @networkTbl FOR XML PATH ('App_ThrottleScheduleOptionList'))
				    INSERT INTO APP_NetworkThrottleOptions (clientId,clientGroupId,NetworkThrottleOptions)
				    VALUES (0,@clientGroupId,@throttleOptions)
				    -- throttling flag
UPDATE APP_ClientGroup SET flag = flag | 0x0800 WHERE id = @clientGroupId
				    -- Push firewall configuration
				    EXEC AppWorkQueueSubmitRequest 5 -- WORK_TOKEN_NETWORK
				    , 0, 0, 0, @clientGroupId, ''
			    END ELSE BEGIN
				    INSERT INTO APP_PlanProp (componentNameId, attrName, attrType, attrVal, created, modified)
				    VALUES (@planId, @constAttrName_Options_Throttle, @constAttrType_Options, 0, @currentTime, 0)
				    -- reset throttling flag value
				    -- -- first - set it up
UPDATE APP_ClientGroup SET flag = flag | 0x0800 WHERE id = @clientGroupId
				    -- -- second unconditionally remove it
UPDATE APP_ClientGroup SET flag = flag - 0x0800 WHERE id = @clientGroupId
				    INSERT INTO @executionErrors VALUES (154, 184, 'Unable to set client group options. Infastructure client group not found')
			    END
			    IF @debug != 0 BEGIN
				    SELECT 'throttling association', * FROM APP_NetworkThrottle WHERE clientGroupId = @clientGroupId
				    SELECT 'throttling data', * FROM APP_NetworkThrottleOptions WHERE clientGroupId = @clientGroupId
			    END
		    END ELSE BEGIN
			    INSERT INTO APP_PlanProp (componentNameId, attrName, attrType, attrVal, created, modified)
			    VALUES (@planId, @constAttrName_Options_Throttle, @constAttrType_Options, 0, @currentTime, 0)
			    -- reset throttling flag value
			    -- -- first - set it up
UPDATE APP_ClientGroup SET flag = flag | 0x0800 WHERE id = @clientGroupId
			    -- -- second unconditionally remove it
UPDATE APP_ClientGroup SET flag = flag - 0x0800 WHERE id = @clientGroupId
		    END
        END
        IF @planSubType = 33554439 BEGIN
            -- various user groups
            -- -- assigned - i.e created especially for this plan user group
            -- -- create corresponded user group. make sure that there is no duplicates in user group names also add owner to the group
            DECLARE @userGroupNameTemplate NVARCHAR(1020) = @planName + ' users'
            DECLARE @userGroupName NVARCHAR(1020) = @userGroupNameTemplate
            DECLARE @userGroupNameCounter INT = 2
            WHILE EXISTS(SELECT * FROM UMGroups WHERE name = @userGroupName) BEGIN
	            SET @userGroupName = @userGroupNameTemplate + '(' + CAST(@userGroupNameCounter AS NVARCHAR(32)) + ')'
	            SET @userGroupNameCounter += 1
            END
            INSERT INTO UMGroups (groupFlags, allCapabilities, allAssociations, selfAssociation, name, [description], origCCId, [GUID], umdsProviderId, email, lastCredSetTime)
            VALUES( 1, 0, 0, 1, @userGroupName,  N'Contains users associated with ''' + @planName +  N''' plan', 2, NEWID(), 0, '', 0)
            DECLARE @usersGroupId INT = SCOPE_IDENTITY()
		    -- Some settings that need to be set on SCG of Plan
		    INSERT INTO APP_AdvanceSettings([entityId],[keyName],[type],[relativePath],[value],[enabled],[deleted],[entityType],[sourceId],[sourceEntityType])
VALUES(@clientGroupId, 'DefaultUserGroupName', N'STRING', 'Commserve',  @userGroupName, 1, 0, 28, 0, 0)
		    INSERT INTO APP_AdvanceSettings([entityId],[keyName],[type],[relativePath],[value],[enabled],[deleted],[entityType],[sourceId],[sourceEntityType])
VALUES(@clientGroupId, 'sLaptopUserDomain', N'STRING', 'iDataAgent', 'Commcell.Local', 1, 0, 28, 0, 0)
		    --Remove the veiw permission from the group. So the user can only see the that has explicit rights on.
		    DECLARE @roleName nvarchar(50) = 'View'
		    DECLARE @roleId int = (SELECT id FROM UMROles WHERE name = @roleName AND flags & (1 | 2) <> 0)
		    delete	UMSecurityAssociations where isUser=0 and userOrGroupId=@usersGroupId and entityTYpe1 = 15/*USERGROUP_ENTITY*/ and  entityId1 = @usersGroupId and roleId=@roleId
            -- -- insert record that ties group to plan
            INSERT INTO APP_PlanProp (componentNameId, attrName, attrType, attrVal, created, modified)
            VALUES (@planId, @constAttrName_UserGroupAssigned, @constAttrType_UserGroupAssigned, CAST(@usersGroupId AS NVARCHAR(32)), @currentTime, 0)
		    DECLARE @x_xmlGroupResp XML = ''
		    --enum ListOperationType  ADD=2,
		    IF @quota IS NOT NULL AND CAST(@quota AS INT) <> 0
		    BEGIN
			    EXEC dbo.AppPlanUpdateUserGroupProp @i_userId, @i_localeId, @planId, 2, 1, @quota, @usersGroupId, @x_xmlGroupResp OUTPUT
		    END
		    ELSE
		    BEGIN
			    EXEC dbo.AppPlanUpdateUserGroupProp @i_userId, @i_localeId, @planId, 2, 0, 100, @usersGroupId, @x_xmlGroupResp OUTPUT
		    END
		    INSERT INTO @executionErrors SELECT dt.value('@__type', 'INT'), pe.value('@errorCode', 'INT'), pe.value('@errorMessage', 'NVARCHAR(1024)') FROM @x_xmlGroupResp.nodes('Api_PlanComponentErrorList/error') R ( ref )
			    CROSS APPLY ref.nodes('./entity') D(dt)
			    CROSS APPLY ref.nodes('./status') P(pe)
			    WHERE pe.value('@errorCode', 'INT') <> 0
		    -- -- populate / update user group
            -- -- -- owner/creator should not be part of the group -- INSERT INTO UMUserGroup (userId, groupId, flag) VALUES(@i_ownerId, @usersGroupId, 0)
            -- -- -- entries specified in the request
            DECLARE  @userIds AS TABLE (Id INT IDENTITY (1,1), entityId INT, entityName NVARCHAR(510), providerId INT, providerName NVARCHAR(510))
            DECLARE  @id INT
            DECLARE  @entityId INT
            DECLARE  @entityName NVARCHAR(510)
            DECLARE  @providerId INT
            DECLARE  @providerName NVARCHAR(510)
            DECLARE  @userEntityDescription NVARCHAR(510) = NULL
            DECLARE  @currentAssociation INT
            -- -- -- -- users
            SET @userEntityDescription= 'Plan ' + @planName + ' user'
            INSERT INTO @userIds
	            SELECT	ref.value('@userId', 'INT'), ref.value('@userName', 'NVARCHAR(512)'), NULL, NULL
	            FROM	@o_xmlText.nodes('Api_CreatePlanReq/plan/laptop/users/users/user') R ( ref )
            SELECT @id = MIN(Id) FROM @userIds
            WHILE @id IS NOT NULL BEGIN
                SELECT @entityId = entityId, @entityName = entityName FROM @userIds WHERE Id = @id
                IF ISNULL(@entityId, 0) != 0 BEGIN
                    -- get current user association. if user associated with other plan then user cannot be associated with the new plan
                    SELECT @currentAssociation = CAST(attrVal AS INT) FROM UMUsersProp WHERE componentNameId = @entityId AND attrName = @constAttrName_AssociatedPlan AND modified = 0
                    IF @currentAssociation IS NULL BEGIN -- if user is not associated with any plan
                        -- include user into newly created group.
				        -- -- existance check is necessary to avoid duplication that can happen if plan creation XML request
				        -- -- contains multiple entries for the same user
                        IF NOT EXISTS (SELECT userId FROM UMUserGroup WHERE userId = @entityId AND groupId = @usersGroupId) BEGIN
                            INSERT INTO UMUserGroup (userId, groupId, flag) VALUES(@entityId, @usersGroupId, 0)
                        END
                        -- and also set user's property
                        INSERT INTO UMUsersProp(componentNameId, attrName, attrType, attrVal, created, modified)
                        VALUES(@entityId, @constAttrName_AssociatedPlan, @constAttrType_AssociatedPlan, @planId, @currentTime, 0)
                    END ELSE IF @currentAssociation != @planId BEGIN -- user is associated with the plan other then @planId
                        -- From CvEntities.x : EntityType.UserEntity = 13
                        -- Windows system error code ERROR_ALREADY_EXISTS = 183
                        INSERT INTO @executionErrors VALUES (13, 183, 'Unable to associate user ' + @entityName + ' (' + CAST(@entityId AS NVARCHAR(32)) + ') with the plan due to existing association with plan' + CAST(@currentAssociation AS NVARCHAR(32)) )
                    END
                END
                SELECT @id = MIN(Id) FROM @userIds WHERE Id > @id
            END
            -- -- -- -- internal (cc) groups
            SET @userEntityDescription= 'Plan ' + @planName + ' associated user group'
            DELETE FROM @userIds
            INSERT INTO @userIds
	            SELECT	ref.value('@userGroupId', 'INT'), ref.value('@userGroupName', 'NVARCHAR(512)'), NULL, NULL
	            FROM	@o_xmlText.nodes('Api_CreatePlanReq/plan/laptop/users/users/userGroup') R ( ref )
            SELECT @id = MIN(Id) FROM @userIds
            WHILE @id IS NOT NULL BEGIN
                SELECT @entityId = entityId, @entityName = entityName FROM @userIds WHERE Id = @id
                IF ISNULL(@entityId, 0) <> 0 BEGIN
                    -- get current group association. if group associated with other plan then user cannot be associated with the new plan
                    SELECT @currentAssociation = CAST(attrVal AS INT) FROM UMGroupsProp WHERE componentNameId = @entityId AND attrName = @constAttrName_AssociatedPlan AND modified = 0
                    IF @currentAssociation IS NULL BEGIN -- if group is not associated with any plan
                        -- set plan property
                        IF NOT EXISTS (SELECT componentNameId FROM APP_PlanProp  WHERE componentNameId = @planId AND attrType = @constAttrType_UserGroupIAssoc AND CAST(LTRIM(attrVal) AS INT) = @entityId) BEGIN
                            INSERT INTO APP_PlanProp (componentNameId, attrName, attrType, attrVal, created, modified)
                                VALUES (@planId, @constAttrName_UserGroupIAssoc, @constAttrType_UserGroupIAssoc, CAST(@entityId AS NVARCHAR(32)), @currentTime, 0)
                        END
                        -- set user group property
                        INSERT INTO UMGroupsProp(componentNameId, attrName, attrType, attrVal, created, modified)
                        VALUES(@entityId, @constAttrName_AssociatedPlan, @constAttrType_AssociatedPlan, @planId, @currentTime, 0)
                    END ELSE IF @currentAssociation != @planId BEGIN -- group is associated with the plan other then @planId
                        -- From CvEntities.x : EntityType.USERGROUP_ENTITY = 15
                        -- Windows system error code ERROR_ALREADY_EXISTS = 183
                        INSERT INTO @executionErrors VALUES (15, 183, 'Unable to associate group ' + CAST(@entityId AS NVARCHAR(32)) + ' with the plan due to existing association with plan' + CAST(@currentAssociation AS NVARCHAR(32)) )
                    END
			    END
                SELECT @id = MIN(Id) FROM @userIds WHERE Id > @id
            END
            -- -- -- -- external groups
		    SET @userEntityDescription= 'Plan ' + @planName + ' associated external user group'
            DELETE FROM @userIds
            INSERT INTO @userIds
	            SELECT	ref.value('@groupId', 'INT'), ref.value('@externalGroupName', 'NVARCHAR(512)'), ref.value('@providerId', 'INT'), ref.value('@providerDomainName', 'NVARCHAR(512)')
	            FROM	@o_xmlText.nodes('Api_CreatePlanReq/plan/laptop/users/users/externalUserGroup') R ( ref )
            SELECT @id = MIN(Id) FROM @userIds
            WHILE @id IS NOT NULL BEGIN
                SELECT @entityId = entityId, @entityName = entityName, @providerId = providerId, @providerName = providerName FROM @userIds WHERE Id = @id
                IF ISNULL(@entityId, 0) <> 0 BEGIN
                    -- get current external group association. if external group associated with other plan then user cannot be associated with the new plan
                    SELECT @currentAssociation = CAST(attrVal AS INT) FROM UMGroupsProp WHERE componentNameId = @entityId AND attrName = @constAttrName_AssociatedPlan AND modified = 0
                    IF @currentAssociation IS NULL BEGIN -- if external group is not associated with any plan
                        -- set plan property
                        IF NOT EXISTS (SELECT componentNameId FROM APP_PlanProp  WHERE componentNameId = @planId AND attrType = @constAttrType_UserGroupEAssoc AND CAST(LTRIM(attrVal) AS INT) = @entityId) BEGIN
                            INSERT INTO APP_PlanProp (componentNameId, attrName, attrType, attrVal, created, modified)
                                VALUES (@planId, @constAttrName_UserGroupEAssoc, @constAttrType_UserGroupEAssoc, CAST(@entityId AS NVARCHAR(32)), @currentTime, 0)
                        END
                        -- set external user group property
                        INSERT INTO UMGroupsProp(componentNameId, attrName, attrType, attrVal, created, modified)
                        VALUES(@entityId, @constAttrName_AssociatedPlan, @constAttrType_AssociatedPlan, @planId, @currentTime, 0)
                    END ELSE IF @currentAssociation != @planId BEGIN -- external group is associated with the plan other then @planId
                        -- From CvEntities.x : EntityType.EXTERNAL_GROUP_ENTITY = 62
                        -- Windows system error code ERROR_ALREADY_EXISTS = 183
                        INSERT INTO @executionErrors VALUES (62, 183, 'Unable to associate external group ' + CAST(@entityId AS NVARCHAR(32)) + ' with the plan due to existing association with plan' + CAST(@currentAssociation AS NVARCHAR(32)) )
                    END
                END
                SELECT @id = MIN(Id) FROM @userIds WHERE Id > @id
            END
        END
		-- Fill replication target details
		if (@planSubType=83918853) --Live Sync .. Api_VSAReplication
		begin
			Declare @replicationDetails table
			(
				taskId int,
				opType Int
			)
			Insert into @replicationDetails
			SELECT  IsNull(ref.value('@taskId','int'),0),
			@constOpType_ADD
			FROM  @o_xmlText.nodes('Api_CreatePlanReq/plan/replicationTargets/taskInfo/task') R ( ref )
			-- delete from replication details where taskId isnt filled.
			Delete from @replicationDetails
			where taskId<=0
			-- Insert the targets into App_planprop
			INSERT INTO APP_PlanProp (componentNameId, attrName, attrType, attrVal, created, modified)
			 select @planId, @constAttName_ReplicationTargets, @constAttType_ReplicationTargets,  taskId, @currentTime, 0	 -- 7 here is PROPERTY_INTEGER
			 from @replicationDetails
		end
        -- calculate plan status
        -- if request's status is Disabled then use it, calculate actual status (enable or incomplete otherwise
        IF (ISNULL(@planStatus, 0) & 0x1) <> 0x1 BEGIN -- if plan is not disabled
            SET @planStatus = 0 -- will update to 2(incomplete) if one or more of necessary component not set
        END
        IF @planStatus = 0 AND @planSubType & 0x1 = 0x1 BEGIN --  PlanEntities.StoragePolicy
            IF ISNULL((SELECT id FROM App_PlanProp WHERE componentNameId = @planId AND attrType = @constAttrType_Policy_Storage AND CAST(attrVal AS INT) > 0), 0) = 0 BEGIN
                SET @planStatus = @planStatus | 0x2 -- incomplete
            END
        END
        IF @planStatus = 0 AND @planSubType & 0x2 = 0x2 BEGIN --  PlanEntities.SubclientPolicy
            IF ((SELECT COUNT(id) FROM App_PlanProp WHERE componentNameId = @planId AND attrType = @constAttrType_Policy_Subclient AND CAST(attrVal AS INT) > 0) <> 3) BEGIN
                SET @planStatus = @planStatus | 0x2 -- incomplete
            END
        END
        IF @planStatus = 0 AND @planSubType & 0x4 = 0x4 BEGIN --  PlanEntities.SchedulePolicy
            IF ISNULL((SELECT id FROM App_PlanProp WHERE componentNameId = @planId AND attrType = @constAttrType_Policy_Schedule AND CAST(attrVal AS INT) > 0), 0) = 0 BEGIN
                SET @planStatus = @planStatus | 0x2 -- incomplete
            END
        END
        IF @planStatus = 0 AND @planSubType & 0x8000 = 0x8000 BEGIN --  PlanEntities.ReplicationTarget
            IF ISNULL((SELECT top 1 id FROM App_PlanProp WHERE componentNameId = @planId AND attrType = @constAttType_ReplicationTargets AND CAST(attrVal AS INT) > 0), 0) = 0 BEGIN
                SET @planStatus = @planStatus | 0x2 -- incomplete
            END
        END
        -- master and template plans are hidden
        IF @i_classId = 0 OR @i_classId = 1 BEGIN
            SET @planStatus = @planStatus | 0x08 -- HIDE_HIDDEN
        END
        -- update in plan definition table.
        UPDATE App_Plan SET flag = @planStatus WHERE id = @planId
SET @permissionsList = CAST(31 AS NVARCHAR(10)) + ',' + CAST(157 AS NVARCHAR(10)) + ',' + CAST(158 AS NVARCHAR(10)) + ',' + CAST(159 AS NVARCHAR(10))
		set @rolePlanCreatorId = 0
		SET @rolePlanCreatorId =ISNULL((SELECT id
                FROM UMRoles
WHERE name = 'Plan Creator Role' ),0)
		if @rolePlanCreatorId=0
		begin
EXEC sec_setCreatorForEntity @i_ownerId, 0, @permissionsList, @errorCode OUTPUT, @errorString OUTPUT, 158, @planId
		end
		else
		begin
EXEC sec_setCreatorForEntity @i_ownerId,@rolePlanCreatorId , '', @errorCode OUTPUT, @errorString OUTPUT, 158, @planId
		end
		IF @errorCode <> 0 BEGIN
            IF LEN(ISNULL(@errorString, '')) = 0
			    SET @errorString = 'Unable to set creator for the plan.'
            -- other errors do not matter any more.
            DELETE FROM @executionErrors
INSERT INTO @executionErrors VALUES (158, @errorCode, @errorString)
		END
        ELSE
        BEGIN
            -- We are not doing any error handling here as setting up CS should not block Plan from being created in case of failure
            EXEC dbo.AppPlanPrepareCSForACApp @i_userId, @i_localeId, @planId, @planSubType, @x_xmlGroupResp OUTPUT
        END
        -- we are done
        IF @debug <> 0 BEGIN
            SELECT * FROM APP_Plan WHERE id = @planId
            SELECT * FROM APP_PlanProp WHERE componentNameId = @planId
            SELECT * FROM @executionErrors
            ROLLBACK TRANSACTION
        END ELSE IF @errorCode <> 0 BEGIN
            ROLLBACK TRANSACTION
        END ELSE BEGIN
            COMMIT TRANSACTION
        END
    END TRY
    BEGIN CATCH
        ROLLBACK TRANSACTION
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
INSERT INTO @executionErrors VALUES(158, ERROR_NUMBER(), CASE ERROR_NUMBER()
			                                                             WHEN 2601 THEN 'Plan ' + @planName + ' already exists.'
																		 ELSE 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' + Convert(VARCHAR(5), ERROR_LINE()) + ']. ' + ERROR_MESSAGE() END)
	    SET @planId = 0
    END CATCH
END
-- if there were no errors so far then create 'success' entry
IF (SELECT COUNT(__type__) FROM @executionErrors) = 0 BEGIN
INSERT INTO @executionErrors VALUES(158, 0, '')
END
-- build output
SET @o_xmlText =
(
    SELECT
        (SELECT
            (SELECT ER.__type__ AS '@__type__'
             FOR XML PATH('entity'), TYPE),
            (SELECT ER.errCode      AS '@errorCode',
                    ER.errMessage   AS '@errorMessage'
             FOR XML PATH('status'), TYPE)
         FROM @executionErrors AS ER
         FOR XML PATH('error'), TYPE)
    FOR XML PATH('Api_PlanComponentErrorList')
)
RETURN @planId
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanCreate')
	delete from GxQscripts where name = 'AppPlanCreate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanCreate')
	delete from GXDBVersions where aliasname = 'AppPlanCreate'
GO

insert into GXDBVersions values(2, 'AppPlanCreate',  '00010001000200390000', 'AppPlanCreate', '00010001000200390000')
GO

