

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanCheckUpdateSubclientV2.sp] ---------- 

-- MODIFIED FOR (CCP)
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanCheckUpdateSubclientV2.sp,v $ $Id: AppPlanCheckUpdateSubclientV2.sp,v 1.1.2.2 2020/02/06 14:04:31 evolohov Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   AppPlanCheckUpdateSubclientV2   -
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppPlanCheckUpdateSubclientV2')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanCheckUpdateSubclientV2 <<<'
	drop procedure AppPlanCheckUpdateSubclientV2
END
IF EXISTS (select * from GxQscripts where name='AppPlanCheckUpdateSubclientV2')
	delete from GxQscripts where name = 'AppPlanCheckUpdateSubclientV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanCheckUpdateSubclientV2')
	delete from GXDBVersions where aliasname = 'AppPlanCheckUpdateSubclientV2'
GO
print '... Creating Procedure: AppPlanCheckUpdateSubclientV2'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPlanCheckUpdateSubclientV2
  @subclientId INT,
  @component NVARCHAR(510),
  @x_xmlData XML OUTPUT
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @rv INT = 0
DECLARE @debug INT = 0
IF OBJECT_ID('tempdb.dbo.#AppPlanSubclientUpdate_tmp__UsingPlans')   IS NOT NULL DROP TABLE #AppPlanSubclientUpdate_tmp__UsingPlans
IF OBJECT_ID('tempdb.dbo.#AppPlanSubclientUpdate_tmp__DerivedPlans') IS NOT NULL DROP TABLE #AppPlanSubclientUpdate_tmp__DerivedPlans
IF OBJECT_ID('tempdb.dbo.#PlanDetails_PlanProps')                    IS NOT NULL DROP TABLE #PlanDetails_PlanProps
CREATE TABLE #AppPlanSubclientUpdate_tmp__UsingPlans(rowId INT IDENTITY(1,1) PRIMARY KEY, planId INT, subclientType CHAR(1), definingPlanId INT)
CREATE TABLE #AppPlanSubclientUpdate_tmp__DerivedPlans(planId INT PRIMARY KEY, basePlanId INT, subclientType CHAR(1), subclientPolicyId VARCHAR(32))
CREATE TABLE #PlanDetails_PlanProps ( depth INT, componentNameId INT, attrName VARCHAR(512), attrType INT, attrVal VARCHAR(MAX), [entityTypeId] INT, [Status] INT )
    CREATE CLUSTERED INDEX #PlanDetails_PlanProps_attrName_idx ON #PlanDetails_PlanProps(attrName)
-- all plans that have @subclientId as attrVal for 'Subclient policy 2', 'Subclient policy 3', 'Subclient policy 4'
DECLARE @backupSetId AS NVARCHAR(32) = CAST ((SELECT backupSet FROM APP_Application WITH(NOLOCK) WHERE id = @subclientId) AS VARCHAR(32))
INSERT INTO #AppPlanSubclientUpdate_tmp__UsingPlans(planId, subclientType, definingPlanId)
    SELECT  componentNameId,  SUBSTRING(attrName, LEN(attrName), 1), NULL
    FROM    App_PlanProp WITH(NOLOCK)
WHERE       attrName IN ('Subclient policy 2', 'Subclient policy 3', 'Subclient policy 4')
            AND attrVal = @backupSetId
IF @debug = 1 SELECT 'plans with subclient defined in App_PlanProp', * FROM #AppPlanSubclientUpdate_tmp__UsingPlans
-- if subclient policy's corresponded backupset is not attached to any plan then subclient can be modified
SET @rv = IIF(EXISTS(SELECT 1 FROM #AppPlanSubclientUpdate_tmp__UsingPlans), 0, 1);
-- -- declare variables to be used for table iterations
DECLARE @definingPlanId   INT     = NULL
DECLARE @curPlanId        INT     = NULL
DECLARE @subclientType    CHAR(1) = NULL
DECLARE @curSubclientType CHAR(1) = NULL
DECLARE @rowCount         INT     = 0
DECLARE @rowCurrent       INT     = 0
-- value will be used to generate component attribute name. just to be on a safe side remove leading and trailing spaces.
SET @component = LTRIM(RTRIM(@component))
-- if subclient is being used by plans (rv == 0) then in order to figure out if subclient policy's component can be modified it is necessary to check the
-- following  2 cases :
IF @rv = 0 BEGIN -- -- no plans in plans hierarchy define subclient component
    -- -- -- iterate through list of plans using subclient policy
    SET @rowCount = (SELECT MAX(rowId) FROM #AppPlanSubclientUpdate_tmp__UsingPlans)
    SET @rowCurrent = 1
    SET @rv = 1 -- be optimistic. loop below will update this value to 0 (cannot be modified) if it will find component definition
    WHILE (@rowCurrent <= @rowCount)  BEGIN
        SET @curPlanId = NULL; SET @curSubclientType = NULL
        -- get row values
        SELECT @curPlanId = planId, @curSubclientType = subclientType FROM #AppPlanSubclientUpdate_tmp__UsingPlans WHERE rowId = @rowCurrent
        -- if read successfully then get whole list of plan properties and see if it contains component in question
        IF @curPlanId IS NOT NULL BEGIN
            -- clean up whatever left from previous iteration
            TRUNCATE TABLE #PlanDetails_PlanProps
            -- get plan properties
            EXEC AppPlanGetPlanComponentsV2 @curPlanId
            -- get plan that defines component for the @curPlanId
            SET @definingPlanId = (SELECT componentNameId FROM #PlanDetails_PlanProps WHERE attrName = @component + ' ' + @curSubclientType)
            UPDATE #AppPlanSubclientUpdate_tmp__UsingPlans SET definingPlanId = @definingPlanId WHERE planId = @curPlanId
            -- check if it defines subclient component at any level of hierarchy
            SET @rv = IIF(@definingPlanId IS NOT NULL, 0, @rv)
            IF @debug = 1 AND @rv = 0 SELECT 'component defined by plan ' + CAST(@curPlanId AS VARCHAR(32))
        END
        SET @rowCurrent += 1
    END
END
IF @rv = 0 BEGIN -- plan itself defines content component.
                 -- in this case it is also necessary to fetch all derived plans and get list of subclients which inherit content
    -- if there is a plan that uses subclient policy and defines component then modification is possible
    SET @subclientType = (SELECT TOP 1 subclientType FROM #AppPlanSubclientUpdate_tmp__UsingPlans UP WHERE planId = definingPlanId)
    IF @subclientType IS NOT NULL BEGIN
        IF @debug = 1 SELECT 'Plan that uses subclient policy and defines component exists'
        SET @rv = 1
        -- for each plan that uses subclient policy figure out list of derived plans
        SET @rowCurrent = 1
        WHILE (@rowCurrent <= @rowCount) BEGIN
            SET @curPlanId = NULL;  SET @curSubclientType = NULL
            -- get row values
            SELECT @curPlanId = planId, @curSubclientType = subclientType FROM #AppPlanSubclientUpdate_tmp__UsingPlans WHERE rowId = @rowCurrent
            -- if read successfully then get list of derived plans for current plan
            IF @curPlanId IS NOT NULL BEGIN
                ;WITH T(planId, basePlanId, subclientType, subclientPolicyId) AS
                (
                    SELECT  P.id, CAST(PP.attrVal AS INT), @curSubclientType, NULL
FROM    APP_Plan P WITH(NOLOCK) INNER JOIN APP_PlanProp PP WITH(NOLOCK) ON PP.attrName = 'Base plan' AND  attrVal = @curPlanId AND PP.componentNameId = P.id
                    UNION ALL
                    SELECT  PP.componentNameId, T.planId, @curSubclientType, NULL
FROM    APP_PlanProp PP WITH(NOLOCK) INNER JOIN T ON PP.attrVal = CAST(T.planId AS VARCHAR) AND attrName = 'Base plan'
                                                         INNER JOIN APP_Plan P WITH(NOLOCK) ON P.id = PP.componentNameId
                )
                INSERT INTO #AppPlanSubclientUpdate_tmp__DerivedPlans SELECT DISTINCT * FROM T
            END -- @curPlanId IS NOT NULL
            -- next plan to process
            SET @rowCurrent += 1
        END -- WHILE
        -- get subclient policy for associated with each plan
        UPDATE #AppPlanSubclientUpdate_tmp__DerivedPlans SET subclientPolicyId = pp.attrVal
FROM   #AppPlanSubclientUpdate_tmp__DerivedPlans DP INNER JOIN App_PlanProp PP ON PP.componentNameId = DP.planId AND PP.attrName = 'Subclient policy' + ' ' + DP.subclientType
        WHERE -- only those should be included in the list which are not defining their own component
                 NOT EXISTS(SELECT 1 FROM App_PlanProp PPW1  WITH(NOLOCK) WHERE PPW1.componentNameId = DP.planId AND PPW1.attrName = @component + ' ' + DP.subclientType)
              -- or enforced ones
              OR dbo.AppPlanIsEntityInTheListV2((SELECT entityId FROM App_PlanEntity PE  WITH(NOLOCK) WHERE PE.[name] = @component + ' ' + DP.subclientType),
(SELECT attrVal  FROM App_planProp PPW2  WITH(NOLOCK) WHERE PPW2.componentNameId = @definingPlanId AND PPW2.attrName = 'Descendants enforced entities')) = 1
        IF @debug = 1
            SELECT 'list of backupsets to update', * FROM #AppPlanSubclientUpdate_tmp__DerivedPlans
    END --  @definingPlanId IS NOT NULL
END
SET @x_xmlData =
(
    SELECT @rv          AS '@allowed',
           @component   AS '@component',
    (   SELECT DISTINCT 7                AS '@_type_',
                        SC.id            AS '@subclientId',
                        SC.subclientName AS '@subclientName',
                        SC.backupSet     AS '@backupsetId',
                        BS.[name]        AS '@backupsetName',
                        SC.instance      AS '@instanceId',
                        INS.[name]       AS '@instanceName',
                        SC.appTypeId     AS '@applicationId',
                        IDA.[name]       AS '@appName',
                        SC.clientId      AS '@clientId',
                        CL.[name]        AS '@clientName',
                        @subclientType   AS '@tagId'
        FROM APP_Application SC WITH(NOLOCK) INNER JOIN APP_Client        CL  WITH(NOLOCK) ON SC.clientId  = CL.id
                                             INNER JOIN APP_iDAType       IDA WITH(NOLOCK) ON SC.appTypeId = IDA.[type]
                                             INNER JOIN APP_InstanceName  INS WITH(NOLOCK) ON SC.instance  = INS.id
                                             INNER JOIN APP_BackupSetName BS  WITH(NOLOCK) ON SC.backupSet = BS.id
        WHERE SC.id = @subclientId
        FOR XML PATH('subclient'), TYPE),
    (   SELECT id       AS '@planId',
               [name]   AS '@planName',
	           158      AS '@_type_',
	           [type]   AS '@planType',
	           subType  AS '@planSubtype'
        FROM APP_Plan
        WHERE id = @definingPlanId
        FOR XML PATH('plan'), TYPE ),
    (   SELECT DISTINCT 7                AS '@_type_',
                        SC.id            AS '@subclientId',
                        SC.subclientName AS '@subclientName',
                        SC.backupSet     AS '@backupsetId',
                        BS.[name]        AS '@backupsetName',
                        SC.instance      AS '@instanceId',
                        INS.[name]       AS '@instanceName',
                        SC.appTypeId     AS '@applicationId',
                        IDA.[name]       AS '@appName',
                        SC.clientId      AS '@clientId',
                        CL.[name]        AS '@clientName'
        FROM APP_Application SC WITH(NOLOCK) INNER JOIN #AppPlanSubclientUpdate_tmp__DerivedPlans DP ON DP.subclientPolicyId = SC.backupSet
                                                                                                        AND SC.appTypeId = 1030
                                             INNER JOIN APP_Client        CL  WITH(NOLOCK) ON SC.clientId  = CL.id
                                             INNER JOIN APP_iDAType       IDA WITH(NOLOCK) ON SC.appTypeId = IDA.[type]
                                             INNER JOIN APP_InstanceName  INS WITH(NOLOCK) ON SC.instance  = INS.id
                                             INNER JOIN APP_BackupSetName BS  WITH(NOLOCK) ON SC.backupSet = BS.id
        FOR XML PATH('entitesToUpdate'), TYPE)
    FOR XML PATH('Api_PlanComponentUpdateRules')
)
IF OBJECT_ID('tempdb.dbo.#AppPlanSubclientUpdate_tmp__UsingPlans')   IS NOT NULL DROP TABLE #AppPlanSubclientUpdate_tmp__UsingPlans
IF OBJECT_ID('tempdb.dbo.#AppPlanSubclientUpdate_tmp__DerivedPlans') IS NOT NULL DROP TABLE #AppPlanSubclientUpdate_tmp__DerivedPlans
IF OBJECT_ID('tempdb.dbo.#PlanDetails_PlanProps')                    IS NOT NULL DROP TABLE #PlanDetails_PlanProps
SELECT @x_xmlData
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanCheckUpdateSubclientV2')
	delete from GxQscripts where name = 'AppPlanCheckUpdateSubclientV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanCheckUpdateSubclientV2')
	delete from GXDBVersions where aliasname = 'AppPlanCheckUpdateSubclientV2'
GO

insert into GXDBVersions values(2, 'AppPlanCheckUpdateSubclientV2',  '00010001000200020000', 'AppPlanCheckUpdateSubclientV2', '00010001000200020000')
GO

