

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanCalcUpdateStatusV2.sp] ---------- 

-- ALLOW_COMMENTS_BELOW_HERE:
-- ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--
-- Copyright (c) 1998  CommVault Systems, Inc. All rights reserved.
--
--
-- This is unpublished proprietary source code of CommVault Systems, Inc.  The  copyright  notice  above  does  not  evidence any actual or
-- intended publication of such source code.
-- ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanCalcUpdateStatusV2.sp,v $ $Id: AppPlanCalcUpdateStatusV2.sp,v 1.1.2.9 2019/11/19 12:02:17 evolohov Exp $";
-- ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--  Calculates plan status with respect to inheritance and plan sub type defined in Api.x as enum PlanSubtype
--
--      @i_planId   INT             plan id
--
-- ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--  Not designed for direct execution. Expected to be called from AppPlanUpdateV2.
-- BEGIN
-- ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppPlanCalcUpdateStatusV2')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanCalcUpdateStatusV2 <<<'
	drop procedure AppPlanCalcUpdateStatusV2
END
IF EXISTS (select * from GxQscripts where name='AppPlanCalcUpdateStatusV2')
	delete from GxQscripts where name = 'AppPlanCalcUpdateStatusV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanCalcUpdateStatusV2')
	delete from GXDBVersions where aliasname = 'AppPlanCalcUpdateStatusV2'
GO
print '... Creating Procedure: AppPlanCalcUpdateStatusV2'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPlanCalcUpdateStatusV2
  @i_planId INTEGER,
  @i_entities VARCHAR(MAX)
AS
SET NOCOUNT ON
DECLARE @rv     INT = 0
DECLARE @debug  INT = 0
DECLARE @executionUnixTime  INT = (SELECT DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE()))
IF OBJECT_ID('tempdb.dbo.#AppPlanCalcUpdateStatus_tmp__EntityStatus') IS NOT NULL DROP TABLE #AppPlanCalcUpdateStatus_tmp__EntityStatus
IF OBJECT_ID('tempdb.dbo.#PlanDetails_PlanProps')                     IS NOT NULL DROP TABLE #PlanDetails_PlanProps
CREATE TABLE #PlanDetails_PlanProps(depth INT, componentNameId INT, attrName VARCHAR(512), attrType INT, attrVal VARCHAR(MAX), [entityTypeId] INT, [Status] INT, PRIMARY KEY(attrName))
-- entityTypeId is the column for JOIN's
CREATE INDEX PlanProps_entityTypId_idx ON #PlanDetails_PlanProps(entityTypeId)
-- entityId is the column JOIN's, no need for additional index
CREATE TABLE #AppPlanCalcUpdateStatus_tmp__EntityStatus (entityId INT PRIMARY KEY, propertyName VARCHAR(128), idValue VARCHAR(MAX))
-- Note : no need for transaction and or try-catch block. stored procedure expected to be called from AppPlanUpdateV2 sp which wraps this call in transaction.
IF LEN(ISNULL(@i_entities, '')) = 0
SELECT @i_entities = attrVal FROM APP_PlanProp WITH(NOLOCK) WHERE componentNameId = @i_planId AND attrName = 'Defintion entities : required'
INSERT INTO #AppPlanCalcUpdateStatus_tmp__EntityStatus
    SELECT DISTINCT CAST(_ID AS INT), NULL, '0' FROM dbo.SplitIDString(@i_entities)
UPDATE  #AppPlanCalcUpdateStatus_tmp__EntityStatus
SET     propertyName = E.name
FROM    #AppPlanCalcUpdateStatus_tmp__EntityStatus  A INNER JOIN App_PlanEntity E ON A.entityId = E.entityId
IF @debug != 0 SELECT 'required entities', * FROM #AppPlanCalcUpdateStatus_tmp__EntityStatus
-- adjustment : when PLAN_ENTITY__SUBCLIENTPOLICY is set then individual subclient policies should be inserted instead
IF EXISTS(SELECT * FROM #AppPlanCalcUpdateStatus_tmp__EntityStatus WHERE entityId = 2) BEGIN
    -- it could happen that list of required entities contains general subclient policy entity and individual subclient policy entities
    -- delete all of them general one will be replaced by individual ones and individual ones will be reinserted
DELETE FROM #AppPlanCalcUpdateStatus_tmp__EntityStatus WHERE entityId IN( 2, 256, 512, 1024)
    INSERT INTO #AppPlanCalcUpdateStatus_tmp__EntityStatus
VALUES (256, 'Subclient policy 2', 0),
(512, 'Subclient policy 3', 0)
	DECLARE @planSubType INT
	SELECT @planSubType = subType FROM APP_Plan	WHERE id = @i_planId
	IF @planSubType <> 150994951 BEGIN			-- For archiver plans, mac subclient policy is not supported.
		INSERT INTO #AppPlanCalcUpdateStatus_tmp__EntityStatus
VALUES(1024, 'Subclient policy 4', 0)
    END
    IF @debug != 0 SELECT 'adjusted required entities', * FROM #AppPlanCalcUpdateStatus_tmp__EntityStatus
END
EXEC AppPlanGetPlanComponentsV2 @i_planId
IF @debug != 0 SELECT 'plan components', * FROM #PlanDetails_PlanProps
UPDATE #AppPlanCalcUpdateStatus_tmp__EntityStatus SET idValue = PP.attrVal
FROM #AppPlanCalcUpdateStatus_tmp__EntityStatus S INNER JOIN #PlanDetails_PlanProps PP ON PP.entityTypeId = S.entityId AND PP.attrVal != '-32000'
IF @debug != 0 SELECT 'components ids', * FROM #AppPlanCalcUpdateStatus_tmp__EntityStatus
SET @rv = IIF(EXISTS (SELECT 1 FROM #AppPlanCalcUpdateStatus_tmp__EntityStatus WHERE idValue = '0'), 0x2, 0)
UPDATE App_Plan SET flag = (((flag | 0x2) ^ 0x2) | @rv) WHERE id = @i_planId
-- unconditionally remove entry that contains list of plans missing entities. if plan is in 'incomplete' state then updated list of missing entities will be reinserted
DELETE FROM APP_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Defintion entities : missing'
-- if plan is incomplete state
IF @rv != 0 BEGIN
    DECLARE @attrVal VARCHAR(510) = NULL
    SELECT @attrVal = COALESCE(@attrVal + ',', '') + CAST(entityId  AS VARCHAR(32))
        FROM #AppPlanCalcUpdateStatus_tmp__EntityStatus WHERE idValue = '0'
    INSERT INTO APP_PlanProp (componentNameId, attrName, attrType, attrVal, created, modified)
VALUES (@i_planId, 'Defintion entities : missing', 1, @attrVal, @executionUnixTime, 0)
END
IF @debug != 0 BEGIN
    SELECT 'calculated status', @rv
    SELECT * FROM #AppPlanCalcUpdateStatus_tmp__EntityStatus
    SELECT * FROM App_Plan WHERE id = @i_planId
END
DROP TABLE #AppPlanCalcUpdateStatus_tmp__EntityStatus
DROP TABLE #PlanDetails_PlanProps
RETURN @rv
GO
-- ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--  END
-- ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

IF EXISTS (select * from GxQscripts where name = 'AppPlanCalcUpdateStatusV2')
	delete from GxQscripts where name = 'AppPlanCalcUpdateStatusV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanCalcUpdateStatusV2')
	delete from GXDBVersions where aliasname = 'AppPlanCalcUpdateStatusV2'
GO

insert into GXDBVersions values(2, 'AppPlanCalcUpdateStatusV2',  '00010001000200090000', 'AppPlanCalcUpdateStatusV2', '00010001000200090000')
GO

