

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanCalcUpdateStatus.sp] ---------- 

-- ALLOW_COMMENTS_BELOW_HERE:
-- ----------------------------------------------------------------------------------------------------------------------------------------
--
-- Copyright (c) 1998  CommVault Systems, Inc. All rights reserved.
--
--
-- This is unpublished proprietary source code of CommVault Systems, Inc.  The  copyright  notice  above  does  not  evidence any actual or
-- intended publication of such source code.
-- ----------------------------------------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanCalcUpdateStatus.sp,v $ $Id: AppPlanCalcUpdateStatus.sp,v 1.1.2.4 2018/03/27 09:01:30 jiechen Exp $";
-- ----------------------------------------------------------------------------------------------------------------------------------------
--  Calculates plan status with respect to inheritance and plan sub type defined in Api.x as enum PlanSubtype
--
--      @i_planId   INT             plan id
--
-- BEGIN
-- ----------------------------------------------------------------------------------------------------------------------------------------
-- MODIFIED FOR (CCP)
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanCalcUpdateStatus.sp,v $ $Id: AppPlanCalcUpdateStatus.sp,v 1.1.2.4 2018/03/27 09:01:30 jiechen Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   Creates or recreates plan associated client group   - marks existing profile as deleted
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppPlanCalcUpdateStatus <<<'

IF EXISTS (select * from sysobjects where name='AppPlanCalcUpdateStatus')
	drop procedure AppPlanCalcUpdateStatus
IF EXISTS (select * from GxQscripts where name='AppPlanCalcUpdateStatus')
	delete from GxQscripts where name = 'AppPlanCalcUpdateStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanCalcUpdateStatus')
	delete from GXDBVersions where aliasname = 'AppPlanCalcUpdateStatus'
GO
print '... Creating Procedure: AppPlanCalcUpdateStatus'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPlanCalcUpdateStatus
  @i_planId INTEGER,
  @i_entities VARCHAR(MAX)
AS
SET NOCOUNT ON
DECLARE @rv     INT = 0
DECLARE @debug  INT = 0
BEGIN TRY
    BEGIN TRANSACTION
DECLARE @entityStatus AS TABLE(entityId INT PRIMARY KEY, propertyName VARCHAR(128), status INT)
    INSERT INTO @entityStatus
        SELECT DISTINCT CAST(_ID AS INT), NULL, 0 FROM dbo.SplitIDString(@i_entities)
    UPDATE @entityStatus SET propertyName = (SELECT TOP 1 name FROM App_PlanEntity B WHERE B.entityId = A.entityId)
    FROM   @entityStatus  A
    IF @debug != 0 SELECT 'required entities', * FROM @entityStatus
    -- adjustment : when PLAN_ENTITY__SUBCLIENTPOLICY is set then individual subcient policies should be inserted instead
IF EXISTS(SELECT * FROM @entityStatus WHERE entityId = 2) BEGIN
        -- it could happen that list of required entities contains general subclient policy entity and individual subclient policy entities
        -- delete all of them general one will be replaced by individual ones and individual ones will be reinserted
DELETE FROM @entityStatus WHERE entityId IN( 2, 256, 512, 1024)
        INSERT INTO @entityStatus
VALUES (256, 'Subclient policy 2', 0),
(512, 'Subclient policy 3', 0),
(1024, 'Subclient policy 4', 0)
        IF @debug != 0 SELECT 'adjusted required entities', * FROM @entityStatus
    END
    UPDATE @entityStatus SET [status] = CASE WHEN ISNULL(dbo.AppPlanGetEntityValueV2(@i_planId, propertyName, default), 0) != 0 THEN 1 ELSE 0 END
    SET @rv = IIF(EXISTS (SELECT 1 FROM @entityStatus WHERE [status] = 0), 0x2, 0)
    UPDATE App_Plan SET flag = (((flag | 0x2) ^ 0x2) | @rv) WHERE id = @i_planId
    IF @debug != 0 BEGIN
        SELECT 'calculated status', @rv
        SELECT * FROM @entityStatus
        SELECT * FROM App_Plan WHERE id = @i_planId
        ROLLBACK TRANSACTION
    END ELSE BEGIN COMMIT TRANSACTION END
END TRY
BEGIN CATCH
    ROLLBACK TRANSACTION
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
END CATCH
RETURN @rv
GO
-- ----------------------------------------------------------------------------------------------------------------------------------------
--  END
-- ----------------------------------------------------------------------------------------------------------------------------------------

IF EXISTS (select * from GxQscripts where name = 'AppPlanCalcUpdateStatus')
	delete from GxQscripts where name = 'AppPlanCalcUpdateStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanCalcUpdateStatus')
	delete from GXDBVersions where aliasname = 'AppPlanCalcUpdateStatus'
GO

insert into GXDBVersions values(2, 'AppPlanCalcUpdateStatus',  '00010001000200040000', 'AppPlanCalcUpdateStatus', '00010001000200040000')
GO

