

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanCalcUpdateDescendentStatusV2.sp] ---------- 

-- ALLOW_COMMENTS_BELOW_HERE:
-- ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--
-- Copyright (c) 1998  CommVault Systems, Inc. All rights reserved.
--
--
-- This is unpublished proprietary source code of CommVault Systems, Inc.  The  copyright  notice  above  does  not  evidence any actual or
-- intended publication of such source code.
-- ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanCalcUpdateDescendentStatusV2.sp,v $ $Id: AppPlanCalcUpdateDescendentStatusV2.sp,v 1.1.2.1 2018/12/06 22:28:09 evolohov Exp $";
-- ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--  Calculates plan status for all plans derived from the specified
--
--      @i_planId   INT             plan id
--
-- BEGIN
-- ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppPlanCalcUpdateDescendentStatusV2')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanCalcUpdateDescendentStatusV2 <<<'
	drop procedure AppPlanCalcUpdateDescendentStatusV2
END
IF EXISTS (select * from GxQscripts where name='AppPlanCalcUpdateDescendentStatusV2')
	delete from GxQscripts where name = 'AppPlanCalcUpdateDescendentStatusV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanCalcUpdateDescendentStatusV2')
	delete from GXDBVersions where aliasname = 'AppPlanCalcUpdateDescendentStatusV2'
GO
print '... Creating Procedure: AppPlanCalcUpdateDescendentStatusV2'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPlanCalcUpdateDescendentStatusV2
  @i_planId INTEGER
AS
SET NOCOUNT ON
DECLARE @rv     INT = 0
DECLARE @debug  INT = 0
IF OBJECT_ID('tempdb.dbo.#AppPlanCalcUpdateDescStatus_tmp__Plans') IS NOT NULL DROP TABLE #AppPlanCalcUpdateDescStatus_tmp__Plans
CREATE TABLE #AppPlanCalcUpdateDescStatus_tmp__Plans(planId INT PRIMARY KEY, basePlanId INT, planSubType INT)
-- get list of all derived plans
;WITH T(planId, basePlanId, planSubType) AS
(
    SELECT  P.id, CAST(PP.attrVal AS INT), p.subType
    FROM    APP_Plan P WITH(NOLOCK) INNER JOIN APP_PlanProp PP WITH(NOLOCK) ON PP.attrName = 'Base plan' AND  attrVal = @i_planId AND PP.componentNameId = P.id
    UNION ALL
    SELECT  PP.componentNameId, T.planId, P.subType
    FROM    APP_PlanProp PP WITH(NOLOCK) INNER JOIN T ON PP.attrVal = CAST(T.planId AS VARCHAR) AND attrName = 'Base plan'
                                         INNER JOIN APP_Plan P WITH(NOLOCK) ON P.id = PP.componentNameId
)
INSERT INTO #AppPlanCalcUpdateDescStatus_tmp__Plans SELECT DISTINCT * FROM T
IF @debug != 0
    SELECT * FROM #AppPlanCalcUpdateDescStatus_tmp__Plans
DECLARE @planId INT = (SELECT MIN(planId) FROM #AppPlanCalcUpdateDescStatus_tmp__Plans)
WHILE @planId IS NOT NULL BEGIN
    -- calculate and update plan status. AppPlanCalcUpdateStatusV2 will retrieve necessary entities from App_PlanProp table
    EXEC AppPlanCalcUpdateStatusV2 @planId, NULL
    -- next iteration
    SET @planId = (SELECT MIN(planId) FROM #AppPlanCalcUpdateDescStatus_tmp__Plans WHERE planId > @planId)
END
-- number of updated plans
SET @rv = (SELECT COUNT(planId) FROM #AppPlanCalcUpdateDescStatus_tmp__Plans)
IF OBJECT_ID('tempdb.dbo.#AppPlanCalcUpdateDescStatus_tmp__Plans') IS NOT NULL DROP TABLE #AppPlanCalcUpdateDescStatus_tmp__Plans
RETURN @rv
GO
-- ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--  END
-- ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

IF EXISTS (select * from GxQscripts where name = 'AppPlanCalcUpdateDescendentStatusV2')
	delete from GxQscripts where name = 'AppPlanCalcUpdateDescendentStatusV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanCalcUpdateDescendentStatusV2')
	delete from GXDBVersions where aliasname = 'AppPlanCalcUpdateDescendentStatusV2'
GO

insert into GXDBVersions values(2, 'AppPlanCalcUpdateDescendentStatusV2',  '00010001000200010000', 'AppPlanCalcUpdateDescendentStatusV2', '00010001000200010000')
GO

