

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPerformSiteOperation.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Ashish Gupta
--	Date:   16/04/2010
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPerformSiteOperation.sp,v $ $Id: AppPerformSiteOperation.sp,v 1.5.86.1 2018/03/22 01:31:58 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppPerformSiteOperation <<<'

IF EXISTS (select * from sysobjects where name='AppPerformSiteOperation')
	drop procedure AppPerformSiteOperation
IF EXISTS (select * from GxQscripts where name='AppPerformSiteOperation')
	delete from GxQscripts where name = 'AppPerformSiteOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPerformSiteOperation')
	delete from GXDBVersions where aliasname = 'AppPerformSiteOperation'
GO
print '... Creating Procedure: AppPerformSiteOperation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPerformSiteOperation
  @i_xmlText XML
AS
DECLARE @i_ClientId			integer
DECLARE @i_AppTypeId		integer
DECLARE @i_OpCode			integer
DECLARE @i_siteId			integer
DECLARE @i_siteName			NVARCHAR(MAX)
DECLARE @i_siteURL			NVARCHAR(MAX)
DECLARE @i_subClientId		integer
DECLARE @i_modified			integer
DECLARE @xmlObj				XML
DECLARE @ida				integer
DECLARE @oldSubClientId		integer
DECLARE @currentTime		integer
  DECLARE @o_xmlText XML
DECLARE @o_ErrorCode		integer = 0
DECLARE @o_ErrorString		NVARCHAR(MAX) = N'Success'
SET @i_ClientId = ISNULL(( SELECT ref.value('@clientId', 'INT')
			FROM @i_xmlText.nodes('Ida_PerformSiteOperationReq') R ( ref ) ), 0)
SET @i_AppTypeId = ISNULL (( SELECT ref.value('@appTypeId', 'INT')
			FROM @i_xmlText.nodes('Ida_PerformSiteOperationReq') R(ref)), 0)
SET @i_OpCode = ISNULL(( SELECT ref.value('@opCode', 'INT')
			FROM @i_xmlText.nodes('Ida_PerformSiteOperationReq') R ( ref ) ), 0)
SET @i_siteId = ISNULL (( SELECT ref.value('@siteId', 'INT')
			FROM @i_xmlText.nodes('Ida_PerformSiteOperationReq/siteInfo/siteInfo') R(ref)), 0)
SET @i_siteURL = ISNULL (( SELECT ref.value('@url', 'NVARCHAR(MAX)')
			FROM @i_xmlText.nodes('Ida_PerformSiteOperationReq/siteInfo') R(ref)), N'')
SET @i_siteName = ISNULL (( SELECT ref.value('@siteName', 'NVARCHAR(MAX)')
			FROM @i_xmlText.nodes('Ida_PerformSiteOperationReq/siteInfo/siteInfo') R(ref)), N'')
SET @i_modified = ISNULL (( SELECT ref.value('@modified', 'INT')
			FROM @i_xmlText.nodes('Ida_PerformSiteOperationReq/siteInfo/siteInfo') R(ref)), 0)
SET @i_subClientId = ISNULL (( SELECT ref.value('@subclientId', 'INT')
			FROM @i_xmlText.nodes('Ida_PerformSiteOperationReq/siteInfo/siteInfo/subClient') R(ref)), 0)
SET @ida = ISNULL((SELECT id FROM App_IDAName WHERE clientId = @i_ClientId AND appTypeId = @i_AppTypeId), 0)
SET @currentTime = dbo.GetUnixTime(GETUTCDATE())
IF @ida = 0
BEGIN
	SET @o_ErrorCode = 1
	SET @o_ErrorString = N'Invalid clientId and AppTypeId passed.'
	GOTO EXIT_ERROR
END
IF @i_OpCode = 1 -- ADD
BEGIN
	IF EXISTS(SELECT * FROM App_Sites WHERE url = @i_siteURL and idaId = @ida)
	BEGIN
		SET @o_ErrorCode = 2
		SET @o_ErrorString = N'Site already exists.'
		GOTO EXIT_ERROR
	END
	INSERT INTO App_Sites (name, url, properties, subClientId, idaId, created, modified)
	VALUES (@i_siteName, @i_siteURL, @i_xmlText, @i_subClientId, @ida, @currentTime, @currentTime)
	SET @i_siteId = ISNULL((SELECT id FROM App_Sites WHERE url = @i_siteURL and idaId = @ida), 0)
	INSERT INTO App_ScFilterFile (componentNameId, type, fileName, created, modified, ccpId)
	VALUES(@i_subClientId, 1, @i_siteURL, @currentTime, 0, 0)
END
ELSE IF @i_OpCode = 2 -- MODIFY
BEGIN
	IF NOT EXISTS (SELECT * FROM App_Sites WHERE id = @i_siteId)
	BEGIN
		SET @o_ErrorCode = 3
		SET @o_ErrorString = N'Site information does not exists'
		GOTO EXIT_ERROR
	END
	IF @i_modified < (SELECT modified FROM App_Sites WHERE id = @i_siteId)
	BEGIN
		SET @o_ErrorCode = 4
		SET @o_ErrorString = N'Site information is stale, please update site information'
		GOTO EXIT_ERROR
	END
	SET @oldSubClientId = ISNULL((SELECT subClientId FROM App_Sites WHERE id = @i_siteId), 0)
	IF @oldSubClientId <> @i_subClientId
	BEGIN
		UPDATE App_ScFilterFile SET modified = @currentTime
		WHERE componentNameId = @oldSubClientId AND fileName = @i_siteURL
		INSERT INTO App_ScFilterFile (componentNameId, type, fileName, created, modified, ccpId)
		VALUES(@i_subClientId, 1, @i_siteURL, @currentTime, 0, 0)
	END
	UPDATE App_Sites SET
		name = @i_siteName,
		properties = @i_xmlText,
		subClientId = @i_subClientId,
		modified = @currentTime
	WHERE id = @i_siteId
END
ELSE
BEGIN
	SET @o_ErrorCode = 5
	SET @o_ErrorString = N'Invalid operation type.'
	GOTO EXIT_ERROR
END
SET @o_xmlText = (
	SELECT
		S.url 'siteInfo/@url',
		S.id 'siteInfo/siteInfo/@siteId',
		S.name 'siteInfo/siteInfo/@siteName',
		S.subClientId 'siteInfo/siteInfo/subClient/@subClientId',
		A.subClientName 'siteInfo/siteInfo/subClient/@subClientName'
	FROM App_Sites S INNER JOIN App_Application A ON S.subClientId = A.id
	WHERE S.idaId = @ida
	FOR XML PATH(''), ROOT('Ida_PerformSiteOperationResp')
)
SELECT @o_xmlText
EXIT_ERROR:
IF @o_errorCode <> 0
BEGIN
	SELECT	1					as TAG,
		0						as Parent,
		@o_errorCode			as [CVGui_GenericResp!1!errorCode],
		@o_errorString			as [CVGui_GenericResp!1!errorMessage]
	FOR XML EXPLICIT
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'AppPerformSiteOperation')
	delete from GxQscripts where name = 'AppPerformSiteOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPerformSiteOperation')
	delete from GXDBVersions where aliasname = 'AppPerformSiteOperation'
GO

insert into GXDBVersions values(2, 'AppPerformSiteOperation',  '00010005008600010000', 'AppPerformSiteOperation', '00010005008600010000')
GO

