

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppOneDriveAllUsersAssocGetInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  				AppOneDriveAllUsersAssocGetInfo						|
--	|		Returns all associated users for OneDrive V1 clients		|
--	+===================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppOneDriveAllUsersAssocGetInfo')
BEGIN
	print '>>> Drop Stored Procedure: AppOneDriveAllUsersAssocGetInfo <<<'
	drop procedure AppOneDriveAllUsersAssocGetInfo
END
IF EXISTS (select * from GxQscripts where name='AppOneDriveAllUsersAssocGetInfo')
	delete from GxQscripts where name = 'AppOneDriveAllUsersAssocGetInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppOneDriveAllUsersAssocGetInfo')
	delete from GXDBVersions where aliasname = 'AppOneDriveAllUsersAssocGetInfo'
GO
print '... Creating Procedure: AppOneDriveAllUsersAssocGetInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppOneDriveAllUsersAssocGetInfo
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
	DECLARE @o_xmlString			XML = NULL
	DECLARE	@errorCode				INT = 0
	DECLARE @userId					INT = 0
	DECLARE @errorString			NVARCHAR(MAX) = ''
	DECLARE @nowTime				INT = datediff(second,'01/01/1970',GETDATE())
	DECLARE @ClientId				INT = 0
	DECLARE @appType				INT = 0
	DECLARE @isCommcellLevelAssociation INT = 0
	DECLARE @pageSz INT = 0
	DECLARE @pageNo	INT = 0
	DECLARE @search	INT = 0
	DECLARE @searchKey NVARCHAR(MAX) = ''
	DECLARE @filterColumn 					INT = 0
	DECLARE	@filterString 						NVARCHAR(40) = ''
	DECLARE @SortColumn						INT = 0
	DECLARE @SortOrder 						INT  = 0
	DECLARE @Quota						nvarchar(20) = '%::oq%'
	DECLARE @autoDiscovered				nvarchar(20) = '%::1%'
	DECLARE @QuotaDisabledStr			nvarchar(20) = '%::nq%'
	DECLARE @isQuotaDisabled		INT = 0
	--DECLARE @maxBigInt				BIGINT = 9223372036854775807
	DECLARE @DISCOVERTYPE_USER													INT = 1
	DECLARE @DISCOVERTYPE_GROUPS												INT = 2
	DECLARE @DISCOVERTYPE_BROWSE_FOLDERS										INT = 3
	DECLARE @DISCOVERTYPE_ALL_USERS												INT = 4
	DECLARE @DISCOVERTYPE_AUTO_DISCOVER_ASSOCIATIONS							INT = 5
	DECLARE @O365Field_DISPLAYNAME INT = 1
	DECLARE @O365Field_AUTO_DISCOVER  INT = 9
	DECLARE @O365Field_ONEDRIVE_QUOTA INT = 10
	DECLARE @O365Field_SMTP_ADDRESS INT = 12
	DECLARE @O365Field_SUBCLIENT_NAME INT = 18
	DECLARE @oneDriveQuotaFilter INT = -1
	DECLARE @INSUFFICIENT_PERMISSIONS	INT = 111
	SELECT	@userId = ISNULL(ref.value('processinginstructioninfo[1]/user[1]/@userId','INT'),0),
			@ClientId = ISNULL(ref.value('subclientEntity[1]/@clientId','INT'),0),
			@appType = ISNULL(ref.value('subclientEntity[1]/@applicationId','INT'),0),
			@pageNo = ISNULL(ref.value('pagingInfo[1]/@pageNumber', 'INTEGER'),0),
			@pageSz = ISNULL(ref.value('pagingInfo[1]/@pageSize', 'INTEGER'),0),
			@search = ISNULL(ref.value('searchInfo[1]/@isSearch', 'INTEGER'),0),
			@SortColumn = ISNULL(ref.value('sortInfo[1]/@sortColumn', 'INTEGER'),0),
			@SortOrder = ISNULL(ref.value('sortInfo[1]/@sortOrder', 'INTEGER'),0),
			@searchKey = ISNULL(ref.value('searchInfo[1]/@searchKey','NVARCHAR(max)'), '')
			FROM @i_xmlString.nodes ('Ida_GetOneDriveAllUsersReq') R(ref)
	IF @pageNo < 0  SET @pageNo = 0 --default page number is 0
	IF @pageSz <= 0 SET @pageSz = 0 -- default no paging
	--Prepare FIlter list table
	DECLARE @filtertbl TABLE (filter xml)
	DECLARE @filterlisttbl TABLE (fCol nvarchar(max), fStr nvarchar(max), rangeMin BIGINT, rangeMax BIGINT)
	INSERT INTO @filtertbl SELECT R.ref.query('.') AS filter
	FROM @i_xmlString.nodes ('Ida_GetOneDriveAllUsersReq/filterInfoList') R(ref)
	INSERT INTO @filterlisttbl SELECT DISTINCT
		filter.value ('filterInfoList[1]/@filterColumn', 'INT') AS fCol ,
		filter.value('filterInfoList[1]/@filterString', 'nvarchar(max)') AS fStr,
		filter.value ('filterInfoList[1]/@filterRangeMin', 'BIGINT') AS rangeMin ,
		filter.value('filterInfoList[1]/@filterRangeMax', 'BIGINT') AS rangeMax
    FROM @filtertbl
	IF EXISTS (SELECT TOP 1 1 FROM @filterlisttbl) set @filterColumn = 1
	SET @filterString = ISNULL((select fStr from @filterlisttbl WHERE fCOl = @O365Field_ONEDRIVE_QUOTA), '')
	IF @filterString  = @QuotaDisabledStr	SET @isQuotaDisabled = 1
	IF @search = 1 AND @searchKey = ''
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error : Invalid Search key'
	END
	IF object_id('tempdb.dbo.#subClientTable') IS NOT NULL
        DROP TABLE #subClientTable
	CREATE TABLE #subClientTable
       (id INT IDENTITY(1,1), subclientId INT)
	CREATE UNIQUE CLUSTERED INDEX subClientTable_subclientId_Index1 ON #subClientTable ([subclientId])
	IF OBJECT_ID('tempdb.dbo.#tempSecurityObjects') IS NOT Null DROP TABLE #tempSecurityObjects
create table  #tempSecurityObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @userId, 2013, 0, '#tempSecurityObjects'
SELECT @isCommcellLevelAssociation=1 from #tempSecurityObjects sec WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0)
	IF NOT EXISTS (SELECT TOP 1 clientId FROm #tempSecurityObjects where clientId = @clientId) AND @isCommcellLevelAssociation = 0
	BEGIN
			SET @errorCode = @INSUFFICIENT_PERMISSIONS
			SET @errorString = 'Error : User does not have required permission to perform this operation'
			GOTO ERROR_EXIT
	END
	INSERT INTO #subClientTable (subclientId) SELECT FR.id
	FROM ( SELECT id FROM APP_Application (NOLOCK)
			where clientId = @ClientId AND appTypeId = @appType
AND (subclientStatus & 0x00002) != 0x00002
AND (subclientStatus & 0x00004) != 0x00004
AND (subclientStatus & 0x00020) != 0x00020)FR
	IF @isCommcellLevelAssociation <>1 AND NOT EXISTS(SELECT * FROM #tempSecurityObjects WHERE clientId = @ClientId AND subClientId = 0)
	BEGIN
			DELETE FROM #subClientTable WHERE subclientId NOT IN (SELECT subclientId FROM #tempSecurityObjects WHERE clientId = @ClientId)
	END
    BEGIN
    SET @o_xmlString =
        (
            SELECT @DISCOVERTYPE_USER '@discoverByType',
            (
                SELECT CA.displayName '@displayName', CA.smtpAddress '@smtpAddress',
                CASE WHEN CA.displayName LIKE @Quota THEN 1 ELSE 0 END AS '@hasOneDriveQuota',
                CASE WHEN CA.displayName LIKE @autoDiscovered THEN 1 ELSE 0 END AS '@isAutoDiscoveredUser',
				ISNULL(CA.userSize, 0) AS '@accountSize',
				ISNULL(CA.numberOfItems, 0) AS '@numberOfItems',
				(SELECT CA.idxCollectionTime AS '@time'  FOR XML PATH ('IdxCollectionTime'), TYPE ),
				(SELECT CA.backupRefTime AS '@time'  FOR XML PATH ('lastBackupJobRanTime'), TYPE )
                FOR XML PATH('userAccountInfo'), TYPE
            ),
            (
                SELECT CA.subclientId '@subclientId', CA.subclientName '@subclientName'
                FOR XML PATH ('subclientEntity') , TYPE
            ),
            ( SELECT CA.TotalRows as '@totalRecords' FOR XML PATH ('pagingInfo'), TYPE )
            FROM
            (
                SELECT * , ROW_NUMBER() OVER ( ORDER BY CASE WHEN @SortColumn = @O365Field_DISPLAYNAME AND @SortOrder = 1 THEN displayName END DESC,
                            CASE WHEN @SortColumn = @O365Field_DISPLAYNAME AND @SortOrder = 0 THEN displayName END ,
                            CASE WHEN @SortColumn = @O365Field_SMTP_ADDRESS AND @SortOrder = 1 THEN smtpAddress END DESC,
                            CASE WHEN @SortColumn = @O365Field_SMTP_ADDRESS AND @SortOrder = 0 THEN smtpAddress END ,
                            CASE WHEN @SortColumn = @O365Field_SUBCLIENT_NAME AND @SortOrder = 1 THEN subclientName END DESC,
                            CASE WHEN @SortColumn = @O365Field_SUBCLIENT_NAME AND @SortOrder = 0  THEN subclientName END ) AS RowNum  FROM
                (
                    SELECT   SP.attrName as smtpAddress,SP.attrVal as displayName, SP.componentNameId as subclientId, AA.subclientName as subclientName,
					AC.userAccountSize AS userSize, AC.backupReferenceTime AS backupRefTime, AC.numberOfItems AS numberOfItems, AC.IdxCollectionTime AS idxCollectionTime,
					COUNT(SP.componentNameId) OVER (PARTITION BY 1) as TotalRows
                    FROM APP_SubClientProp (NOLOCK) SP
                    JOIN #subClientTable TS ON TS.subclientId = SP.componentNameId
                    JOIN APP_Application (NOLOCK) AA ON AA.id = TS.subclientId
					LEFT JOIN APP_CloudAppUserDetails (NOLOCK) AC ON AC.subclientId = AA.id AND AC.smtpAddress = (CASE WHEN SP.attrName LIKE '%;%' THEN SUBSTRING(SP.attrName, 0, CHARINDEX(';', SP.attrName)) ELSE SP.attrName END)
                    WHERE SP.attrType = @appType AND SP.modified = 0
                    AND ((@search = 0) OR (SP.attrName LIKE (  CASE WHEN LEN(@searchKey) > 0  THEN   @searchKey ELSE '%%' END )))
                    AND ( (@filterColumn = 0 )
                    OR ((  SP.attrVal LIKE ISNULL((select fStr from @filterlisttbl WHERE fCOl = @O365Field_DISPLAYNAME),  '%%' ))
                    AND ( (@isQuotaDisabled = 0 AND SP.attrVal  LIKE @Quota) OR (@isQuotaDisabled = 1 AND SP.attrVal  NOT LIKE @Quota))
                    AND (  SP.attrVal LIKE ISNULL((select fStr from @filterlisttbl WHERE fCOl = @O365Field_AUTO_DISCOVER),  '%%' ))
                    AND (  SP.attrName LIKE ISNULL((select fStr from @filterlisttbl WHERE fCOl = @O365Field_SMTP_ADDRESS) , '%%' ))
                    AND (  (SP.componentNameId IN ( select CONVERT(INTEGER, fStr) from @filterlisttbl WHERE fCOl = @O365Field_SUBCLIENT_NAME))  OR  (@O365Field_SUBCLIENT_NAME NOT IN (select fCol from @filterlisttbl) AND (@filterColumn > 0) ))
                    ))
                ) P
            )CA
            WHERE (@pageSz = 0) OR   ((RowNum > (@pageNo * @pageSz))  AND  (RowNum <= ((@pageNo * @pageSz)+ @pageSz)))
            FOR XML PATH('userAssoc'),
            ROOT('Ida_GetOneDriveAllUsersResp')
    )
    END
ERROR_EXIT:
	IF @o_xmlString IS NULL
	BEGIN
	SET @o_xmlString =
		(
			SELECT
				(
					SELECT @errorCode '@errorCode', @errorString '@errorString'
					FOR XML PATH('resp'), Type
				)
				FOR XML PATH('Ida_GetOneDriveAllUsersResp')
		)
	END
	SELECT @o_xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppOneDriveAllUsersAssocGetInfo')
	delete from GxQscripts where name = 'AppOneDriveAllUsersAssocGetInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppOneDriveAllUsersAssocGetInfo')
	delete from GXDBVersions where aliasname = 'AppOneDriveAllUsersAssocGetInfo'
GO

insert into GXDBVersions values(2, 'AppOneDriveAllUsersAssocGetInfo',  '00000000000000000000', 'AppOneDriveAllUsersAssocGetInfo', '00000000000000000000')
GO

