

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppOffice365ClientOverview.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2018  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppOffice365ClientOverview')
BEGIN
	print '>>> Drop Stored Procedure: AppOffice365ClientOverview <<<'
	drop procedure AppOffice365ClientOverview
END
IF EXISTS (select * from GxQscripts where name='AppOffice365ClientOverview')
	delete from GxQscripts where name = 'AppOffice365ClientOverview'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppOffice365ClientOverview')
	delete from GXDBVersions where aliasname = 'AppOffice365ClientOverview'
GO
print '... Creating Procedure: AppOffice365ClientOverview'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppOffice365ClientOverview
  @i_backupsetId INT,
  @i_userId INT,
  @i_mode INT,
  @o_xmlString XML OUTPUT
AS
SET NOCOUNT ON;
BEGIN
	-- AppTypes
	DECLARE @CV_APPTYPE_EXCHANGE_ONEPASS INT = 137
	DECLARE @CV_APPTYPE_CLOUD_APPS INT = 134
	DECLARE @CV_APPTYPE_SHAREPOINT INT = 78
	-- V2 CloudApp Instance Types
	DECLARE @ONEDRIVE_INSTANCE	INT = 7
	DECLARE @D365_INSTANCE		INT = 35
	DECLARE @TEAMS_INSTANCE		INT = 36
	-- Discover By Type
    DECLARE @DISCOVERTYPE_USER                              INT = 1
    DECLARE @DISCOVERTYPE_ASSOCIATED_SHAREPOINT_WEB_SITES   INT = 6
    DECLARE @DISCOVERTYPE_TEAM                              INT = 12
    DECLARE @DISCOVERTYE_DYNAMICS_365_ENTITY				INT = 14
	DECLARE @errorCode INT = 0
	DECLARE @errorString NVARCHAR(1024) = ''
	DECLARE @INSUFFICIENT_PERMISSIONS	INT = 111
	DECLARE @hasPermission INT = 0
	DECLARE @clientId INT
	DECLARE @appType INT
	DECLARE @isOffice365V2Client INT
	DECLARE @instanceId INT
	DECLARE @subclientId INT
	DECLARE @listSubclientId TABLE(subclientId INT)
	DECLARE @numberOfUsers BIGINT = 0
	DECLARE @dbStatXML XML = NULL
	DECLARE @discoverStateXML XML = NULL
	DECLARE @isModernAuthEnabled INT = 0
	DECLARE @instanceType INT
	SET @i_backupsetId = ISNULL(@i_backupsetId, 0)   -- Set 0 if null
		IF @i_backupSetId <= 0
		BEGIN
			SET @errorCode = 1
			SET @errorString = 'Error: Invalid backupset id [' + CAST(@i_backupSetId AS VARCHAR(16)) + ']'
			GOTO ERROR_EXIT
		END
	SET @i_userId = ISNULL(@i_userId, 0)   -- Set 0 if null
	IF @i_userId <= 0
	BEGIN
		SET @errorCode = 2
		SET @errorString = 'Error: Invalid user id [' + CAST(@i_userId AS VARCHAR(16)) + ']'
		GOTO ERROR_EXIT
	END
	SET @appType = (SELECT TOP 1 appTypeId FROM App_Application (NOLOCK) where backupset = @i_backupSetId)
	SET @ClientId = (SELECT TOP 1 clientId FROM App_Application (NOLOCK) where backupset = @i_backupSetId)
	SET @instanceId = (SELECT TOP 1 instance FROM App_Application (NOLOCK) where backupset = @i_backupSetId)
	SET @subclientId = (SELECT TOP 1 id FROM App_Application (NOLOCK) where backupset = @i_backupSetId)
EXEC sec_checkPermissionOnEntity @i_userId, 0, @hasPermission OUTPUT, 3, @ClientId, 4, @appType, 5, @instanceId, 6, @i_backupsetId, 7,@subclientId
	IF @hasPermission <> 1
	BEGIN
			SET @errorCode = @INSUFFICIENT_PERMISSIONS
			SET @errorString = 'Error : User does not have required permission to perform this operation'
			GOTO ERROR_EXIT
	END
	BEGIN TRY
		-- set required variables
		INSERT INTO @listSubclientId(subclientId)
		(
			SELECT id FROM APP_Application(NOLOCK) WHERE backupSet = @i_backupsetId
			AND subclientStatus & 0x02 != 0x02 /*UNINSTALLED*/ AND subclientStatus & 0x04 != 0x04 /*DELETED*/ AND subclientStatus & 0x00020 != 0x00020 /*HIDDEN*/
		)
		IF NOT EXISTS (SELECT TOP 1 subclientId FROM @listSubclientId)
			BEGIN
				SET @errorCode = 1
				SET @errorString = 'Error: Active subclients not found for backupset id [' + CAST(@i_backupSetId AS VARCHAR(16)) + ']'
				GOTO ERROR_EXIT
			END
		IF @i_mode = 1
		BEGIN
			DECLARE @associatedConnectionsXML XML = ''
			DECLARE @associatedConnectionsCount INT = 0
			DECLARE @maxUsersForFiveConnections INT = 0
			IF @appType = @CV_APPTYPE_CLOUD_APPS
			BEGIN
				SET @isModernAuthEnabled = 1
				SET @instanceType =  ISNULL((SELECT attrVal FROM APP_InstanceProp(NOLOCK)
                                    WHERE componentNameId = @instanceId and attrName = 'Cloud Apps Instance Type' AND modified = 0), 0)
				SET @maxUsersForFiveConnections = 5000
				SET @associatedConnectionsXML = CAST(REPLACE ((SELECT TOP 1 attrVal FROM APP_InstanceProp(NOLOCK) WHERE componentNameId = @instanceId AND attrName IN ('OneDrive Azure Connections', 'V2CloudApps Azure Connections') AND modified = 0),'encoding="UTF-8"', 'encoding="UTF-16"') AS XML)
				SET @associatedConnectionsCount = @associatedConnectionsXML.value('count(/App_Office365AzureConnections/azureApps)', 'int')
				/*Counting only active entities for mode 1*/
				SET @numberOfUsers = (SELECT COUNT(DISTINCT cuser.smtpAddress) FROM APP_CloudAppUserDetails(NOLOCK) cuser
									WHERE cuser.subClientId IN (SELECT subclientId FROM @listSubclientId)
									AND cuser.modified = 0 AND status = 0/*Active*/ AND cuser.discoverByType = (CASE @instanceType
																													WHEN @ONEDRIVE_INSTANCE THEN @DISCOVERTYPE_USER
																													WHEN @TEAMS_INSTANCE THEN @DISCOVERTYPE_TEAM
																													WHEN @D365_INSTANCE THEN @DISCOVERTYE_DYNAMICS_365_ENTITY
																												END))
			END
			ELSE IF @appType = @CV_APPTYPE_EXCHANGE_ONEPASS
			BEGIN
				SET @maxUsersForFiveConnections = 2500
				SET @isModernAuthEnabled = (SELECT attrVal FROM APP_IDAProp(NOLOCK) WHERE attrName = 'Exchange Modern Auth' AND modified = 0
											AND componentNameId IN (SELECT id FROM APP_IDAName(NOLOCK) WHERE clientId = @clientId))
				IF @isModernAuthEnabled = 1
				BEGIN
					SET @associatedConnectionsXML = CAST(REPLACE ((SELECT TOP 1 attrVal FROM App_IdaProp(NOLOCK) WHERE componentNameId IN (SELECT id FROM App_IdaName(NOLOCK) WHERE clientId = @clientId) AND attrName = 'Exchange Azure Connections' AND modified = 0),'encoding="UTF-8"', 'encoding="UTF-16"') AS XML)
					SET @associatedConnectionsCount = @associatedConnectionsXML.value('count(/App_Office365AzureConnections/azureApps)', 'int')
				END
				ELSE
				BEGIN
					SET @associatedConnectionsXML = CAST(REPLACE ((SELECT TOP 1 attrVal FROM App_IdaProp(NOLOCK) WHERE componentNameId IN (SELECT id FROM App_IdaName(NOLOCK) WHERE clientId = @clientId) AND attrName = 'Exchange OnePass Admin Accounts' AND modified = 0),'encoding="UTF-8"', 'encoding="UTF-16"') AS XML)
					/*Count only service accounts*/
					SET @associatedConnectionsCount = (SELECT COUNT(*) FROM @associatedConnectionsXML.nodes('/App_ExchangeAdminAccounts/adminAccounts') E(a) WHERE E.a.value('@serviceType', 'int') = 2)
				END
				/*Counting only active users for mode 1*/
				SET @numberOfUsers = (SELECT COUNT(assocId) FROM APP_EmailConfigPolicyAssoc(NOLOCK)
                                    WHERE backupsetId = @i_backupsetId AND mailBoxType IN (1, 2, 3) AND modified = 0 AND status = 0)
			END
			ELSE IF @appType = @CV_APPTYPE_SHAREPOINT
			BEGIN
				SET @maxUsersForFiveConnections = 5000
				SET @isModernAuthEnabled = (SELECT attrVal FROM APP_BackupSetProp(NOLOCK) WHERE attrName = 'Sharepoint Modern Auth' AND modified = 0 AND componentNameId = @i_backupsetId)
				IF @isModernAuthEnabled = 1
				BEGIN
					SET @associatedConnectionsXML = CAST(REPLACE ((SELECT TOP 1 attrVal FROM APP_BackupSetProp(NOLOCK) WHERE componentNameId = @i_backupsetId AND attrName = 'Sharepoint Azure Connections' AND modified = 0),'encoding="UTF-8"', 'encoding="UTF-16"') AS XML)
					SET @associatedConnectionsCount = @associatedConnectionsXML.value('count(/App_Office365AzureConnections/azureApps)', 'int')
				END
				ELSE
				BEGIN
					SET @associatedConnectionsXML = CAST(REPLACE ((SELECT TOP 1 attrVal FROM APP_BackupSetProp(NOLOCK) WHERE componentNameId = @i_backupsetId AND attrName = 'Sharepoint Service Accounts' AND modified = 0),'encoding="UTF-8"', 'encoding="UTF-16"') AS XML)
					/*Count only service accounts*/
					SET @associatedConnectionsCount = (SELECT COUNT(*) FROM @associatedConnectionsXML.nodes('/App_SharepointServiceAccounts/accounts') E(a) WHERE E.a.value('@serviceType', 'int') = 51)
				END
				/*Counting only active sites for mode 1*/
				SET @numberOfUsers = (SELECT COUNT(DISTINCT CA.smtpAddress) FROM APP_CloudAppUserDetails(NOLOCK) CA
                WHERE CA.subClientId IN (SELECT subclientId FROM @listSubclientId) AND CA.modified = 0
                AND CA.discoverByType = @DISCOVERTYPE_ASSOCIATED_SHAREPOINT_WEB_SITES/*Associated SharePoint Web Sites*/ AND (CA.flags&2=0) AND CA.status = 0/*Active*/)
			END
			/*Send empty response if the requirement is met*/
			IF (@numberOfUsers <= @maxUsersForFiveConnections AND @associatedConnectionsCount >= 5) OR (@numberOfUsers > @maxUsersForFiveConnections AND @associatedConnectionsCount >= 10)
			BEGIN
				SET @o_xmlString = '<App_Office365ClientOverviewResp />'
				GOTO ERROR_EXIT
			END
			IF @isModernAuthEnabled = 1
				SET @o_xmlString = (SELECT (SELECT (CASE WHEN @numberOfUsers <= @maxUsersForFiveConnections THEN 5 ELSE 10 END) AS '@requiredAzureApps'
									FOR XML PATH ('office365ClientOverview'), TYPE)
									FOR XML PATH ('App_Office365ClientOverviewResp'))
			ELSE
				SET @o_xmlString = (SELECT (SELECT (CASE WHEN @numberOfUsers <= @maxUsersForFiveConnections THEN 5 ELSE 10 END) AS '@requiredServiceAccounts'
									FOR XML PATH ('office365ClientOverview'), TYPE)
									FOR XML PATH ('App_Office365ClientOverviewResp'))
			GOTO ERROR_EXIT
		END
		SELECT @instanceId = instance, @appType = appTypeId, @clientId = clientId
		FROM APP_Application(NOLOCK)
		WHERE id = (SELECT MIN(subclientId) FROM @listSubclientId)
		-- check clientType
		IF @appType NOT IN (@CV_APPTYPE_CLOUD_APPS, @CV_APPTYPE_EXCHANGE_ONEPASS, @CV_APPTYPE_SHAREPOINT)
			BEGIN
				SET @errorCode = 1
				SET @errorString = 'Error: Unidentified clientType [' + CAST(@appType AS VARCHAR(8)) + '] of backupset id [' + CAST(@i_backupSetId AS VARCHAR(16)) + ']'
				GOTO ERROR_EXIT
			END
		IF OBJECT_ID('tempdb.dbo.#tempOffice365ClientStats') IS NOT NULL
			DROP TABLE #tempOffice365ClientStats
		CREATE TABLE #tempOffice365ClientStats
		(
			lastArchiveJobRunTime INT DEFAULT 0,
			backupSize BIGINT DEFAULT 0,
			numberOfUsers BIGINT DEFAULT 0,
			numberOfItems BIGINT DEFAULT 0,
			lastPlayedBkpJobId BIGINT DEFAULT 0,
			lastPlayedBkpJobTime BIGINT DEFAULT 0,
			lastBackupJobInfo XML,
			-- For Exchange
			backupsetType INT,
			itemsContentIndexed BIGINT,
			-- For CloudApps
			instanceType INT,
			-- For Sharepoint
			siteCount INT
		)
		-- Last archive job for Exchange/CloudApps/SharePoint
		INSERT INTO #tempOffice365ClientStats (lastArchiveJobRunTime)
		(SELECT ISNULL(MAX(servEndDate), 0) AS bkptime FROM JMBkpStats(NOLOCK)
		WHERE appId IN (SELECT subclientId FROM @listSubclientId)
		AND status IN (1/*JMSUCCESS*/, 3/*PARTIALSUCCESS*/, 14/*JMSUCCESSWITHWARNINGS*/) AND opType = 4 /*Backup*/)
		-- Is Office365 V2 client
		SET @isOffice365V2Client = ISNULL((SELECT attrVal FROM APP_ClientProp(NOLOCK) clientProp
									WHERE clientProp.componentNameId = @clientId AND clientProp.attrName = 'Office 365 Pseudo Client' AND clientProp.attrVal = 1 AND modified = 0),  0)
		IF @appType = @CV_APPTYPE_CLOUD_APPS OR @appType = @CV_APPTYPE_SHAREPOINT
			BEGIN
				SET @dbStatXML = (SELECT properties FROM IdxDbState(NOLOCK) WHERE dbid = (SELECT id FROM App_IndexDBInfo(NOLOCK) WHERE backupSetId = @i_backupsetId))
				IF @dbStatXML IS NOT NULL
					UPDATE #tempOffice365ClientStats
					SET backupSize = Idx.backupSize, numberOfItems = Idx.itemsIndexed, lastPlayedBkpJobTime = idx.lastPlayedBkpJobTime, lastPlayedBkpJobId = Idx.lastPlayedBkpJobId
					FROM (SELECT
							ISNULL(P.ref.value('@lastPlayedBkpJobTime', 'BIGINT'), 0) AS lastPlayedBkpJobTime,
							ISNULL(P.ref.value('@lastPlayedBkpJobId', 'BIGINT'), 0) AS lastPlayedBkpJobId,
							ISNULL(P.ref.value('(stat/@applicationSize)[1]', 'BIGINT'), 0) AS backupSize,
							ISNULL(P.ref.value('(stat/@itemsIndexed)[1]', 'BIGINT'), 0) AS itemsIndexed
						FROM @dbStatXML.nodes('/Indexing_DbStats/apps') P(ref)) Idx
				ELSE
					UPDATE #tempOffice365ClientStats
					SET backupSize = ISNULL((SELECT SUM(totalUncompBytes) FROM JMBkpStats(NOLOCK)
											WHERE appId IN (SELECT subclientId FROM @listSubclientId) AND status IN (1/*JMSUCCESS*/, 3/*PARTIALSUCCESS*/, 14/*JMSUCCESSWITHWARNINGS*/)), 0)
			END
		IF @appType = @CV_APPTYPE_CLOUD_APPS
			BEGIN
				-- OneDrive instance type
				UPDATE #tempOffice365ClientStats
				SET instanceType = ISNULL((SELECT attrVal FROM APP_InstanceProp(NOLOCK)
									WHERE componentNameId = @instanceId and attrName = 'Cloud Apps Instance Type' AND modified = 0), 0)
				SET @instanceType = (SELECT instanceType FROM #tempOffice365ClientStats)
				-- OneDriveV2/Teams/D365 number of users
				SET @numberOfUsers = (SELECT COUNT(DISTINCT cuser.smtpAddress) FROM APP_CloudAppUserDetails(NOLOCK) cuser
									WHERE cuser.subClientId IN (SELECT subclientId FROM @listSubclientId)
									AND cuser.modified = 0 AND cuser.discoverByType = (CASE @instanceType
																													WHEN @ONEDRIVE_INSTANCE THEN @DISCOVERTYPE_USER
																													WHEN @TEAMS_INSTANCE THEN @DISCOVERTYPE_TEAM
																													WHEN @D365_INSTANCE THEN @DISCOVERTYE_DYNAMICS_365_ENTITY
																												 END))
				-- OneDrive V1 number of users
				IF @instanceType = @ONEDRIVE_INSTANCE AND @numberOfUsers = 0
					SET @numberOfUsers = (SELECT COUNT(DISTINCT sprop.attrName) FROM APP_SubClientProp(NOLOCK) sprop
										WHERE sprop.componentNameId in (SELECT subclientId FROM @listSubclientId)
										AND sprop.modified = 0 AND sprop.attrType = 134)
				UPDATE #tempOffice365ClientStats SET numberOfUsers = @numberOfUsers
				-- CloudApps discover state
				IF @instanceType = @ONEDRIVE_INSTANCE
					SET @discoverStateXML = CAST(REPLACE((ISNULL((SELECT TOP 1 attrVal
											FROM APP_InstanceProp(NOLOCK)
											WHERE attrName = 'Discovery State' AND modified = 0 AND componentNameId = @instanceId ORDER BY created DESC), '<App_Office365DiscoverState />')), 'encoding="UTF-8"', 'encoding="UTF-16"') AS XML)
				ELSE IF @instanceType IN (@TEAMS_INSTANCE, @D365_INSTANCE)
					SET @discoverStateXML = CAST(REPLACE((ISNULL((SELECT TOP 1 attrVal
											FROM APP_InstanceProp(NOLOCK)
											WHERE attrName = 'V2CloudApps Discovery State' AND modified = 0 AND componentNameId = @instanceId ORDER BY created DESC), '<App_Office365DiscoverState />')), 'encoding="UTF-8"', 'encoding="UTF-16"') AS XML)
			END
		ELSE IF @appType = @CV_APPTYPE_EXCHANGE_ONEPASS
			BEGIN
				-- Exchange backupset type
				UPDATE #tempOffice365ClientStats
				SET backupsetType = ISNULL((SELECT attrVal FROM APP_BackupSetProp(NOLOCK)
									WHERE componentNameId = @i_backupsetId AND attrName = 'Exchange OnePass BackupSet Type' AND modified = 0), 0)
				-- Exchange email count, backup size, items content indexed and index collection time
				SET @dbStatXML = (SELECT properties FROM IdxDbState(NOLOCK) WHERE dbid = (SELECT id FROM App_IndexDBInfo(NOLOCK) WHERE backupSetId = @i_backupsetId))
				IF @dbStatXML IS NULL
					UPDATE #tempOffice365ClientStats SET itemsContentIndexed = 0
				ElSE
					UPDATE #tempOffice365ClientStats
					SET backupSize = idx.backupSize, numberOfItems = Idx.itemsIndexed, itemsContentIndexed = Idx.itemsContentIndexed, lastPlayedBkpJobTime = idx.lastPlayedBkpJobTime, lastPlayedBkpJobId = Idx.lastPlayedBkpJobId
					FROM (SELECT
							ISNULL(P.ref.value('@lastPlayedBkpJobTime', 'BIGINT'), 0) AS lastPlayedBkpJobTime,
							ISNULL(P.ref.value('@lastPlayedBkpJobId', 'BIGINT'), 0) AS lastPlayedBkpJobId,
							ISNULL(P.ref.value('(stat/@applicationSize)[1]', 'BIGINT'), 0) AS backupSize,
							ISNULL(P.ref.value('(stat/@itemsIndexed)[1]', 'BIGINT'), 0) AS itemsIndexed,
							ISNULL(P.ref.value('(stat/@itemsContentIndexed)[1]', 'BIGINT'), 0) AS itemsContentIndexed
						FROM @dbStatXML.nodes('/Indexing_DbStats/apps') P(ref)) Idx
				-- Exchange number of users (mailbox count)
				UPDATE #tempOffice365ClientStats
				SET numberOfUsers = (SELECT COUNT(assocId) FROM APP_EmailConfigPolicyAssoc(NOLOCK)
									WHERE backupsetId = @i_backupsetId AND mailBoxType IN (1, 2, 3) AND modified = 0 )
				--	Exchange discover state
				SET @discoverStateXML = CAST(REPLACE((ISNULL((SELECT TOP 1 attrVal
										FROM APP_IDAProp(NOLOCK)
										WHERE attrName = 'Discovery State' AND modified = 0 AND componentNameId IN (SELECT id FROM APP_IDAName(NOLOCK) WHERE clientId = @clientId AND appTypeId = @CV_APPTYPE_EXCHANGE_ONEPASS) ORDER BY created DESC), '<App_Office365DiscoverState />')), 'encoding="UTF-8"', 'encoding="UTF-16"') AS XML)
			END
		ELSE /*IF @clientType = @CV_APPTYPE_SHAREPOINT*/
			BEGIN
				-- Sharepoint number of users
				UPDATE #tempOffice365ClientStats
				SET numberOfUsers = (SELECT COUNT(DISTINCT bsProp.attrName) FROM APP_BackupSetProp(NOLOCK) bsProp
				WHERE bsProp.componentNameId IN (SELECT DISTINCT app.backupSet FROM APP_Application(NOLOCK) app
				WHERE app.backupSet = @i_backupsetId AND app.subclientStatus & 0x02 != 0x02 /*UNINSTALLED*/ AND app.subclientStatus & 0x04 != 0x04 /*DELETED*/ AND app.subclientStatus & 0x00020 != 0x00020 /*HIDDEN*/)
				AND bsProp.attrType = 137 AND bsProp.modified = 0)
				-- Sharepoint number of sites
				UPDATE #tempOffice365ClientStats
				SET siteCount = (SELECT COUNT(DISTINCT CA.smtpAddress) FROM APP_CloudAppUserDetails(NOLOCK) CA
				WHERE CA.subClientId IN (SELECT subclientId FROM @listSubclientId) AND CA.modified = 0
				AND CA.discoverByType = @DISCOVERTYPE_ASSOCIATED_SHAREPOINT_WEB_SITES/*Associated SharePoint Web Sites*/ AND (CA.flags&2=0))
				-- SharePoint discover state
				SET @discoverStateXML = CAST(REPLACE((ISNULL((SELECT TOP 1 attrVal
                                        FROM App_BackupSetProp(NOLOCK)
                                        WHERE attrName = 'SharePoint Discovery State' AND modified = 0 AND componentNameId = @i_backupsetId ORDER BY created DESC), '<App_Office365DiscoverState />')), 'encoding="UTF-8"', 'encoding="UTF-16"') AS XML)
			END
		-- Last backup job info
		UPDATE #tempOffice365ClientStats
		SET lastBackupJobInfo = (SELECT attrVal FROM APP_IDAProp(NOLOCK) WHERE attrName = 'Last Backup Job Info' AND modified = 0
		                         AND componentNameId IN (SELECT id FROM APP_IDAName(NOLOCK) WHERE clientId = @clientId AND appTypeId IN (@CV_APPTYPE_EXCHANGE_ONEPASS, @CV_APPTYPE_CLOUD_APPS, @CV_APPTYPE_SHAREPOINT)))
		SET @o_xmlString = (SELECT (SELECT
								@appType AS "@appType",
								@i_backupsetId AS "@backupsetId",
								backupsetType AS "@backupsetType",
								instanceType AS "@instanceType",
								@isOffice365V2Client AS "@isOffice365V2Client",
								(SELECT (SELECT
									backupSize AS "@backupSize",
									numberOfUsers AS "@numberOfUsers",
									numberOfItems AS "@numberOfItems",
									itemsContentIndexed AS "@itemsContentIndexed",
									siteCount AS "@siteCount"
								FOR XML PATH ('stats'), TYPE)),
								(SELECT (SELECT
									lastArchiveJobRunTime AS "@lastArchiveJobRanTime",
									(SELECT (SELECT
										ISNULL(N.ref.value('@discoveryProgress', 'INT'), 0) AS "@discoveryProgress",
										ISNULL(N.ref.value('@discoveryStatus', 'INT'), 0) AS "@discoveryStatus",
										ISNULL(N.ref.value('@lastCacheGroupsCount', 'BIGINT'), 0) AS "@lastCacheGroupsCount",
										ISNULL(N.ref.value('@lastCacheUpdateTime', 'BIGINT'), 0) AS "@lastCacheUpdateTime",
										ISNULL(N.ref.value('@lastCacheUsersCount', 'BIGINT'), 0) AS "@lastCacheUsersCount",
										ISNULL(N.ref.value('@totalDiscoveredGroups', 'BIGINT'), 0) AS "@totalDiscoveredGroups",
										ISNULL(N.ref.value('@totalDiscoveredUsers', 'BIGINT'), 0) AS "@totalDiscoveredUsers"
									FROM @discoverStateXML.nodes('/App_Office365DiscoverState') N(ref)
									FOR XML PATH ('discoverState'), TYPE)),
								(SELECT (SELECT
								lastPlayedBkpJobId AS "@lastPlayedBkpJobId",
								lastPlayedBkpJobTime AS "@lastPlayedBkpJobTime"
								FOR XML PATH ('lastPlayedJobSummary'), TYPE)),
								(SELECT L.N.query('.') FROM lastBackupJobInfo.nodes('lastBackupJobInfo') L(N))
								FOR XML PATH ('summary'), TYPE))
							FROM #tempOffice365ClientStats
							FOR XML PATH ('office365ClientOverview'), TYPE)
							FOR XML PATH ('App_Office365ClientOverviewResp'))
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SELECT @errorCode = ERROR_NUMBER(), @errorString = ERROR_MESSAGE()
	END CATCH
	ERROR_EXIT:
		IF @errorCode <> 0
			BEGIN
				SET @o_xmlString =
				(SELECT ISNULL(@errorCode,0) AS '@errorCode', ISNULL(@errorString,'')
									AS '@errorMessage' FOR XML PATH('App_Office365ClientOverviewResp'))
			END
	IF OBJECT_ID('tempdb.dbo.#tempOffice365ClientStats') IS NOT NULL
		DROP TABLE #tempOffice365ClientStats
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppOffice365ClientOverview')
	delete from GxQscripts where name = 'AppOffice365ClientOverview'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppOffice365ClientOverview')
	delete from GXDBVersions where aliasname = 'AppOffice365ClientOverview'
GO

insert into GXDBVersions values(2, 'AppOffice365ClientOverview',  '00000000000000000000', 'AppOffice365ClientOverview', '00000000000000000000')
GO

