

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppObjServerSetSecurityContentMap.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppObjServerSetSecurityContentMap.sp,v $ $Id: AppObjServerSetSecurityContentMap.sp,v 1.8.60.2 2018/03/22 01:51:26 jiechen Exp $";
--
--  +========================================================================+
--  |   Procedure:  AppObjServerSetSecurityContentMap()
--  |
--  | Description:  xx
--  |
--  |       Input:  xx
--  |
--  |      Output:
-- 	|
--  |      Return:  xxx
--  |
--  |   Revisions  Author						Description
--  |   ---------  -------				--------------------------------
--  |   1.1        Bhavyan Mehta   Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppObjServerSetSecurityContentMap <<<'

IF EXISTS (select * from sysobjects where name='AppObjServerSetSecurityContentMap')
	drop procedure AppObjServerSetSecurityContentMap
IF EXISTS (select * from GxQscripts where name='AppObjServerSetSecurityContentMap')
	delete from GxQscripts where name = 'AppObjServerSetSecurityContentMap'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppObjServerSetSecurityContentMap')
	delete from GXDBVersions where aliasname = 'AppObjServerSetSecurityContentMap'
GO
print '... Creating Procedure: AppObjServerSetSecurityContentMap'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppObjServerSetSecurityContentMap
  @i_xml XML
AS
  DECLARE @o_xmlText XML
SET NOCOUNT ON
BEGIN
	DECLARE @i_clientId INT = 0
	DECLARE @i_backupSetId INT = 0
	DECLARE @i_subClientId INT = 0
	DECLARE @contentListTbl TABLE ( t_url varchar(1024),
									t_id int,
									t_userId int,
									t_groupId int
								   )
	DECLARE @i_subClientName NVARCHAR(256)
-- Get the input parameters
	SET @i_clientId = ISNULL (( SELECT ref.value('@clientId', 'INT')
					FROM  @i_xml.nodes ('Ida_ObjServerSetContentReq/subClientInfo') R(ref)), 0)
	SET @i_backupSetId = ISNULL (( SELECT ref.value('@backupsetId', 'INT')
					FROM  @i_xml.nodes ('Ida_ObjServerSetContentReq/subClientInfo') R(ref)), 0)
	SET @i_subClientId = ISNULL (( SELECT ref.value('@subclientId', 'INT')
					FROM  @i_xml.nodes ('Ida_ObjServerSetContentReq/subClientInfo') R(ref)), 0)
	SET @i_subClientName = ( SELECT ref.value('@subclientName', 'NVARCHAR(256)')
					FROM  @i_xml.nodes ('Ida_ObjServerSetContentReq/subClientInfo') R(ref))
	IF ( @i_subClientId = -1 )
	BEGIN
		SET @i_subClientId = ( SELECT DISTINCT ID
							   FROM APP_Application
							   WHERE clientId = @i_clientId
								AND backupSet = @i_backupSetId
								AND subClientName = @i_subClientName
							 )
	END
BEGIN TRY
BEGIN TRAN
-- Retrieve the mapping information from xml
	INSERT INTO @contentListTbl
	SELECT ref.value('@url', 'VARCHAR(1024)'), 0, usr.value('@userId','INT'), 0
	FROM  @i_xml.nodes ('Ida_ObjServerSetContentReq/contentMappingList') R(ref)
	OUTER APPLY ref.nodes('securityInfo/users') S(usr)
	INSERT INTO @contentListTbl
	SELECT ref.value('@url', 'VARCHAR(1024)'), 0, 0, usrGroups.value('@userGroupId','INT')
	FROM  @i_xml.nodes ('Ida_ObjServerSetContentReq/contentMappingList') R(ref)
	OUTER APPLY ref.nodes('securityInfo/userGroups') T(usrGroups)
-- Get the ids of the urls
	UPDATE @contentListTbl
	SET t_id = SCF.id
	FROM APP_ScFilterFile SCF
	WHERE SCF.fileName = t_url
		AND SCF.modified = 0
-- Sync up the security table for sites that are deleted
	DELETE UMUserandGroupEntityAssociation
WHERE entityType = 9508
	AND objectId IN ( SELECT SCF.id
						  FROM APP_ScFilterFile SCF
						  WHERE SCF.modified <> 0
							AND SCF.componentNameId = @i_subClientId
					)
-- Now, insert into the security table the content map
	DELETE UMUserandGroupEntityAssociation
WHERE entityType = 9508
	AND objectId IN ( SELECT DISTINCT t_id
					  FROM @contentListTbl
					 )
	INSERT INTO UMUserandGroupEntityAssociation
SELECT ISNULL(t_userId,0), ISNULL(t_groupId,0), 0, 0, 9508, t_id, 0 -- only userid, groupid and scfilterfile item is populated
	FROM @contentListTbl
	SELECT	1					as TAG,
			0					as Parent,
			'0'			as [CVGui_GenericResp!1!errorCode],
			'Success'			as [CVGui_GenericResp!1!errorMessage]
		FOR XML EXPLICIT
	COMMIT TRAN
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SELECT	1					as TAG,
			0					as Parent,
			'1'			as [CVGui_GenericResp!1!errorCode],
			'Error'			as [CVGui_GenericResp!1!errorMessage]
		FOR XML EXPLICIT
	ROLLBACK TRAN
END CATCH
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppObjServerSetSecurityContentMap')
	delete from GxQscripts where name = 'AppObjServerSetSecurityContentMap'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppObjServerSetSecurityContentMap')
	delete from GXDBVersions where aliasname = 'AppObjServerSetSecurityContentMap'
GO

insert into GXDBVersions values(2, 'AppObjServerSetSecurityContentMap',  '00010008006000020000', 'AppObjServerSetSecurityContentMap', '00010008006000020000')
GO

