

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppObjServerGetSecurityContentMap.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppObjServerGetSecurityContentMap.sp,v $ $Id: AppObjServerGetSecurityContentMap.sp,v 1.7.276.2 2018/03/22 01:32:53 jiechen Exp $";
--
--  +========================================================================+
--  |   Procedure:  AppObjServerGetSecurityContentMap()
--  |
--  | Description:  xx
--  |
--  |       Input:  xx
--  |
--  |      Output:
-- 	|
--  |      Return:  xxx
--  |
--  |   Revisions  Author						Description
--  |   ---------  -------				--------------------------------
--  |   1.1        Bhavyan Mehta   Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppObjServerGetSecurityContentMap <<<'

IF EXISTS (select * from sysobjects where name='AppObjServerGetSecurityContentMap')
	drop procedure AppObjServerGetSecurityContentMap
IF EXISTS (select * from GxQscripts where name='AppObjServerGetSecurityContentMap')
	delete from GxQscripts where name = 'AppObjServerGetSecurityContentMap'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppObjServerGetSecurityContentMap')
	delete from GXDBVersions where aliasname = 'AppObjServerGetSecurityContentMap'
GO
print '... Creating Procedure: AppObjServerGetSecurityContentMap'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppObjServerGetSecurityContentMap
  @i_xml XML
AS
  DECLARE @o_xmlText XML
SET NOCOUNT ON
BEGIN
	DECLARE @i_clientId INT = 0
	DECLARE @i_backupSetId INT = 0
	DECLARE @i_subClientId INT = 0
	DECLARE @i_subClientName NVARCHAR(256)
-- Get the input parameters
	SET @i_clientId = ISNULL (( SELECT ref.value('@clientId', 'INT')
					FROM  @i_xml.nodes ('Ida_ObjServerGetContentReq/subClientInfo') R(ref)), 0)
	SET @i_backupSetId = ISNULL (( SELECT ref.value('@backupsetId', 'INT')
					FROM  @i_xml.nodes ('Ida_ObjServerGetContentReq/subClientInfo') R(ref)), 0)
	SET @i_subClientId = ISNULL (( SELECT ref.value('@subclientId', 'INT')
					FROM  @i_xml.nodes ('Ida_ObjServerGetContentReq/subClientInfo') R(ref)), 0)
	SET @i_subClientName = ( SELECT ref.value('@subclientName', 'NVARCHAR(256)')
					FROM  @i_xml.nodes ('Ida_ObjServerSetContentReq/subClientInfo') R(ref))
-- Fetch the data and return back
	IF ( @i_subClientId = -1 )
	BEGIN
		SET @i_subClientId = ( SELECT DISTINCT ID
							   FROM APP_Application
							   WHERE clientId = @i_clientId
								AND backupSet = @i_backupSetId
								AND subClientName = @i_subClientName
							 )
	END
	SET @o_xmlText =
	(
		SELECT D.fileName '@url', (
									SELECT (
										SELECT USR.id '@userId', USR.login '@userName'
										FROM UMUserandGroupEntityAssociation UUG INNER JOIN UMUsers USR ON UUG.userId = USR.id
										WHERE UUG.objectId = D.objectId
										FOR XML PATH('users'),TYPE
										)
								,  		(
										SELECT UG.id '@userGroupId', UG.name '@userGroupName'
										FROM UMUserandGroupEntityAssociation UUG INNER JOIN UMGroups UG ON UUG.groupId = UG.id
										WHERE UUG.objectId = D.objectId
										FOR XML PATH('userGroups'),TYPE
										)
									FOR XML PATH('securityInfo'),TYPE
								)
		FROM (
				SELECT DISTINCT objectId, fileName
				FROM UMUserandGroupEntityAssociation INNER JOIN APP_ScFilterFile ON objectId = id
WHERE componentNameId = @i_subClientId AND  entityType = 9508
			 ) AS D
		FOR XML PATH('contentMappingList'), ROOT('Ida_ObjServerGetContentResp')
	)
	IF ( @o_xmlText IS NULL )
		SET @o_xmlText = '<Ida_ObjServerGetContentResp />'
	SELECT @o_xmlText
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppObjServerGetSecurityContentMap')
	delete from GxQscripts where name = 'AppObjServerGetSecurityContentMap'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppObjServerGetSecurityContentMap')
	delete from GXDBVersions where aliasname = 'AppObjServerGetSecurityContentMap'
GO

insert into GXDBVersions values(2, 'AppObjServerGetSecurityContentMap',  '00010007027600020000', 'AppObjServerGetSecurityContentMap', '00010007027600020000')
GO

