

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppNotifyMountPathChangesToClient.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  AppNotifyMountPathChangesToClient
--  | Description:  Generates a xml with operations that need to perform on client
--  |				in this case, refresh cache and mark next job as full for
--  |				the subclients associated to mount path.
--  |
--  | Logic : Based on mount path operation,
--  |    		For DELETE	: We need to refresh the cache on client
--  |							and also make sure to mark next job as FULL
--  |			For MOVE	: We need to refresh the cache on client
--  +========================================================================+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppNotifyMountPathChangesToClient')
BEGIN
	print '>>> Drop Stored Procedure: AppNotifyMountPathChangesToClient <<<'
	drop procedure AppNotifyMountPathChangesToClient
END
IF EXISTS (select * from GxQscripts where name='AppNotifyMountPathChangesToClient')
	delete from GxQscripts where name = 'AppNotifyMountPathChangesToClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppNotifyMountPathChangesToClient')
	delete from GXDBVersions where aliasname = 'AppNotifyMountPathChangesToClient'
GO
print '... Creating Procedure: AppNotifyMountPathChangesToClient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppNotifyMountPathChangesToClient
  @i_mountPathId INT,
  @i_mountPathOpType INT
--operation Type 1 - DELETE, 2 - MOVE
AS
SET NOCOUNT ON
--Declarations
DECLARE @currentTime INT = dbo.GetUnixTime(GetUTCDate())
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
    DECLARE @refreshCache INT = 0
    DECLARE @markNextJobFull INT = 0
	DECLARE @xmlReq NVARCHAR(MAX) = ''
	DECLARE @doWeOwnTable INT = 0
	IF object_id('tempdb.dbo.#tempMPForNextJobFull') IS NULL
	BEGIN
		CREATE TABLE #tempMPForNextJobFull( mpId INT PRIMARY KEY)
		INSERT INTO #tempMPForNextJobFull VALUES(@i_mountPathId)
		SET @doWeOwnTable = 1
	END
	--For Delete
IF @i_mountPathOpType IN (1, 2, 3, 4)
    BEGIN
        SET @refreshCache = 1
        SET @markNextJobFull = 1
    END
	INSERT INTO APP_WorkQueueRequest (clientId, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag, remoteClient)
	SELECT DISTINCT
			APP.clientId,
			56/*WORK_TOKEN_CLIENT_PROCESS_XML_REQ*/,
			CONVERT(VARCHAR(MAX),
					(SELECT @refreshCache AS '@refreshCache',  @markNextJobFull AS '@markNextJobFull',
								(SELECT SMP1.subClientId AS '@subclientId'
									FROM APP_SubclientToMountPathMapping SMP1
										INNER JOIN App_Application APP1
											ON SMP1.subClientId = APP1.id
										WHERE SMP1.mountPathId = @i_mountPathId AND APP.clientId = APP1.clientId
									FOR XML PATH('subclients'), TYPE)
								FOR XML PATH('App_MountPathModificationReq'), TYPE
							)),
			@currentTime , 0, 0, 0, -1
			FROM APP_SubclientToMountPathMapping SMP
				INNER JOIN App_Application APP ON SMP.subClientId = APP.id
				INNER JOIN #tempMPForNextJobFull mp ON mp.mpId = SMP.mountPathId
	IF (@doWeOwnTable = 1 AND (object_id('tempdb.dbo.#tempMPForNextJobFull') IS NOT NULL))
	BEGIN
		 DROP TABLE #tempMPForNextJobFull
	END
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppNotifyMountPathChangesToClient')
	delete from GxQscripts where name = 'AppNotifyMountPathChangesToClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppNotifyMountPathChangesToClient')
	delete from GXDBVersions where aliasname = 'AppNotifyMountPathChangesToClient'
GO

insert into GXDBVersions values(2, 'AppNotifyMountPathChangesToClient',  '00000000000000000000', 'AppNotifyMountPathChangesToClient', '00000000000000000000')
GO

