

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppNavSettingsSet.sp] ---------- 

--  +============================================================================================+
--  |		 		 Name:  AppNavSettingsSet()
--  | Description:  Allows for PUT of navigation settings for a Company or At Global Level
--  +============================================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppNavSettingsSet.sp,v $ $Id: AppNavSettingsSet.sp,v 1.1.2.4.28.1 2021/04/06 04:19:09 sthakkar Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppNavSettingsSet')
BEGIN
	print '>>> Drop Stored Procedure: AppNavSettingsSet <<<'
	drop procedure AppNavSettingsSet
END
IF EXISTS (select * from GxQscripts where name='AppNavSettingsSet')
	delete from GxQscripts where name = 'AppNavSettingsSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppNavSettingsSet')
	delete from GXDBVersions where aliasname = 'AppNavSettingsSet'
GO
print '... Creating Procedure: AppNavSettingsSet'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppNavSettingsSet
  @i_userId INTEGER,
  @i_providerId INTEGER,
  @o_xmlText XML OUTPUT,
  @o_errCode INTEGER OUTPUT,
  @o_errString NVARCHAR(1024) OUTPUT
AS
SET NOCOUNT ON
BEGIN TRY
DECLARE @canManageProvider		INTEGER		= 0
DECLARE @tenantAdminGroupId		INTEGER		= 0
DECLARE @ownerCompany			INTEGER		= 0
DECLARE @xmlText				XML
DECLARE @errCode				INTEGER
DECLARE @errString				NVARCHAR(1024)
DECLARE @loggedInUserOwnerCompany INTEGER = 0
SET @loggedInUserOwnerCompany =   dbo.AppGetCompanyForUserOrUserGroup(@i_userId , 1)
IF OBJECT_ID('tempdb.dbo.#NavSettingTbl') IS NOT NULL DROP TABLE #NavSettingTbl
CREATE TABLE #NavSettingTbl	(roleType INT , propertyName VARCHAR(128), isGlobal INT, propertyVal NVARCHAR(MAX))
IF OBJECT_ID('tempdb.dbo.#InfoTable') IS NOT NULL DROP TABLE #InfoTable
CREATE TABLE #InfoTable	(userRole INT PRIMARY KEY, deniedPropName VARCHAR(64) , landingURL VARCHAR(512), includePropName VARCHAR(64))
DECLARE @nowTime				INTEGER		=   dbo.GetUnixTime (GetUTCdate())
SET @o_errCode = 0
SET @o_errString = ''
IF @i_providerId > 0
BEGIN
	-- We have some Provider Id. Get the Owner Company Id in order to identify correct company
	SET @ownerCompany = dbo.AppGetCompanyForProvider(@i_providerId)
END
ELSE
BEGIN
	-- In case of no provider there, we will get data for user based on his/her company
	SET @ownerCompany = @loggedInUserOwnerCompany
END
EXEC sec_checkPermissionOnEntity  @i_userId, 1, @canManageProvider OUTPUT, 61, @ownerCompany
IF (@canManageProvider=1)
BEGIN
	INSERT INTO #InfoTable
VALUES	(0, 'Restricted Nav Items For MSP Admin', 'Default Landing Page For MSP Admin', NULL),
(1, 'Restricted Nav Items For Tenant Admin', 'Default Landing Page For Tenant Admin','Include Nav Items For Tenant Admin'),
(3, 'Restricted Nav Items For MSP User', 'Default Landing Page For MSP User',NULL),
(2, 'Restricted Nav Items For Tenant User', 'Default Landing Page For Tenant User','Include Nav Items For Tenant User'),
(4, 'Restricted Nav Items For Restricted Admin', 'Default Landing Page For Restricted Admin',NULL)
	-- If any Commcell Admin/MSP Admin send out request, then only chnage global settings.
	IF (@ownerCompany = 0)
	BEGIN
		-- GET Data from XML into Temp Table For Global Level
		INSERT INTO #NavSettingTbl
		SELECT IT.userRole, IT.deniedPropName, 1, ref.value('@deniedNavItems', 'NVARCHAR(MAX)')
			FROM @o_xmlText.nodes('Api_UpdateNavItemsReq/navSettings/globalSettings') R ( ref )
			INNER JOIN #InfoTable IT ON
				IT.userRole=ref.value('@userRole', 'INT')
		UNION
		SELECT IT.userRole, IT.landingURL, 1, ref.value('@defaultLandingPage', 'NVARCHAR(MAX)')
			FROM @o_xmlText.nodes('Api_UpdateNavItemsReq/navSettings/globalSettings') R ( ref )
			INNER JOIN #InfoTable IT ON
			IT.userRole=ref.value('@userRole', 'INT')
	END
	ELSE
	BEGIN
		-- GET Data from XML into Temp Table For company Level
		-- Only Tenant Admin and Tenant User can have company specific properties
		INSERT INTO #NavSettingTbl
		SELECT IT.userRole, IT.deniedPropName, 0, ref.value('@deniedNavItems', 'NVARCHAR(MAX)')
		FROM @o_xmlText.nodes('Api_UpdateNavItemsReq/navSettings/companySettings') R ( ref )
		INNER JOIN #InfoTable IT ON
			IT.userRole=ref.value('@userRole', 'INT')
		UNION
		SELECT IT.userRole, IT.landingURL, 0, ref.value('@defaultLandingPage', 'NVARCHAR(MAX)')
		FROM @o_xmlText.nodes('Api_UpdateNavItemsReq/navSettings/companySettings') R ( ref )
		INNER JOIN #InfoTable IT ON
			IT.userRole=ref.value('@userRole', 'INT')
		UNION
		SELECT IT.userRole, IT.includePropName, 0, ref.value('@includeNavItems', 'NVARCHAR(MAX)')
		FROM @o_xmlText.nodes('Api_UpdateNavItemsReq/navSettings/companySettings') R ( ref )
		INNER JOIN #InfoTable IT ON
IT.userRole=ref.value('@userRole', 'INT') AND (@loggedInUserOwnerCompany = 0 OR IT.userRole = 2)
	END
	-- Delete any unwanted rows from Table (if input was not proper)
	DELETE FROM #NavSettingTbl WHERE propertyName IS NULL OR propertyVal IS NULL
	-- First Merge Global settings
	MERGE GXGlobalParam AS DEST
	USING #NavSettingTbl AS SRC
		ON SRC.isGlobal = 1 AND SRC.propertyName=DEST.name
		WHEN MATCHED
			THEN UPDATE SET value=SRC.propertyVal
		WHEN NOT MATCHED AND SRC.isGlobal = 1 THEN
			INSERT (name, value, created, modified)
			Values( SRC.propertyName, SRC.propertyVal, @nowTime, 0);
	-- Now Set Company Level Properties
	MERGE App_companyProp AS DEST
	USING #NavSettingTbl AS SRC
		ON SRC.isGlobal = 0 AND SRC.propertyName=DEST.attrName AND DEST.componentNameId=@ownerCompany AND DEST.modified=0
		WHEN MATCHED
			THEN UPDATE SET attrVal=SRC.propertyVal
		WHEN NOT MATCHED AND SRC.isGlobal = 0 THEN
			INSERT (componentNameId, attrName, attrType, attrVal, created, modified )
			Values( @ownerCompany, SRC.propertyName, 1, SRC.propertyVal, @nowTime, 0);
END
ELSE
BEGIN
	-- User don't have rights to see specific provider details
SET @o_errCode =  (1878 | (CAST(POWER(2, 24) AS BIGINT) * 35))
	SET @o_errString = (SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK) WHERE messageId = @o_errCode AND [localeId] = 0)
END
SET @o_xmlText = (SELECT @o_errCode AS '@errorCode',  @o_errString AS '@errorMessage'
				FOR XML PATH('Api_GenericResp'),TYPE)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @o_errCode = ERROR_NUMBER()
    set @o_errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	SET @o_xmlText = (SELECT @o_errCode AS '@errorCode',  @o_errString AS '@errorMessage'
					FOR XML PATH('Api_GenericResp'),TYPE)
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppNavSettingsSet')
	delete from GxQscripts where name = 'AppNavSettingsSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppNavSettingsSet')
	delete from GXDBVersions where aliasname = 'AppNavSettingsSet'
GO

insert into GXDBVersions values(2, 'AppNavSettingsSet',  'v1.1.2.4.28.1', 'AppNavSettingsSet', 'v1.1.2.4.28.1')
GO

