

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppNavSettingsGet.sp] ---------- 

--  +==============================================================================+
--  |		 		 Name:  AppNavSettingsGet()
--  | Description:  Allows for GET of navigation settings for a user
--  +==============================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppNavSettingsGet.sp,v $ $Id: AppNavSettingsGet.sp,v 1.1.2.4.28.1 2021/04/06 04:19:13 sthakkar Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppNavSettingsGet')
BEGIN
	print '>>> Drop Stored Procedure: AppNavSettingsGet <<<'
	drop procedure AppNavSettingsGet
END
IF EXISTS (select * from GxQscripts where name='AppNavSettingsGet')
	delete from GxQscripts where name = 'AppNavSettingsGet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppNavSettingsGet')
	delete from GXDBVersions where aliasname = 'AppNavSettingsGet'
GO
print '... Creating Procedure: AppNavSettingsGet'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppNavSettingsGet
  @i_userId INTEGER,
  @i_providerId INTEGER,
  @o_xmlText XML OUTPUT,
  @o_errCode INTEGER OUTPUT,
  @o_errString NVARCHAR(1024) OUTPUT
AS
SET NOCOUNT ON
BEGIN TRY
DECLARE @canSeeProvider			INTEGER		= 0
DECLARE @ownerCompany			INTEGER
DECLARE @userRole               INTEGER
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET @o_errCode = 0
SET @o_errString = ''
IF @i_providerId > 0
BEGIN
	EXEC sec_canSeeOrManageNameServer  @i_userId, @i_providerId, 1, 0, 0, @canSeeProvider OUTPUT
	IF @canSeeProvider = 0
	BEGIN
		-- User don't have rights to see specific provider details
SET @o_errCode =  (1878 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @o_errString = (SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK) WHERE messageId = @o_errCode AND [localeId] = 0)
	END
	ELSE
	BEGIN
		SET @ownerCompany = dbo.AppGetCompanyForProvider(@i_providerId)
	END
END
ELSE
BEGIN
	-- In case of no provider there, we will get data for user based on his/her company
	SET @ownerCompany = dbo.AppGetCompanyForUserOrUserGroup(@i_userId , 1)
END
IF @o_errCode = 0
BEGIN
	DECLARE @provId INT
	EXEC AppGetUserRoleType  @i_userId, @userRole OUTPUT, @provId  OUTPUT, @o_errCode OUTPUT, @o_errString OUTPUT
	IF @o_errCode = 0
		IF OBJECT_ID('tempdb.dbo.#DetailsTable') IS NOT NULL DROP TABLE #DetailsTable
		CREATE TABLE #DetailsTable	(userRole INT, isGlobalSetting INT DEFAULT 0, isApplicable INT DEFAULT 0, deniedItems NVARCHAR(MAX) NULL, landingURL NVARCHAR(MAX) DEFAULT NULL,includeItems NVARCHAR(max) DEFAULT NULL)
		IF OBJECT_ID('tempdb.dbo.#InfoTable') IS NOT NULL DROP TABLE #InfoTable
		CREATE TABLE #InfoTable	(userRole INT PRIMARY KEY, deniedPropName VARCHAR(64) , landingURL VARCHAR(64),includePropName VARCHAR(64) DEFAULT NULL)
		INSERT INTO #InfoTable
VALUES (0, 'Restricted Nav Items For MSP Admin', 'Default Landing Page For MSP Admin',NULL),
(1, 'Restricted Nav Items For Tenant Admin', 'Default Landing Page For Tenant Admin','Include Nav Items For Tenant Admin'),
(3, 'Restricted Nav Items For MSP User', 'Default Landing Page For MSP User',NULL),
(2, 'Restricted Nav Items For Tenant User', 'Default Landing Page For Tenant User','Include Nav Items For Tenant User'),
(4, 'Restricted Nav Items For Restricted Admin', 'Default Landing Page For Restricted Admin',NULL)
		INSERT INTO #DetailsTable (userRole, isGlobalSetting)
VALUES (0, 1),
(1, 0),
(1, 1),
(2, 0),
(2, 1),
(3, 1),
(4, 1)
		UPDATE #DetailsTable
		SET isApplicable = 1
		WHERE
(@userRole=0 AND userRole=0) OR
(@userRole IN (0,1) AND userRole=1) OR
(@userRole IN (0,3) AND userRole=3) OR
(@userRole IN (0,1,2) AND userRole=2) OR
(@userRole IN (0,4) AND userRole=4)
		UPDATE DT
		SET DT.deniedItems = GX1.value, DT.landingURL=GX2.value
		FROM #DetailsTable DT
		INNER JOIN #InfoTable IT
			ON IT.userRole=DT.userRole
		LEFT OUTER JOIN GXGlobalParam GX1
			ON GX1.name=IT.deniedPropName
		LEFT OUTER JOIN GXGlobalParam GX2
			ON GX2.name=IT.landingURL
		WHERE DT.isApplicable=1 AND DT.isGlobalSetting=1
		UPDATE DT
		SET DT.deniedItems = ACP1.attrVal, DT.landingURL=ACP2.attrVal,DT.includeItems = ACP3.attrVal
		FROM #DetailsTable DT
		INNER JOIN #InfoTable IT
			ON IT.userRole=DT.userRole
		LEFT OUTER JOIN App_CompanyProp ACP1
			ON ACP1.attrName=IT.deniedPropName AND ACP1.modified=0 AND ACP1.componentNameId=@ownerCompany
		LEFT OUTER JOIN App_CompanyProp ACP2
			ON ACP2.attrName=IT.landingURL AND ACP2.modified=0 AND ACP2.componentNameId=@ownerCompany
		LEFT OUTER JOIN App_CompanyProp ACP3
			ON ACP3.attrName=IT.includePropName AND ACP3.modified=0 AND ACP3.componentNameId=@ownerCompany
		WHERE DT.isApplicable=1 AND DT.isGlobalSetting=0 AND @ownerCompany>0
		-- Make sure to remove all unwanted rows here.
		DELETE FROM #DetailsTable WHERE (deniedItems IS NULL AND landingURL IS NULL AND includeItems IS NULL) OR (isApplicable=0)
		SET @o_xmlText = (SELECT
								(SELECT
									(SELECT
											userRole AS '@userRole', deniedItems AS '@deniedNavItems' , landingURL AS '@defaultLandingPage'
										FROM #DetailsTable WHERE isGlobalSetting=1
									 FOR XML PATH('globalSettings'), TYPE),
								(SELECT
											userRole AS '@userRole', deniedItems AS '@deniedNavItems' , landingURL AS '@defaultLandingPage', includeItems AS '@includeNavItems'
									 FROM #DetailsTable WHERE isGlobalSetting=0
									 FOR XML PATH('companySettings'), TYPE)
								FOR XML PATH('navSettings'), TYPE),
								(SELECT 0 AS '@errorCode', '' AS '@errorMessage'  FOR XML PATH('error'),TYPE)
							 FOR XML PATH('Api_GetNavItemsResp'),TYPE)
		-- Remove temp tables
		IF OBJECT_ID('tempdb.dbo.#DetailsTable') IS NOT NULL DROP TABLE #DetailsTable
		IF OBJECT_ID('tempdb.dbo.#InfoTable') IS NOT NULL DROP TABLE #InfoTable
END
IF @o_errCode <> 0
BEGIN
		SET @o_xmlText = (SELECT
							(SELECT @o_errCode AS '@errorCode',  @o_errString AS '@errorMessage'  FOR XML PATH('error'),TYPE)
						 FOR XML PATH('Api_GetNavItemsResp'),TYPE)
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @o_errCode = ERROR_NUMBER()
    set @o_errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	SET @o_xmlText = (SELECT
					(SELECT @o_errCode AS '@errorCode',  @o_errString AS '@errorMessage'  FOR XML PATH('error'),TYPE)
					FOR XML PATH('Api_GetNavItemsResp'),TYPE)
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppNavSettingsGet')
	delete from GxQscripts where name = 'AppNavSettingsGet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppNavSettingsGet')
	delete from GXDBVersions where aliasname = 'AppNavSettingsGet'
GO

insert into GXDBVersions values(2, 'AppNavSettingsGet',  'v1.1.2.4.28.1', 'AppNavSettingsGet', 'v1.1.2.4.28.1')
GO

