

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppMoveInstance.sp] ---------- 

---------------------------------------------------------------------------
-- RETURN CODES:
--- BY CONVENTION, ALL CODES BELOW 100 ARE SOME FORM OF SUCCESS, EVERYTHING
--- GREATER IS SOME KIND OF FAILURE
---------------------------------------------------------------------------
--==--==--==--==--==--==--==--==--==--==--==--==--==--==--==--==--==--
-- FOLLOWING DEFINITIONS ARE TO FACILITATE UPDATING THE SCRIPT WITH --
-- THE LEAST DISRUPTION CAUSED BY TABLE NAME CHANGES !!!!!!!        --
--==--==--==--==--==--==--==--==--==--==--==--==--==--==--==--==--==--
--==--==--==--==--==--==--==--==--==--==--==--==--==--==--==--==--==--==
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppMoveInstance.sp,v $ $Id: AppMoveInstance.sp,v 1.11.208.4 2019/12/27 12:31:55 rengu Exp $";
--
--  +========================================================================+
--  | Stored Precedure: AppMoveInstance()
--  |
--  |   Revisions  Author     Description
--  |   ---------  -------    ---------------------------------------------
--  |   1.0        stuk      Initial Edit
--  +========================================================================+
--  NOTE: SINCE 5.9, 6.1, and 7.0 Each have a different set of Oracle related tables (or renames), this Procedure MUST
--        Have a different version number for each one.  Keep this in mind if patches to existing procs is req'd
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppMoveInstance')
BEGIN
	print '>>> Drop Stored Procedure: AppMoveInstance <<<'
	drop procedure AppMoveInstance
END
IF EXISTS (select * from GxQscripts where name='AppMoveInstance')
	delete from GxQscripts where name = 'AppMoveInstance'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppMoveInstance')
	delete from GXDBVersions where aliasname = 'AppMoveInstance'
GO
print '... Creating Procedure: AppMoveInstance'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppMoveInstance
  @i_instanceName NVARCHAR(512),
  @i_sourceClientNames NVARCHAR(255),
  @i_destClientName NVARCHAR(255),
  @i_appType integer
AS
-- FOLLOWING IS "ROW" THAT IS RETURNED --
  DECLARE @retCode integer;
  DECLARE @infoString nvarchar(255);
SET NOCOUNT ON
-- "VARIABLES" ---
DECLARE @inStrLen			INTEGER						-- FOR PARSING
DECLARE @nextSeper			INTEGER
DECLARE @thisClient			NVARCHAR(255)
DECLARE @thisClientId		INTEGER
DECLARE @instanceId			INTEGER
DECLARE @rowCount			INTEGER
DECLARE @destClientId		INTEGER
DECLARE @srcClientId		INTEGER
DECLARE @sqlError			INTEGER = 0
DECLARE @currentTableName	VARCHAR(100)
--  "CONSTANTS" --
DECLARE @appTypeName   nvarchar(100)
DECLARE @scStatusBits  INTEGER;
DECLARE @DELIM       char(1)
DECLARE @curTime INTEGER = dbo.GetUnixTime(GetUTCDate())
SET @appTypeName = (select [name] From APP_iDAType where type = @i_appType)
IF @appTypeName IS nuLL
   SET @appTypeName = 'Unknown(' +convert(varchar(9), @i_appType) + ')'
SET     @scStatusBits  =    2+4        -- CV_STATUS_UNINSTALLED+CV_STATUS_DELETED     NOT(+CV_STATUS_DEFAULT(8)+CV_STATUS_HIDDEN(32))
SET     @DELIM       = CHAR(10)		   -- ASCII <LF> Character
--==--==--==--==--==--==--==--==--==--==--==--==--==--
--- DO SOME BASIC SANITY TESTS FIRST!              ---
--==--==--==--==--==--==--==--==--==--==--==--==--==--
SET @retCode = 0				-- 'APP_INSTMOVE_OK'  ASSUME WE WILL BE SUCCESSFUL!
SET @destClientId = (select [id] from APP_client WHERE name = @i_destClientName)
IF @destClientId IS nuLL
BEGIN
SET @retCode = 103			-- 'APP_INSTMOVE_DESTINATION_NOEXIST'
	set @infoString = 'Destination client [' +@i_destClientName + '] does not exist.'
	GOTO RETURN_RESULTS
END
IF NOT EXISTS (Select * from APP_application WHERE clientId = @destClientId AND appTypeId = @i_appType AND   (subClientStatus & @scStatusBits) = 0)
BEGIN
SET @retCode = 104			-- 'APP_INSTMOVE_DESTINATION_BAD_IDA'
	set @infoString = 'Destination client [' +@i_destClientName + '] does not have an iDa of type [' + @appTypeName + '].'
	GOTO RETURN_RESULTS
END
--==--==--==--==--==--==--==--==--==--==--==--==--==--
--- SET UP LIST OF CLIENTS TO LOOK FOR INSTANCE ON ---
--- .. IF LIST IS PASSED AS PARAMETER, PARSE IT,   ---
--- .. OTHERWISE USE LIST OF ALL CLIENTS THAT HAVE ---
--- .. COMPATIBLE APPLICATIONS                     ---
--==--==--==--==--==--==--==--==--==--==--==--==--==--
--  WE WILL USE A TEMPORARY TABLE DO SPEED THINGS UP A BIT --
IF object_id('tempdb.dbo.#APPMOVEINSTANCE_TMP') IS NOT Null DROP TABLE #APPMOVEINSTANCE_TMP
CREATE TABLE #APPMOVEINSTANCE_TMP
     (
     [clientId]		int,
     [appType]		int,
     [instanceId]	int,
[clientName]	nvarchar(255),					--'MAX_VARCHAR_SIZE'
[instanceName] nvarchar(512)
     )
-- DETERMINE IF LIST OF CLIENTS WAS PASSED IN OR IF WE ARE LOOKING FOR ALL CLIENTS --
--------------------------------------------------------------------------------------
Set @inStrLen    = LEN(@i_sourceClientNames)
IF @inStrLen > 0
BEGIN
	WHILE (LEN(@i_sourceClientNames) > 0)
	BEGIN
		SET @nextSeper   = CHARINDEX(@DELIM, @i_sourceClientNames, 1)
		IF @nextSeper = 0
		BEGIN
		    SET @i_sourceClientNames = @i_sourceClientNames+@DELIM
		    SET @nextSeper = @instrlen+1
		END
--		GET CLIENT NAME, ID & (COMPATIBLE) APPTYPE:
--      -------------------------------------------
		SET @thisClient    = RTRIM(LTRIM(SUBSTRING(@i_sourceClientNames, 1, @nextSeper-1)))
SET @thisClientId  = (SELECT [id] from APP_client where name = @thisClient)
		INSERT INTO #APPMOVEINSTANCE_TMP
		  SELECT DISTINCT clientId, @i_appType, instance, @thisClient, ''
FROM APP_application
		     WHERE appTypeId = @i_appType
		       AND clientId  = @thisClientId
		       AND   (subClientStatus & @scStatusBits) = 0
		DELETE #APPMOVEINSTANCE_TMP WHERE clientId IS nuLL
		--TODOTODO														-- DO WE WANT TO ADD BOGUS CLIENT NAMES HERE?
--		SET UP TO GET NEXT CLIENT IN THE LIST:
--      --------------------------------------
		IF (@inStrLen - @nextSeper <= 0)
		    BREAK
		SET @i_sourceClientNames = SUBSTRING(@i_sourceClientNames, @nextSeper+1, @inStrLen-@nextSeper)
		SET @inStrLen = LEN(@i_sourceClientNames)
		--Select 'remaining string'=@i_sourceClientNames, Len=@insTRLen
	END																		-- (while)
END																		-- (inStrLen > 0)
ELSE
BEGIN
		INSERT INTO #APPMOVEINSTANCE_TMP
		  SELECT DISTINCT clientId, @i_appType, instance, '', ''
FROM APP_application
		     WHERE appTypeId = @i_appType
		       AND   (subClientStatus & @scStatusBits) = 0
		UPDATE #APPMOVEINSTANCE_TMP
SET [clientName] = (select Name from APP_client Where id = [clientId])
		DELETE #APPMOVEINSTANCE_TMP
		    WHERE [clientName] = @i_destClientName
END
----------------------------------------------------------------------------------------------------------
---  WE KNOW HAVE A LIST OF POTENTIAL SRC CLIENTS IN OUR TEMP TABLE, EITHER PASSED FROM COMMAND LINE OR --
---  TAKEN FROM THE FULL SET OF CLIENTS WITH THE SAME APPTYPE.  WE KNOW NEED TO FIND THE INSTANCE       --
----------------------------------------------------------------------------------------------------------
		------------------------------------------------
		-- DID WE FIND INSTANCE IN LIST OF CLIENTS?   --
		------------------------------------------------
		UPDATE #APPMOVEINSTANCE_TMP
SET [instanceName] = (select name from APP_instanceName where id = instanceId)
		DELETE #APPMOVEINSTANCE_TMP
		WHERE [instanceName] <> @i_instanceName
		SET @rowCount = (Select count(*) FROM #APPMOVEINSTANCE_TMP)
		IF @rowCount = 0
		BEGIN
SET @retCode = 100		--'APP_INSTMOVE_INST_NOT_FOUND'
			SET @infoString = 'Instance not found in selected clients list'
			GOTO RETURN_RESULTS
		END
		------------------------------------------------
		-- DID WE FIND INSTANCE IN TOO MANY CLIENTS?  --
		------------------------------------------------
		IF @rowCount > 1
		BEGIN
SET @retCode = 101		--'APP_INSTMOVE_MULTIPLE_SOURCED_INSTANCE'
			SET @infoString = 'Instance was found on more than one client ('
			DECLARE ClientsCursor CURSOR
			FOR
			SELECT  distinct clientName FROM #APPMOVEINSTANCE_TMP
			OPEN ClientsCursor
			FETCH NEXT FROM ClientsCursor INTO @thisClient
			WHILE @@FETCH_STATUS = 0
			BEGIN
                SET @infoString =  @infoString +@thisClient + '; '
				FETCH NEXT FROM ClientsCursor INTO @thisClient
			END
			SET @inStrLen =LEN(@infoString)
			SET @infoString =  SUBSTRING(@infoString,1,@inStrLen-1) + ')'
			CLOSE ClientsCursor
			DEALLOCATE ClientsCursor
			GOTO RETURN_RESULTS
		END
		-------------------------------------------------
		-- IS INSTANCE NAME A CONFLICT IN DESTINATION? --
		-------------------------------------------------
IF EXISTS (SELECT * FROM APP_application as APP, APP_instanceName as INST
		            WHERE APP.clientId  = @destClientId
		              AND APP.appTypeId = @i_appType
		              AND APP.instance  = INST.id
		              AND   (APP.subClientStatus & @scStatusBits) = 0
		              AND INST.name     = @i_instanceName)
		BEGIN
SET @retCode = 102			-- 'APP_INSTMOVE_DUPLICATE_INSTANCE'
			set @infoString = 'Instance [' +@i_instanceName +'] already exists on Destination client [' +@i_destClientName + '].'
			GOTO RETURN_RESULTS
		END
		SET @srcClientId = (select clientId FROM #APPMOVEINSTANCE_TMP)		-- No "WHERE" needed, should only be one row left!
		set @instanceId  = (select instanceId FROM #APPMOVEINSTANCE_TMP)
---------------------------------------------------------------------------------------------------------
---  THESE ARE THE TABLES THAT MUST BE MODIFIED:
---
	-- Application
	-- Backuptask
	-- RestoreTask
	-- AppExtendedProperties
	-- OracleRacInstance
	-- archCopyToApp
	-- archFileOracle
	-- CNJobRstHistory
	-- dbRestoreTasks
	-- NTDclntAgentMAConfig
	-- NTNotificationRule
	-- NTDschedConfig
	-- oracleObjects
	-- oracleDataFiles  ???
----------------------------------------------------------------------------------------------------------
BEGIN TRY
BEGIN TRAN
SET @currentTableName =									'APP_application'
UPDATE APP_application
	  SET clientId = @destClientId
	  WHERE clientId  = @srcClientId
		AND instance  = @instanceId
		AND appTypeId = @i_appType
SET @currentTableName =									'TM_AssocEntity'
UPDATE TM_AssocEntity
	  SET clientId = @destClientId
	  WHERE clientId  = @srcClientId
		AND instanceId  = @instanceId
		AND appTypeId = @i_appType
SET @currentTableName =									'TM_AssocEntity'+ '(src)'
UPDATE TM_AssocEntity
	  SET clientId = @destClientId
	  WHERE clientId = @srcClientId
		AND instanceId  = @instanceId
		AND appTypeId = @i_appType
SET @currentTableName =									'TM_SubTaskOptions'+ '(dest)'
UPDATE TM_SubTaskOptions
	  SET value = @destClientId
	  WHERE subTaskId IN (
		SELECT subTaskId FROM TM_SubTask
			WHERE  taskId IN (
SELECT taskId FROM TM_AssocEntity
					WHERE clientId = @srcClientId
					AND instanceId  = @instanceId
					AND appTypeId = @i_appType
				)
		)
AND optionId = 293753447
SET @currentTableName =									'App_ExtendedProperties'
UPDATE App_ExtendedProperties
	  SET clientId = @destClientId
	  WHERE clientId  = @srcClientId
		AND instance  = @instanceId
		AND appTypeId = @i_appType
SET @currentTableName =									'App_OracleRacInstance'
UPDATE App_OracleRacInstance
	  SET clientId = @destClientId
	  WHERE clientId  = @srcClientId					-- SHOULD NEVER HAVE TO DO THIS ONE, BUT
		AND instaceId  = @instanceId					-- IT IS ADDED HERE FOR COMPLETENESS
SET @currentTableName =									'archCopyToApp'
	UPDATE ARCHCOPYTOAPP
	  SET clientId = @destClientId
	  WHERE clientId    = @srcClientId
		AND instanceId  = @instanceId
		AND appTypeId   = @i_appType
SET @currentTableName =									'archFileOracle'
UPDATE archFileOracle
	  SET clientId = @destClientId
	  WHERE clientId    = @srcClientId
		AND instanceId  = @instanceId
	--  AND appTypeId   = @i_appType						--appId in table points to application table?
SET @currentTableName =									'dbRestoreTasks'
UPDATE dbRestoreTasks
	  SET clientId = @destClientId
	  WHERE clientId    = @srcClientId
		AND instId  = @instanceId
	 -- AND appTypeId   = @i_appType					-- No appTypeId in table, but think this is ORACLE ONLY table?
SET @currentTableName =									'NTDclntAgentMAConfig'
UPDATE NTDclntAgentMAConfig
	  SET clientId = @destClientId
	  WHERE clientId    = @srcClientId
		AND instanceId  = @instanceId
		AND appTypeId   = @i_appType
	-- We need to send refresh OSC tokens to clients so that if there are any automatic schedules associated, they would be reflected.
SET @currentTableName =									'APP_WorkQueueRequest'+ '(src)'
INSERT INTO APP_WorkQueueRequest (clientId, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag, remoteClient)
	SELECT @srcClientId, 4/*WORK_TOKEN_OSC*/, 0, @curTime, 0, 0, 0, -1
SET @currentTableName =									'APP_WorkQueueRequest'+ '(dest)'
INSERT INTO APP_WorkQueueRequest (clientId, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag, remoteClient)
	SELECT @destClientId, 4/*WORK_TOKEN_OSC*/, 0, @curTime, 0, 0, 0, -1
	-- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- !
	-- NTNOTIFICATIONRULE_TABLE:
	--							 THIS TABLE has field xmlEntityList that needs to be unserialized/modified & then re-serialized
	--                           ifaoif Instance was selected for an alert .... THIS IS VERY EXPENSIVE TO DO, AND IF CODE IS ADDED
	--							 should probably be done OUTSIDE of transaction!
	-- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- !
SET @currentTableName =									'NTDschedConfig'
UPDATE NTDschedConfig
	  SET clientId = @destClientId
	  WHERE clientId    = @srcClientId
		AND instanceId  = @instanceId
		AND appTypeId   = @i_appType
	-- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- !
	-- ORACLEOBJECTS_TABLE :
	-- ORACLEDATAFILES_TABLE :
	--							THESE TABLES DO NOT APPEAR TO HAVE CONCEPT OF CLIENT BINDING, SO
	--							THEY SHOULD NOT REQUIRE "MIGRATION" UPDATE
	-- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- ! -- !
	--
	-------------------------------------------------------------------------------------------------------------------------
	-- OTHER TABLES !MAY! BE REQUIRED, BUT THIS IS LIST SO FAR (03/01/2006).  EACH RELEASE MAY ALSO HAVE IT'S OWN ADDITIONAL
	-- SET OF TABLES, AND POTENTIALLY (unlikely)  OBSOLETED TABLES.  TABLE NAMES SHOULD BE CONTROLLED THROUGH MACRO's FOR
	-- TABLE NAMES AT THE TOP OF THIS FILE
	-------------------------------------------------------------------------------------------------------------------------
	--
	---------------------------------------------------
	--- ALL DONE W/UPDATES, COMMIT CHANGES & RETURN ---
	---------------------------------------------------
	COMMIT TRAN
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    Set @sqlError      = ERROR_NUMBER()
	ROLLBACK TRAN
END CATCH
IF @sqlError = 0
BEGIN
set @thisClient = (select name from APP_client where id = @srcClientId)
	SET @infoString =	'Instance [' + @i_instanceName +'(' +Convert(varchar(10), @instanceId) + ')] moved from '
	SET @infoString =  @infoString + 'Client [' + @thisClient + '(' + Convert(varchar(10), @srcClientId) + ')] to '
	SET @infoString =  @infoString + 'Client [' + @i_destClientName + '(' + Convert(varchar(10), @destClientID) + ')].'
	GOTO RETURN_RESULTS
END
ELSE
BEGIN
	------------------------------------------------
	--- IF WE KNOW WHAT THE SQL ERROR WAS, WE     --
	--- CAN RETURN A MORE INTELLIGENT RETURN CODE --
	------------------------------------------------
	if @sqlError = 515
	  BEGIN
SET @retCode = 10515			-- 'APP_INSTMOVE_FAILED_NULL_CONTRAINT_VIOLATION'
		SET @infoString = 'Attempt to write NULL clientId (error([' +convert(varchar(12), @sqlError) +']) when updating table [' + @currentTableName + '].'
	  END
	ELSE if @sqlError = 547
	  BEGIN
SET @retCode = 10547			-- 'APP_INSTMOVE_FAILED_CONTRAINT_VIOLATION'
		SET @infoString = 'Foreign Key Contstraint Violation[' +convert(varchar(12), @sqlError) +'] when attempting to update table [' + @currentTableName + '].'
	  END
	ELSE
	  BEGIN
SET @retCode = 10000									-- 'APP_INSTMOVE_FAILED'  (GENERIC ERROR RESPONSE)
	  SET @infoString = 'Error [' +convert(varchar(12), @sqlError) +'] when attempting to update table [' + @currentTableName + '].'
	  END
END
-- Drop Thru, clean up and return results
RETURN_RESULTS:
-- DEBUG -- select * from #APPMOVEINSTANCE_TMP				-- FOR DEBUGGING,  NOT REAL RETURN !@#!@#!@
-- DEBUG -- select srcClientId=@srcClientId, destClientId=@destClientId, instanceId=@instanceId
  IF object_id('tempdb.dbo.#APPMOVEINSTANCE_TMP') IS NOT Null
     DROP TABLE #APPMOVEINSTANCE_TMP
  SELECT [retCode] = @retCode, [infoString] = @infoString		-- THIS IS THE DATA THE CALLER IS EXPECTING
  SET NOCOUNT OFF
GO


IF EXISTS (select * from GxQscripts where name = 'AppMoveInstance')
	delete from GxQscripts where name = 'AppMoveInstance'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppMoveInstance')
	delete from GXDBVersions where aliasname = 'AppMoveInstance'
GO

insert into GXDBVersions values(2, 'AppMoveInstance',  '00010011020800040000', 'AppMoveInstance', '00010011020800040000')
GO

