

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppModifyPlanIndexServerForEntity.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppModifyPlanIndexServerForEntity.sp,v $ $Id: AppModifyPlanIndexServerForEntity.sp,v 1.1.2.3 2019/03/29 01:22:32 alakra Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppModifyPlanIndexServerForEntity')
BEGIN
	print '>>> Drop Stored Procedure: AppModifyPlanIndexServerForEntity <<<'
	drop procedure AppModifyPlanIndexServerForEntity
END
IF EXISTS (select * from GxQscripts where name='AppModifyPlanIndexServerForEntity')
	delete from GxQscripts where name = 'AppModifyPlanIndexServerForEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppModifyPlanIndexServerForEntity')
	delete from GXDBVersions where aliasname = 'AppModifyPlanIndexServerForEntity'
GO
print '... Creating Procedure: AppModifyPlanIndexServerForEntity'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppModifyPlanIndexServerForEntity
  @i_userId INTEGER,
  @i_localeId INTEGER,
  @i_entityId INTEGER,
  @i_entityType INTEGER,
  @i_planId INTEGER,
  @i_indexServer INTEGER,
  @i_reqXML XML,
  @i_opType INTEGER,
  @o_errCode INTEGER OUTPUT,
  @o_errString VARCHAR(1024) OUTPUT
AS
  DECLARE @errorCode INT
  DECLARE @errorString VARCHAR(MAX)
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @executionUnixTime  INT           = (SELECT DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE()))
DECLARE @continue INT = 1
SET @o_errCode = 0
SET @o_errString = 'Success'
IF ((@i_entityType != 7) OR (@i_entityId = 0))
BEGIN
	SET @o_errCode = 5
	SET @o_errString = 'Entity Type not supported for this operations'
END
IF (@o_errCode = 0)
BEGIN
	IF @i_opType = 3  -- Delete
	BEGIN
		DECLARE @indexingEnabledCount INT  = ISNULL ((SELECT COUNT(DISTINCT APP.id) FROM APP_Application AAP1  WITH (NOLOCK)
INNER JOIN APP_SubClientProp ASCP WITH (NOLOCK) ON ASCP.componentNameId = AAP1.id AND ASCP.attrName = 'Associated Plan Index Server Id' AND ASCP.modified=0
															INNER JOIN APP_Application APP WITH (NOLOCK) ON AAP1.backupSet = APP.backupSet
INNER JOIN APP_SubClientProp SCP WITH (NOLOCK) ON SCP.componentNameId = APP.id AND SCP.attrName = 'Associated Plan Index Server Id' AND SCP.modified=0 AND APP.subclientStatus & (2 | 4 | 16 | 32) = 0 -- (0x00002, 0x00004, 0x00010, 0x00020)), 0)
															WHERE AAP1.id=@i_entityId),0)
		-- Nothing needs to be done here.
		IF @indexingEnabledCount = 0
		BEGIN
			SET @continue = 0
		END
		ELSE
		BEGIN
			-- We have bug in AppModifyIndexServer. That need indexserver to even delete the association for subclient.
DECLARE @indexServer INT = (SELECT CAST(attrval AS INT) FROM APP_SubClientProp  WITH (NOLOCK) WHERE componentNameId = @i_entityId AND attrName = 'Associated Plan Index Server Id' AND modified=0)
DELETE FROM APP_SubClientProp WHERE componentNameId = @i_entityId AND attrName = 'Associated Plan Index Server Id'
			IF (@indexingEnabledCount = 1)
			BEGIN
				-- Replace XML Tag
				SET @continue = 1
			END
			ELSE
			BEGIN
				-- This is not the last subclient for which enabled indexing mapped to parent backupset.
				-- We can only remove indexing from backupset level when it is the last subclient of the backupset for which we setup indexing.
				SET @continue = 0
			END
		END
	END
	ELSE IF @i_opType IN (1,2)  -- ADD OR UPDATE
	BEGIN
		IF (@i_indexServer > 0)
		BEGIN
			-- Insert property that we are enabling indexing for this subclient
			MERGE APP_SubClientProp AS T
				USING (SELECT @i_entityId AS subclientID,  @i_indexServer AS attrval) AS S
ON T.componentNameId = S.subclientID AND T.attrName = 'Associated Plan Index Server Id' AND T.modified = 0
				WHEN MATCHED
					THEN UPDATE SET T.attrVal = CAST(S.attrval AS NVARCHAR(32))
				WHEN NOT MATCHED
					THEN INSERT (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
VALUES(@i_entityId, 'Associated Plan Index Server Id', 7, CAST(S.attrval AS NVARCHAR(32)), @executionUnixTime, 0, 0);
		END
		ELSE
		BEGIN
			-- Mark this as soft error. We will make it hard error once we have tested all features of enabling indexing
			-- If we make this hard error, we will never be able to use plan with indexing enabled and packages being missing
			SET @continue = 0
		END
	END
	ELSE
	BEGIN
		SET @o_errCode = 5
		SET @o_errString = 'Optype not supported.'
	END
END
IF (@continue = 1) AND (@o_errCode = 0)
BEGIN
	EXEC AppModifyIndexServer @i_reqXML OUTPUT
	-- We have to update our error code and error message , if we executed above code.
	SET @o_errCode = (SELECT @i_reqXML.value('(//./@errorCode )[1]','INT'))
	SET @o_errString = (SELECT @i_reqXML.value('(//./@errorMessage )[1]','NVARCHAR(MAX)'))
END
SET  @errorCode = @o_errCode
SET  @errorString = @o_errString
IF ((@errorString IS NULL) OR (@errorString=''))
BEGIN
	IF @errorCode = 0
		SET @errorString = 'Success'
	ELSE
		SET @errorString = 'Failed'
END
SELECT @errorCode, @errorString
RETURN
ERROR_EXIT:
GO

IF EXISTS (select * from GxQscripts where name = 'AppModifyPlanIndexServerForEntity')
	delete from GxQscripts where name = 'AppModifyPlanIndexServerForEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppModifyPlanIndexServerForEntity')
	delete from GXDBVersions where aliasname = 'AppModifyPlanIndexServerForEntity'
GO

insert into GXDBVersions values(2, 'AppModifyPlanIndexServerForEntity',  '00010001000200030000', 'AppModifyPlanIndexServerForEntity', '00010001000200030000')
GO

