

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppModifyIndexServerForCI.sp] ---------- 

SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppModifyIndexServerForCI')
BEGIN
	print '>>> Drop Stored Procedure: AppModifyIndexServerForCI <<<'
	drop procedure AppModifyIndexServerForCI
END
IF EXISTS (select * from GxQscripts where name='AppModifyIndexServerForCI')
	delete from GxQscripts where name = 'AppModifyIndexServerForCI'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppModifyIndexServerForCI')
	delete from GXDBVersions where aliasname = 'AppModifyIndexServerForCI'
GO
print '... Creating Procedure: AppModifyIndexServerForCI'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppModifyIndexServerForCI
  @xmlText XML
AS
SELECT @xmlText = @xmlText.query('/Indexing_ModifyIndexServerForCIReq/modifyIndexServerReq')
SET
  @xmlText = replace(replace(cast(@xmlText as nvarchar(max)),
                           '<modifyIndexServerReq',
                           '<Indexing_ModifyIndexServerReq'),
                   '</modifyIndexServerReq>',
                   '</Indexing_ModifyIndexServerReq>')
DECLARE @opType INT = ISNULL(@xmlText.value('(/Indexing_ModifyIndexServerReq/@opType)[1]', 'INT'), 0)
DECLARE @entityType INT = ISNULL(@xmlText.value('(/Indexing_ModifyIndexServerReq/@entityType)[1]', 'INT'), 0)
IF @opType = 3  AND @entityType = 7 -- DELETE, subclient type
-- remove subclients whose backupset has atleast one subclient with ci policy enabled.
BEGIN
	DECLARE @backupsetList TABLE(appId INT, bkpsetId INT)
	INSERT INTO @backupsetList
	SELECT  id, backupSet FROM @xmlText.nodes('/Indexing_ModifyIndexServerReq/entityIdList') AS T(N)
	JOIN  APP_Application as APP WITH (NOLOCK) ON APP.id = T.N.value('@val', 'INT')
	DELETE  @backupsetList FROM @backupsetList bkp
	JOIN APP_Application APP WITH (NOLOCK) ON bkp.bkpsetId = APP.backupSet
	JOIN APP_SubClientProp scp WITH (NOLOCK) ON scp.componentNameId = APP.id
	WHERE scp.attrName = 'Enable Content Indexing' and scp.attrVal = 1
	and scp.modified = 0 and APP.subclientStatus & (2 | 4 | 16 | 32) = 0 -- (CV_STATUS_UNINSTALLED, CV_STATUS_DELETED, CV_STATUS_DUMMY, CV_STATUS_HIDDEN)
	SET @xmlText.modify('delete /Indexing_ModifyIndexServerReq/entityIdList')
	DECLARE @entityXML XML
	SET @entityXML = (SELECT appId AS '@val' FROM @backupsetList FOR XML PATH('entityIdList'), TYPE)
	SET @xmlText.modify('insert sql:variable("@entityXML") into (/Indexing_ModifyIndexServerReq)[1]')
END
EXEC AppModifyIndexServer @xmlText OUTPUT
SET NOCOUNT ON
GO

IF EXISTS (select * from GxQscripts where name = 'AppModifyIndexServerForCI')
	delete from GxQscripts where name = 'AppModifyIndexServerForCI'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppModifyIndexServerForCI')
	delete from GXDBVersions where aliasname = 'AppModifyIndexServerForCI'
GO

insert into GXDBVersions values(2, 'AppModifyIndexServerForCI',  '00000000000000000000', 'AppModifyIndexServerForCI', '00000000000000000000')
GO

