

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppModifyIndexServer.sp] ---------- 

SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppModifyIndexServer')
BEGIN
	print '>>> Drop Stored Procedure: AppModifyIndexServer <<<'
	drop procedure AppModifyIndexServer
END
IF EXISTS (select * from GxQscripts where name='AppModifyIndexServer')
	delete from GxQscripts where name = 'AppModifyIndexServer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppModifyIndexServer')
	delete from GXDBVersions where aliasname = 'AppModifyIndexServer'
GO
print '... Creating Procedure: AppModifyIndexServer'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppModifyIndexServer
  @xmlText XML OUTPUT
AS
DECLARE @errorCode          INT = 0
DECLARE @errorString        NVARCHAR(MAX) = ''
DECLARE @idxServerClientId INT = ISNULL(@xmlText.value('(/Indexing_ModifyIndexServerReq/@idxServerClientId)[1]', 'INT'), 0)
DECLARE @isPrimary INT = ISNULL(@xmlText.value('(/Indexing_ModifyIndexServerReq/@isPrimary)[1]', 'bit'), 0)
DECLARE @engineType INT = ISNULL(@xmlText.value('(/Indexing_ModifyIndexServerReq/@engineType)[1]', 'INT'), 0)
IF @engineType  = 0
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Indexing Engine type is not set in request'
	GOTO PROC_EXIT
END
DECLARE @opType INT = ISNULL(@xmlText.value('(/Indexing_ModifyIndexServerReq/@opType)[1]', 'INT'), 0)
IF @opType  = 0
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Operation type is not set in request'
	GOTO PROC_EXIT
END
IF @opType <> 3 AND NOT EXISTS(SELECT 1 FROM APP_Client WITH (NOLOCK) WHERE id = @idxServerClientId)
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Invalid Index Server Id set in request'
	GOTO PROC_EXIT
END
DECLARE @entityType INT = ISNULL(@xmlText.value('(/Indexing_ModifyIndexServerReq/@entityType)[1]', 'INT'), 0)
DECLARE @appType INT = ISNULL(@xmlText.value('(/Indexing_ModifyIndexServerReq/@appType)[1]', 'INT'), 0)
DECLARE @dbList TABLE(backupsetId INT, subclientId INT, appType INT, appGuid NVARCHAR(256))
IF @entityType = 7 -- subclient type
BEGIN
	INSERT INTO @dbList
		SELECT  DISTINCT APP.backupSet, APP.id, APP.appTypeId, APP.GUID FROM @xmlText.nodes('/Indexing_ModifyIndexServerReq/entityIdList') AS T(N)
        JOIN  APP_Application as APP WITH (NOLOCK) ON APP.id = T.N.value('@val', 'INT')
END
ELSE IF @entityType = 6 --backupset
BEGIN
	INSERT INTO @dbList
		SELECT  DISTINCT APP.backupSet, APP.id, APP.appTypeId, APP.GUID FROM @xmlText.nodes('/Indexing_ModifyIndexServerReq/entityIdList') AS T(N)
        JOIN  APP_Application as APP WITH (NOLOCK) ON APP.backupSet = T.N.value('@val', 'INT')
END
ELSE IF @entityType = 3 --client
BEGIN
	IF @appType = 0
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'appType not set in request'
		GOTO PROC_EXIT
	END
	INSERT INTO @dbList
		SELECT  DISTINCT APP.backupSet, APP.id, APP.appTypeId, APP.GUID FROM @xmlText.nodes('/Indexing_ModifyIndexServerReq/entityIdList') AS T(N)
        JOIN  APP_Application as APP WITH (NOLOCK) ON APP.clientId = T.N.value('@val', 'INT') AND APP.appTypeId = @appType
END
ELSE IF @entityType = 28 --client group
BEGIN
	IF @appType = 0
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'appType not set in request'
		GOTO PROC_EXIT
	END
	INSERT INTO @dbList
		SELECT  DISTINCT APP.backupSet, APP.id, APP.appTypeId, APP.GUID FROM @xmlText.nodes('/Indexing_ModifyIndexServerReq/entityIdList') AS T(N)
		JOIN APP_ClientGroupAssoc CG WITH (NOLOCK) ON CG.clientGroupId = T.N.value('@val', 'INT')
        JOIN  APP_Application as APP WITH (NOLOCK) ON APP.clientId = CG.clientId AND APP.appTypeId = @appType
END
DECLARE @backupsetId INT = 0
DECLARE @subclientId INT = 0
DECLARE @appGuid NVARCHAR(256)
DECLARE @newIdxServerName NVARCHAR(1024)
SELECT @newIdxServerName = name FROM APP_Client WITH (NOLOCK) WHERE id = @idxServerClientId
DECLARE cur CURSOR FOR SELECT backupsetId,subclientId,appType,appGuid FROM @dbList
OPEN cur
FETCH NEXT FROM cur INTO @backupsetId, @subclientId, @appType, @appGuid
WHILE @@FETCH_STATUS = 0
BEGIN
	DECLARE @bsGuid nvarchar(64)
	DECLARE @dbName nvarchar(64)
	DECLARE @oldIdxServerName NVARCHAR(1024)
	SELECT @bsGuid = GUID from APP_BackupSetName where id = @backupsetId
	SET @dbName = @bsGuid
	DECLARE @isSubClientIndexEnabled INT = 0
	SELECT @isSubClientIndexEnabled = dbo.isSubClientIndexEnabled(@backupsetId)
	IF @isSubClientIndexEnabled = 1
	BEGIN
		SET @dbName = @appGuid
	END
	SELECT @oldIdxServerName = name FROM App_IndexDBInfo A WITH (NOLOCK) JOIN APP_Client B WITH (NOLOCK) ON a.currentIdxServer = B.id
	WHERE isPrimary = @isPrimary AND idxDbEngineType = @engineType AND backupSetGUID = @bsGuid
	IF @opType = 1 -- ADD
	BEGIN
		DECLARE @skipIfPrimaryExistsForEngine INT = ISNULL(@xmlText.value('(/Indexing_ModifyIndexServerReq/@skipIfPrimaryExistsForEngine)[1]', 'bit'), 0)
		IF @skipIfPrimaryExistsForEngine = 1
		BEGIN
			DECLARE @primaryIdxSrvr INT = 0
			SELECT @primaryIdxSrvr = currentIdxServer FROM App_IndexDBInfo WITH (NOLOCK) where backupSetGUID = @bsGuid AND dbName = @dbName AND  idxDbEngineType = @engineType AND isPrimary = 1
			IF @primaryIdxSrvr <> 0
			BEGIN
				GOTO REC_NEXT
			END
		END
		DECLARE @updateIfSrvrExistsForEngine INT = ISNULL(@xmlText.value('(/Indexing_ModifyIndexServerReq/@updateIfSrvrExistsForEngine)[1]', 'bit'), 0)
		IF EXISTS(SELECT 1 FROM App_IndexDBInfo WITH (NOLOCK) where backupSetGUID = @bsGuid AND dbName = @dbName AND idxDbEngineType = @engineType AND isPrimary = @isPrimary)
		BEGIN
			IF @updateIfSrvrExistsForEngine = 1
			BEGIN
				UPDATE App_IndexDBInfo SET currentIdxServer = @idxServerClientId  WHERE isPrimary = @isPrimary AND idxDbEngineType = @engineType AND backupSetGUID = @bsGuid AND dbName = @dbName
				IF @oldIdxServerName <> @newIdxServerName
					EXEC AppAuditIdxServerChange @oldIdxServerName, @newIdxServerName
			END
			ELSE
				GOTO REC_NEXT
		END
		DECLARE @isIndexingV2Xml nvarchar(1024) = '<Indexing_GetIndexingVersionReq backupsetId="'+CAST(@backupsetId AS varchar)+'" appTypeOverride="'+CAST(@appType AS varchar)+'"></Indexing_GetIndexingVersionReq>'
		DECLARE @isIndexingV2OutXml XML
		EXEC AppGetIndexingVersionForThisClient @xmlText  = @isIndexingV2Xml, @o_xmlText = @isIndexingV2OutXml OUTPUT
		DECLARE @indexingVersion INT = ISNULL(@isIndexingV2OutXml.value('(/Indexing_GetIndexingVersionResp/@indexingVersionId)[1]', 'INT'), 0)
		DECLARE @idxAppType INT = ISNULL(@isIndexingV2OutXml.value('(/Indexing_GetIndexingVersionResp/@idxAppType)[1]', 'INT'), @appType)
		IF @indexingVersion = 2 -- only for indexingv2
		BEGIN
			INSERT INTO App_IndexDBInfo (dbName, type, idxDbEngineType, backupSetId, currentIdxServer, backupSetGUID, properties, isPrimary, committedTransactionId)
				SELECT @dbName, @idxAppType,  @engineType, @backupsetId, @idxServerClientId, @bsGuid, NULL, @isPrimary, 0  WHERE NOT EXISTS(select currentIdxServer from App_IndexDBInfo where dbName = @dbName and backupSetGuid = @bsGuid AND isPrimary = @isPrimary)
		END
		ELSE
			GOTO REC_NEXT
	END
	ELSE IF @opType = 2 -- UPDATE
	BEGIN
		UPDATE App_IndexDBInfo SET currentIdxServer = @idxServerClientId  WHERE isPrimary = @isPrimary AND idxDbEngineType = @engineType AND backupSetGUID = @bsGuid AND dbName = @dbName
		IF @oldIdxServerName <> @newIdxServerName
			EXEC AppAuditIdxServerChange @oldIdxServerName, @newIdxServerName
	END
	ELSE IF @opType = 3 -- DELETE
	BEGIN
		DELETE App_IndexDBInfo WHERE idxDbEngineType = @engineType AND isPrimary = @isPrimary AND backupSetGUID = @bsGuid AND dbName = @dbName
	END
	REC_NEXT:
		FETCH NEXT FROM cur INTO @backupsetId, @subclientId, @appType, @appGuid
END
CLOSE cur
DEALLOCATE cur
PROC_EXIT:
SET @xmlText = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
                        FOR XML PATH('App_GenericResp'), TYPE)
--SELECT @outXml
SET NOCOUNT ON
GO

IF EXISTS (select * from GxQscripts where name = 'AppModifyIndexServer')
	delete from GxQscripts where name = 'AppModifyIndexServer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppModifyIndexServer')
	delete from GXDBVersions where aliasname = 'AppModifyIndexServer'
GO

insert into GXDBVersions values(2, 'AppModifyIndexServer',  '00000000000000000000', 'AppModifyIndexServer', '00000000000000000000')
GO

