

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppModifyClientFeatures.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2016 CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +================================================================================================+
--  |   Procedure:  AppModifyClientFeatures()
--  |
--  | Description:  SP for Pushing Modified Features to clients.
--  |
--  |       Input:  Modified Features
--  |      Output:  ErrorCode, ErrorString to determine status of the operation
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   1.0		   rengu  	To Send Modified Feature List to client through Work Queue Token
--  +================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppModifyClientFeatures <<<'

IF EXISTS (select * from sysobjects where name='AppModifyClientFeatures')
	drop procedure AppModifyClientFeatures
IF EXISTS (select * from GxQscripts where name='AppModifyClientFeatures')
	delete from GxQscripts where name = 'AppModifyClientFeatures'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppModifyClientFeatures')
	delete from GXDBVersions where aliasname = 'AppModifyClientFeatures'
GO
print '... Creating Procedure: AppModifyClientFeatures'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppModifyClientFeatures
  @xmldata XML
AS
  DECLARE @oxml XML
--Declarations
DECLARE @errorCode INT=0
DECLARE @errorString nvarchar(MAX)=N'Success'
DECLARE @permissionsList nvarchar(2048)=NULL
DECLARE @clientId INT = -1
DECLARE @subClientId INT = -1;
DECLARE @planId INT = 0
DECLARE @archivingFeatureType INT = 6
DECLARE @isArchivingFeatureEnabled INT = -1
DECLARE @archivingPermissionId INT = -1
DECLARE @archivingEnabledOnPlan INT = 0
DECLARE @archivingPresentOnClient INT = 0
DECLARE @clientInstallPkgReq XML
DECLARE @clientInstallPkgResp XML
DECLARE @idaPropReqChangeReq XML
DECLARE @nowTime INT = (SELECT DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE()))
DECLARE @workQOutPutTbl TABLE (errCode INT, errString NVARCHAR(MAX))
DECLARE @workQueueParam NVARCHAR(MAX) = NULL
DECLARE @clientOSType INT = 0
DECLARE @archivingPkgId INT = 753  /*WIN INSTALL PACKAGE ID*/
DECLARE @i_osType INT = 1 /* 1-Windows, 2-UNIX*/
DECLARE @addonPackagePresent INT = 0
DECLARE @pushSCChangeWQ INT = 0
DECLARE @retentionDaysFromPolicy INT = 0
DECLARE @subClientPolicyId INT= -1
DECLARE @idaType INT = 0
---------------------------------------------------
-- Audit Parameters
---------------------------------------------------
DECLARE @opMsgId            INTEGER
DECLARE @opEvMsgId          INTEGER
DECLARE @opId               INTEGER
DECLARE @paramMsgId         INTEGER
DECLARE @paramData          NVARCHAR(1024)
DECLARE @dataIsEvent        INTEGER = 0
DECLARE @userId				INTEGER
-------------------------------------------------------------------------------------------------------------------------------------------
--Code Below Here is From AppPlanConstants.spb
-- declare plan properties definition shared values
DECLARE @constAttrType_BasePlan					INT = 260
DECLARE @constAttrName_BasePlan					NVARCHAR(32) = N'BasePlan'
DECLARE @constAttrType_Feature					INT = 261
DECLARE @constAttrName_Feature					NVARCHAR(32) = N'Feature'
DECLARE @constAttrType_Alert					INT = 262
DECLARE @constAttrName_Alert					NVARCHAR(32) = N'Alert'
DECLARE @constAttrType_AccessPolicy				INT = 263
DECLARE @constAttrName_AccessPolicy				NVARCHAR(32) = N'Access policy'
DECLARE @constAttrType_Policy_Subclient			INT = 264
DECLARE @constAttrName_Policy_Subclient			NVARCHAR(32) = N'Subclient policy'
DECLARE @constAttrType_Policy_Schedule			INT = 265
DECLARE @constAttrName_Policy_Schedule			NVARCHAR(32) = N'Schedule policy'
DECLARE @constAttrType_Policy_Storage			INT = 266
DECLARE @constAttrName_Policy_Storage			NVARCHAR(32) = N'Storage policy'
DECLARE @constAttrType_Options					INT = 267
DECLARE @constAttrName_Options_Quota			NVARCHAR(32) = 'Quota'
DECLARE @constAttrName_Options_EdgeDriveQuota	NVARCHAR(32) = 'Edge Drive Quota Size'
DECLARE @constAttrName_Options_Throttle			NVARCHAR(32) = 'Network Throttle'
DECLARE @constAttrType_UserGroupAssigned		INT = 268
DECLARE @constAttrName_UserGroupAssigned		NVARCHAR(32) = 'Assigned user group'
DECLARE @constAttrType_UserGroupIAssoc			INT = 269
DECLARE @constAttrName_UserGroupIAssoc			NVARCHAR(32) = 'Associated internal user group'
DECLARE @constAttrType_UserGroupEAssoc			INT = 270
DECLARE @constAttrName_UserGroupEAssoc			NVARCHAR(32) = 'Associated external user group'
DECLARE @constAttrType_Restrictions				INT = 271
DECLARE @constAttrName_Restrictions				NVARCHAR(32) = 'Entity restrictions'
DECLARE @constAttrType_AssociatedPlan			INT = 272
DECLARE @constAttrName_AssociatedPlan			NVARCHAR(32) = 'Associated Plan'
DECLARE @constAttrType_ClientGroupAssigned		INT = 273
DECLARE @constAttrName_ClientGroupAssigned		NVARCHAR(32) = 'Assigned client group'
DECLARE @constAttType_ScheduledForDeletion		INT = 274
DECLARE @constAttName_ScheduledForDeletion		NVARCHAR(32) = 'Scheduled for deletion'
DECLARE @constAttType_EdgeDriveAssigned  		INT = 275
DECLARE @constAttName_EdgeDriveAssigned 		NVARCHAR(32) = 'Assgined Edge Drive'
DECLARE @constAttrType_Policy_SubclientWin		INT = 276
DECLARE @constAttrName_Policy_SubclientWin		NVARCHAR(32) = N'Subclient policy 2'
DECLARE @constAttrType_Policy_SubclientLin		INT = 277
DECLARE @constAttrName_Policy_SubclientLin		NVARCHAR(32) = N'Subclient policy 3'
DECLARE @constAttrType_Policy_SubclientMac		INT = 278
DECLARE @constAttrName_Policy_SubclientMac		NVARCHAR(32) = N'Subclient policy 4'
DECLARE @constAttType_SubclientRetention		INT = 279
DECLARE @constAttName_SubclientRetention		NVARCHAR(32) = 'Subclient retention period'
DECLARE @constAttType_SubclientVersions			INT = 280
DECLARE @constAttName_SubclientVersions			NVARCHAR(32) = 'Number of Synth Full Versions'
DECLARE @constAttrType_Policy_ScheduleLog   		INT = 281
DECLARE @constAttrName_Policy_ScheduleLog   		NVARCHAR(32) = N'Log schedule policy'
DECLARE @constAttrType_Policy_StorageLog    		INT = 282
DECLARE @constAttrName_Policy_StorageLog   		 NVARCHAR(32) = N'Log storage policy'
DECLARE @constAttType_SlaInMinutes			INT = 283
DECLARE @constAttName_SlaInMinutes			NVARCHAR(32) = N'SLA In Minutes'
DECLARE @constAttType_LogSlaInMinutes			INT = 285
DECLARE @constAttName_LogSlaInMinutes			NVARCHAR(32) = N'Log SLA In Minutes'
DECLARE @constAttType_ReplicationTargets    		INT = 284
DECLARE @constAttName_ReplicationTargets   		 NVARCHAR(32) = N'Replication schedule policy'
DECLARE @constAttType_ForcedArchiving   		INT = 286
DECLARE @constAttName_ForcedArchiving   		 NVARCHAR(32) = N'Forced Archiving'
-- plan entity identifiers are declared in http:--ncvs/source/xref/win/vaultcx/Source/Common/XmlMessage/Api.x : enum PlanEntities
DECLARE @constPlanEntity_StoragePolicy		 INT =   1
DECLARE @constPlanEntity_SubclientPolicy	 INT =   2
DECLARE @constPlanEntity_SchedulePolicy		 INT =   4
DECLARE @constPlanEntity_Features			 INT =   8
DECLARE @constPlanEntity_Users				 INT =  16
DECLARE @constPlanEntity_Alerts				 INT =  32
DECLARE @constPlanEntity_AccessPolicies		 INT =  64
DECLARE @constPlanEntity_Options			 INT = 128
DECLARE @constPlanEntity_SubclientPolicy_Win INT = 256
DECLARE @constPlanEntity_SubclientPolicy_Lin INT = 512
DECLARE @constPlanEntity_SubclientPolicy_Mac INT = 1024
DECLARE @constPlanEntity_ClientGroup		 INT = 2048
DECLARE @constPlanEntity_EdgeDrive           INT = 4096
DECLARE @constPlanEntity_StoragePolicyLog	 INT = 8192
DECLARE @constPlanEntity_SchedulePolicyLog   INT = 16384
DECLARE @constPlanEntity_ReplicationTargets	 INT = 32768
-- entity operations. declared in http:--ncvs/source/xref/11.0-win/vaultcx/Source/Common/XmlMessage/CVGui.x#197 : enum ListOperationType
DECLARE @constOpType_NONE					INT = 0
DECLARE @constOpType_OVERWRITE				INT = 1
DECLARE @constOpType_ADD					INT = 2
DECLARE @constOpType_DELETE					INT = 3
DECLARE @constOpType_CLEAR					INT = 4
-------------------------------------------------------------------------------------------------------------------------------------------
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	if OBJECT_ID('tempdb.dbo.#existingpermissions') is not null drop table dbo.#existingpermissions
	if OBJECT_ID('tempdb.dbo.#newpermissions') is not null drop table dbo.#newpermissions
	if OBJECT_ID('tempdb.dbo.#mergedpermissions') is not null drop table dbo.#mergedpermissions
	create table #existingpermissions
	(
		permissionId integer,
		enabled integer
	);
	create table #newpermissions
	(
		permissionId integer,
		enabled integer
	);
	create table #mergedpermissions
	(
		permissionId integer,
	);
	SET @userId = ISNULL((
		SELECT R.ref.value('@userId','INT') FROM @xmldata.nodes('/App_ModifyFeatureReq/processinginstructioninfo/user') R(ref)
	), -1)
	SET @clientId = ISNULL ((
		SELECT R.ref.value('@clientId','INT') FROM @xmldata.nodes('/App_ModifyFeatureReq/client') R(ref)
	), -1)
	--Fetching client OS type /*1-Windows 2-UNIX*/
	SET @clientOSType = dbo.scgGetClientOSType(@clientId)
	IF @clientOSType != 1
	BEGIN
		SET @errorCode = 1
        SET @errorString = N'Client Not Supported'
		GOTO GENERATE_OUTPUT
	END
	--Update Features in Client Prop Table
	SET @permissionsList = ISNULL((
		SELECT attrVal FROM App_ClientProp WHERE componentNameId = @clientId AND attrName = @constAttrName_Feature
	),'')
	INSERT INTO #existingpermissions
	SELECT Value,1 FROM
		dbo.cte_split_inline(@permissionsList,',') WHERE Value <> 0
	SET @archivingPresentOnClient = ISNULL((SELECT 1 FROM #existingpermissions WHERE permissionId = @archivingFeatureType),0)
	INSERT INTO #newpermissions
	SELECT R.ref.value('@featureType', 'int') , R.ref.value('@enable', 'int')
		FROM @xmldata.nodes('/App_ModifyFeatureReq/features') R(ref)
	DELETE ep
	FROM #existingpermissions ep
	INNER JOIN #newpermissions np
		ON  ep.permissionId = np.permissionId
	WHERE np.enabled = 0
	INSERT INTO #mergedpermissions
	select permissionId from #existingpermissions WHERE enabled = 1
	UNION
	select permissionId from #newpermissions WHERE enabled = 1
	SET @permissionsList = NULL
	SELECT @permissionsList = coalesce(@permissionsList+',','')+convert(varchar(12),permissionId)
	FROM #mergedpermissions
	ORDER BY permissionId
	SET @permissionsList = ISNULL(@permissionsList,'')
	IF @clientId > 0
	BEGIN
		IF EXISTS(SELECT 1 FROM App_ClientProp WHERE attrName=@constAttrName_Feature AND componentNameId = @clientId)
		BEGIN
			UPDATE App_ClientProp SET attrVal = @permissionsList
			WHERE attrName=@constAttrName_Feature AND componentNameId = @clientId
		END
		ELSE
		BEGIN
			INSERT APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
            VALUES(@clientId,@constAttrName_Feature, 1,@permissionsList, @nowTime, 0 ,0)
		END
	END
---------------------------------------------------------------------
-- Archiving Feature Checks
---------------------------------------------------------------------
	SET @archivingPermissionId = (SELECT id FROM UMPermissions WHERE permissionName='Archiving' )
	--fetching plan Id for the client
	SET @planId = ISNULL((
		SELECT CAST(attrVal AS INT) FROM APP_ClientProp
WHERE componentNameId = @clientId AND attrName = 'Associated Plan'
		),0)
	--Checking whether Archiving is Enabled on Plan Level
	SET @archivingEnabledOnPlan = ISNULL((SELECT 1 FROM   UMRolesPermissions URP INNER JOIN UMPermissions UP ON URP.permissionId = UP.id
WHERE  URP.roleId = CAST(dbo.AppPlanGetEntityValue(@planId, 'Feature', default) AS INT)
											AND UP.id = @archivingPermissionId ),0)
	SET @isArchivingFeatureEnabled = ISNULL ((
		SELECT R.ref.value('@enable','INT') FROM
			@xmldata.nodes('/App_ModifyFeatureReq/features[@featureType=sql:variable("@archivingFeatureType")]') R(ref)
	), -1)
	IF @archivingEnabledOnPlan = 1 OR @archivingPresentOnClient = 1
	BEGIN
		--Fetching Subclient Id
		SET @subClientId = ISNULL( (SELECT SC.id
FROM APP_Application SC WHERE SC.clientId = @clientId AND SC.subclientStatus & 0x00008 = 0x00008
AND SC.subclientStatus & 0x00010 != 0x00010),-1)
		--Checking if addon package is already present
		SET @addonPackagePresent = ISNULL((SELECT 1 FROM simInstalledPackages WHERE simPackageID = @archivingPkgId AND ClientId = @clientId),0)
		--Fetching IDA Type for the client
SET @idaType = ISNULL((SELECT attrval FROM APP_ClientProp WITH (NOLOCK) WHERE attrname = 'Ida Type'
	                                    AND componentNameId = @clientId AND modified = 0),4)
		--Fetching SubClient Policy Id
SET @subClientPolicyId = IIF(@idaType = 2, dbo.AppPlanGetEntityValueV2(@planId, 'Subclient policy 2', default),
IIF(@idaType=3, dbo.AppPlanGetEntityValueV2(@planId, 'Subclient policy 3', default),
dbo.AppPlanGetEntityValueV2(@planId, 'Subclient policy 4', default)))
		-- Fetching Backup retention days as Archiving Retention will also be similar to this in SP10
		SET @retentionDaysFromPolicy = ISNULL((SELECT CAST(SCP.attrVal AS INT) FROM APP_SubClientProp SCP
												WHERE SCP.attrName = N'Days to keep items past their expiration'
												AND SCP.modified = 0
												AND SCP.componentNameId = @subClientPolicyId),730)
		IF @isArchivingFeatureEnabled = 1
		BEGIN
			IF @clientOSType = @i_osType --If Windows
			BEGIN
				IF @addonPackagePresent = 1 --If client already had addon package then change the subclient properties
				BEGIN
					--For updating subclient props and pushing Work token for Subclient Content change
					SET @pushSCChangeWQ = 1
				END
				ELSE --If windows client does not have the addon package
				BEGIN
					SET @clientInstallPkgReq = (SELECT 0 AS'@checkAndRemoveInstalledPackage',(
										SELECT @clientId AS 'client/@clientId', @archivingPkgId AS 'packageInfoList/@packageId'
										FOR XML PATH('reqList'), TYPE)
										FOR XML PATH('JobManager_ClientPackageReqList'), TYPE)
					EXEC JMPushPackagesWithOutputArg @clientInstallPkgReq, @clientInstallPkgResp output
				END
			END
		END
		ELSE IF @isArchivingFeatureEnabled = 0 -- Delete some props and call work queue token for subclient content change
		BEGIN
			--If Archiving disabled from client
			UPDATE APP_SubClientProp SET modified = @nowTime
			WHERE componentNameId = @subClientId
AND attrName = 'Turbo Mode Enable Stubbing'
			SET @workQueueParam = CONVERT( NVARCHAR(MAX),(SELECT @subClientId AS '@subclientID' FOR XML PATH('TMMsg_SubclientChangeReq'), TYPE))
			INSERT INTO @workQOutPutTbl
			EXEC AppWorkQueueSubmitRequest 7/*WORK_TOKEN_SUBCLIENT_CONTENT*/, 0, 0, @clientId, 0, @workQueueParam
			SELECT @errorCode = errCode, @errorString = errString FROM @workQOutPutTbl
		END
		IF @clientOSType != @i_osType --If MAC
		BEGIN
			--For updating subclient props and pushing Work token for Subclient Content change
			IF @isArchivingFeatureEnabled = 1
			BEGIN
				SET @pushSCChangeWQ = 1
			END
			ELSE
			BEGIN
				SET @pushSCChangeWQ = 0
			END
			SET @idaPropReqChangeReq = (SELECT @isArchivingFeatureEnabled AS '@isArchiverDriverEnabled',(
										SELECT @subClientId AS '@applicationId', 4 /*APPTYPE_ENTITY*/ AS '@_type_'
										FOR XML PATH('Idainfo'), TYPE)
									FOR XML PATH('App_AppIDAPropModification'), TYPE)
			SET @workQueueParam = CONVERT( NVARCHAR(MAX), @idaPropReqChangeReq)
			DELETE FROM @workQOutPutTbl
			INSERT INTO @workQOutPutTbl
			EXEC AppWorkQueueSubmitRequest 36/*WORK_TOKEN_IDA_PROP_MODIFIED*/, 0, 0, @clientId, 0, @workQueueParam
			SELECT @errorCode = errCode, @errorString = errString FROM @workQOutPutTbl
		END
		IF @pushSCChangeWQ = 1
		BEGIN
			--Updating Subclient properties
			UPDATE APP_SubClientProp SET modified = @nowTime
			WHERE componentNameId = @subClientId
AND attrName IN ('Is Archive Retention Mode Enabled','User deleted stubs expiration days','Turbo Mode Enable Stubbing','Enable Redundancy For Data Backedup')
			AND modified = 0
			INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
VALUES(@subClientId,'Is Archive Retention Mode Enabled', 7, 1 , @nowTime, 0, 0),
(@subClientId,'User deleted stubs expiration days', 7, @retentionDaysFromPolicy , @nowTime, 0, 0),
(@subClientId,'Turbo Mode Enable Stubbing' , 2, 1 , @nowTime, 0, 0),
(@subClientId,'Enable Redundancy For Data Backedup' , 2, 1 , @nowTime, 0, 0)
			--Updating Ida properties
IF NOT EXISTS( SELECT 1 FROM APP_IDAProp IP where IP.attrName = 'Enable Archive' AND IP.modified = 0
							AND IP.componentNameId =
								(
									SELECT id FROM APP_IDAName WHERE clientId = @clientId AND appTypeId IN (SELECT appTypeId FROM APP_AppTypeGroupAssoc WHERE appGroupId IN (34,57) /*APPGRP_UnixFileSystem, APPGRP_WindowsFileSystemIDA */	)
								)
						 )
			BEGIN
				INSERT INTO APP_IDAProp
SELECT AG.id,'Enable Archive' , 2, 1 , @nowTime, 0, 0
						FROM APP_IDAName AG
						WHERE AG.appTypeId IN (
							select appTypeId from APP_AppTypeGroupAssoc where appGroupId IN ( 57, 34) /*APPGRP_WindowsFileSystemIDA*/
						)
						AND AG.clientId = @clientId
			END
IF NOT EXISTS( SELECT 1 FROM APP_IDAProp IP where IP.attrName = 'Use Archiver Driver' AND IP.modified = 0
							AND IP.componentNameId =
								(
									SELECT id FROM APP_IDAName WHERE clientId = @clientId AND appTypeId IN (SELECT appTypeId FROM APP_AppTypeGroupAssoc WHERE appGroupId = 34 /*APPGRP_UnixFileSystem*/	)
								)
						 )
			BEGIN
				INSERT INTO APP_IDAProp
SELECT AG.id,'Use Archiver Driver' , 2, 1 , @nowTime, 0, 0
						FROM APP_IDAName AG
						WHERE AG.appTypeId IN (
							select appTypeId from APP_AppTypeGroupAssoc where appGroupId = 34 /*APPGRP_UnixFileSystem*/
						)
						AND AG.clientId = @clientId
			END
			SET @workQueueParam = CONVERT( NVARCHAR(MAX),(SELECT @subClientId AS '@subclientID' FOR XML PATH('TMMsg_SubclientChangeReq'), TYPE))
			DELETE FROM @workQOutPutTbl
			INSERT INTO @workQOutPutTbl
			EXEC AppWorkQueueSubmitRequest 7/*WORK_TOKEN_SUBCLIENT_CONTENT*/, 0, 0, @clientId, 0, @workQueueParam
			SELECT @errorCode = errCode, @errorString = errString FROM @workQOutPutTbl
		END
	END
------------------------------------------------------
-- Audit Trail
------------------------------------------------------
SET @opMsgId = (273 | (CAST(POWER(2, 24) AS BIGINT) * 84))
EXEC EvGuiAuditSetOperation @opMsgId, @userId, @opEvMsgId OUTPUT, @opId OUTPUT
--Feature Enabled/Disabled
SET @paramMsgId  = (1578 | (CAST(POWER(2, 24) AS BIGINT) * 85))
 SET @paramData = IIF(@isArchivingFeatureEnabled = 1,'Enabled','Disabled')
 EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
 EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
--User
SET @paramMsgId  = (1189 | (CAST(POWER(2, 24) AS BIGINT) * 85))
 SET @paramData = (SELECT login FROM UMUsers WHERE id = @userId)
 EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
 EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
--Client
SET @paramMsgId  = (1436 | (CAST(POWER(2, 24) AS BIGINT) * 85))
 SET @paramData = (SELECT name FROM App_Client WHERE id = @clientId)
 EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
 EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
------------------------------------------------------
-- End Archiving Feature
------------------------------------------------------
	if OBJECT_ID('tempdb.dbo.#existingpermissions') is not null drop table dbo.#existingpermissions
	if OBJECT_ID('tempdb.dbo.#newpermissions') is not null drop table dbo.#newpermissions
	if OBJECT_ID('tempdb.dbo.#mergedpermissions') is not null drop table dbo.#mergedpermissions
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
            SET @errorCode = ERROR_NUMBER()
            SET @errorString = N'Error During SP Execution. Error Message :' + ERROR_MESSAGE()
END  CATCH
GENERATE_OUTPUT:
	SET @oxml = (
					SELECT	@errorCode as '@errorCode',
							@errorString as '@errorMessage'
								FOR XML PATH ( 'App_GenericResp' ),TYPE
				 )
	SELECT @oxml
GO

IF EXISTS (select * from GxQscripts where name = 'AppModifyClientFeatures')
	delete from GxQscripts where name = 'AppModifyClientFeatures'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppModifyClientFeatures')
	delete from GXDBVersions where aliasname = 'AppModifyClientFeatures'
GO

insert into GXDBVersions values(2, 'AppModifyClientFeatures',  '00000000000000000000', 'AppModifyClientFeatures', '00000000000000000000')
GO

