

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppMigrateSRMSubClients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sumit Kumar Gupta
--	Date:   06/30/2009
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppMigrateSRMSubClients.sp,v $ $Id: AppMigrateSRMSubClients.sp,v 1.7.274.1 2018/03/27 08:00:08 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppMigrateSRMSubClients <<<'

IF EXISTS (select * from sysobjects where name='AppMigrateSRMSubClients')
	drop procedure AppMigrateSRMSubClients
IF EXISTS (select * from GxQscripts where name='AppMigrateSRMSubClients')
	delete from GxQscripts where name = 'AppMigrateSRMSubClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppMigrateSRMSubClients')
	delete from GXDBVersions where aliasname = 'AppMigrateSRMSubClients'
GO
print '... Creating Procedure: AppMigrateSRMSubClients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppMigrateSRMSubClients
  @i_ClientId INTEGER = 0,
  @errCode integer			OUTPUT,
  @errString varchar(1024)	OUTPUT
AS
SET NOCOUNT ON
DECLARE @tbl_ListofSubClients	TABLE (id INTEGER, subclientName nvarchar(128), subclientStatus INTEGER)
DECLARE @tbl_ListofSRMXMLBlob	TABLE (ClientId INTEGER, attrVal nvarchar(MAX))
DECLARE @tbl_temp				TABLE (componentNameId INTEGER, contentType INTEGER, filePathName nvarchar(1024))
DECLARE @Client_XMLBlob XML
DECLARE @Created integer;
DECLARE @totalRows		INTEGER
DECLARE @loc			INTEGER
DECLARE @l_appType		INTEGER
DECLARE @createTime			INTEGER
SET @createTime = dbo.getunixtime(GETUTCDATE())
SET @l_appType = 600
SET @totalRows = 0
SET @loc = 0
SET @errCode = 0
SET @errString = 'SUCCESS'
	INSERT INTO @tbl_ListofSubClients
	SELECT Id, subclientName, subclientStatus FROM [APP_Application] WITH (READUNCOMMITTED)
	WHERE appTypeId = 600 AND clientId = @i_ClientId AND (subclientStatus = 0 OR subclientStatus = 8)
	INSERT INTO @tbl_ListofSRMXMLBlob
	SELECT componentNameId, attrVal FROM [APP_SubClientProp] WITH (READUNCOMMITTED)
	WHERE componentNameId IN (SELECT Id from @tbl_ListofSubClients)
	AND attrName = 'SRM Content Blob' AND modified = 0
	UPDATE APP_SubClientProp SET modified = @createTime
		FROM APP_SubClientProp AS scProp
			INNER JOIN APP_Application AS apln
			ON apln.appTypeId in (600, 603)
				AND apln.clientId = @i_ClientId
				AND apln.subclientStatus in (0, 8)
				AND apln.id = scProp.componentNameId
				AND scProp.attrName = 'SRM Data Collection Options'
				AND scProp.modified = 0
	INSERT INTO [APP_SubClientProp] (componentNameId,attrName, attrType, attrVal, created, modified)
	SELECT id, 'SRM Data Collection Options', 10, 257, @createTime, 0
	FROM [APP_Application]
	WHERE appTypeId in ( 600, 603) AND clientId = @i_ClientId AND (subclientStatus = 0 OR subclientStatus = 8)
	INSERT INTO @tbl_temp (componentNameId, contentType, filePathName)
	SELECT id, 1, '\' FROM @tbl_ListofSubClients
	WHERE subclientStatus = 8
	DECLARE srmFSSubClientXMLBlob CURSOR FOR
		SELECT DISTINCT attrVal FROM @tbl_ListofSRMXMLBlob
	OPEN srmFSSubClientXMLBlob
		FETCH NEXT FROM srmFSSubClientXMLBlob INTO @Client_XMLBlob
		WHILE @@FETCH_STATUS = 0
			BEGIN
				INSERT INTO @tbl_temp (componentNameId, contentType, filePathName)
				SELECT
						id, 1, IncludePath.SimplePath.value('.', 'nvarchar(max)')
				FROM
						@tbl_ListofSubClients, @Client_XMLBlob.nodes('/FSSubclient/include/SimplePath') IncludePath(SimplePath)
						WHERE subclientName = IncludePath.SimplePath.value('../../@Name', 'nvarchar(128)')
				INSERT INTO @tbl_temp (componentNameId, contentType, filePathName)
				SELECT
						id, 2, ExceptionPath.WCPath.value('.', 'nvarchar(max)')
				FROM
						@tbl_ListofSubClients, @Client_XMLBlob.nodes('/FSSubclient/exception/WCPath') ExceptionPath(WCPath)
						WHERE subclientName = ExceptionPath.WCPath.value('../../@Name', 'nvarchar(128)')
				INSERT INTO @tbl_temp (componentNameId, contentType, filePathName)
				SELECT
						id, 3, ExcludePath.WCPath.value('.', 'nvarchar(max)')
				FROM
						@tbl_ListofSubClients, @Client_XMLBlob.nodes('/FSSubclient/exclude/WCPath') ExcludePath(WCPath)
						WHERE subclientName = ExcludePath.WCPath.value('../../@Name', 'nvarchar(128)')
				FETCH NEXT FROM srmFSSubClientXMLBlob INTO @Client_XMLBlob
			END
	CLOSE srmFSSubClientXMLBlob
	DEALLOCATE srmFSSubClientXMLBlob
	SET @Created = DATEDIFF(second,'1/1/1970',GETUTCDATE())
	UPDATE APP_ScFilterFile SET modified = @createTime
	FROM APP_ScFilterFile AS scFilter
		INNER JOIN @tbl_temp AS tmpTbl
			ON scFilter.componentNameId = tmpTbl.componentNameId
			AND scFilter.type = tmpTbl.contentType
			AND scFilter.fileName = tmpTbl.filePathName
			AND scFilter.modified = 0
	INSERT INTO [APP_ScFilterFile]
	SELECT
			componentNameId, contentType, filePathName, @Created, 0, 0
	FROM
			@tbl_temp
	IF (@@ERROR <> 0)
	BEGIN
		SET @errCode = @@ERROR
		SET @loc = @loc + 1
		SET @errString = 'AppMigrateSRMSubClients: Failed to insert data into APP_ScFilterFile.. Location: ' + CONVERT(VARCHAR, @loc, 10)
		GOTO ERROR_EXIT
	END
	SET @totalRows = @totalRows + @@ROWCOUNT
	--Setting the Storage Policy of all subclients to Analytics Policy
	DECLARE @analyticsPolicy INTEGER
	SET @analyticsPolicy = NULL
	SELECT @analyticsPolicy = id FROM archGroup WITH (READUNCOMMITTED) WHERE (type = 4 AND name LIKE 'Analytics Policy');
	IF (@analyticsPolicy = NULL)
	BEGIN
		SET @errCode = -1
		SET @loc = @loc + 1
		SET @errString = 'ANALYTICS POLICY not found in archGroup table'
		GOTO ERROR_EXIT
	END
	ELSE
		UPDATE APP_Application SET dataArchGrpID = @analyticsPolicy WHERE (clientId = @i_ClientId AND appTypeId = @l_appType);
ERROR_EXIT:
		--SELECT  @errCode , @errString
GO

IF EXISTS (select * from GxQscripts where name = 'AppMigrateSRMSubClients')
	delete from GxQscripts where name = 'AppMigrateSRMSubClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppMigrateSRMSubClients')
	delete from GXDBVersions where aliasname = 'AppMigrateSRMSubClients'
GO

insert into GXDBVersions values(2, 'AppMigrateSRMSubClients',  '00010007027400010000', 'AppMigrateSRMSubClients', '00010007027400010000')
GO

