

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppMigrateExchangeMBFromClassicAgent.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  AppMigrateExchangeMBFromClassicAgent()
--  |				 Description:  To migrate mailboxes configuration from classic agent to Exchange One pass
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppMigrateExchangeMBFromClassicAgent.sp,v $ $Id: AppMigrateExchangeMBFromClassicAgent.sp,v 1.1.4.9 2020/08/24 15:17:24 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppMigrateExchangeMBFromClassicAgent')
BEGIN
	print '>>> Drop Stored Procedure: AppMigrateExchangeMBFromClassicAgent <<<'
	drop procedure AppMigrateExchangeMBFromClassicAgent
END
IF EXISTS (select * from GxQscripts where name='AppMigrateExchangeMBFromClassicAgent')
	delete from GxQscripts where name = 'AppMigrateExchangeMBFromClassicAgent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppMigrateExchangeMBFromClassicAgent')
	delete from GXDBVersions where aliasname = 'AppMigrateExchangeMBFromClassicAgent'
GO
print '... Creating Procedure: AppMigrateExchangeMBFromClassicAgent'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppMigrateExchangeMBFromClassicAgent
  @xmlReq XML OUTPUT
AS
SET NOCOUNT ON
BEGIN TRY
BEGIN TRAN
DECLARE	@i_jobId			INT
DECLARE	@errorCode			INT
DECLARE @refAppId			INT
DECLARE @inXml				XML
DECLARE @userId				INT
DECLARE @isPSTArchvingSC	INT
SET @errorCode = 0
SET @i_jobId	=	ISNULL((SELECT ref.value('@jobId', 'INT') FROM @xmlReq.nodes('App_MigratePSTMbxInfo') R(ref)), 0)
SET @refAppId	=	ISNULL((SELECT ref.value('@appId', 'INT') FROM @xmlReq.nodes('App_MigratePSTMbxInfo') R(ref)), 0)
SET @userId		=	ISNULL((SELECT ref.value('@userId', 'INT') FROM @xmlReq.nodes('App_MigratePSTMbxInfo') R(ref)), 0)
SET @isPSTArchvingSC = ISNULL((SELECT ref.value('@isPSTArchivingSubclient', 'INT') FROM @xmlReq.nodes('App_MigratePSTMbxInfo') R(ref)), 0)
IF @userId = 0 -- From the index server
BEGIN
	SET @userId = ISNULL((select distinct userId From JMJobInfo(READUNCOMMITTED) where jobId = @i_jobId), 0)
	IF @userId = 0
		SET @userId = ISNULL((Select top 1 id From UmUsers where name = (SELECT userName From JMBkpStats(READUNCOMMITTED) Where jobid = @i_jobId)), 1)
END
-- None of these temp tables should ever exist when this procedure is called!
IF object_id('tempdb.dbo.#mailboxTbl') IS NOT NULL
	DROP TABLE #mailboxTbl
CREATE TABLE #mailboxTbl
(
	componentId			int,
	userGUID			varchar(64),
	displayName			nvarchar(512),
	aliasName			nvarchar(512),
	smtpAddress			nvarchar(512),
	associated			int,
	autoDiscoveredUser	int,
	mailboxType			int
)
DECLARE @policies TABLE
(
	policyId		int,
	policyName		varchar(128),
	policyType		int
)
DECLARE @AssocRespTbl	TABLE
(
	respXML		XML
)
DECLARE @scStatsTbl TABLE
(
	appId  int,
	status int,
	appGUID varchar(128)
)
DECLARE @scStats XMl
IF @isPSTArchvingSC > 0
BEGIN
	INSERT INTO #mailboxTbl
	SELECT
	0/*Not Applicable*/,
	ref.value('@mbxGUID','varchar(1024)'),
	ref.value('@displayName','varchar(1024)'),
	ref.value('@displayName','varchar(1024)'),
	ref.value('@smtpAddress','varchar(1024)'),
	0/*Associated*/,
	1/*Auto Discovered*/,
	1/*user mailbox*/
	FROM
	@xmlReq.nodes('/App_MigratePSTMbxInfo/pstMbxs') R(ref)
END
ELSE
BEGIN
	INSERT INTO #mailboxTbl
	SELECT componentId, [1103], [1102], [1101], [1100], 0/*Associated*/, 1/*Auto Discovered*/, 1/*user mailbox*/
	FROM (
	select stringVal, componentId, propertyTypeId From APP_ComponentProp Where componentId In
		(select id From APP_SubClientProp Where componentNameId IN(select distinct srcAppId From JMReferenceCopy(READUNCOMMITTED) where refJobId = @i_jobId))
		and propertyTypeId IN(1100/*CV_COMPONENT_EXMB_MAILBOX*/, 1101/*CV_COMPONENT_EXMB_ALIASNAME*/, 1102/*CV_COMPONENT_EXMB_DISPLAYNAME*/, 1103/*CV_COMPONENT_EXMB_GUID*/)) up
	PIVOT (MAX(stringVal) FOR propertyTypeId IN ([1100], [1101], [1102], [1103])) AS pvt
	ORDER BY componentId
	-- Remove the entries where the GUID is emtpy
	DELETE FROM #mailboxTbl Where LEN(userGUID) = 0
	UPDATE #mailboxTbl
	SET userGUID = REPLACE(REPLACE(userGUID, '{', ''), '}', '')
END
-- Remove the duplicate mailboxes
;With mailboxTblCTE As
(
select userGUID, ROW_NUMBER() OVER(PARTITION BY userGUID ORDER BY userGUID) as RowNum
From #mailboxTbl
)
Delete From mailboxTblCTE Where RowNum > 1;
-- For policies
INSERT INTO @policies VALUES(0/*PolicyId*/, ''/*PolicyName*/, 1/*policyType*/)
INSERT INTO @policies VALUES(0/*PolicyId*/, ''/*PolicyName*/, 2/*policyType*/)
INSERT INTO @policies VALUES(0/*PolicyId*/, ''/*PolicyName*/, 3/*policyType*/)
SET @inXml = (
SELECT
(
	(
		SELECT
		(
			SELECT
			1 '@enableAutoDiscovery'
			FOR XML PATH('advanceOptions'), TYPE
		),
		(
			SELECT
			1 '@discoverByType',
			1 '@fromClassicAgent',
			0 '@isOverWriteIfExists',
			(
				SELECT
					aliasName '@aliasName',
					displayName '@displayName',
					smtpAddress '@smtpAdrress',
					associated '@associated',
					autoDiscoveredUser '@isAutoDiscoveredUser',
					mailboxType '@mailBoxType',
					userGUID 'user/@userGUID',
13 'user/@_type_'
				FROM #mailboxTbl
				WHERE len(userGUID) > 0
				FOR XML PATH('mailBoxes'), TYPE
			)
			FOR XML PATH('emailDiscoverinfo'), TYPE
		),
		(
			SELECT
				policyId 'policyEntity/@policyId',
				policyName 'policyEntity/@policyName',
				policyType 'detail/emailPolicy/@emailPolicyType'
			FROM @policies
			FOR XML PATH('emailPolicies'), ROOT('policies'), TYPE
		),
		(
			SELECT
				A.id		'@subclientId',
				A.instance	'@instanceId',
				A.backupSet '@backupsetId',
				A.appTypeId '@applicationId',
				A.clientId '@clientId'
			FROM APP_Application(READUNCOMMITTED) A
			Where A.id = @refAppId
			FOR XML PATH('subclientEntity'), TYPE
		)
		FOR XML PATH('emailAssociation'),TYPE
	)
)
FOR XML PATH('Ida_SetEmailPolicyAssociationReq')
)
SET @inXml.modify('insert <processinginstructioninfo><user/></processinginstructioninfo>
	into (/Ida_SetEmailPolicyAssociationReq)[1]')
SET @inXml.modify('insert attribute userId {sql:variable("@userId")}
	into (/Ida_SetEmailPolicyAssociationReq/processinginstructioninfo/user)[1]')
INSERT INTO @AssocRespTbl
EXEC AppEmailConfigPolicyAssocSetInfo @inXml
SET @scStats = (select top 1 xmlJobInfo From JMReferenceCopyJobStats(NOLOCK) where jobid = @i_jobId)
INSERT INTO @scStatsTbl
SELECT
ISNULL(Tbl.Col.value('@subclientId', 'int'),0),
ISNULL(Tbl.Col.value('@status', 'int'),0),
''
FROM @scStats.nodes('/JobManager_RefCopyJobStats/SourceSubClientStats') as Tbl(Col)
UPDATE sc
SET sc.appGUID = App.guid
FROM @scStatsTbl sc, App_Application(NOLOCK) App
Where App.id =  sc.appId
MERGE App_SubclientProp scProp
USING @scStatsTbl refStats
ON scProp.componentNameId = @refAppId AND scProp.attrName = 'MigratedFromClassic_AppGUID' AND scProp.attrVal = cast(refStats.appGUID as nvarchar(max)) AND scProp.modified = 0 AND refStats.status IN(4,5,6)/*RefCopyStatusFlags*/
WHEN NOT MATCHED THEN
INSERT (componentnameid, attrname, attrtype, attrval, created, modified)
VALUES (@refAppId, 'MigratedFromClassic_AppGUID', 2, cast(refStats.appGUID as nvarchar(max)), dbo.getunixtime(getutcdate()), 0);
DROP TABLE #mailboxTbl
COMMIT TRAN
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = 1
	ROLLBACK TRANSACTION
	THROW;
END CATCH;
SELECT @xmlReq = (
				SELECT
					@errorCode '@errorCode'
					FOR XML PATH('App_GenericResp')
			  )
GO

IF EXISTS (select * from GxQscripts where name = 'AppMigrateExchangeMBFromClassicAgent')
	delete from GxQscripts where name = 'AppMigrateExchangeMBFromClassicAgent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppMigrateExchangeMBFromClassicAgent')
	delete from GXDBVersions where aliasname = 'AppMigrateExchangeMBFromClassicAgent'
GO

insert into GXDBVersions values(2, 'AppMigrateExchangeMBFromClassicAgent',  '00010001000400090000', 'AppMigrateExchangeMBFromClassicAgent', '00010001000400090000')
GO

