

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppMessageCacheEnable.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppMessageCacheEnable.sp,v $ $Id: AppMessageCacheEnable.sp,v 1.3.60.2 2018/03/22 01:43:21 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppMessageCacheEnable <<<'

IF EXISTS (select * from sysobjects where name='AppMessageCacheEnable')
	drop procedure AppMessageCacheEnable
IF EXISTS (select * from GxQscripts where name='AppMessageCacheEnable')
	delete from GxQscripts where name = 'AppMessageCacheEnable'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppMessageCacheEnable')
	delete from GXDBVersions where aliasname = 'AppMessageCacheEnable'
GO
print '... Creating Procedure: AppMessageCacheEnable'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure AppMessageCacheEnable
-- Input arguments
  @i_jobId integer = 0
AS
  DECLARE @o_errorCode int
  DECLARE @o_errorCodeStr nvarchar(1024)
SET @o_errorCode = 0
SET NOCOUNT ON
BEGIN TRY
	DECLARE	@currentTime	 INTEGER
	SET	@currentTime = dbo.GetUnixTime(GetUTCDate())
	IF NOT EXISTS( SELECT jobId FROM JMJobInfo WHERE jobId=@i_jobId)
	BEGIN
		SET @o_errorCode = 1
		SET @o_errorCodeStr = N'There is no job info for given jobId in JMJobInfo table.'
	END
	ELSE
	BEGIN
		INSERT INTO APP_MessageCacheConfig (jobId,jobPhaseId,commCellId,createTime,flag)
		SELECT @i_jobId, currentPhase, commCellId, @currentTime, 0
		FROM JMJobInfo JM
		WHERE JM.jobId = @i_jobId
		AND NOT EXISTS (SELECT APP.jobId FROM APP_MessageCacheConfig APP WHERE APP.jobId = @i_jobId AND APP.jobPhaseId = JM.currentPhase AND APP.commCellId = JM.commCellId)
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	set @o_errorCode = 2
	set @o_errorCodeStr = N'Failed to populate APP_MessageCacheConfig. Error code [' + CAST(ERROR_NUMBER() AS NVARCHAR(10)) + ']. ' + ERROR_MESSAGE()
END CATCH
SELECT @o_errorCode, @o_errorCodeStr
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppMessageCacheEnable')
	delete from GxQscripts where name = 'AppMessageCacheEnable'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppMessageCacheEnable')
	delete from GXDBVersions where aliasname = 'AppMessageCacheEnable'
GO

insert into GXDBVersions values(2, 'AppMessageCacheEnable',  '00010003006000020000', 'AppMessageCacheEnable', '00010003006000020000')
GO

