

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppMessageCacheAddMessage.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppMessageCacheAddMessage.sp,v $ $Id: AppMessageCacheAddMessage.sp,v 1.4.60.2 2018/03/22 01:30:54 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppMessageCacheAddMessage <<<'

IF EXISTS (select * from sysobjects where name='AppMessageCacheAddMessage')
	drop procedure AppMessageCacheAddMessage
IF EXISTS (select * from GxQscripts where name='AppMessageCacheAddMessage')
	delete from GxQscripts where name = 'AppMessageCacheAddMessage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppMessageCacheAddMessage')
	delete from GXDBVersions where aliasname = 'AppMessageCacheAddMessage'
GO
print '... Creating Procedure: AppMessageCacheAddMessage'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure AppMessageCacheAddMessage
-- Input arguments
  @i_jobId integer = 0,
  @i_msgType integer = 0,
  @i_msgData varchar(max)
AS
  DECLARE @o_errorCode int
  DECLARE @o_errorCodeStr nvarchar(1024)
SET @o_errorCode = 0
SET NOCOUNT ON
BEGIN TRY
	DECLARE	@currentTime	 INTEGER
	SET	@currentTime = dbo.GetUnixTime(GetUTCDate())
	IF NOT EXISTS( SELECT jobId FROM JMJobInfo WHERE jobId=@i_jobId)
	BEGIN
		SET @o_errorCode = 1
		SET @o_errorCodeStr = N'There is no job info for given jobId in JMJobInfo table.'
	END
	ELSE
	BEGIN
		INSERT INTO APP_MessageCacheRequests (jobTypeId,jobPhaseId,subclientId,msgType,msgData,createTime,flag)
		SELECT JMJ.opType, JMJ.currentPhase, JMB.applicationId, @i_msgType, @i_msgData, @currentTime, 0
		FROM JMJobInfo JMJ,  JMBkpJobInfo JMB
		WHERE JMJ.jobId = @i_jobId AND JMB.jobId = @i_jobId
		AND JMJ.opType = 4
		AND NOT EXISTS (SELECT APP.jobTypeId
						FROM APP_MessageCacheRequests APP
						WHERE APP.jobTypeId = JMJ.opType AND APP.jobPhaseId = JMJ.currentPhase
						AND APP.subclientId = JMB.applicationId AND APP.msgType = @i_msgType
						AND APP.msgData = @i_msgData)
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	set @o_errorCode = 2
	set @o_errorCodeStr = N'Failed to add message to APP_MessageCacheRequests. Error code [' + CAST(ERROR_NUMBER() AS NVARCHAR(10)) + ']. ' + ERROR_MESSAGE()
END CATCH
SELECT @o_errorCode, @o_errorCodeStr
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppMessageCacheAddMessage')
	delete from GxQscripts where name = 'AppMessageCacheAddMessage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppMessageCacheAddMessage')
	delete from GXDBVersions where aliasname = 'AppMessageCacheAddMessage'
GO

insert into GXDBVersions values(2, 'AppMessageCacheAddMessage',  '00010004006000020000', 'AppMessageCacheAddMessage', '00010004006000020000')
GO

