

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppMarkProviderForDelete.sp] ---------- 

--  +===========================================================================+
--  |		 		 Name:  AppMarkProviderForDelete()
--  | Description:  Mark Provider For Delete. will be deleted by EVMGRS Thread.
--  +===========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppMarkProviderForDelete.sp,v $ $Id: AppMarkProviderForDelete.sp,v 1.1.2.23 2020/11/20 15:11:09 jswaminathan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppMarkProviderForDelete')
BEGIN
	print '>>> Drop Stored Procedure: AppMarkProviderForDelete <<<'
	drop procedure AppMarkProviderForDelete
END
IF EXISTS (select * from GxQscripts where name='AppMarkProviderForDelete')
	delete from GxQscripts where name = 'AppMarkProviderForDelete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppMarkProviderForDelete')
	delete from GXDBVersions where aliasname = 'AppMarkProviderForDelete'
GO
print '... Creating Procedure: AppMarkProviderForDelete'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppMarkProviderForDelete
  @i_userId INTEGER,
  @i_providerId INTEGER,
  @i_localeId INTEGER,
  @o_errCode INTEGER OUTPUT,
  @o_errString NVARCHAR(1024) OUTPUT,
  @o_warnCode INTEGER OUTPUT,
  @o_warnString NVARCHAR(1024) OUTPUT
AS
  DECLARE @errorCode INTEGER
  DECLARE @errorString NVARCHAR(1024)
  DECLARE @warningCode INTEGER
  DECLARE @warningString NVARCHAR(1024)
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
DECLARE @canManageProvider INT
DECLARE @providerTable table (id int, hostName nvarchar(4000))
BEGIN TRY
	-- local variables
	DECLARE @nowTime AS integer = dbo.GetUnixTime (GetUTCdate())
EXEC sec_checkPermissionOnEntity @i_userId, 1, @canManageProvider OUTPUT, 61, @i_providerId
	DECLARE @companyId INT
	SET @companyId = dbo.AppGetOrganizationForUser(@i_userId)
	SET @o_warnCode = 0
	SET @o_warnString = ''
IF @canManageProvider = 1 AND @companyId <> @i_providerId -- cannot delete it's own company
BEGIN
	-- Deletion of company is allowed only when it is deactivated.
IF EXISTS(SELECT 1 FROM UMDSProviders WITH (NOLOCK) WHERE id = @i_providerId AND serviceType = 5 AND
((flags & 0x0010) = 0) )
	BEGIN
SET @o_errCode = (3900 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errString =  (SELECT message FROM EvLocaleMsgs WHERE messageId = (3900 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @i_localeId)
		GOTO SCRIPT_EXIT
	END
	DECLARE @companyClientGroupId INT = 0
SET @companyClientGroupId = ISNULL((SELECT attrValInt FROM App_CompanyProp WHERE attrName='Associated Smart Client Group' AND componentNameId=@i_providerId AND modified=0 AND cs_attrName = CHECKSUM('Associated Smart Client Group')),0)
	--clear flag from client group
UPDATE App_clientGroup SET flag = flag & ~(1073741824) WHERE ID = @companyClientGroupId
	-- Get owner company of company about to be deleted
	DECLARE @ownerCompany INT = (SELECT UD.ownerCompany FROM UMDSProviders UD WHERE UD.id=@i_providerId)
		INSERT INTO @providerTable
		SELECT id, hostName
				FROM UMDSProviders WHERE ownerCompany = @i_providerId
AND serviceType<>5
		UNION
		SELECT id, hostName FROM UMDSProviders WHERE Id = @i_providerId
		UPDATE UMDSProviders
		SET
			ownerCompany = @ownerCompany
WHERE ownerCompany=@i_providerId AND serviceType=5
		-- Mark provided Company and all its child in its tree to get deleted
		UPDATE UMDSProviders
			SET
flags = flags | 0x0002 ,
				enabled=0,
				domainName = domainName + '(Deleted,' +convert(varchar(8),id) + ')'
			WHERE id in (SELECT DISTINCT id FROM @providerTable)
		-- For All the users of below Providers, mark all there users as hidden
		-- USERS_HIDE
UPDATE UMUsers SET flags= flags | 0x004,login = login + '(Deleted,' +convert(varchar(8),id) + ')'  WHERE umDSproviderId IN (SELECT DISTINCT id FROM @providerTable)
		-- For All the users of below Providers, mark all there users groups as hidden
		-- GF_GROUP_HIDDEN
UPDATE UMGroups SET groupFlags= groupFlags | 0x0010  WHERE umDSproviderId IN (SELECT DISTINCT id FROM @providerTable)
		-- Delete all alerts for all organizations
		Update NTNotificationrule
		set revision=0,status=2
		where id in
		(
			select componentnameid from NTNotificationProp with (readuncommitted)
where attrName='OrganizationId' and attrVal in
			(
				SELECT DISTINCT providerTable.id FROM @providerTable providerTable
			)
			and modified=0
		)
		-- If some one has this company set as default company, delete it.
DELETE FROM UMUsersProp WHERE attrName = 'DefaultOperatorCompany' AND attrVal = CAST(@i_providerId AS VARCHAR(10))
        --Auditing
        DECLARE @opMsgId INTEGER
        DECLARE @opEvMsgId          INTEGER
        DECLARE @opId               INTEGER
        DECLARE @paramMsgId         INTEGER
        DECLARE @paramData          NVARCHAR(MAX)
        DECLARE @dataIsEvent        INTEGER
        DECLARE @companyName nvarchar(4000)
        DECLARE companyCur CURSOR LOCAL FORWARD_ONLY STATIC READ_ONLY FOR
                  SELECT hostname FROM @providerTable
            OPEN companyCur
            FETCH NEXT FROM companyCur INTO @companyName
            WHILE @@FETCH_STATUS = 0
            BEGIN
SET @opMsgId = (227 | (CAST(POWER(2, 24) AS BIGINT) * 84))
                EXEC EvGuiAuditSetOperation @opMsgId, @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
                SET @dataIsEvent = 0
SET @paramMsgId  = (1623 | (CAST(POWER(2, 24) AS BIGINT) * 85))
                EXEC EvGuiAuditSetParamData @opId, @companyName, @dataIsEvent
                EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
                FETCH NEXT FROM companyCur INTO @companyName
            END
            CLOSE companyCur
            DEALLOCATE companyCur
		SET @o_errCode = 0
		SET @o_errString = ''
		------------- Following code looks for company plan, storage pool, storage policies, MA which are shared across MSP/ another company. We will not delete all such company entities ---------
		----- A. Look for company storage pools which are either shared with MSP or shared with another company i.e. any company apart from companies in providerTable. We can not delete such storage pools since dependent policy copies are still in use. ---------------------
		IF object_id('tempdb.dbo.#nonDeletableStoragePoolsTbl') is not null
        		DROP TABLE #nonDeletableStoragePoolsTbl
		create table #nonDeletableStoragePoolsTbl (name NVARCHAR(MAX),
				    			   entityId INT NOT NULL,
							   companyId INT NOT NULL
							   PRIMARY KEY(entityId))
		IF object_id('tempdb.dbo.#companyStoragePoolsTbl') is not null
        		DROP TABLE #companyStoragePoolsTbl
		create table #companyStoragePoolsTbl (name NVARCHAR(MAX),
				    				id INT NOT NULL,
									policyId INT NOT NULL,
									companyId INT NOT NULL
									PRIMARY KEY(id, policyId))
		INSERT INTO #companyStoragePoolsTbl
		SELECT DISTINCT AG.name, App.entityId, AGP.archGroupId, App.companyId
		FROM archCopyToGlobalPolicy A
		INNER JOIN App_CompanyEntities App
On App.entityType = 17 AND A.globalPolicyId = App.entityId
		INNER JOIN @providerTable P
			On P.id = App.companyId
		INNER JOIN archGroup AG
			ON AG.id = App.entityId
		INNER JOIN archGroupCopy AGP
			On AGP.id = A.copyId
		INSERT INTO #nonDeletableStoragePoolsTbl
		SELECT DISTINCT SPT.name, SPT.id, SPT.companyId
		FROM #companyStoragePoolsTbl SPT
		LEFT JOIN App_CompanyEntities App
On App.entityType = 17 AND App.entityId = SPT.policyId
		WHERE App.entityId is NULL /*MSP entity*/
				OR App.companyId NOT IN (SELECT id FROM @providerTable)   -- Pool is either shared with MSP policy or another company policy
		----- B. Look for company plans which are either being used by MSP or another company clients. We can not delete such plans -----
		IF object_id('tempdb.dbo.#nonDeletablePlansTbl') is not null
        		DROP TABLE #nonDeletablePlansTbl
		create table #nonDeletablePlansTbl (name NVARCHAR(MAX),
				    			   entityId INT NOT NULL,
							   companyId INT NOT NULL
							   PRIMARY KEY(entityId))
		IF object_id('tempdb.dbo.#companyPlansTbl') is not null
        		DROP TABLE #companyPlansTbl
		create table #companyPlansTbl (name NVARCHAR(MAX),
				    			   id INT NOT NULL,
							   companyId INT NOT NULL
							   PRIMARY KEY(id))
		INSERT INTO #companyPlansTbl
		SELECT DISTINCT AP.name, AP.id, ACE.companyId
		FROM App_plan AP WITH(NOLOCK)
		INNER JOIN App_CompanyEntities ACE WITH(NOLOCK)
ON ACE.entityId = AP.id AND ACE.entityType = 158
		INNER JOIN @providerTable P
			On P.id = ACE.companyId
		INSERT INTO #nonDeletablePlansTbl
		SELECT DISTINCT CPT.name, CPT.id, CPT.companyId
		FROM #companyPlansTbl CPT
		INNER JOIN APP_ClientProp ACP WITH(NOLOCK)
ON  ACP.attrName = 'Associated Plan'
				AND ACP.attrVal = CAST(CPT.id AS VARCHAR(32))
				AND ACP.modified = 0
		INNER JOIN App_Client CL WITH(NOLOCK)
			ON CL.id = ACP.componentNameId
AND ((CL.status & 0x00004) = 0)
AND ((CL.status & 0x00002) = 0)
		LEFT JOIN App_CompanyEntities ACE
ON ACE.entityId = CL.id AND ACE.entityType = 3
		WHERE  ACE.entityId is NULL /*MSP entity*/ OR ACE.companyId NOT IN (SELECT id FROM @providerTable)
		INSERT INTO #nonDeletablePlansTbl
		SELECT DISTINCT CPT.name, CPT.id, CPT.companyId
		FROM #companyPlansTbl CPT
		INNER JOIN APP_BackupSetProp BKP WITH(NOLOCK)
ON BKP.attrName = 'Associated Plan' AND BKP.attrVal = CAST(CPT.id AS VARCHAR(32)) AND BKP.modified = 0
		INNER JOIN APP_Application Appl WITH(NOLOCK)
			ON Appl.backupSet = BKP.componentNameId
		INNER JOIN App_client AC WITH(NOLOCK)
			ON AC.id = Appl.clientId
AND Appl.appTypeId <> 1030
AND ((AC.status & 0x00004) = 0)
AND ((AC.status & 0x00002) = 0)
		LEFT JOIN App_CompanyEntities ACE WITH(NOLOCK)
ON (ACE.entityId = BKP.componentNameId AND ACE.entityType = 6) OR
(ACE.entityId = AC.id AND ACE.entityType = 3)
		LEFT JOIN #nonDeletablePlansTbl NDPT
			ON NDPT.entityId = CPT.id
		WHERE  (ACE.entityId is NULL /*MSP entity*/ OR ACE.companyId NOT IN (SELECT id FROM @providerTable))
				AND NDPT.entityId is NULL
		INSERT INTO #nonDeletablePlansTbl
		SELECT DISTINCT CPT.name, CPT.id, CPT.companyId
		FROM #companyPlansTbl CPT
		INNER JOIN APP_SubClientProp SCPROP WITH(NOLOCK)
ON (SCPROP.cs_attrName = CHECKSUM(N'Associated Plan'))
AND (SCPROP.attrName = 'Associated Plan')
                    AND (SCPROP.modified = 0)
                    AND (SCPROP.attrVal =  CAST(CPT.id  AS NVARCHAR(32)))
		INNER JOIN APP_Application Appl
			ON Appl.id = SCPROP.componentNameId
AND (Appl.subclientStatus & 0x00004 = 0)
AND (Appl.subclientStatus &  0x00002 = 0)
		INNER JOIN App_client AC
			ON AC.id = Appl.clientId
AND Appl.appTypeId <> 1030
AND ((AC.status & 0x00004) = 0)
AND ((AC.status & 0x00002) = 0)
		LEFT JOIN App_CompanyEntities ACE WITH(NOLOCK)
ON (ACE.entityId = Appl.id AND ACE.entityType = 7) OR
(ACE.entityId = AC.id AND ACE.entityType = 3)
		LEFT JOIN #nonDeletablePlansTbl NDPT
			ON NDPT.entityId = CPT.id
		WHERE  (ACE.entityId is NULL /*MSP entity*/ OR ACE.companyId NOT IN (SELECT id FROM @providerTable))
				AND NDPT.entityId is NULL
		IF (SELECT COUNT(0)
			FROM #nonDeletablePlansTbl) > 0
		BEGIN
			DECLARE @nonDeletablePlans NVARCHAR(MAX)
			SET @nonDeletablePlans = STUFF((SELECT ', ' + name
								FROM #nonDeletablePlansTbl
								FOR XML PATH('')), 1, 2, '')
			UPDATE App_CompanyEntities
SET flags = flags | 0x4
			FROM App_CompanyEntities App
			INNER JOIN #nonDeletablePlansTbl NDP
ON App.entityType = 158
				AND App.entityId = NDP.entityId
				AND App.companyId = NDP.companyId
SET @o_warnCode = (4647 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_warnString +=  (SELECT message FROM EvLocaleMsgs WHERE messageId = (4647 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @i_localeId)
			SET @o_warnString =  REPLACE(@o_warnString, '^1%s', @nonDeletablePlans)
		END
		----- C. Look for company storage policies which are either used by MSP or another company clients. We can not delete such SP.  ------------
		IF object_id('tempdb.dbo.#nonDeletableStoragePoliciesTbl') is not null
        		DROP TABLE #nonDeletableStoragePoliciesTbl
		create table #nonDeletableStoragePoliciesTbl (name NVARCHAR(MAX),
				    			   entityId INT NOT NULL,
							   companyId INT NOT NULL
							   PRIMARY KEY(entityId))
			--- C1 -- Get storage policies which are not attached to plan
		INSERT INTO #nonDeletableStoragePoliciesTbl
		SELECT DISTINCT AG.name, AG.id, ACE.companyId
		FROM archGroup AG
		INNER JOIN App_CompanyEntities ACE
			ON ACE.entityId = AG.id
AND ACE.entityType = 17
AND AG.flags & (256 | 16384 | 33554432 | 8388608 | 536870912) = 0
		INNER JOIN @providerTable P
			On P.id = ACE.companyId
		INNER JOIN APP_Application Appl
			ON (Appl.dataArchGrpID = AG.id OR Appl.logArchGrpID = AG.id)
AND (Appl.subclientStatus & 0x00004 = 0)
AND (Appl.subclientStatus &  0x00002 = 0)
		INNER JOIN App_client AC
			ON AC.id = Appl.clientId
AND Appl.appTypeId <> 1030
AND ((AC.status & 0x00004) = 0)
AND ((AC.status & 0x00002) = 0)
		LEFT JOIN App_CompanyEntities ACE2
ON (ACE2.entityId = Appl.id AND ACE2.entityType = 7) OR
(ACE2.entityId = AC.id AND ACE2.entityType = 3)
		WHERE ACE2.entityId is NULL /*MSP entity*/
			OR ACE2.companyId NOT IN (SELECT id FROM @providerTable)
			-- C2. Get storage policies which are attached to company plan
		INSERT INTO #nonDeletableStoragePoliciesTbl
		SELECT DISTINCT AG.name, AG.id, NDP.companyId
		FROM archGroup AG
		INNER JOIN App_PlanProp APP
			ON App.attrName = 'Storage policy'
				AND App.attrVal = CAST (AG.id AS varchar(32))
		INNER JOIN #nonDeletablePlansTbl NDP
			ON NDP.entityId = APP.componentNameId
		IF (SELECT COUNT(0)
			FROM #nonDeletableStoragePoliciesTbl) > 0
		BEGIN
			DECLARE @nonDeletableStoragePolicies NVARCHAR(MAX)
			SET @nonDeletableStoragePolicies = STUFF((SELECT ', ' + name
								FROM #nonDeletableStoragePoliciesTbl
								FOR XML PATH('')), 1, 2, '')
			UPDATE App_CompanyEntities
SET flags = flags | 0x4
			FROM App_CompanyEntities App
			INNER JOIN #nonDeletableStoragePoliciesTbl SP
ON App.entityType = 17
				AND App.entityId = SP.entityId
				AND App.companyId = SP.companyId
SET @o_warnCode = (4648 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_warnString +=  (SELECT message FROM EvLocaleMsgs WHERE messageId = (4648 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @i_localeId)
			SET @o_warnString =  REPLACE(@o_warnString, '^1%s', @nonDeletableStoragePolicies )
		END
		-- Get company storage pools which are attached to non deletable plans of company. We cannot delete company pool if dependent plan is shared. ---
		INSERT INTO #nonDeletableStoragePoolsTbl
		SELECT DISTINCT SPT.name, SPT.id, SPT.companyId
		FROM #companyStoragePoolsTbl SPT
		INNER JOIN App_PlanProp APP
			ON App.attrName = 'Storage policy' AND App.attrVal = CAST (SPT.policyId AS varchar(32))
		INNER JOIN #nonDeletablePlansTbl AP
			ON AP.entityId = APP.componentNameId
		LEFT JOIN #nonDeletableStoragePoolsTbl NDSP
			ON NDSP.entityId = SPT.id
		WHERE NDSP.entityId is NULL
		-- Get company storage pools which are attached to non deletable storage policies (SP which are not attached to plans) of company. We cannot company pool if dependent policy is shared
		INSERT INTO #nonDeletableStoragePoolsTbl
		SELECT DISTINCT SPT.name, SPT.id, SPT.companyId
		FROM #companyStoragePoolsTbl SPT
		INNER JOIN #nonDeletableStoragePoliciesTbl SP
			ON SP.entityId = SPT.policyId
		LEFT JOIN #nonDeletableStoragePoolsTbl NDSP
			ON NDSP.entityId = SPT.id
		WHERE NDSP.entityId is NULL
		IF (SELECT COUNT(0)
			FROM #nonDeletableStoragePoolsTbl) > 0
		BEGIN
			DECLARE @nonDeletableStoragePools NVARCHAR(MAX)
			SET @nonDeletableStoragePools = STUFF((SELECT ', ' + name
								FROM #nonDeletableStoragePoolsTbl
								FOR XML PATH('')), 1, 2, '')
			UPDATE App_CompanyEntities
SET flags = flags | 0x4
			FROM App_CompanyEntities App
			INNER JOIN #nonDeletableStoragePoolsTbl SP
ON App.entityType = 17
				AND App.entityId = SP.entityId
				AND App.companyId = SP.companyId
SET @o_warnCode = (4615 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_warnString +=  (SELECT message FROM EvLocaleMsgs WHERE messageId = (4615 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @i_localeId)
			SET @o_warnString =  REPLACE(@o_warnString, '^1%s', @nonDeletableStoragePools)
		END
		----- D. Look for company media agents which are either being used by MSP or another company plan/ pool/SP. We can not delete such MA -----
		IF object_id('tempdb.dbo.#nonDeletableMediaAgentsTbl') is not null
        		DROP TABLE #nonDeletableMediaAgentsTbl
		create table #nonDeletableMediaAgentsTbl (name NVARCHAR(MAX),
				    			   entityId INT NOT NULL,
							   companyId INT NOT NULL
							   PRIMARY KEY(entityId))
		IF object_id('tempdb.dbo.#companyMediaAgentsAndPolicyTbl') is not null
        		DROP TABLE #companyMediaAgentsAndPolicyTbl
		create table #companyMediaAgentsAndPolicyTbl (
				    				MAId INT NOT NULL,
									MAName NVARCHAR(MAX),
									policyId INT NOT NULL,
									companyId INT NOT NULL
									PRIMARY KEY(MAId, policyId))
		INSERT INTO #companyMediaAgentsAndPolicyTbl
		SELECT  DISTINCT MMP.ClientId, AC.displayName, AGC.archGroupId, ACE.companyId
		FROM MMDrivepool MMP
		INNER JOIN MMDataPath MMD
			ON MMP.DrivepoolId = MMD.DrivePoolId
		INNER JOIN App_CompanyEntities ACE
			ON ACE.entityId = MMP.ClientId
AND ACE.entityType = 11
		INNER JOIN @providerTable P
			On P.id = ACE.companyId
		INNER JOIN App_Client AC
			ON AC.id = MMP.ClientId
		INNER JOIN archGroupCopy AGC
			ON AGC.id = MMD.CopyId
		-- Get company media agents which are attached to non deletable SP of company
		INSERT INTO #nonDeletableMediaAgentsTbl
		SELECT  DISTINCT MPT.MAName, MPT.MAId, MPT.companyId
		FROM #companyMediaAgentsAndPolicyTbl MPT
		INNER JOIN #nonDeletableStoragePoliciesTbl NDSP
			ON MPT.policyId = NDSP.entityId
		LEFT JOIN #nonDeletableMediaAgentsTbl NDMA
			ON NDMA.entityId = MPT.MAId
		WHERE NDMA.entityId is NULL
		-- Get company media agents which are attached to non deletable pool of company
		INSERT INTO #nonDeletableMediaAgentsTbl
		SELECT  DISTINCT MPT.MAName, MPT.MAId, MPT.companyId
		FROM #companyMediaAgentsAndPolicyTbl MPT
		INNER JOIN #nonDeletableStoragePoolsTbl NDSP
			ON MPT.policyId = NDSP.entityId
		LEFT JOIN #nonDeletableMediaAgentsTbl NDMA
			ON NDMA.entityId = MPT.MAId
		WHERE NDMA.entityId is NULL
		-- Get company media agents which is shared with policy of another company/ MSP SP
		INSERT INTO #nonDeletableMediaAgentsTbl
		SELECT  DISTINCT MPT.MAName, MPT.MAId, MPT.companyId
		FROM #companyMediaAgentsAndPolicyTbl MPT
		LEFT JOIN App_CompanyEntities ACE
ON ACE.entityId = MPT.policyId AND ACE.entityType = 17
		LEFT JOIN #nonDeletableMediaAgentsTbl NDMA
			ON NDMA.entityId = MPT.MAId
		WHERE NDMA.entityId is NULL
			AND (ACE.entityId is NULL /*MSP entity*/
			OR ACE.companyId NOT IN (SELECT id FROM @providerTable))
		--- Identify MA which host DDB partition from MSP or another company storage policy
		--- Identify MA for which the given MA is the only local MA for a library
		INSERT INTO #nonDeletableMediaAgentsTbl
		SELECT AC.name, H.ClientId, ACE.companyId
		FROM   MMHost H
		INNER JOIN App_Client AC
			ON AC.id = H.clientId
		INNER JOIN App_CompanyEntities ACE
ON entityType = 11 AND entityId = H.ClientId
		INNER JOIN @providerTable P
			On P.id = ACE.companyId
		WHERE (
			 -- Identify MA which host DDB partition from MSP or another company storage policy
			EXISTS(
              			SELECT 1
	              		FROM   IdxSIDBSubStore SS
                           	INNER JOIN archCopySIDBSTore acss ON acss.sidbstoreid = SS.SIDBStoreId
                           	INNER JOIN archGroupCopy agc ON agc.id = acss.copyid
              			WHERE  SS.CLientId = H.CLientId
                           	AND NOT EXISTS(
                                  	select 1 --query to fetch all copy/storage-pool copy associated to deleting company
				  	FROM App_CompanyEntities ACE
				  	INNER JOIN @providerTable P
				  		On P.id = ACE.companyId
WHERE entityType = 17 AND entityId = agc.archGroupId
                           		)
       				)
       			OR
			EXISTS(
				-- Identify MA for which the given MA is the only local MA for a library
      		 		--MA deletion deconfigure tape libs(and there is no data-loss too), therefore only check for mag libs
              			SELECT 1
              			FROM   MMDeviceController DC
              			WHERE  DC.ClientId = H.ClientId
                           	--local MA
AND (DC.DeviceAccessType & (16 | 32 | 128)) =  0
                           	--no other local controller for device
                           	AND NOT EXISTS(
                                  SELECT 1 FROM MMDeviceController DC2 WHERE DC2.DeviceId = DC.deviceId AND DC2.ClientId <> DC.ClientID
AND (DC2.DeviceAccessType & (16| 32 | 128)) =  0
                           	)
                           	--do not belong to libraries being deleted
                           	AND NOT EXISTS(
                                  		SELECT 1 -- queries to list all library associated to company
						FROM MMMountPathTostorageDevice MPSd
						INNER JOIN MMMountpath MP
							ON MP.mountpathid = MPSD.mountpathid
						INNER JOIN App_CompanyEntities ACE
ON entityType = 9 AND entityId = MP.LibraryId
						INNER JOIN @providerTable P
				  			On P.id = ACE.companyId
						WHERE MPSD.deviceid = dc.deviceid
                           			)
       				)
		        )
			AND NOT EXISTS (select entityId FROM #nonDeletableMediaAgentsTbl )
		IF (SELECT COUNT(0)
			FROM #nonDeletableMediaAgentsTbl) > 0
		BEGIN
			DECLARE @nonDeletableMediaAgents NVARCHAR(MAX)
			SET @nonDeletableMediaAgents = STUFF((SELECT ', ' + name
								FROM #nonDeletableMediaAgentsTbl
								FOR XML PATH('')), 1, 2, '')
			UPDATE App_CompanyEntities
SET flags = flags | 0x4
			FROM App_CompanyEntities App
			INNER JOIN #nonDeletableMediaAgentsTbl SP
ON App.entityType = 11
				AND App.entityId = SP.entityId
				AND App.companyId = SP.companyId
			-- cannot delete client entity (and it's instance/backupset/subclient) if not going to delete media agent of MA client entity
			UPDATE App_CompanyEntities
SET flags = flags | 0x4
			FROM App_CompanyEntities App
			INNER JOIN #nonDeletableMediaAgentsTbl SP
ON App.entityType = 3
				AND App.entityId = SP.entityId
				AND App.companyId = SP.companyId
			UPDATE App_CompanyEntities
SET flags = App.flags | 0x4
			FROM App_CompanyEntities App
			INNER JOIN App_Application Appl WITH(NOLOCK)
ON Appl.id = App.entityId AND App.entityType = 7
			INNER JOIN #nonDeletableMediaAgentsTbl SP
				ON Appl.clientId = SP.entityId
				AND App.companyId = SP.companyId
			UPDATE App_CompanyEntities
SET flags = App.flags | 0x4
			FROM App_CompanyEntities App
			INNER JOIN APP_Application Appl WITH(NOLOCK)
ON Appl.backupSet = App.entityId AND App.entityType = 6
			INNER JOIN #nonDeletableMediaAgentsTbl SP
				ON Appl.clientId = SP.entityId
				AND App.companyId = SP.companyId
			UPDATE App_CompanyEntities
SET flags = App.flags | 0x4
			FROM App_CompanyEntities App
			INNER JOIN APP_Application Appl WITH(NOLOCK)
ON Appl.instance = App.entityId AND App.entityType = 5
			INNER JOIN #nonDeletableMediaAgentsTbl SP
				ON Appl.clientId = SP.entityId
				AND App.companyId = SP.companyId
			WHERE Appl.instance <> 1
				AND Appl.instance NOT IN (SELECT componentNameId
				  FROM APP_InstanceProp WITH(NOLOCK) INNER JOIN App_InstanceName WITH(NOLOCK)
ON App_instancename.id=componentNameId and attrName = 'Discovered VM Instance' and APP_InstanceProp.modified=0 and status=0x200000 AND attrVal = '1')
SET @o_warnCode = (4646 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_warnString +=  (SELECT message FROM EvLocaleMsgs WHERE messageId = (4646 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @i_localeId)
			SET @o_warnString =  REPLACE(@o_warnString, '^1%s', @nonDeletableMediaAgents )
		END
		----- E.  Mark dependent policy copy & library of SP/ storage pool as not deleteble  -----
		IF object_id('tempdb.dbo.#nonDeletablePolicyCopiesTbl') is not null
        		DROP TABLE #nonDeletablePolicyCopiesTbl
		create table #nonDeletablePolicyCopiesTbl (id INT NOT NULL
							   PRIMARY KEY(id))
		INSERT INTO #nonDeletablePolicyCopiesTbl
		SELECT DISTINCT AGC.id
		FROM archGroupCopy AGC WITH(NOLOCK)
		INNER JOIN #nonDeletableStoragePoliciesTbl Pol
			On  AGC.archGroupId = Pol.entityId
		UNION
		SELECT DISTINCT AGC.id
		FROM archGroupCopy AGC WITH(NOLOCK)
		INNER JOIN #nonDeletableStoragePoolsTbl P
			On AGC.archGroupId = P.entityId
		-- Policy copy
		UPDATE App_CompanyEntities
SET flags = App.flags | 0x4
		FROM App_CompanyEntities App
		INNER JOIN #nonDeletablePolicyCopiesTbl AGC
ON AGC.id = App.entityId AND App.entityType = 18
		-- Library
		UPDATE App_CompanyEntities
SET flags = App.flags | 0x4
		FROM App_CompanyEntities App
		INNER JOIN MMLibrary ML WITH(NOLOCK)
ON ML.libraryId = App.entityId AND App.entityType = 9
		INNER JOIN MMMasterPool MMP WITH(NOLOCK)
			ON MMP.LibraryId = ML.LibraryId
		INNER JOIN MMDrivePool MD WITH(NOLOCK)
			ON MMP.MasterPoolId = MD.MasterPoolId
		INNER JOIN MMDataPath MDP WITH(NOLOCK)
			ON MD.DrivePoolId = MDP.DrivePoolId
		INNER JOIN #nonDeletablePolicyCopiesTbl AGC WITH(NOLOCK)
			ON AGC.id = MDP.CopyId
		----- F.  Mark dependent schedule policies of non deleteble company plans as not deleteble  -----
		UPDATE App_CompanyEntities
SET flags = ACE.flags | 0x4
	        FROM App_CompanyEntities ACE
	        INNER JOIN TM_Task T WITH(NOLOCK)
ON T.taskid = ACE.entityId AND ACE.entityType = 35
		INNER JOIN @providerTable P
			ON P.id = ACE.companyId
		INNER JOIN App_PlanProp APP WITH(NOLOCK)
ON APP.attrName in ('Schedule policy', 'Log schedule policy', 'Backup copy schedule policy', 'Index copy schedule policy', 'Replication schedule policy')
				AND APP.attrVal = CAST (ACE.entityId AS varchar(32))
		INNER JOIN #nonDeletablePlansTbl AP
			ON AP.entityId = APP.componentNameId
		----- G.  Mark company tape libraries as not deleteble since they're not deleted from MMLibrary table even after deconfig  -----
		UPDATE App_CompanyEntities
SET flags = App.flags | 0x4
	        FROM App_CompanyEntities App
	        INNER JOIN MMLibrary ML WITH(NOLOCK)
ON ML.libraryId = App.entityId AND App.entityType = 9
		INNER JOIN @providerTable P
			On P.id = App.companyId
WHERE ML.LibraryTypeId <> 3
END
ELSE
BEGIN
SET @o_errCode = (3287 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errString =  (SELECT message FROM EvLocaleMsgs WHERE messageId = (3287 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @i_localeId)
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @o_errCode = ERROR_NUMBER()
    SET @o_errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
     IF ( /* cursor is open */
        CURSOR_STATUS('local', 'companyCur') >= 0 )
    CLOSE companyCur
    IF (/* cursor is closed */
        CURSOR_STATUS('local','companyCur') = -1 )
    DEALLOCATE companyCur
END CATCH
SCRIPT_EXIT:
SET @warningCode=@o_warnCode
SET @warningString=@o_warnString
SET @errorCode=@o_errCode
SET @errorString=@o_errString
SELECT @errorCode, @errorString, @warningCode , @warningString
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppMarkProviderForDelete')
	delete from GxQscripts where name = 'AppMarkProviderForDelete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppMarkProviderForDelete')
	delete from GXDBVersions where aliasname = 'AppMarkProviderForDelete'
GO

insert into GXDBVersions values(2, 'AppMarkProviderForDelete',  '00010001000200230000', 'AppMarkProviderForDelete', '00010001000200230000')
GO

