

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppMaintainVMProtectedStatus.sp] ---------- 

--  +==============================================================================+
--  |		 		 Name:  AppGetTenantAdminForCompany()
--  | Description:  Allows for GET of Tenant Adminprovided ProviderID
--  +==============================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppMaintainVMProtectedStatus.sp,v $ $Id: AppMaintainVMProtectedStatus.sp,v 1.1.2.4 2020/10/15 23:13:09 alakra Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppMaintainVMProtectedStatus')
BEGIN
	print '>>> Drop Stored Procedure: AppMaintainVMProtectedStatus <<<'
	drop procedure AppMaintainVMProtectedStatus
END
IF EXISTS (select * from GxQscripts where name='AppMaintainVMProtectedStatus')
	delete from GxQscripts where name = 'AppMaintainVMProtectedStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppMaintainVMProtectedStatus')
	delete from GXDBVersions where aliasname = 'AppMaintainVMProtectedStatus'
GO
print '... Creating Procedure: AppMaintainVMProtectedStatus'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppMaintainVMProtectedStatus
  @o_errorCode INT OUTPUT,
  @o_errorString NVARCHAR(MAX) OUTPUT
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
  DECLARE @errorCode INT
  DECLARE @errorString NVARCHAR(MAX)
BEGIN TRY
	SET @errorCode = 0
	SET @errorString = ''
	IF OBJECT_ID('tempdb.dbo.#AppGetVMInfoMaintenance_tmp__VMInfo'						) IS NOT null DROP TABLE #AppGetVMInfoMaintenance_tmp__VMInfo
	IF OBJECT_ID('tempdb.dbo.#AppGetVMInfoMaintenance_tmp__VMInfoLatestSuccess'			) IS NOT null DROP TABLE #AppGetVMInfoMaintenance_tmp__VMInfoLatestSuccess
	IF OBJECT_ID('tempdb.dbo.#AppGetVMInfoMaintenance_tmp__VMInfoLatestSuccessV2'		) IS NOT null DROP TABLE #AppGetVMInfoMaintenance_tmp__VMInfoLatestSuccessV2
	IF OBJECT_ID('tempdb.dbo.#AppGetVMInfoMaintenance_tmp__VMInfoLatestFailed'			) IS NOT null DROP TABLE #AppGetVMInfoMaintenance_tmp__VMInfoLatestFailed
	DECLARE @createTime	INT = dbo.getunixtime(GETUTCDATE())
	CREATE TABLE #AppGetVMInfoMaintenance_tmp__VMInfo
	(
		clientId            INT,
		jobId				INT,
		clientPropJobRowId	INT DEFAULT 0,
		appId				INT DEFAULT 0,
		clientPropAppRowId	INT DEFAULT 0,
		jmLatestJobId		INT DEFAULT 0,
		jmLatestAppId		INT DEFAULT 0,
		isIndexingV2		INT DEFAULT 0,
		isFailedVM			INT DEFAULT 0,
		sGUID				NVARCHAR(128)
	)
	CREATE CLUSTERED INDEX Idx_ClientsList ON #AppGetVMInfoMaintenance_tmp__VMInfo(clientId)
	CREATE TABLE #AppGetVMInfoMaintenance_tmp__VMInfoLatestSuccess
	(
		clientId            INT,
		jmLatestJobId		INT,
		jmLatestAppId		INT,
		createTime			INT,
		rowId				INT
	)
	CREATE TABLE #AppGetVMInfoMaintenance_tmp__VMInfoLatestSuccessV2
	(
		clientId            INT,
		jmLatestJobId		INT,
		rowId				INT
	)
	CREATE TABLE #AppGetVMInfoMaintenance_tmp__VMInfoLatestFailed
	(
		clientId            INT,
		jmLatestAppId		INT,
		rowId				INT
	)
	-- Get All VM's , there latest job (in DB), which subclient and if they are indexing v2 one's
	INSERT INTO #AppGetVMInfoMaintenance_tmp__VMInfo (clientId, sGUID, isIndexingV2, jobId, clientPropJobRowId, appId, clientPropAppRowId, isFailedVM)
	SELECT AC.id, AC.guid , ISNULL(CAST(ACP1.attrval AS INT), 0), ISNULL(CAST(ACP2.attrval AS INT), 0), ISNULL(ACP2.id, 0), ISNULL(CAST(ACP3.attrval AS INT), 0), ISNULL(ACP3.id, 0), 0
		FROM APP_Client AC  WITH (NOLOCK)
        INNER JOIN APP_ClientProp ACP  WITH (NOLOCK)
              ON ACP.componentnameid=AC.id AND ACP.attrname='Virtual Server Discovered Clients' AND ACP.attrval='1' AND ACP.modified=0
		LEFT OUTER JOIN APP_ClientProp ACP1 WITH (NOLOCK)
			ON ACP1.componentnameId=AC.id AND ACP1.attrName='IndexingV2_VSA' AND ACP1.modified=0
		LEFT OUTER JOIN APP_ClientProp ACP2 WITH (NOLOCK)
			ON ACP2.componentnameId=AC.id AND ACP2.attrName='Last Backup JobID' AND ACP2.modified=0
		LEFT OUTER JOIN APP_ClientProp ACP3 WITH (NOLOCK)
ON ACP3.componentnameId=AC.id AND ACP3.attrName='Last Backup Subclient' AND ACP3.modified=0
	--  Query For Success V1 and V2 Also (It will help for V2 as we need parent job id that was used to back it up last time)
	--	For V2 case, this will be get the last hypervisor appId
	INSERT INTO #AppGetVMInfoMaintenance_tmp__VMInfoLatestSuccess
	SELECT clientId, jobId, appId, startDate, 1 FROM (
	SELECT OT.clientId AS clientId, JMB.jobId  AS jobId, JMB.appId AS appId, JMB.servStartDate AS startDate, ROW_NUMBER() OVER (PARTITION BY OT.clientId ORDER BY JMB.servStartDate DESC) AS rowId
		FROM JMBkpStats JMB WITH(NOLOCK)
			INNER JOIN APP_VMProp VMP WITH(NOLOCK) ON
				JMB.jobId = VMP.jobId AND VMP.attrName='vmStatus' AND VMP.attrVal IN ('0', '3')/* COMPLETED, PARTIAL_SUCCESS*/
				AND JMB.opType IN(4, 14, 59) -- 4 - BACKUP, 14 - SYNTHFULL, 59 - SNAPBACKUP
				AND JMB.STATUS IN(1, 3, 14) -- 1- JMSUCCESS, 3 - PARTIALSUCCESS, 14 - JMSUCCESSWITHWARNINGS
				AND JMB.dataStatus NOT IN (1, 2)	-- 1- DATA_STATUS_AGED, 2 - DATA_STATUS_MEDIADELETED
			INNER JOIN #AppGetVMInfoMaintenance_tmp__VMInfo OT ON
					VMP.VMclientId = OT.clientId
			WHERE ((OT.isIndexingV2=0) OR (OT.isIndexingV2=1 AND JMB.opType<>14))	-- No SYNTHFULL for V2 here
		)SUB WHERE rowid=1
	-- For successful backup and snap backup job, we will have correct status from above query
	INSERT INTO #AppGetVMInfoMaintenance_tmp__VMInfoLatestSuccessV2
	SELECT ClientId, jobId, RowNo  FROM
	(SELECT
			OT.clientId AS ClientId,
			OT.jobId  AS jobId,
			ROW_NUMBER() OVER (PARTITION BY OT.clientId ORDER BY JMB.servStartDate DESC) as RowNo
		FROM JMBkpStats JMB WITH(NOLOCK)
			INNER JOIN APP_Application AAP WITH (NOLOCK) ON
				AAP.id=JMB.appId
				AND AAP.appTypeId=106
				AND JMB.opType IN (14)  -- 14- SYNTHFULL
				AND JMB.STATUS IN(1, 3, 14)  -- 1- JMSUCCESS, 3 - PARTIALSUCCESS, 14 - JMSUCCESSWITHWARNINGS
				AND JMB.dataStatus NOT IN(1, 2)     -- 1- DATA_STATUS_AGED, 2 - DATA_STATUS_MEDIADELETED
			INNER JOIN #AppGetVMInfoMaintenance_tmp__VMInfo OT ON
				AAP.clientId=OT.clientId
			LEFT OUTER JOIN #AppGetVMInfoMaintenance_tmp__VMInfoLatestSuccess AVIS
				ON AVIS.clientId=OT.clientId AND JMB.servStartDate <= AVIS.createTime
		 WHERE OT.isIndexingV2=1 AND AVIS.clientId IS NULL
		) SUB
		WHERE RowNo=1
	UPDATE VMTBL
		SET VMTBL.jmLatestJobId=t.jmLatestJobId
	FROM #AppGetVMInfoMaintenance_tmp__VMInfoLatestSuccess VMTBL
	INNER JOIN #AppGetVMInfoMaintenance_tmp__VMInfoLatestSuccessV2 t ON
            t.clientId = VMTBL.clientId
	-- Finally Failed VM's
	--  Query For Failed VM's
	-- There is Left Outer join so that we only consider  VM for which status is not yet calcluated
	INSERT INTO #AppGetVMInfoMaintenance_tmp__VMInfoLatestFailed
	SELECT OT.clientId AS clientId, JMB.appId AS appId, ROW_NUMBER() OVER (PARTITION BY OT.clientId ORDER BY JMB.servStartDate DESC) AS rowId
		FROM JMBkpStats JMB WITH(NOLOCK)
			INNER JOIN JMQinetixUpdateStatus JMQ WITH(NOLOCK) ON
				JMB.jobId = JMQ.jobId
				AND JMB.opType IN(4, 14, 59) -- 4 - BACKUP, 14 - SYNTHFULL, 59 - SNAPBACKUP
				-- AND JMB.STATUS IN(1, 3, 14) -- 1- JMSUCCESS, 3 - PARTIALSUCCESS, 14 - JMSUCCESSWITHWARNINGS	-- We don't care about job status
				-- AND JMB.dataStatus NOT IN (1, 2)	-- 1- DATA_STATUS_AGED, 2 - DATA_STATUS_MEDIADELETED		-- We also don't care about data being already aged
				-- AND JMQ.status IN (0,3)	-- 0 - COMPLETED, 3 - PARTIAL_SUCCESS -- No status from JMQ is needed
			INNER JOIN #AppGetVMInfoMaintenance_tmp__VMInfo OT ON
            JMQ.clientId = OT.clientId
			LEFT OUTER JOIN #AppGetVMInfoMaintenance_tmp__VMInfoLatestSuccess VMS
				ON VMS.clientId=OT.clientId
			WHERE VMS.clientId IS NULL
	UPDATE AVM
		SET AVM.jmLatestJobId=VMTBL.jmLatestJobId,
			AVM.jmLatestAppId=VMTBL.jmLatestAppId
	FROM #AppGetVMInfoMaintenance_tmp__VMInfo AVM
	INNER JOIN #AppGetVMInfoMaintenance_tmp__VMInfoLatestSuccess VMTBL
		ON VMTBL.clientId=AVM.clientId
	--Update the  pending failed cases now
	UPDATE AVM
		SET AVM.jmLatestAppId=VMTBL.jmLatestAppId,
			AVM.isFailedVM=1
	FROM #AppGetVMInfoMaintenance_tmp__VMInfo AVM
	INNER JOIN #AppGetVMInfoMaintenance_tmp__VMInfoLatestFailed VMTBL
		ON VMTBL.clientId=AVM.clientId
	-- At this moment, out temp table is all but ready
	-- Nothing else left
	-- Delete latest job info if that job has been pruned and there is no latest job
	DELETE ACP
	FROM APP_ClientProp ACP
	INNER JOIN #AppGetVMInfoMaintenance_tmp__VMInfo VMTbl
		ON ACP.id =VMTbl.clientPropJobRowId
	WHERE VMTbl.jmLatestJobId=0
	-- Delete last APPId info if there is no valid backup job id left
	-- If we have valid job id left and 0 appid, then we should leave the appid value as is
	-- there can be a case where for V2 only synthetic full job is left. In such case there will not be any job for parent but we should keep track of last job via parent for security rights
	--	--	So, in V2 case where only synthetic full is left and no parent job is left but older app is present, we will not delete it.
	DELETE ACP
	FROM APP_ClientProp ACP
	INNER JOIN #AppGetVMInfoMaintenance_tmp__VMInfo VMTbl
		ON ACP.id =VMTbl.clientPropAppRowId
	WHERE VMTbl.jmLatestAppId=0 AND VMTbl.jmLatestJobId=0
	-- Update latest Job Id when it is different from the one we have in DB
	-- Update is way to efficient here as we are joining on id in client prop and that too when value is different
	UPDATE ACP
		SET ACP.attrVal=VMTbl.jmLatestJobId
	FROM APP_ClientProp ACP
	INNER JOIN #AppGetVMInfoMaintenance_tmp__VMInfo VMTbl
		ON ACP.id=VMTbl.clientPropJobRowId
	WHERE VMTbl.jmLatestJobId <>VMTbl.jobId AND VMTbl.clientPropJobRowId<>0
	-- Update latest Hypervisor Subclient Id when it is different from the one we have in DB
	UPDATE ACP
		SET ACP.attrVal=VMTbl.jmLatestAppId
	FROM APP_ClientProp ACP
	INNER JOIN #AppGetVMInfoMaintenance_tmp__VMInfo VMTbl
		ON ACP.id=VMTbl.clientPropAppRowId
	WHERE VMTbl.jmLatestAppId <>VMTbl.appId AND VMTbl.clientPropAppRowId<>0
	-- Insert only for case where we don't have existing 'Last Backup JobID' row . This is determind by clientPropJobRowId
	-- We have added left outer join to avoid any timing condition where JM also inserts the same property and we ned up with 2 properties
	INSERT INTO APP_ClientProp
	SELECT ATV.clientId, 'Last Backup JobID', 7, ATV.jmLatestJobId,  @createTime, 0, 0 FROM #AppGetVMInfoMaintenance_tmp__VMInfo ATV
	LEFT OUTER JOIN APP_ClientProp ACP WITH(NOLOCK) ON ACP.componentNameId=ATV.clientId AND ACP.attrName='Last Backup JobID' AND ACP.modified=0
		WHERE clientPropJobRowId=0 AND jmLatestJobId<>0 AND ACP.componentNameId IS NULL
	-- Insert only for case where we don't have existing 'Last Backup Subclient' row . This is determind by clientPropAppRowId
	-- We have added left outer join to avoid any timing condition where JM also inserts the same property and we ned up with 2 properties
	INSERT INTO APP_ClientProp
SELECT clientId, 'Last Backup Subclient', 7, jmLatestAppId,  @createTime, 0, 0 FROM #AppGetVMInfoMaintenance_tmp__VMInfo ATV
LEFT OUTER JOIN APP_ClientProp ACP WITH(NOLOCK) ON ACP.componentNameId=ATV.clientId AND ACP.attrName='Last Backup Subclient' AND ACP.modified=0
		WHERE clientPropAppRowId=0 AND jmLatestAppId<>0 AND clientPropJobRowId=0 AND ACP.componentNameId IS NULL
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode = ERROR_NUMBER()
    SET @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
SCRIPT_EXIT:
SET @o_errorCode	 = @errorCode
SET @o_errorString	 = @errorString
SELECT @o_errorCode, @o_errorString
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppMaintainVMProtectedStatus')
	delete from GxQscripts where name = 'AppMaintainVMProtectedStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppMaintainVMProtectedStatus')
	delete from GXDBVersions where aliasname = 'AppMaintainVMProtectedStatus'
GO

insert into GXDBVersions values(2, 'AppMaintainVMProtectedStatus',  '00010001000200040000', 'AppMaintainVMProtectedStatus', '00010001000200040000')
GO

