

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppMaintainDBSanity.sp] ---------- 

--  +==============================================================================+
--  |		 		 Name:  AppMaintainDBSanity
--  | Description:  Allows for GET of Tenant Adminprovided ProviderID
--  +==============================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppMaintainDBSanity.sp,v $ $Id: AppMaintainDBSanity.sp,v 1.1.2.1 2020/12/07 21:43:10 alakra Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppMaintainDBSanity')
BEGIN
	print '>>> Drop Stored Procedure: AppMaintainDBSanity <<<'
	drop procedure AppMaintainDBSanity
END
IF EXISTS (select * from GxQscripts where name='AppMaintainDBSanity')
	delete from GxQscripts where name = 'AppMaintainDBSanity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppMaintainDBSanity')
	delete from GXDBVersions where aliasname = 'AppMaintainDBSanity'
GO
print '... Creating Procedure: AppMaintainDBSanity'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppMaintainDBSanity
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
  DECLARE @errorCode INT
  DECLARE @errorString NVARCHAR(MAX)
BEGIN TRY
	SET @errorCode = 0
	SET @errorString = ''
	IF OBJECT_ID('tempdb.dbo.#ClientProp_ClenaupTmpTbl') IS NOT NULL
			DROP TABLE #ClientProp_ClenaupTmpTbl
	CREATE TABLE #ClientProp_ClenaupTmpTbl (id INT PRIMARY KEY, countRank INT)
	INSERT INTO #ClientProp_ClenaupTmpTbl
	SELECT id, RANK() OVER(PARTITION BY componentNameId,
												attrname
					   ORDER BY id DESC) rank
				FROM APP_ClientProp WITH(NOLOCK) WHERE attrname IN('Last backup JobId', 'Last Backup Subclient') AND modified=0
	DELETE E
    FROM APP_ClientProp E
         INNER JOIN #ClientProp_ClenaupTmpTbl T
		ON E.ID = T.ID
	WHERE T.countRank>1
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode = ERROR_NUMBER()
    SET @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	IF @errorCode = 1205  --DEADLOCK error
    BEGIN
        ;THROW;   -- rethrow the DEADLOCK so XE captures.
    END
END CATCH
SCRIPT_EXIT:
SELECT @errorCode, @errorString
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppMaintainDBSanity')
	delete from GxQscripts where name = 'AppMaintainDBSanity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppMaintainDBSanity')
	delete from GXDBVersions where aliasname = 'AppMaintainDBSanity'
GO

insert into GXDBVersions values(2, 'AppMaintainDBSanity',  '00010001000200010000', 'AppMaintainDBSanity', '00010001000200010000')
GO

