

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppLoadBalanceIdxServer.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppLoadBalanceIdxServer')
BEGIN
	print '>>> Drop Stored Procedure: AppLoadBalanceIdxServer <<<'
	drop procedure AppLoadBalanceIdxServer
END
IF EXISTS (select * from GxQscripts where name='AppLoadBalanceIdxServer')
	delete from GxQscripts where name = 'AppLoadBalanceIdxServer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppLoadBalanceIdxServer')
	delete from GXDBVersions where aliasname = 'AppLoadBalanceIdxServer'
GO
print '... Creating Procedure: AppLoadBalanceIdxServer'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppLoadBalanceIdxServer
  @inXml XML = NULL
AS
SET NOCOUNT ON
-- Aux variables
DECLARE @appId	 		INT
DECLARE @dbId	 		INT
DECLARE @dbSize 		INT
DECLARE @clId 			INT
DECLARE @toClId 		INT
DECLARE @toClDiskSize 	INT
DECLARE @dbGuid 		NVARCHAR(36)
DECLARE @bsGuid 		NVARCHAR(36)
DECLARE @bsId 			INT
DECLARE @curClId 		INT
DECLARE @curDiskSize 	INT
DECLARE @lastDbClId		INT
DECLARE @curPred 		FLOAT
DECLARE @curLoad 		FLOAT
DECLARE @toClAvgLoad 	FLOAT
DECLARE @tmpLoadCheck 	FLOAT
DECLARE @idxServerLoadKThreshold INT = 4 -- default value for Kt
DECLARE @archGrpId		INT = NULL
DECLARE @overloadedThreshold FLOAT = CAST(ISNULL((SELECT value FROM GXGlobalParam WITH(NOLOCK) WHERE name = 'nIndexServerOverloadThreshold'), 90) AS FLOAT) / 100
DECLARE @warningThreshold FLOAT = CAST(ISNULL((SELECT value FROM GXGlobalParam WITH(NOLOCK) WHERE name = 'nIndexServerWarningThreshold'), 70) AS FLOAT) / 100
DECLARE @optimalThreshold FLOAT = CAST(ISNULL((SELECT value FROM GXGlobalParam WITH(NOLOCK) WHERE name = 'nIndexServerOptimalThreshold'), 30) AS FLOAT) / 100
-- Tmp tables
IF object_id('tempdb.dbo.#IndexServerLoad') IS NOT NULL DROP TABLE #IndexServerLoad
CREATE TABLE #IndexServerLoad (
	clientId 	INT,
	avgLoad 	FLOAT,
	assingments INT
)
IF object_id('tempdb.dbo.#IndexDatabases') IS NOT NULL DROP TABLE #IndexDatabases
CREATE TABLE #IndexDatabases (
	dbId 		INT,
	bsId 		INT,
	appId 		INT,
	dbGuid 		NVARCHAR(max),
	bsGuid 		NVARCHAR(max),
	curClId 	INT,
	dbSize 		FLOAT
)
IF object_id('tempdb.dbo.#OverloadedServers') IS NOT NULL DROP TABLE #OverloadedServers
CREATE TABLE #OverloadedServers (
	clientId 	INT,
	load 		FLOAT,
	pred 		FLOAT,
	diskSize	BIGINT,
	class 		INT
)
IF object_id('tempdb.dbo.#AvailableServers') IS NOT NULL DROP TABLE #AvailableServers
CREATE TABLE #AvailableServers (
	clientId 	INT,
	diskSize 	INT,
	capacity 	FLOAT,
	load 		FLOAT,
	assingments INT
)
IF object_id('tempdb.dbo.#ProcessedServers') IS NOT NULL DROP TABLE #ProcessedServers
CREATE TABLE #ProcessedServers (
	clientId 	INT,
	retCode 	INT,
	retStr		NVARCHAR(max)
)
-- Output variables
DECLARE @retCode INT = 0
DECLARE @retStr  NVARCHAR(max) = ''
-- Output XML
-- Expected return codes:
-- 0 - OK, load balance finished without problems
-- 1 - There are still movements waiting to be done in IdxServerMigrations table
-- 2 - No Idx server overload detected
DECLARE @outXml		XML
-- Check for pending migrations
IF EXISTS (SELECT * FROM IdxServerMigrations WITH(NOLOCK) WHERE isMigrated = 0 AND jobId IS NULL)
BEGIN
	SET @retCode = 1
	SET @retStr = 'There are pending migrations detected in IdxServerMigrations table.'
	SET @outXml = (SELECT @retCode AS '@retCode', @retStr as '@retStr' FOR XML PATH('App_LoadBalanceIdxSrvrRes'), type)
	GOTO CX_EXIT
END
IF @inXml IS NOT NULL
	SET @archGrpId = @inXml.value('(/App_LoadBalanceIdxSrvrReq/@archGrpId)[1]', 'INT')
-- Get all media agents that need maintenance
IF @archGrpId IS NOT NULL AND EXISTS (SELECT 1 FROM archGroup WHERE id = @archGrpId) -- Check if archGrpId is valid, if it is get MAs that need maintenance from the group
BEGIN
	INSERT INTO #OverloadedServers
		SELECT DISTINCT ISL.clientId, ISL.load, ISL.predictedCapacity, ISL.diskSizeMB, ISL.classification
		FROM archGroup AG WITH(NOLOCK)
			 INNER JOIN APP_Application APP WITH(NOLOCK) ON AG.id = APP.dataArchGrpID AND APP.subclientStatus & 6 = 0
			 INNER JOIN APP_Client CL WITH(NOLOCK) ON APP.clientId = CL.id AND CL.name NOT LIKE '%_IndexServer'
			 INNER JOIN MMHost MM WITH(NOLOCK) ON CL.id = MM.ClientId
			 INNER JOIN IdxServerLoad ISL WITH(NOLOCK) ON CL.id = ISL.clientId AND
			 	(
					 (ISL.load >= @optimalThreshold AND ISL.load < @warningThreshold AND k > @idxServerLoadKThreshold) OR	-- Optimal but with predicted load count > K
					 (ISL.load >= @warningThreshold AND ISL.load < @overloadedThreshold AND trend > 0) OR -- Warning with positive trend
					 (ISL.load >= @overloadedThreshold) -- Overloaded
				)
		WHERE AG.id = @archGrpId AND
				(MM.MmHostSoftState <> 0  AND MM.MmHostEnabled <> 0) AND -- Overload index server is not offline
((MM.Attribute & 16) = 0) -- And it's not marked for maintenance
END
ELSE
BEGIN
	INSERT INTO #OverloadedServers
		SELECT ISL.clientId, ISL.load, ISL.predictedCapacity, ISL.diskSizeMB, ISL.classification
		FROM IdxServerLoad ISL WITH(NOLOCK)
			 INNER JOIN MMHost MM WITH(NOLOCK) ON ISL.clientId = MM.ClientId
		WHERE	(
					(ISL.load >= @optimalThreshold AND ISL.load < @warningThreshold AND ISL.k > @idxServerLoadKThreshold) OR	-- Optimal but with predicted ISL.load count > K
					(ISL.load >= @warningThreshold AND ISL.load < @overloadedThreshold AND ISL.trend > 0) OR -- Warning with positive trend
					(ISL.load >= @overloadedThreshold)-- Overloaded
				) AND
				(MM.MmHostSoftState <> 0  AND MM.MmHostEnabled <> 0) AND -- Overload index server is not offline
((MM.Attribute & 16) = 0) -- And it's not marked for maintenance
	;
END
-- Check if there is any MAs needing maintenance
IF NOT EXISTS (SELECT 1 FROM #OverloadedServers)
BEGIN
	SET @retCode = 2
	SET @retStr = 'No Index Servers are requiring migrations at this moment.'
	SET @outXml = (SELECT @retCode as '@retCode', @retStr as '@retStr' FOR XML PATH('App_LoadBalanceIdxSrvrRes'), type)
	GOTO CX_EXIT
END
-- Populate loads
INSERT INTO #IndexServerLoad
	SELECT clientId, AVG(averagePredictLoad), COUNT(DB.id)
	FROM IdxServerLoad AS ISL WITH (NOLOCK)
	LEFT JOIN App_IndexDBInfo AS DB WITH (NOLOCK) ON ISL.clientId = DB.currentIdxServer
	GROUP BY clientId
-- Populate processed MAs
INSERT INTO #ProcessedServers
	SELECT clientId, 0, ''
	FROM #OverloadedServers
-- Select an Index DB to move
WHILE EXISTS (SELECT 1 FROM #OverloadedServers)
BEGIN
	SELECT TOP 1 @clId = clientId, @curLoad = load, @curPred = pred, @curDiskSize = diskSize FROM #OverloadedServers ORDER BY class DESC;
	-- Select the first DB for this client and the backup set Id to inspect for possible migration MAs
	INSERT INTO #IndexDatabases
		SELECT 	DB.id,
				DB.backupSetId,
				APP.id,
				DB.dbName,
				DB.backupSetGUID,
				DB.currentIdxServer,
				dbSize = (ISNULL(ST.properties.value('(/Indexing_DbStats/@dbsize)[1]', 'BIGINT'), 0) +
					ISNULL(ST.properties.value('(/Indexing_DbStats/@logsSize)[1]', 'BIGINT'), 0) +
					ISNULL(ST.properties.value('(/Indexing_DbStats/@reportsSize)[1]', 'BIGINT'), 0) +
					ISNULL(ST.properties.value('(/Indexing_DbStats/@maintenanceSize)[1]', 'BIGINT'), 0)) / (1024 * 1024)
		FROM 	App_IndexDBInfo AS DB WITH(NOLOCK)
				INNER JOIN IdxDbState AS ST WITH(NOLOCK) ON DB.id = ST.dbId
				INNER JOIN APP_Application AS APP WITH(NOLOCK) ON APP.backupSet = DB.backupSetId AND APP.subclientStatus & 4 = 0 AND (dbo.isSubClientIndexEnabled( DB.backupSetId ) = 0 OR App.GUID = DB.dbName)
		WHERE 	DB.currentIdxServer = @clId AND
				DB.isPrimary = 1 AND
				DB.idxDbEngineType = 1 AND -- This will just work for ctree dbs for now
DB.flags & 2 = 0 AND
				(dbo.isSubClientIndexEnabled(DB.backupSetId) = 0 OR (DB.dbName <> DB.backupSetGUID))
	-- Iterate over all DB until the target MA is no longer overloaded
	WHILE EXISTS (SELECT 1 FROM #IndexDatabases)
	BEGIN
		-- Get next db
		SELECT TOP 1 @dbId = dbId, @bsId = bsId, @appId = appId, @dbGuid = dbGuid, @bsGuid = bsGuid, @dbSize = dbSize, @curClid = curClid FROM #IndexDatabases  ORDER BY dbSize DESC;
		-- Select client Id from data path anc calculate possible moves
		INSERT INTO #AvailableServers
			SELECT DISTINCT MM.clientId, IL.diskSizeMB, IL.capacity, CL.avgLoad, CL.assingments
			FROM MMHost AS MM WITH(NOLOCK)
				 INNER JOIN IdxServerLoad IL WITH(NOLOCK) ON MM.ClientId = IL.clientId
				 INNER JOIN #IndexServerLoad CL WITH(NOLOCK) ON IL.ClientId = CL.clientId
				 INNER JOIN MMDrivePool MMDP WITH(NOLOCK) ON MM.clientId = MMDP.ClientId
				 INNER JOIN MMDataPath MMD WITH(NOLOCK) ON MMD.DrivePoolId = MMDP.DrivePoolId AND MMD.Flag & 4 = 4
				 INNER JOIN archGroup AG WITH(NOLOCK) ON MMD.CopyId = AG.defaultCopy
				 INNER JOIN APP_Application APP WITH(NOLOCK) ON AG.id = APP.dataArchGrpID AND APP.backupSet = @bsId AND APP.subclientStatus & 4 = 0 AND (dbo.isSubClientIndexEnabled(@bsId) = 0 OR App.id = @appId)
				 INNER JOIN APP_ClientProp PROP WITH(NOLOCK) ON IL.clientId = PROP.componentNameId AND PROP.modified = 0 AND PROP.attrName = 'Idx: cache enabled'
			WHERE 	MM.ClientId NOT IN (SELECT clientId FROM #OverloadedServers) AND -- Client is not overloaded
					PROP.attrVal = 1 AND -- Index Cache is enabled
					(MM.MmHostSoftState <> 0  AND MM.MmHostEnabled <> 0) AND -- Don't use offline MAs
((MM.Attribute & 16) = 0) AND -- Don't transfer to MAs marked for maintenance
					(@curPred / IL.predictedCapacity) < 1 -- Don't consider moving to WARNING or OVERLOADED MAs even when  prop < 1;
		-- Iterate over all possible MAs to migrate this DB
		WHILE EXISTS (SELECT 1 FROM #AvailableServers)
		BEGIN
			-- Get next MA from availables to move
			SELECT TOP 1 	@toClId = clientId,
							@toClDiskSize = diskSize
			FROM #AvailableServers
			ORDER BY (load * (assingments + 1))/capacity  ASC;
			SELECT @toClAvgLoad = avgLoad FROM #IndexServerLoad WHERE clientId = @toClId
			-- Set load for this DB if in the new MA
			SET @tmpLoadCheck = @toClAvgLoad + CAST(@dbSize AS FLOAT) / CAST(@toClDiskSize AS FLOAT)
			-- Check if it would overload the new MA in the next cycle
			IF @tmpLoadCheck < @warningThreshold
			BEGIN
				-- If it fits, sets the move to loadBalanceMigrations
				INSERT INTO IdxServerMigrations(indexId, fromClientId, toClientId, startTime, endTime)
					VALUES (@dbId, @curClid, @toClId, 0, 0)
				-- Update temp table
				UPDATE #IndexServerLoad SET avgLoad = @tmpLoadCheck, assingments += 1 WHERE clientId = @toClId
				-- Set expected load after removing the DB
				SET @curLoad = @curLoad - CAST(@dbSize AS FLOAT) / CAST(@curDiskSize AS FLOAT)
				BREAK
			END
			DELETE FROM #AvailableServers WHERE clientId = @toClId
		END
		-- Clear tmpAvailIdxMAsTable
		DELETE FROM #AvailableServers
		-- Check if the moving is effective, so we wont need to move any other DB
		IF @curLoad < @warningThreshold
			BREAK
		ELSE
			DELETE FROM #IndexDatabases WHERE dbId = @dbId
	END
	IF NOT EXISTS (SELECT * FROM IdxServerMigrations WHERE fromClientId = @clId AND isMigrated = 0 AND jobId IS NULL)
	BEGIN
		SET @retCode = 3
		SET @retStr = 'No available movements for a media agent.'
		UPDATE #ProcessedServers SET retCode = @retCode, retStr = 'No available movements' WHERE clientId = @clId
	END
	-- Remove processed client from tmp table and clear aux tbl
	DELETE FROM #IndexDatabases
	DELETE FROM #AvailableServers
	DELETE FROM #OverloadedServers WHERE clientId = @clId
END
-- Finish the process
SET @outXml = (
	SELECT @retCode as '@retCode', @retStr as '@retStr', (
		SELECT CL.name AS '@clientName', P.retCode AS '@retCode', P.retStr AS '@retStr'
		FROM  App_client AS CL WITH(NOLOCK) , #ProcessedServers AS P WHERE CL.id = P.clientId
		FOR XML PATH ('idxServers'), type
	) FOR XML PATH('App_LoadBalanceIdxSrvrRes'), type)
CX_EXIT:
SELECT @outXml
-- SELECT * FROM IdxServerMigrations
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppLoadBalanceIdxServer')
	delete from GxQscripts where name = 'AppLoadBalanceIdxServer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppLoadBalanceIdxServer')
	delete from GXDBVersions where aliasname = 'AppLoadBalanceIdxServer'
GO

insert into GXDBVersions values(2, 'AppLoadBalanceIdxServer',  '00000000000000000000', 'AppLoadBalanceIdxServer', '00000000000000000000')
GO

