

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppLiveSyncReplicationsSetInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppLiveSyncReplicationsSetInfo.sp,v $ $Id: AppLiveSyncReplicationsSetInfo.sp,v 1.1.2.7 2019/06/16 02:58:52 rpolimera Exp $";
--	+===================================================================+
--	|  					  AppLiveSyncReplicationsSetInfo						|
--	| Procedure for create/update a APP_SiteReplication table			|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppLiveSyncReplicationsSetInfo')
BEGIN
	print '>>> Drop Stored Procedure: AppLiveSyncReplicationsSetInfo <<<'
	drop procedure AppLiveSyncReplicationsSetInfo
END
IF EXISTS (select * from GxQscripts where name='AppLiveSyncReplicationsSetInfo')
	delete from GxQscripts where name = 'AppLiveSyncReplicationsSetInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppLiveSyncReplicationsSetInfo')
	delete from GXDBVersions where aliasname = 'AppLiveSyncReplicationsSetInfo'
GO
print '... Creating Procedure: AppLiveSyncReplicationsSetInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppLiveSyncReplicationsSetInfo
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
	DECLARE	@o_xmlString		XML
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowTime			INT = datediff(second, '01/01/1970', GETDATE())
	DECLARE @taskName			NVARCHAR(MAX) = ''
	DECLARE @siteInfoCount		INT = 0
    DECLARE @assocCount			INT = 0
    DECLARE @replicationId      INT = 0
	DECLARE @drive				NVARCHAR(MAX) = ''
	DECLARE @trackingId			NVARCHAR(MAX) = ''
	DECLARE @uuid				NVARCHAR(MAX) = ''
	DECLARE @componentVal		NVARCHAR(MAX) = ''
	DECLARE @sourceGuid			NVARCHAR(MAX) = ''
	DECLARE @destinationGuid	NVARCHAR(MAX) = ''
	DECLARE @outTable			TABLE(replicationId INT, taskId INT)
	IF object_id('tempdb.dbo.#livesync_InfoTable') is not null
		DROP TABLE #livesync_InfoTable
	CREATE TABLE #livesync_InfoTable (replicationId INT, lastRestoreTime INT, lastSyncedBkpJob INT, flags INT, status INT, options NVARCHAR(MAX), configuration XML)
	CREATE CLUSTERED INDEX livesync_InfoTable_replicationId_Index1 ON #livesync_InfoTable ([replicationId])
	IF object_id('tempdb.dbo.#outTable') is not null
		DROP TABLE #outTable
	CREATE TABLE #outTable (replicationId INT, taskId INT)
	CREATE CLUSTERED INDEX outTable_replicationId_Index1 ON #outTable ([replicationId])
	-- READ THE XML
	INSERT #livesync_InfoTable (replicationId, lastRestoreTime, lastSyncedBkpJob, flags, status, options, configuration)
	SELECT	ISNULL((ref.value('@replicationId', 'INT')), 0),
			CASE WHEN ref.value('@lastRestoreTime', 'INT') IS NULL OR ref.value('@lastRestoreTime', 'INT') = 0 THEN V.lastRestoreTime ELSE CASE WHEN ref.value('@lastRestoreTime', 'INT') = 1 THEN 0 ELSE ref.value('@lastRestoreTime', 'INT') END END lastRestoreTime, --THIS IS LAST SYNC TIME (VALUE TAKEN FROM BACKUP JOB)
			CASE WHEN ref.value('@lastSyncedBkpJob', 'INT') IS NULL OR ref.value('@lastSyncedBkpJob', 'INT') = 0 THEN V.lastSyncedBkpJob ELSE ref.value('@lastSyncedBkpJob', 'INT') END lastSyncedBkpJob,
			CASE WHEN ref.value('@flags', 'INT') IS NULL OR ref.value('@flags', 'INT') = 0 THEN V.flags ELSE ref.value('@flags', 'INT') END flags,
			CASE WHEN ref.value('@status', 'INT') IS NULL OR ref.value('@status', 'INT') = 0 THEN V.status ELSE ref.value('@status', 'INT') END status,
			CASE WHEN ref.value('@options', 'NVARCHAR(MAX)') IS NULL OR ref.value('@options', 'NVARCHAR(MAX)') = '' THEN V.options ELSE ref.value('@options', 'NVARCHAR(MAX)') END options,
			CASE WHEN ref.value('@configuration', 'NVARCHAR(MAX)') IS NULL OR ref.value('@configuration', 'NVARCHAR(MAX)') = '' THEN V.configuration ELSE ref.value('@configuration', 'NVARCHAR(MAX)') END configuration
			FROM @i_xmlString.nodes ('App_SetLiveSyncReplicationReq/siteInfo') R(ref)
			JOIN APP_LiveSyncReplication V (NOLOCK) ON ref.value('@replicationId', 'VARCHAR(255)') = V.replicationId
	--BEGIN TRAN
		UPDATE APP_LiveSyncReplication SET
			lastRestoreTime = (CASE WHEN RT.lastRestoreTime IS NULL THEN VR.lastRestoreTime ELSE RT.lastRestoreTime END),
			lastSyncTime =    (CASE WHEN ISNULL(RT.status,0) = 1 AND RT.lastRestoreTime IS NOT NULL  THEN RT.lastRestoreTime  ELSE VR.lastSyncTime END ),
			flags = (CASE WHEN RT.flags IS NULL THEN VR.flags ELSE RT.flags END),
			modified = @nowTime,
			status = (CASE WHEN RT.status IS NULL THEN VR.status ELSE RT.status END),
			lastSyncedBkpJob =(CASE WHEN RT.lastSyncedBkpJob IS NULL THEN VR.lastSyncedBkpJob ELSE RT.lastSyncedBkpJob END),
			options = (CASE WHEN RT.options IS NULL THEN VR.options ELSE RT.options END),
			configuration = (CASE WHEN RT.configuration IS NULL THEN VR.configuration ELSE RT.configuration END)
		--OUTPUT inserted.replicationId, inserted.taskId
		--INTO #outTable
		FROM APP_LiveSyncReplication VR
			JOIN #livesync_InfoTable RT ON
			RT.replicationId = VR.replicationId
		SELECT @errorCode = @@ERROR, @replicationId = SCOPE_IDENTITY()
ERROR:
--IF @errorCode <> 0
--	ROLLBACK TRAN
--ELSE
--	COMMIT TRAN
ERROR_EXIT:
    SET @o_xmlString =
    (
		SELECT
			(SELECT
				@replicationId AS '@replicationId'
				--taskId AS '@taskId'
				--FROM #outTable
				FOR XML PATH('siteInfo'), TYPE
			),
			(SELECT @errorCode '@errorCode',
					@errorString '@errorMessage'
			FOR XML PATH ('resp'), TYPE
			)
		FOR XML PATH(''), ROOT('App_LiveSyncReplicationResp')
    )
	SELECT @o_xmlString
	IF object_id('tempdb.dbo.#livesync_InfoTable') is not null
		DROP TABLE #livesync_InfoTable
	IF object_id('tempdb.dbo.#outTable') is not null
		DROP TABLE #outTable
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppLiveSyncReplicationsSetInfo')
	delete from GxQscripts where name = 'AppLiveSyncReplicationsSetInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppLiveSyncReplicationsSetInfo')
	delete from GXDBVersions where aliasname = 'AppLiveSyncReplicationsSetInfo'
GO

insert into GXDBVersions values(2, 'AppLiveSyncReplicationsSetInfo',  '00010001000200070000', 'AppLiveSyncReplicationsSetInfo', '00010001000200070000')
GO

