

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppLiveSyncReplicationsGetInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  				AppLiveSyncReplicationsGetInfo						|
--	|		 Procedure to get replication information					|
--	+===================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppLiveSyncReplicationsGetInfo')
BEGIN
	print '>>> Drop Stored Procedure: AppLiveSyncReplicationsGetInfo <<<'
	drop procedure AppLiveSyncReplicationsGetInfo
END
IF EXISTS (select * from GxQscripts where name='AppLiveSyncReplicationsGetInfo')
	delete from GxQscripts where name = 'AppLiveSyncReplicationsGetInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppLiveSyncReplicationsGetInfo')
	delete from GXDBVersions where aliasname = 'AppLiveSyncReplicationsGetInfo'
GO
print '... Creating Procedure: AppLiveSyncReplicationsGetInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppLiveSyncReplicationsGetInfo
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
	DECLARE	@o_xmlString			XML
	DECLARE @pos				INT = 0
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowTime			INT = dbo.GetUnixTime (GetUTCdate())
	-- READ THE XML
	DECLARE @replicationId			INT
	DECLARE @taskId					INT
	DECLARE @srcSubclientId			INT
	DECLARE @srcBackupSetId			INT
	DECLARE @srcIstanceId			INT
	DECLARE @srcClientId			INT
	DECLARE @srcAppId				INT
	DECLARE @destIstanceId			INT
	DECLARE @destClientId			INT
	DECLARE @userId					INT
	DECLARE @inPropertyLevel		INT = 30 --ListPropertyLevels_AllProperties
	SELECT @replicationId=ISNULL(si.value('@replicationId', 'INT'), 0), @taskId=ISNULL(si.value('subTask[1]/@taskId', 'INT'), 0), @inPropertyLevel=ISNULL(ref.value('@propertyLevel', 'INT'), @inPropertyLevel), @userId = ISNULL(ref.value('user[1]/@userId', 'INT'), 0),
		@srcSubclientId=ISNULL(sr.value('@subclientId', 'INT'), 0), @srcBackupSetId=ISNULL(sr.value('@backupsetId', 'INT'), 0), @srcIstanceId=ISNULL(sr.value('@instanceId', 'INT'), 0),
		@srcClientId=ISNULL(sr.value('@clientId', 'INT'), 0), @srcAppId=ISNULL(sr.value('@applicationId', 'INT'), 0), @destClientId=ISNULL(de.value('@clientId', 'INT'), 0), @destIstanceId=ISNULL(de.value('@instanceId', 'INT'), 0)
			FROM @i_xmlString.nodes ('App_LiveSyncReplicationReq') R(ref)
			OUTER APPLY ref.nodes('./siteInfo') S(si)
			OUTER APPLY si.nodes('./source') T(sr)
			OUTER APPLY si.nodes('./destination') D(de)
	IF object_id('tempdb.dbo.#livesync_InfoTable') is not null
		DROP TABLE #livesync_InfoTable
CREATE TABLE #livesync_InfoTable (replicationId INT, ccId INT, clId INT, clientName NVARCHAR(2048), displayName NVARCHAR(2048), apId INT, appTypeName NVARCHAR(2048), instId INT, instanceName NVARCHAR(2048), bsId INT, backupsetName NVARCHAR(2048),subclientId INT,
taskId INT, subTaskId INT, subTaskName NVARCHAR(2048), lastSyncedBkpJob INT, destClientId INT, destInstanceId INT, status INT, lastRestoreTime INT, options NVARCHAR(MAX), configuration NVARCHAR(MAX), bkpJobsToSync NVARCHAR(1024), restoreSource NVARCHAR(1024), sla int, lastBackupTime INT, protectedSize BIGINT,
				repGroupId INT, repGroupName NVARCHAR(510),
				RPOSecs INT)
	CREATE CLUSTERED INDEX livesync_InfoTable_replicationId_taskId_Index1 ON #livesync_InfoTable ([replicationId], [taskId])
--
	IF @inPropertyLevel = 30 -- ListPropertyLevels_AllProperties
	BEGIN
		-- For last sync time in replication property details, if lastSynctime column is filled then we use it. Else we use lastRestoreTime.
		INSERT #livesync_InfoTable
        (replicationId, ccId, clId, clientName, displayName, apId, appTypeName, instId, instanceName, bsId, backupsetName, subclientId, taskId, subTaskId, subTaskName, lastSyncedBkpJob, destClientId, destInstanceId, status, lastRestoreTime, options, configuration, bkpJobsToSync, restoreSource, sla, lastBackupTime, repGroupId, repGroupName, RPOSecs)
		SELECT DISTINCT LS.replicationId, APP.origCCId, APP.clientId, CL.name, CL.displayName, APP.appTypeId, IDA.displayName, APP.instance, INS.name, backupsetId, BS.name, LS.subclientId,
				T.taskId, ST.subTaskId, ST.subTaskName, LS.lastSyncedBkpJob, LS.destClientId, LS.destInstanceId, LS.status,
CASE WHEN LS.apptypeId != 81 AND LS.apptypeId NOT IN (SELECT APP_AppTypeGroupAssoc.appTypeId FROM APP_AppTypeGroupAssoc(NOLOCK)
					WHERE appGroupId=35 -- APPGRP_FileSystemIDA
					AND typeOfGroup=0)
					AND LS.lastSyncTime>0 THEN LS.lastSyncTime ELSE LS.lastRestoreTime END,
				LS.options, CAST(LS.configuration AS NVARCHAR(MAX)),
				LS.bkpJobsToSync, LS.restoreSource, -1, CASE WHEN LS.lastBackupForReplication>0 THEN LS.lastBackupForReplication ELSE LS.lastBackupTime END, ISNULL(REP.id,0), ISNULL(REP.name,''), 24*3600
		FROM APP_LiveSyncReplication LS WITH (NOLOCK)
		JOIN TM_Task T WITH (NOLOCK) ON T.taskId = LS.taskId
			AND
			(
				T.taskId = @taskId OR @taskId = 0
			)
		LEFT OUTER JOIN TM_SubTask ST WITH (NOLOCK) ON ST.taskId = T.taskId
		JOIN APP_Application APP WITH (NOLOCK) ON APP.backupset = LS.backupsetId
			AND
			(
				( @srcBackupSetId = 0 OR APP.backupSet = @srcBackupSetId )
				AND
				( @srcIstanceId = 0 OR APP.instance = @srcIstanceId )
				AND
				( @srcClientId = 0 OR APP.clientId = @srcClientId )
				AND
				( @srcAppId = 0 OR APP.appTypeId = @srcAppId )
			)
		JOIN APP_BackupSetName BS WITH (NOLOCK) ON BS.id = APP.backupSet
		JOIN APP_InstanceName INS WITH (NOLOCK) ON INS.id = APP.instance
		JOIN APP_iDAType IDA WITH (NOLOCK) ON IDA.type = APP.appTypeId
		JOIN APP_Client CL WITH (NOLOCK) ON CL.id = APP.clientId
		LEFT JOIN App_ReplicationGroupAssociation REPASSOC on T.taskId = REPASSOC.taskId
		LEFT JOIN App_ReplicationGroup REP on REP.id = REPASSOC.componentNameId
		WHERE
		(
			LS.backupsetId = @srcBackupSetId OR @srcBackupSetId = 0
		)
		AND
		(
			LS.destInstanceId = @destIstanceId OR @destIstanceId = 0
		)
		AND
		(
			LS.destClientId = @destClientId OR @destClientId = 0
		)
		AND
		(
			LS.replicationId = @replicationId OR @replicationId = 0
		)
		-- Flags = 1 indicates replication pair deleted
		AND (LS.flags & 1)=0
	-- Check for security associations
	IF ( @userId > 0 )
		BEGIN
			DECLARE @isUserAdmin INT = 0
			IF OBJECT_ID('tempdb.dbo.#idaListTemp') IS NOT NULL DROP TABLE #idaListTemp
			CREATE TABLE #idaListTemp
			(
				t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT
			)
			EXECUTE sec_isUserAdmin   @i_userid = @userId ,@o_isUserAdmin = @isUserAdmin  OUTPUT
			IF ( @isUserAdmin != 1 )
			BEGIN
EXEC sec_getIdaObjectsForUser @userId, 7 /*SUBCLIENT_ENTITY*/ , 0, 0, '#idaListTemp'
				DELETE LS
				FROM #livesync_InfoTable LS
				LEFT OUTER JOIN #idaListTemp ida ON LS.subclientId = ida.t_subclientId WHERE ida.t_subclientId IS NULL
			END
		END
	-- Update SLA Status
	-- SLA --> 0 -> Missed SLA, 2 -> Met SLA, 3 -> Not Available
		UPDATE liveSync
			SET sla = CASE WHEN datediff(minute, dbo.getdatetime(lastRestoretime), getutcdate()) <= ISNULL(CAST(PP.attrVal AS INT),240) THEN 2
					ELSE 0
					END,
				RPOSecs = CAST(PP.attrVal as INT) * 60
		FROM #livesync_InfoTable liveSync INNER JOIN APP_SubClientProp SP ON liveSync.subclientId = SP.componentNameId
		INNER JOIN App_PlanProp PP on Sp.attrVal = PP.componentNameId
		AND SP.attrName = 'Associated plan'
		AND SP.modified = 0
AND PP.attrName = 'RPO In Minutes'
		AND PP.modified = 0
		AND lastRestoretime > 0
		-- if subclient was not associated with plan or if lastRestoreTime was not available then rpo met is set based on the sync status.
		-- if sync status is in sync , then rpo is met else rpo is not met.
		update #livesync_InfoTable
		SET sla = CASE WHEN status = 1 AND datediff(minute, dbo.getdatetime(lastRestoretime), getutcdate()) <= 24*60 THEN 2
						ELSE 0
					END
		where sla = -1
	---- Update the protected size for sql entities
		UPDATE LS
		SET LS.protectedSize = T.backup_size
		FROM #livesync_InfoTable LS
		INNER JOIN (
		select databasename, backup_size, dbInfo.instanceId, ROW_NUMBER() over (partition by db.databasename, dbInfo.instanceId order by backup_finish_date desc) as rn
		FROM sqlDbBackupInfo dbInfo
		INNER JOIN SqlDatabaseInfo db ON db.instanceId = dbInfo.instanceId AND db.databaseId = dbInfo.sqlNameId AND dbInfo.type = 'D' -- D >- FULL | I -> DIFF | L -> LOG
		INNER JOIN #livesync_InfoTable LS ON LS.instId = dbInfo.instanceId AND LS.restoreSource = db.DatabaseName
) T ON T.DatabaseName = LS.restoreSource AND T.instanceId = LS.instId WHERE LS.apId = 81 AND T.rn = 1
		OPTION (MAXDOP 4)
	-- update the protected size for oracle and oracle rac
		UPDATE LS
		SET LS.protectedSize = IP1.attrVal
		FROM #livesync_InfoTable LS
		LEFT OUTER JOIN APP_InstanceProp IP1 ON LS.instId = IP1.componentNameId AND IP1.attrName = 'Last Data Backup Size'
		WHERE ISNULL(IP1.attrVal, '0') <> '0'
AND LS.apId IN (22, 80)
		OPTION (MAXDOP 4)
		-- If we don't have size info at instance level, populate from oracleDataFiles table
		UPDATE LS
		SET LS.protectedSize = OU.DBSIZE
		FROM #livesync_InfoTable LS
		INNER JOIN (SELECT o.instId, SUM(o.maxDBDataSize) as DBSIZE FROM oracleDataFiles o WHERE o.deleteFlag = 0 GROUP BY o.instId) OU
		ON LS.instId = OU.instId AND ou.DBSIZE IS NOT NULL
WHERE LS.apId IN (22, 80)  AND LS.protectedSize = 0
		OPTION (MAXDOP 4)
	-- Update the proetced size for other ida's
		UPDATE LS
		SET LS.protectedSize = R.frontendSize
		FROM #livesync_InfoTable LS INNER JOIN RptCapacityUsage R ON LS.subclientId = R.appId
		WHERE R.startDT = (SELECT MAX(startDT) FROM RptCapacityUsage) AND LS.protectedSize IS NULL
		OPTION (MAXDOP 4)
	-- store replication properties in prop table
	IF object_id('tempdb.dbo.#livesync_PropTable') is not null
		drop table #livesync_PropTable
	CREATE TABLE #livesync_PropTable(repId INT, propertyTypeId INT, propertyValue nvarchar(max))
	-- Check running jobs to pick last replication job
	INSERT INTO #livesync_PropTable(repId, propertyTypeId, propertyValue)
SELECT LS.replicationId, 2215, jobId FROM #livesync_InfoTable LS -- CV_REPLICATIONPROP_VM_CURRENT_OR_LAST_JOB_ID
	INNER JOIN (
		SELECT rstTaskID, MAX(jobId) AS jobId, bkpSetID FROM JMRstJobInfo JM
		INNER JOIN #livesync_InfoTable LS ON JM.bkpSetID = LS.bsId AND LS.subTaskId = JM.rstTaskID
		GROUP BY rstTaskID, bkpSetID
	) job ON job.rstTaskID = LS.subTaskId AND job.bkpSetID = LS.bsId
	OPTION (MAXDOP 4)
	-- find the last replication job
	INSERT INTO #livesync_PropTable(repId, propertyTypeId, propertyValue)
SELECT LS.replicationId, 2215, jobId FROM #livesync_InfoTable LS -- CV_REPLICATIONPROP_VM_CURRENT_OR_LAST_JOB_ID
	LEFT JOIN #livesync_PropTable prop ON prop.repId = LS.replicationId
	INNER JOIN (
		SELECT JM.subTaskId, MAX(jobId) AS jobId, bkpSetID FROM JMRestoreStats JM
		INNER JOIN #livesync_InfoTable LS ON JM.bkpSetID = LS.bsId AND LS.subTaskId = JM.subTaskId
		GROUP BY JM.subTaskId, bkpSetID
	) job ON job.subTaskId = LS.subTaskId AND job.bkpSetID = LS.bsId
	where prop.propertyValue IS NULL
	OPTION (MAXDOP 4)
	-- the last successful replication job
	INSERT INTO #livesync_PropTable(repId, propertyTypeId, propertyValue)
SELECT LS.replicationId, 2208, jobId FROM #livesync_InfoTable LS -- CV_REPLICATIONPROP_LAST_SUCCESSFUL_REPLICATION_ID
	INNER JOIN (
		SELECT JM.subTaskId, MAX(jobId) AS jobId, bkpSetID FROM JMRestoreStats JM
		INNER JOIN #livesync_InfoTable LS ON JM.bkpSetID = LS.bsId AND LS.subTaskId = JM.subTaskId
		WHERE JM.status IN (1,3,14) GROUP BY JM.subTaskId, bkpSetID
	) job ON job.subTaskId = LS.subTaskId AND job.bkpSetID = LS.bsId
	OPTION (MAXDOP 4)
	-- FORM THE XML RESPONSE
		SET @o_xmlString =
				(
					SELECT INFO.replicationId '@replicationId', INFO.lastSyncedBkpJob '@lastSyncedBkpJob', INFO.status '@status', INFO.lastRestoreTime '@lastRestoreTime', INFO.lastBackupTime '@lastBackupTime', INFO.protectedSize '@protectedSize', INFO.options '@options', INFO.bkpJobsToSync '@BkpJobsToSync', INFO.restoreSource '@restoreSource', INFO.sla '@SLAStatus', INFO.configuration '@configuration', INFO.RPOSecs '@RPOSecs', CASE WHEN INFO.lastRestoretime <> 0 THEN @nowTime - INFO.lastRestoretime ELSE 0 END '@RPOBehindSecs',
                    INFO.taskId 'subTask/@taskId', INFO.subTaskId 'subTask/@subtaskId', INFO.subTaskName 'subTask/@subtaskName', INFO.bsId 'source/@backupsetId', ccId 'source/@commCellId', INFO.backupsetName 'source/@backupsetName', INFO.subclientId 'source/@subclientId', INFO.instId 'source/@instanceId',
					INFO.instanceName 'source/@instanceName', INFO.apId 'source/@applicationId', INFO.appTypeName 'source/@appName', INFO.clId 'source/@clientId', INFO.clientName 'source/@clientName', INFO.displayName 'source/@displayName',
                    INFO.destClientId 'destination/@clientId', C.name 'destination/@clientName', C.displayName 'destination/@displayName', INFO.destInstanceId 'destination/@instanceId', I.name 'destination/@instanceName',
					INFO.repGroupId 'replicationGroup/@replicationGroupId', INFO.repGroupName 'replicationGroup/@replicationGroupName',
					( SELECT prop.propertyTypeId '@propertyId', prop.propertyValue '@propertyValue' FROM #livesync_PropTable prop WHERE prop.repId = INFO.replicationId FOR XML PATH('VMReplInfoProperties'), TYPE)
					FROM #livesync_InfoTable INFO
					JOIN APP_Client C (NOLOCK) ON C.id = INFO.destClientId
					LEFT OUTER JOIN APP_InstanceName I (NOLOCK) ON I.id = INFO.destInstanceId
					FOR XML PATH('siteInfo'),
					ROOT('App_LiveSyncReplicationResp')
				)
	END
	ELSE IF @inPropertyLevel = 1 -- ListPropertyLevels_ListOnly
	BEGIN
		SET @o_xmlString =
				(
					SELECT LS.replicationId '@replicationId', LS.taskId 'subTask/@taskId',
					LS.subTaskId 'subTask/@subtaskId'
					FROM APP_LiveSyncReplication LS (NOLOCK)
					WHERE LS.backupsetId = @srcBackupSetId
					AND
					(
						LS.destInstanceId = @destIstanceId OR @destIstanceId = 0
					)
					AND
					(
						LS.destClientId = @destClientId OR @destClientId = 0
					)
					AND
					(
						LS.replicationId = @replicationId OR @replicationId = 0
					)
					FOR XML PATH('siteInfo'),
					ROOT('App_LiveSyncReplicationResp')
				)
	END
ERROR_EXIT:
	IF @errorCode <> 0
		SET @o_xmlString = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
							FOR XML PATH('App_GenericResp'), TYPE)
	IF @o_xmlString IS NULL
		SET @o_xmlString = '<App_LiveSyncReplicationResp/>'
	IF OBJECT_ID('tempdb.dbo.#replicationInfoOut') IS NOT NULL
		INSERT INTO #replicationInfoOut(repInfo)
		SELECT @o_xmlString
	ELSE
		SELECT @o_xmlString AS o_xmlString
	IF object_id('tempdb.dbo.#livesync_InfoTable') is not null
		DROP TABLE #livesync_InfoTable
	IF object_id('tempdb.dbo.#livesync_PropTable') is not null
		drop table #livesync_PropTable
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppLiveSyncReplicationsGetInfo')
	delete from GxQscripts where name = 'AppLiveSyncReplicationsGetInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppLiveSyncReplicationsGetInfo')
	delete from GXDBVersions where aliasname = 'AppLiveSyncReplicationsGetInfo'
GO

insert into GXDBVersions values(2, 'AppLiveSyncReplicationsGetInfo',  '00000000000000000000', 'AppLiveSyncReplicationsGetInfo', '00000000000000000000')
GO

