

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppLiveSyncCheckReverseReplication.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  				AppLiveSyncReplicationsGetInfo						|
--	|		 Procedure to get replication information					|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppLiveSyncCheckReverseReplication')
BEGIN
	print '>>> Drop Stored Procedure: AppLiveSyncCheckReverseReplication <<<'
	drop procedure AppLiveSyncCheckReverseReplication
END
IF EXISTS (select * from GxQscripts where name='AppLiveSyncCheckReverseReplication')
	delete from GxQscripts where name = 'AppLiveSyncCheckReverseReplication'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppLiveSyncCheckReverseReplication')
	delete from GXDBVersions where aliasname = 'AppLiveSyncCheckReverseReplication'
GO
print '... Creating Procedure: AppLiveSyncCheckReverseReplication'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppLiveSyncCheckReverseReplication
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML 
-----------------------------------------------------------
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
BEGIN
	DECLARE	@o_xmlString			XML
	DECLARE @pos				INT = 0
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowTime			INT = dbo.GetUnixTime (GetUTCdate())
	-- READ THE XML
	DECLARE @taskId					INT
	DECLARE @srcSubclientId			INT
	DECLARE @srcBackupSetId			INT
	DECLARE @srcIstanceId			INT
	DECLARE @srcClientId			INT
	DECLARE @srcAppId				INT
	DECLARE @destIstanceId			INT
	DECLARE @destClientId			INT
	DECLARE @destBackupsetId		INT = 0
	DECLARE @destBackupsetName		NVARCHAR(MAX) = ''
	SELECT @taskId=ISNULL(si.value('subTask[1]/@taskId', 'INT'), 0),
		@srcSubclientId=ISNULL(sr.value('@subclientId', 'INT'), 0), @srcBackupSetId=ISNULL(sr.value('@backupsetId', 'INT'), 0), @srcIstanceId=ISNULL(sr.value('@instanceId', 'INT'), 0),
		@srcClientId=ISNULL(sr.value('@clientId', 'INT'), 0), @srcAppId=ISNULL(sr.value('@applicationId', 'INT'), 0), @destClientId=ISNULL(de.value('@clientId', 'INT'), 0), @destIstanceId=ISNULL(de.value('@instanceId', 'INT'), 0),
		@destBackupsetName=ISNULL(de.value('@backupsetName', 'NVARCHAR(MAX)'), '')
			FROM @i_xmlString.nodes ('App_LiveSyncReplicationReq') R(ref)
			OUTER APPLY ref.nodes('./siteInfo') S(si)
			OUTER APPLY si.nodes('./source') T(sr)
			OUTER APPLY si.nodes('./destination') D(de)
	-- If destination instance isnt there then we can ignore below checks
	IF (@destIstanceId<=0)
	BEGIN
		SELECT '<App_LiveSyncReplicationResp/>'
		RETURN
	END
	-- First identify the destination backupset for destination instance. For DB2 we can get DB backupset name from job option.
IF (@srcAppId=37 OR @srcAppId=62 )
	BEGIN
		-- If the schedule doesnt have target DB name then we return no reverse replication configured.
		IF (@destBackupsetName IS NULL OR LEN(@destBackupsetName)=0)
		BEGIN
			SELECT '<App_LiveSyncReplicationResp/>'
			RETURN
		END
		SELECT @destBackupsetId = App_Application.backupset FROM App_Application (NOLOCK)
		INNER JOIN App_backupsetName (NOLOCK) ON App_backupsetName.ID = App_Application.backupset
		AND App_Application.instance = @destIstanceId AND App_backupsetName.name = @destBackupsetName
		-- If the db isnt there on destination instance then return no reverse replication configured
		IF (@destBackupsetId =0)
		BEGIN
			SELECT '<App_LiveSyncReplicationResp/>'
			RETURN
		END
	END
	-- For supported apptypes check whether there is replicaton schedule in reverse. From destination to source and if so error out.
	IF EXISTS(SELECT 1 FROM TM_AssocEntity (NOLOCK) INNER JOIN TM_Subtask ON
	TM_AssocEntity.instanceId = @destIstanceId AND (TM_AssocEntity.backupsetId = @destBackupsetId OR @destBackupsetId = 0 ) AND
	TM_AssocEntity.taskID = TM_Subtask.taskID AND TM_Subtask.operationType = 1007 -- SITE_REPLICATION
	INNER JOIN TM_Task ON TM_Task.taskID = TM_Subtask.taskID AND TM_Task.deleted = 0 AND TM_Task.disabled = 0
AND TM_Task.taskType IN (2,4) ) -- 2 , 4
	BEGIN
		-- Generate xml with destination as source and source as destination.
		DECLARE @xml XML = ( SELECT 30 '@propertyLevel' ,
			(SELECT @destClientId '@clientId', @srcAppId '@applicationId', @destIstanceId '@instanceId', @destBackupsetId '@backupsetId' FOR XML PATH('source'),TYPE),
			(SELECT @srcClientId '@clientId' , @srcAppId '@applicationId', @srcIstanceId  '@instanceId' , @srcBackupSetId  '@backupsetId' FOR XML PATH('destination'),TYPE)
			FOR XML PATH('App_LiveSyncReplicationReq')
		)
		EXEC AppLiveSyncReplicationsGetInfo @xml
		RETURN
	END
	SELECT '<App_LiveSyncReplicationResp/>'
	RETURN
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppLiveSyncCheckReverseReplication')
	delete from GxQscripts where name = 'AppLiveSyncCheckReverseReplication'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppLiveSyncCheckReverseReplication')
	delete from GXDBVersions where aliasname = 'AppLiveSyncCheckReverseReplication'
GO

insert into GXDBVersions values(2, 'AppLiveSyncCheckReverseReplication',  '00000000000000000000', 'AppLiveSyncCheckReverseReplication', '00000000000000000000')
GO

